/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.company.service;

import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.company.dao.CompanyPopupReminderMapper;
import cn.smarthse.modules.health.company.model.CategoryInfo;
import cn.smarthse.modules.health.company.model.CompanyPopupReminder;
import cn.smarthse.modules.health.company.service.ICompanyPopupReminderService;
import cn.smarthse.modules.health.entity.base.selfjudge.CompanyHsePreventionControlSelfJudge;
import cn.smarthse.modules.health.entity.base.selfjudge.SelfInspectionRiskAssessmentReportInfo;
import cn.smarthse.services.hfi.api.entity.riskev.RiskExposeEvaluate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.smarthse.exception.ServiceException;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.transaction.annotation.Transactional;

@DubboService
@Transactional(readOnly=true)
public class CompanyPopupReminderServiceImpl
extends BaseServiceImpl<CompanyPopupReminderMapper, CompanyPopupReminder>
implements ICompanyPopupReminderService {
    public Boolean shouldShowPopup(Long cid) {
        CompanyPopupReminder entity = new CompanyPopupReminder();
        entity.setCid(cid);
        CompanyPopupReminder vo = ((CompanyPopupReminderMapper)this.dao).selectByCid(cid);
        if (vo == null) {
            return true;
        }
        if (vo.getIsShowVictims() == null || vo.getIsShowVictims() < 3) {
            return false;
        }
        if (vo.getLoginRemindTime() == null) {
            return true;
        }
        Date loginRemindTime = vo.getLoginRemindTime();
        return loginRemindTime.before(new Date());
    }

    @Transactional
    public void updateReminderTime(CompanyPopupReminder entity) {
        String reminderType = entity.getReminderType();
        Calendar calendar = Calendar.getInstance();
        switch (reminderType) {
            case "day": {
                calendar.set(11, 23);
                calendar.set(12, 59);
                calendar.set(13, 59);
                entity.setLoginRemindTime(calendar.getTime());
                break;
            }
            case "month": {
                calendar.set(5, calendar.getActualMaximum(5));
                calendar.set(11, 23);
                calendar.set(12, 59);
                calendar.set(13, 59);
                entity.setLoginRemindTime(calendar.getTime());
                break;
            }
            case "year": {
                calendar.set(2, 11);
                calendar.set(5, 31);
                calendar.set(11, 23);
                calendar.set(12, 59);
                calendar.set(13, 59);
                entity.setLoginRemindTime(calendar.getTime());
                break;
            }
            default: {
                throw new ServiceException("\u9009\u62e9\u63d0\u9192\u7c7b\u578b\u4e0d\u6b63\u786e");
            }
        }
        Date now = new Date();
        CompanyPopupReminder existingEntity = ((CompanyPopupReminderMapper)this.dao).selectByCid(entity.getCid());
        entity.setUpdateDate(now);
        entity.setUpdateBy(entity.getUpdateBy());
        if (existingEntity != null && existingEntity.getId() != null) {
            ((CompanyPopupReminderMapper)this.dao).updateByPrimaryKeySelective(entity);
        } else {
            entity.setCreateBy(entity.getCid());
            entity.setCreateDate(now);
            entity.setIsValid(Boolean.valueOf(true));
            ((CompanyPopupReminderMapper)this.dao).insert(entity);
        }
    }

    public List<CategoryInfo> getCategoryInfoByCid(Long cid) {
        ArrayList<CategoryInfo> list = new ArrayList<CategoryInfo>();
        List<SelfInspectionRiskAssessmentReportInfo> selfList = ((CompanyPopupReminderMapper)this.dao).getSelfByCid(cid);
        boolean hasPass = selfList.stream().filter(Objects::nonNull).anyMatch(item -> item.getStatus().intValue() == 4 || item.getStatus().intValue() == 5);
        if (hasPass) {
            return list;
        }
        SelfInspectionRiskAssessmentReportInfo reportInfo = selfList.stream().filter(Objects::nonNull).max(Comparator.comparing(SelfInspectionRiskAssessmentReportInfo::getCreateDate)).orElse(null);
        CategoryInfo self = new CategoryInfo();
        self.setCheckState(Byte.valueOf(reportInfo == null ? (byte)1 : reportInfo.getStatus()));
        self.setType(Long.valueOf(3L));
        list.add(self);
        if (reportInfo == null || reportInfo.getStatus().intValue() == 1) {
            RiskExposeEvaluate hazardData;
            CompanyHsePreventionControlSelfJudge hseData = ((CompanyPopupReminderMapper)this.dao).getHseByCid(cid);
            if (hseData == null || hseData.getStatus() != 4) {
                CategoryInfo hse = new CategoryInfo();
                hse.setType(Long.valueOf(1L));
                hse.setCheckState(Byte.valueOf(hseData == null ? (byte)1 : hseData.getStatus()));
                list.add(hse);
            }
            if ((hazardData = ((CompanyPopupReminderMapper)this.dao).getHazardByCid(cid)) == null || hazardData.getReportStatus() != 4) {
                CategoryInfo hazard = new CategoryInfo();
                hazard.setType(Long.valueOf(2L));
                hazard.setCheckState(Byte.valueOf(hazardData == null ? (byte)1 : hazardData.getReportStatus().byteValue()));
                list.add(hazard);
            }
        } else {
            RiskExposeEvaluate hazardData;
            CompanyHsePreventionControlSelfJudge hseData = ((CompanyPopupReminderMapper)this.dao).getHseById(reportInfo.getSelfReportId());
            if (hseData == null || hseData.getStatus() != 4) {
                CategoryInfo hse = new CategoryInfo();
                hse.setType(Long.valueOf(1L));
                hse.setCheckState(Byte.valueOf(hseData == null ? (byte)1 : hseData.getStatus()));
                list.add(hse);
            }
            if ((hazardData = ((CompanyPopupReminderMapper)this.dao).getHazardById(reportInfo.getExposureReportId())) == null || hazardData.getReportStatus() != 4) {
                CategoryInfo hazard = new CategoryInfo();
                hazard.setType(Long.valueOf(2L));
                hazard.setCheckState(Byte.valueOf(hazardData == null ? (byte)1 : hazardData.getReportStatus().byteValue()));
                list.add(hazard);
            }
        }
        return list;
    }
}

