/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.company.service;

import cn.hutool.core.convert.Convert;
import cn.smarthse.common.framework.redis.RedisClient;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.number.NumberUtil;
import cn.smarthse.common.util.number.SysConvertTool;
import cn.smarthse.modules.health.company.dao.CompanyBusinessTableMapper;
import cn.smarthse.modules.health.company.service.ICompanyBusinessTableService;
import cn.smarthse.modules.health.entity.base.company.CompanyBusinessTable;
import cn.smarthse.modules.health.param.CompanyBusinessTableParam;
import cn.smarthse.modules.health.param.SearchParam;
import cn.smarthse.modules.health.service.work.reform.ICompanyRiskProspectService;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicEconomyService;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicNewService;
import cn.smarthse.modules.health.supervise.model.home.v3223.homeIndex.HomeRiskControlVo;
import cn.smarthse.modules.health.supervise.model.home.v3223.homeRiskMitigation.KeyFactoryRiskInfo;
import cn.smarthse.modules.health.supervise.model.home.v3223.homeRiskMitigation.RankInfo;
import cn.smarthse.modules.health.supervise.model.keyFactory.EconomicAccountTable;
import cn.smarthse.modules.health.supervise.model.keyFactory.RiskStateTable;
import cn.smarthse.modules.health.supervise.model.keyFactory.RiskWarnTable;
import cn.smarthse.modules.health.vo.riskResolve.HomeRiskWarnVo;
import cn.smarthse.modules.health.vo.riskResolve.RiskCalculator;
import cn.smarthse.modules.health.vo.riskResolve.RiskVisualDto;
import cn.smarthse.modules.health.vo.riskResolve.RiskWarnItem;
import cn.smarthse.modules.health.vo.work.HomeIndexSearchVo;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
public class CompanyBusinessTableServiceImpl
extends BaseServiceImpl<CompanyBusinessTableMapper, CompanyBusinessTable>
implements ICompanyBusinessTableService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CompanyBusinessTableServiceImpl.class);
    @DubboReference
    IReformItemBasicNewService reformItemBasicNewService;
    @DubboReference
    IReformItemBasicEconomyService reformItemBasicEconomyService;
    @DubboReference(version="1.0.0")
    private ICompanyRiskProspectService companyRiskProspectService;
    @Autowired
    RedisClient redisClient;
    private String cacheName = "ICompanyBusinessTableService";
    public static final int TIMEOUT = 10800;

    @Transactional(readOnly=false)
    public void generateCompanyBusinessTable() {
        ((CompanyBusinessTableMapper)this.dao).deleteByExample(new Example(CompanyBusinessTable.class));
        ((CompanyBusinessTableMapper)this.dao).getCompanyBusinessTableList();
        ((CompanyBusinessTableMapper)this.dao).deleteCompanyBusinessTableListV2();
        ((CompanyBusinessTableMapper)this.dao).getCompanyBusinessTableListV2();
        this.redisClient.delPrefix("HomeIndexControllerV3223:getRiskControl");
        this.redisClient.delPrefix("HomeRiskMitigationController");
        this.redisClient.delPrefix("HomeRiskMitigationControllerV3223");
        this.redisClient.delPrefix(this.cacheName);
    }

    public RiskStateTable headDataByRiskStatTable(CompanyBusinessTableParam searchParam) {
        return (RiskStateTable)this.redisClient.get(this.cacheName, "headDataByRiskStatTable:" + searchParam.hashCode(), 10800L, () -> {
            if (StringUtils.isNotBlank((CharSequence)searchParam.getScales())) {
                searchParam.setScaleList(cn.smarthse.common.util.StringUtils.parseToIntegerList((String)searchParam.getScales(), (String)","));
            }
            searchParam.setIsHeader(Boolean.valueOf(true));
            if (Objects.equals(true, searchParam.getIsCityLevelStreet())) {
                searchParam.setBelongType(Integer.valueOf(2));
                searchParam.setOnlyThisLevel(Boolean.valueOf(true));
            }
            List<RiskStateTable> list = ((CompanyBusinessTableMapper)this.dao).getRiskStatTableList(searchParam);
            this.setSupplementAreaInfo1(list, searchParam);
            if (CollectionUtils.isEmpty(list) || list.get(0) == null) {
                return null;
            }
            RiskStateTable table = list.get(0);
            this.convertRiskStatTable(table);
            if (Objects.equals(true, searchParam.getIsCityLevelStreet())) {
                table.setAreaName(table.getAreaName() + "\u672c\u7ea7");
            }
            return table;
        });
    }

    public List<RiskStateTable> listDataByRiskStatTable(CompanyBusinessTableParam searchParam) {
        return (List)this.redisClient.get(this.cacheName, "listDataByRiskStatTable:" + searchParam.hashCode(), 10800L, () -> {
            if (StringUtils.isNotBlank((CharSequence)searchParam.getScales())) {
                searchParam.setScaleList(cn.smarthse.common.util.StringUtils.parseToIntegerList((String)searchParam.getScales(), (String)","));
            }
            ArrayList<RiskStateTable> list = new ArrayList();
            if (Objects.equals((byte)4, searchParam.getLevel())) {
                return Collections.emptyList();
            }
            if (Objects.equals(true, searchParam.getIsCityLevelStreet())) {
                searchParam.setBelongType(Integer.valueOf(2));
                searchParam.setOnlyThisLevel(Boolean.valueOf(true));
            }
            if (Objects.equals((byte)2, searchParam.getLevel()) && !Objects.equals(true, searchParam.getIsCityLevelStreet())) {
                CompanyBusinessTableParam newSearchParam = new CompanyBusinessTableParam();
                BeanUtils.copyProperties((Object)searchParam, (Object)newSearchParam);
                if (!Objects.equals(true, searchParam.getOnlyThisLevel())) {
                    newSearchParam.setBelongType(Integer.valueOf(0));
                    newSearchParam.setOnlyThisLevel(Boolean.valueOf(true));
                    List<RiskStateTable> list2 = ((CompanyBusinessTableMapper)this.dao).getRiskStatTableList(newSearchParam);
                    this.setSupplementAreaInfo1(list2, searchParam);
                    list.addAll(list2);
                }
                if (!Objects.equals(false, searchParam.getOnlyThisLevel())) {
                    newSearchParam.setBelongType(Integer.valueOf(2));
                    newSearchParam.setOnlyThisLevel(Boolean.valueOf(true));
                    newSearchParam.setIsCityLevelStreet(Boolean.valueOf(true));
                    RiskStateTable table = this.headDataByRiskStatTable(newSearchParam);
                    if (table != null) {
                        list.add(table);
                    }
                }
            } else if (Objects.equals(true, searchParam.getIsCounty())) {
                CompanyBusinessTableParam newParam = new CompanyBusinessTableParam();
                if (Objects.equals(true, searchParam.getIsPilotProject())) {
                    newParam.setIsPilotProject(Boolean.valueOf(true));
                }
                newParam.setAreaId(searchParam.getAreaId());
                newParam.setLevel(searchParam.getLevel());
                newParam.setBelongType(Integer.valueOf(2));
                newParam.setOnlyThisLevel(Boolean.valueOf(true));
                List<RiskStateTable> riskStatTableList = ((CompanyBusinessTableMapper)this.dao).getRiskStatTableList(newParam);
                newParam.setBelongType(Integer.valueOf(0));
                newParam.setOnlyThisLevel(Boolean.valueOf(true));
                newParam.setIsCounty(Boolean.valueOf(true));
                list = ((CompanyBusinessTableMapper)this.dao).getRiskStatTableList(newParam);
                this.setSupplementAreaInfo1(list, searchParam);
                for (RiskStateTable table : riskStatTableList) {
                    if (table == null) continue;
                    table.setAreaName(table.getAreaName() + "\u672c\u7ea7");
                    list.add(table);
                }
            } else {
                list = ((CompanyBusinessTableMapper)this.dao).getRiskStatTableList(searchParam);
                this.setSupplementAreaInfo1(list, searchParam);
            }
            list.stream().filter(Objects::nonNull).forEach(this::convertRiskStatTable);
            this.setRiskStatTableSort(list, searchParam);
            return list;
        });
    }

    private void convertRiskStatTable(RiskStateTable table) {
        if (table.getNeedKeyFactoryComNum() == null) {
            return;
        }
        table.setDefuseComRate(NumberUtil.rateDouble((int)(table.getIsDefuseComNum() * 100), (int)table.getNeedKeyFactoryComNum(), (int)2));
        table.setDetectionComRate(NumberUtil.rateDouble((int)(table.getDetectionResolveComNum() * 100), (int)table.getDetectionComNum(), (int)2));
        table.setPhysicalCheckComRate(NumberUtil.rateDouble((int)(table.getPhysicalCheckResolveComNum() * 100), (int)table.getPhysicalCheckComNum(), (int)2));
        table.setExistRiskComNum(Integer.valueOf(table.getNeedKeyFactoryComNum() - table.getIsDefuseComNum()));
        table.setDefuseComRate25(Double.valueOf(0.0));
        table.setIsDefuseComNum25(Integer.valueOf(0));
    }

    private void setRiskStatTableSort(List<RiskStateTable> list, CompanyBusinessTableParam searchParam) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)searchParam.getSort())) {
            return;
        }
        list.sort((o1, o2) -> {
            switch (searchParam.getSort()) {
                case "defuseComRate desc": {
                    return o2.getDefuseComRate().compareTo(o1.getDefuseComRate());
                }
                case "detectionComRate desc": {
                    return o2.getDetectionComRate().compareTo(o1.getDetectionComRate());
                }
                case "physicalCheckComRate desc": {
                    return o2.getPhysicalCheckComRate().compareTo(o1.getPhysicalCheckComRate());
                }
            }
            return o2.getAreaId().compareTo(o1.getAreaId());
        });
    }

    public RiskWarnTable headDataByRiskWarnTable(CompanyBusinessTableParam searchParam) {
        return (RiskWarnTable)this.redisClient.get(this.cacheName, "headDataByRiskWarnTable:" + searchParam.hashCode(), 10800L, () -> {
            if (StringUtils.isNotBlank((CharSequence)searchParam.getScales())) {
                searchParam.setScaleList(cn.smarthse.common.util.StringUtils.parseToIntegerList((String)searchParam.getScales(), (String)","));
            }
            searchParam.setIsHeader(Boolean.valueOf(true));
            if (Objects.equals(true, searchParam.getIsCityLevelStreet())) {
                searchParam.setBelongType(Integer.valueOf(2));
                searchParam.setOnlyThisLevel(Boolean.valueOf(true));
            }
            List<RiskWarnTable> list = ((CompanyBusinessTableMapper)this.dao).getRiskWarnTableList(searchParam);
            this.setSupplementAreaInfo2(list, searchParam);
            if (CollectionUtils.isEmpty(list) || list.get(0) == null) {
                return null;
            }
            RiskWarnTable table = list.get(0);
            this.convertRiskWarnTable(table);
            if (Objects.equals(true, searchParam.getIsCityLevelStreet())) {
                table.setAreaName(table.getAreaName() + "\u672c\u7ea7");
            }
            return table;
        });
    }

    public List<RiskWarnTable> listDataByRiskWarnTable(CompanyBusinessTableParam searchParam) {
        return (List)this.redisClient.get(this.cacheName, "listDataByRiskWarnTable:" + searchParam.hashCode(), 10800L, () -> {
            if (StringUtils.isNotBlank((CharSequence)searchParam.getScales())) {
                searchParam.setScaleList(cn.smarthse.common.util.StringUtils.parseToIntegerList((String)searchParam.getScales(), (String)","));
            }
            ArrayList<RiskWarnTable> list = new ArrayList();
            if (Objects.equals((byte)4, searchParam.getLevel())) {
                return Collections.emptyList();
            }
            if (Objects.equals(true, searchParam.getIsCityLevelStreet())) {
                searchParam.setBelongType(Integer.valueOf(2));
                searchParam.setOnlyThisLevel(Boolean.valueOf(true));
            }
            if (Objects.equals((byte)2, searchParam.getLevel()) && !Objects.equals(true, searchParam.getIsCityLevelStreet())) {
                CompanyBusinessTableParam newSearchParam = new CompanyBusinessTableParam();
                BeanUtils.copyProperties((Object)searchParam, (Object)newSearchParam);
                if (!Objects.equals(true, searchParam.getOnlyThisLevel())) {
                    newSearchParam.setBelongType(Integer.valueOf(0));
                    newSearchParam.setOnlyThisLevel(Boolean.valueOf(true));
                    List<RiskWarnTable> list2 = ((CompanyBusinessTableMapper)this.dao).getRiskWarnTableList(newSearchParam);
                    this.setSupplementAreaInfo2(list2, searchParam);
                    list.addAll(list2);
                }
                if (!Objects.equals(false, searchParam.getOnlyThisLevel())) {
                    newSearchParam.setBelongType(Integer.valueOf(2));
                    newSearchParam.setOnlyThisLevel(Boolean.valueOf(true));
                    newSearchParam.setIsCityLevelStreet(Boolean.valueOf(true));
                    RiskWarnTable table2 = this.headDataByRiskWarnTable(newSearchParam);
                    if (table2 != null) {
                        list.add(table2);
                    }
                }
            } else if (Objects.equals(true, searchParam.getIsCounty())) {
                CompanyBusinessTableParam newParam = new CompanyBusinessTableParam();
                if (Objects.equals(true, searchParam.getIsPilotProject())) {
                    newParam.setIsPilotProject(Boolean.valueOf(true));
                }
                newParam.setAreaId(searchParam.getAreaId());
                newParam.setLevel(searchParam.getLevel());
                newParam.setBelongType(Integer.valueOf(2));
                newParam.setOnlyThisLevel(Boolean.valueOf(true));
                List<RiskWarnTable> riskWarnTableList = ((CompanyBusinessTableMapper)this.dao).getRiskWarnTableList(newParam);
                newParam.setBelongType(Integer.valueOf(0));
                newParam.setOnlyThisLevel(Boolean.valueOf(true));
                newParam.setIsCounty(Boolean.valueOf(true));
                list = ((CompanyBusinessTableMapper)this.dao).getRiskWarnTableList(newParam);
                this.setSupplementAreaInfo2(list, searchParam);
                for (RiskWarnTable table3 : riskWarnTableList) {
                    if (table3 == null) continue;
                    table3.setAreaName(table3.getAreaName() + "\u672c\u7ea7");
                    list.add(table3);
                }
            } else {
                list = ((CompanyBusinessTableMapper)this.dao).getRiskWarnTableList(searchParam);
                this.setSupplementAreaInfo2(list, searchParam);
            }
            list.stream().filter(Objects::nonNull).forEach(this::convertRiskWarnTable);
            if (StringUtils.isNotBlank((CharSequence)searchParam.getKeyWord())) {
                return list.stream().filter(Objects::nonNull).filter(table -> table.getAreaName().contains(searchParam.getKeyWord())).collect(Collectors.toList());
            }
            return list;
        });
    }

    public EconomicAccountTable headDataByEconomicAccountTable(CompanyBusinessTableParam searchParam) {
        return (EconomicAccountTable)this.redisClient.get(this.cacheName, "headDataByEconomicAccountTable:" + searchParam.hashCode(), 10800L, () -> {
            if (StringUtils.isNotBlank((CharSequence)searchParam.getScales())) {
                searchParam.setScaleList(cn.smarthse.common.util.StringUtils.parseToIntegerList((String)searchParam.getScales(), (String)","));
            }
            searchParam.setIsHeader(Boolean.valueOf(true));
            if (Objects.equals(true, searchParam.getIsCityLevelStreet())) {
                searchParam.setBelongType(Integer.valueOf(2));
                searchParam.setOnlyThisLevel(Boolean.valueOf(true));
            }
            List<EconomicAccountTable> list = ((CompanyBusinessTableMapper)this.dao).getEconomicAccountTableList(searchParam);
            this.setSupplementAreaInfo3(list, searchParam);
            if (CollectionUtils.isEmpty(list) || list.get(0) == null) {
                return null;
            }
            EconomicAccountTable table = list.get(0);
            if (Objects.equals(true, searchParam.getIsCityLevelStreet())) {
                table.setAreaName(table.getAreaName() + "\u672c\u7ea7");
            }
            return table;
        });
    }

    public List<EconomicAccountTable> listDataByEconomicAccountTable(CompanyBusinessTableParam searchParam) {
        return (List)this.redisClient.get(this.cacheName, "listDataByEconomicAccountTable:" + searchParam.hashCode(), 10800L, () -> {
            if (StringUtils.isNotBlank((CharSequence)searchParam.getScales())) {
                searchParam.setScaleList(cn.smarthse.common.util.StringUtils.parseToIntegerList((String)searchParam.getScales(), (String)","));
            }
            ArrayList<EconomicAccountTable> list = new ArrayList();
            if (Objects.equals((byte)4, searchParam.getLevel())) {
                return Collections.emptyList();
            }
            if (Objects.equals(true, searchParam.getIsCityLevelStreet())) {
                searchParam.setBelongType(Integer.valueOf(2));
                searchParam.setOnlyThisLevel(Boolean.valueOf(true));
            }
            if (Objects.equals((byte)2, searchParam.getLevel()) && !Objects.equals(true, searchParam.getIsCityLevelStreet())) {
                CompanyBusinessTableParam newSearchParam = new CompanyBusinessTableParam();
                BeanUtils.copyProperties((Object)searchParam, (Object)newSearchParam);
                if (!Objects.equals(true, searchParam.getOnlyThisLevel())) {
                    newSearchParam.setBelongType(Integer.valueOf(0));
                    newSearchParam.setOnlyThisLevel(Boolean.valueOf(true));
                    List<EconomicAccountTable> list2 = ((CompanyBusinessTableMapper)this.dao).getEconomicAccountTableList(newSearchParam);
                    this.setSupplementAreaInfo3(list2, searchParam);
                    list.addAll(list2);
                }
                if (!Objects.equals(false, searchParam.getOnlyThisLevel())) {
                    newSearchParam.setBelongType(Integer.valueOf(2));
                    newSearchParam.setOnlyThisLevel(Boolean.valueOf(true));
                    newSearchParam.setIsCityLevelStreet(Boolean.valueOf(true));
                    EconomicAccountTable table = this.headDataByEconomicAccountTable(newSearchParam);
                    if (table != null) {
                        list.add(table);
                    }
                }
            } else if (Objects.equals(true, searchParam.getIsCounty())) {
                CompanyBusinessTableParam newParam = new CompanyBusinessTableParam();
                if (Objects.equals(true, searchParam.getIsPilotProject())) {
                    newParam.setIsPilotProject(Boolean.valueOf(true));
                }
                newParam.setAreaId(searchParam.getAreaId());
                newParam.setLevel(searchParam.getLevel());
                newParam.setBelongType(Integer.valueOf(2));
                newParam.setOnlyThisLevel(Boolean.valueOf(true));
                List<EconomicAccountTable> riskStatTableList = ((CompanyBusinessTableMapper)this.dao).getEconomicAccountTableList(newParam);
                newParam.setBelongType(Integer.valueOf(0));
                newParam.setOnlyThisLevel(Boolean.valueOf(true));
                newParam.setIsCounty(Boolean.valueOf(true));
                list = ((CompanyBusinessTableMapper)this.dao).getEconomicAccountTableList(newParam);
                this.setSupplementAreaInfo3(list, searchParam);
                for (EconomicAccountTable table : riskStatTableList) {
                    if (table == null) continue;
                    table.setAreaName(table.getAreaName() + "\u672c\u7ea7");
                    list.add(table);
                }
            } else {
                list = ((CompanyBusinessTableMapper)this.dao).getEconomicAccountTableList(searchParam);
                this.setSupplementAreaInfo3(list, searchParam);
            }
            return list;
        });
    }

    private void convertRiskWarnTable(RiskWarnTable table) {
        if (table == null) {
            return;
        }
        table.setFirstUnResolvedNum(Integer.valueOf(table.getFirstPushNum() - table.getFirstResolvedNum()));
        table.setYellowUnResolvedNum(Integer.valueOf(table.getYellowPushNum() - table.getYellowResolvedNum()));
        table.setRedUnResolvedNum(Integer.valueOf(table.getRedPushNum() - table.getRedResolvedNum()));
        table.setExUnResolvedNum(Integer.valueOf(table.getExPushNum() - table.getExResolvedNum()));
        table.setRiskNum(Integer.valueOf(table.getFirstPushNum() + table.getYellowPushNum() + table.getRedPushNum() + table.getExPushNum()));
        table.setRiskResolvedNum(Integer.valueOf(table.getFirstResolvedNum() + table.getYellowResolvedNum() + table.getRedResolvedNum() + table.getExResolvedNum()));
        table.setRiskUnResolvedNum(Integer.valueOf(table.getRiskNum() - table.getRiskResolvedNum()));
    }

    private void setSupplementAreaInfo1(List<RiskStateTable> list, CompanyBusinessTableParam searchParam) {
        if (searchParam.getIsCityLevelStreet().booleanValue()) {
            return;
        }
        searchParam.setIsAreaSearch(Boolean.valueOf(true));
        List<RiskStateTable> suppleList = ((CompanyBusinessTableMapper)this.dao).getRiskStatAreaTableList(searchParam);
        Set collect = list.stream().filter(item -> item != null && item.getAreaId() != null).map(RiskStateTable::getAreaId).collect(Collectors.toSet());
        for (RiskStateTable table : suppleList) {
            if (table == null || table.getAreaId() == null || collect.contains(table.getAreaId())) continue;
            list.add(table);
        }
        searchParam.setIsAreaSearch(Boolean.valueOf(false));
    }

    private void setSupplementAreaInfo2(List<RiskWarnTable> list, CompanyBusinessTableParam searchParam) {
        if (searchParam.getIsCityLevelStreet().booleanValue()) {
            return;
        }
        searchParam.setIsAreaSearch(Boolean.valueOf(true));
        List<RiskWarnTable> suppleList = ((CompanyBusinessTableMapper)this.dao).getRiskWarnAreaTableList(searchParam);
        Set collect = list.stream().filter(item -> item != null && item.getAreaId() != null).map(RiskWarnTable::getAreaId).collect(Collectors.toSet());
        for (RiskWarnTable table : suppleList) {
            if (table == null || table.getAreaId() == null || collect.contains(table.getAreaId())) continue;
            list.add(table);
        }
        searchParam.setIsAreaSearch(Boolean.valueOf(false));
    }

    private void setSupplementAreaInfo3(List<EconomicAccountTable> list, CompanyBusinessTableParam searchParam) {
        if (searchParam.getIsCityLevelStreet().booleanValue()) {
            return;
        }
        searchParam.setIsAreaSearch(Boolean.valueOf(true));
        List<EconomicAccountTable> suppleList = ((CompanyBusinessTableMapper)this.dao).getEconomicAccountAreaTableList(searchParam);
        Set collect = list.stream().filter(item -> item != null && item.getAreaId() != null).map(EconomicAccountTable::getAreaId).collect(Collectors.toSet());
        for (EconomicAccountTable table : suppleList) {
            if (table == null || table.getAreaId() == null || collect.contains(table.getAreaId())) continue;
            list.add(table);
        }
        searchParam.setIsAreaSearch(Boolean.valueOf(false));
    }

    @Transactional
    public void backUpTableLastWeek() {
        ((CompanyBusinessTableMapper)this.dao).cleanBackUpTable2();
        ((CompanyBusinessTableMapper)this.dao).saveBackUpTable2();
    }

    public HomeRiskControlVo getRiskControl(HomeIndexSearchVo searchVo) {
        HomeRiskControlVo riskControlVo = new HomeRiskControlVo();
        riskControlVo.setRedRiskNum(Integer.valueOf(0));
        CompanyBusinessTableParam searchParam = new CompanyBusinessTableParam().setAreaId(searchVo.getAreaId()).setLevel(searchVo.getAreaLevel()).setBelongType(searchVo.getBelongType()).setOnlyThisLevel(searchVo.getIsCurrent()).setOnlyShowFcCompany(Boolean.valueOf(Objects.equals(searchVo.getIsFcImportanceCompany(), 1)));
        RiskWarnTable riskWarnTable = this.headDataByRiskWarnTable(searchParam);
        riskControlVo.setCompletedReformNum(Integer.valueOf(riskWarnTable.getExResolvedNum() + riskWarnTable.getRedResolvedNum() + riskWarnTable.getYellowResolvedNum() + riskWarnTable.getFirstResolvedNum()));
        riskControlVo.setTotalReformNum(Integer.valueOf(riskWarnTable.getExPushNum() + riskWarnTable.getRedPushNum() + riskWarnTable.getYellowPushNum() + riskWarnTable.getFirstPushNum()));
        searchVo.setIsSearchOldTable(Boolean.valueOf(true));
        HomeRiskControlVo riskControlVoOld = (HomeRiskControlVo)this.redisClient.get(this.cacheName, searchVo.getAreaId() + ":" + searchVo.getAreaLevel() + ":" + searchVo.getIsCurrent(), 21600L, () -> ((CompanyBusinessTableMapper)this.dao).getHomeRiskControlInfo(searchVo));
        riskControlVo.setRate(riskControlVoOld);
        CompanyBusinessTableParam riskStatTableParam = new CompanyBusinessTableParam().setAreaId(searchVo.getAreaId()).setLevel(searchVo.getAreaLevel()).setBelongType(searchVo.getBelongType()).setOnlyThisLevel(searchVo.getIsCurrent()).setOnlyShowFcCompany(Boolean.valueOf(Objects.equals(searchVo.getIsFcImportanceCompany(), 1)));
        RiskStateTable riskStatTable = this.headDataByRiskStatTable(riskStatTableParam);
        if (riskStatTable == null) {
            return riskControlVo;
        }
        riskControlVo.setNeedKeyFactoryCompanyNum(riskStatTable.getNeedKeyFactoryComNum());
        riskControlVo.setNeedRiskCompanyNum(riskStatTable.getNeedKeyFactoryComNum());
        riskControlVo.setCompletedRiskNum(riskStatTable.getIsDefuseComNum());
        if (riskStatTable.getDefuseComRate() != null && riskControlVoOld.getFinishDefuseCompanyRate() != null) {
            double a = riskStatTable.getDefuseComRate();
            double b = Double.parseDouble(riskControlVoOld.getFinishDefuseCompanyRate());
            riskControlVo.setChainResolutionRate(String.format("%.2f", a - b));
            riskControlVo.setFinishDefuseCompanyRate(String.valueOf(a));
        }
        riskControlVo.setDefuseComRate(riskStatTable.getDefuseComRate());
        riskControlVo.setDetectionComRate(riskStatTable.getDetectionComRate());
        riskControlVo.setPhysicalCheckComRate(riskStatTable.getPhysicalCheckComRate());
        return riskControlVo;
    }

    public KeyFactoryRiskInfo keyFactoryRiskInfo(SearchParam searchParam) {
        CompanyBusinessTableParam riskStatTableParam = new CompanyBusinessTableParam().setAreaId(searchParam.getAreaId()).setLevel(searchParam.getLevel()).setBelongType(searchParam.getBelongType()).setOnlyThisLevel(searchParam.getIsCurrent()).setOnlyShowFcCompany(searchParam.getOnlyShowFcCompany()).setSystemDeploymentSource(searchParam.getSystemDeploymentSource()).setScales(searchParam.getScales()).setScaleList(searchParam.getScaleList()).setIsPilotProject(searchParam.getIsPilotProject());
        RiskStateTable riskStatTable = this.headDataByRiskStatTable(riskStatTableParam);
        KeyFactoryRiskInfo info = new KeyFactoryRiskInfo();
        info.setPortraitCompanyNum(riskStatTable.getNeedKeyFactoryComNum());
        info.setExistRiskCompanyNum(riskStatTable.getExistRiskComNum());
        info.setNoRiskCompanyNum(riskStatTable.getIsDefuseComNum());
        info.setNoResolveCompanyNum(riskStatTable.getExistRiskComNum());
        info.setResolveCompanyNum(riskStatTable.getIsDefuseComNum());
        info.setDefuseRate(riskStatTable.getDefuseComRateStr());
        info.setDetectionResolvedCompanyNum(riskStatTable.getDetectionResolveComNum());
        info.setPhyCheckResolvedCompanyNum(riskStatTable.getPhysicalCheckResolveComNum());
        info.setDetectionCompanyNum(riskStatTable.getDetectionComNum());
        info.setPhyCheckCompanyNum(riskStatTable.getPhysicalCheckComNum());
        info.setDetectionResolveRate(riskStatTable.getDetectionComRateStr());
        info.setPhyCheckResolveRate(riskStatTable.getPhysicalCheckComRateStr());
        if (Objects.equals(true, searchParam.getIsPilotProject())) {
            info.setFuture3MonthExistRiskCompanyNum(this.companyRiskProspectService.getCountSoonWarning(riskStatTableParam));
        }
        return info;
    }

    public RankInfo rankData(SearchParam searchParam) {
        RankInfo info = new RankInfo();
        CompanyBusinessTableParam riskStatTableParam = new CompanyBusinessTableParam().setAreaId(searchParam.getAreaId()).setLevel(searchParam.getLevel()).setBelongType(searchParam.getBelongType()).setOnlyThisLevel(searchParam.getIsCurrent()).setOnlyShowFcCompany(searchParam.getOnlyShowFcCompany()).setIsPilotProject(searchParam.getIsPilotProject());
        RiskStateTable riskStatTable = this.headDataByRiskStatTable(riskStatTableParam);
        if (riskStatTable != null) {
            info.setAreaId(riskStatTable.getAreaId());
            info.setAreaName(riskStatTable.getAreaName());
            info.setDefuseRate(riskStatTable.getDefuseComRateStr());
            info.setDetectionRate(riskStatTable.getDetectionComRateStr());
            info.setPhysicalCheckRate(riskStatTable.getPhysicalCheckComRateStr());
        }
        this.economicAccountStatementDataFetch(searchParam, info);
        return info;
    }

    public List<RiskStateTable> completeRateSort(CompanyBusinessTableParam searchParam) {
        if (searchParam.getIsFinished().booleanValue()) {
            List<RiskStateTable> riskStatTables = this.listDataByRiskStatTable(searchParam);
            return riskStatTables;
        }
        List<RiskStateTable> riskStatTables = this.listDataByRiskStatTable(searchParam);
        for (RiskStateTable riskStatTable : riskStatTables) {
            if (riskStatTable == null) continue;
            riskStatTable.setIsDefuseComNum(Integer.valueOf(riskStatTable.getNeedKeyFactoryComNum() - riskStatTable.getIsDefuseComNum()));
            BigDecimal hundred = new BigDecimal("100.00");
            BigDecimal defuseComRate = BigDecimal.valueOf(riskStatTable.getDefuseComRate());
            BigDecimal result = hundred.subtract(defuseComRate).setScale(2, RoundingMode.HALF_UP);
            riskStatTable.setDefuseComRate(Double.valueOf(result.doubleValue()));
        }
        return riskStatTables;
    }

    public HomeRiskWarnVo getHomeRiskWarnVo(CompanyBusinessTableParam searchVo) {
        RiskWarnTable riskWarnTable = this.headDataByRiskWarnTable(searchVo);
        HomeRiskWarnVo vo = new HomeRiskWarnVo();
        if (riskWarnTable == null) {
            return vo;
        }
        RiskWarnItem exItem = new RiskWarnItem();
        exItem.setTotalNum(riskWarnTable.getExPushNum());
        exItem.setResolvedNum(riskWarnTable.getExResolvedNum());
        exItem.setUnresolvedNum(Integer.valueOf(exItem.getTotalNum() - riskWarnTable.getExResolvedNum()));
        vo.setExLaw(exItem);
        RiskWarnItem redItem = new RiskWarnItem();
        redItem.setTotalNum(Integer.valueOf(riskWarnTable.getExPushNum() + riskWarnTable.getRedPushNum()));
        redItem.setResolvedNum(riskWarnTable.getRedResolvedNum());
        redItem.setUnresolvedNum(Integer.valueOf(redItem.getTotalNum() - riskWarnTable.getRedPushNum()));
        vo.setRedAlert(redItem);
        RiskWarnItem yellItem = new RiskWarnItem();
        yellItem.setTotalNum(Integer.valueOf(riskWarnTable.getExPushNum() + riskWarnTable.getRedPushNum() + riskWarnTable.getYellowPushNum()));
        yellItem.setResolvedNum(riskWarnTable.getYellowResolvedNum());
        yellItem.setUnresolvedNum(Integer.valueOf(yellItem.getTotalNum() - riskWarnTable.getYellowResolvedNum()));
        vo.setYellowAlert(yellItem);
        RiskWarnItem firstItem = new RiskWarnItem();
        firstItem.setTotalNum(Integer.valueOf(riskWarnTable.getExPushNum() + riskWarnTable.getRedPushNum() + riskWarnTable.getYellowPushNum() + riskWarnTable.getFirstPushNum()));
        firstItem.setResolvedNum(riskWarnTable.getFirstResolvedNum());
        firstItem.setUnresolvedNum(Integer.valueOf(firstItem.getTotalNum() - riskWarnTable.getFirstUnResolvedNum()));
        vo.setFirstPush(firstItem);
        return vo;
    }

    private void economicAccountStatementDataFetch(SearchParam searchParam, RankInfo rankInfo) {
        Long regionId = searchParam.getAreaId();
        Byte regionLevel = searchParam.getAreaLevel() != null ? searchParam.getAreaLevel() : (searchParam.getLevel() != null ? searchParam.getLevel() : (byte)0);
        int isFcImportanceCompany = searchParam.getOnlyShowFcCompany() != false ? 1 : 0;
        Integer belongType = searchParam.getBelongType();
        Boolean isCurrent = searchParam.getIsCurrent();
        RiskVisualDto dto = (RiskVisualDto)this.redisClient.get(this.cacheName, "visualEconomicAccountStatementDataFetch" + searchParam.hashCode(), 10800L, () -> this.reformItemBasicEconomyService.visualEconomicAccountStatementDataFetch(regionId, regionLevel, Integer.valueOf(isFcImportanceCompany), belongType, isCurrent));
        Long num = dto.getNum();
        BigDecimal amount = dto.getAccount();
        log.error("\u3010\u6253\u5370ERROR\u65e5\u5fd7\u3011\u76d1\u7ba1\u7aef::\u536b\u4f01\u98ce\u63a7::\u7ecf\u6d4e\u8d26::\u5173\u952e\u6570\u636e\u7ed3\u679c::\u5df2\u5316\u89e3\u98ce\u9669\u4f01\u4e1a\u6570[{}]::\u514d\u4e8e\u5904\u7f5a\u989d\u5ea6[{}]", (Object)num, (Object)amount);
        rankInfo.setFreePunishAmount(SysConvertTool.convertUnit((BigDecimal)amount)).setMostFreePunishAmount(SysConvertTool.convertUnit((BigDecimal)Convert.toBigDecimal((Object)num).multiply(RiskCalculator.MOST_FREE_RATE).setScale(2, RoundingMode.HALF_UP))).setLeastFreePunishAmount(SysConvertTool.convertUnit((BigDecimal)Convert.toBigDecimal((Object)num).multiply(RiskCalculator.LESS_FREE_RATE).setScale(2, RoundingMode.HALF_UP)));
    }
}

