/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.company.service;

import cn.smarthse.common.framework.redis.RedisClient;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.company.dao.CompanyBusinessTable20250630Mapper;
import cn.smarthse.modules.health.company.service.ICompanyBusinessTable20250630Service;
import cn.smarthse.modules.health.entity.base.company.CompanyBusinessTable20250630;
import cn.smarthse.modules.health.param.CompanyBusinessTableParam;
import cn.smarthse.modules.health.param.SearchParam;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicEconomyService;
import cn.smarthse.modules.health.supervise.model.keyFactory.EconomicAccountTable;
import cn.smarthse.modules.health.vo.riskResolve.RiskVisualDto;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@DubboService
public class CompanyBusinessTable20250630ServiceImpl
extends BaseServiceImpl<CompanyBusinessTable20250630Mapper, CompanyBusinessTable20250630>
implements ICompanyBusinessTable20250630Service {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CompanyBusinessTable20250630ServiceImpl.class);
    @DubboReference
    IReformItemBasicEconomyService reformItemBasicEconomyService;
    @Autowired
    RedisClient redisClient;
    private String cacheName = "ICompanyBusinessTable20250630Service";
    public static final int TIMEOUT = 10800;

    @Transactional(readOnly=false)
    public void generateCompanyBusinessTable20250630() {
        ((CompanyBusinessTable20250630Mapper)this.dao).truncateCompanyBusinessTable20250630();
        ((CompanyBusinessTable20250630Mapper)this.dao).getCompanyBusinessTable20250630List();
        this.redisClient.delPrefix(this.cacheName);
    }

    public EconomicAccountTable headDataByEconomicAccountTable(CompanyBusinessTableParam searchParam) {
        return (EconomicAccountTable)this.redisClient.get(this.cacheName, "headDataByEconomicAccountTable:" + searchParam.hashCode(), 10800L, () -> {
            searchParam.setIsHeader(Boolean.valueOf(true));
            if (Objects.equals(true, searchParam.getIsCityLevelStreet())) {
                searchParam.setBelongType(Integer.valueOf(2));
                searchParam.setOnlyThisLevel(Boolean.valueOf(true));
            }
            List<EconomicAccountTable> list = ((CompanyBusinessTable20250630Mapper)this.dao).getEconomicAccountTableList(searchParam);
            this.setSupplementAreaInfo3(list, searchParam);
            if (CollectionUtils.isEmpty(list) || list.get(0) == null) {
                return null;
            }
            EconomicAccountTable table = list.get(0);
            if (Objects.equals(true, searchParam.getIsCityLevelStreet())) {
                table.setAreaName(table.getAreaName() + "\u672c\u7ea7");
            }
            return table;
        });
    }

    public List<EconomicAccountTable> listDataByEconomicAccountTable(CompanyBusinessTableParam searchParam) {
        return (List)this.redisClient.get(this.cacheName, "listDataByEconomicAccountTable:" + searchParam.hashCode(), 10800L, () -> {
            ArrayList<EconomicAccountTable> list = new ArrayList();
            if (Objects.equals((byte)4, searchParam.getLevel())) {
                return Collections.emptyList();
            }
            if (Objects.equals(true, searchParam.getIsCityLevelStreet())) {
                searchParam.setBelongType(Integer.valueOf(2));
                searchParam.setOnlyThisLevel(Boolean.valueOf(true));
            }
            if (Objects.equals((byte)2, searchParam.getLevel()) && !Objects.equals(true, searchParam.getIsCityLevelStreet())) {
                CompanyBusinessTableParam newSearchParam = new CompanyBusinessTableParam();
                BeanUtils.copyProperties((Object)searchParam, (Object)newSearchParam);
                if (!Objects.equals(true, searchParam.getOnlyThisLevel())) {
                    newSearchParam.setBelongType(Integer.valueOf(0));
                    newSearchParam.setOnlyThisLevel(Boolean.valueOf(true));
                    List<EconomicAccountTable> list2 = ((CompanyBusinessTable20250630Mapper)this.dao).getEconomicAccountTableList(newSearchParam);
                    this.setSupplementAreaInfo3(list2, searchParam);
                    list.addAll(list2);
                }
                if (!Objects.equals(false, searchParam.getOnlyThisLevel())) {
                    newSearchParam.setBelongType(Integer.valueOf(2));
                    newSearchParam.setOnlyThisLevel(Boolean.valueOf(true));
                    newSearchParam.setIsCityLevelStreet(Boolean.valueOf(true));
                    EconomicAccountTable table = this.headDataByEconomicAccountTable(newSearchParam);
                    if (table != null) {
                        list.add(table);
                    }
                }
            } else if (Objects.equals(true, searchParam.getIsCounty())) {
                CompanyBusinessTableParam newParam = new CompanyBusinessTableParam();
                if (Objects.equals(true, searchParam.getIsPilotProject())) {
                    newParam.setIsPilotProject(Boolean.valueOf(true));
                }
                newParam.setAreaId(searchParam.getAreaId());
                newParam.setLevel(searchParam.getLevel());
                newParam.setBelongType(Integer.valueOf(2));
                newParam.setOnlyThisLevel(Boolean.valueOf(true));
                List<EconomicAccountTable> riskStatTableList = ((CompanyBusinessTable20250630Mapper)this.dao).getEconomicAccountTableList(newParam);
                newParam.setBelongType(Integer.valueOf(0));
                newParam.setOnlyThisLevel(Boolean.valueOf(true));
                newParam.setIsCounty(Boolean.valueOf(true));
                list = ((CompanyBusinessTable20250630Mapper)this.dao).getEconomicAccountTableList(newParam);
                this.setSupplementAreaInfo3(list, searchParam);
                for (EconomicAccountTable table : riskStatTableList) {
                    if (table == null) continue;
                    table.setAreaName(table.getAreaName() + "\u672c\u7ea7");
                    list.add(table);
                }
            } else {
                list = ((CompanyBusinessTable20250630Mapper)this.dao).getEconomicAccountTableList(searchParam);
                this.setSupplementAreaInfo3(list, searchParam);
            }
            return list;
        });
    }

    private void setSupplementAreaInfo3(List<EconomicAccountTable> list, CompanyBusinessTableParam searchParam) {
        if (searchParam.getIsCityLevelStreet().booleanValue()) {
            return;
        }
        searchParam.setIsAreaSearch(Boolean.valueOf(true));
        List<EconomicAccountTable> suppleList = ((CompanyBusinessTable20250630Mapper)this.dao).getEconomicAccountAreaTableList(searchParam);
        Set collect = list.stream().filter(item -> item != null && item.getAreaId() != null).map(EconomicAccountTable::getAreaId).collect(Collectors.toSet());
        for (EconomicAccountTable table : suppleList) {
            if (table == null || table.getAreaId() == null || collect.contains(table.getAreaId())) continue;
            list.add(table);
        }
        searchParam.setIsAreaSearch(Boolean.valueOf(false));
    }

    private void provinceVisualEconomicAccount() {
        SearchParam param = new SearchParam();
        param.setLimit(null);
        param.setRows(null);
        param.setPage(Integer.valueOf(1));
        param.setKeywords(null);
        param.setFinish(null);
        param.setClosed(null);
        param.setAreaId(Long.valueOf(330000000000L));
        param.setAreaName(null);
        param.setLevel(Byte.valueOf((byte)1));
        param.setCompanyLevel(null);
        param.setIsCurrent(null);
        param.setOnlyThisLevel(null);
        param.setCid(null);
        param.setStatus(null);
        param.setType(Byte.valueOf((byte)3));
        param.setStatusList(null);
        param.setUnifiedSocialCc(null);
        param.setIsExistRadioactivity(Boolean.valueOf(false));
        param.setContainPausedBusiness(Boolean.valueOf(false));
        param.setPickupCount(Boolean.valueOf(false));
        param.setGenerationSource(null);
        param.setBelongType(Integer.valueOf(1));
        param.setAreaParentId(null);
        param.setProvinceId(null);
        param.setYear(null);
        param.setCompanyType(null);
        param.setContainCompanyType(null);
        param.setContainVictimLess3Company(Boolean.valueOf(false));
        param.setContainCloseCompany(null);
        param.setIsCity(Boolean.valueOf(false));
        param.setIsCounty(Boolean.valueOf(false));
        param.setFilterNoDataArea(Boolean.valueOf(false));
        param.setDataSource(null);
        param.setSort(null);
        param.setProjectCode(null);
        param.setNoCode(Boolean.valueOf(false));
        param.setImportBatchNo(null);
        param.setBusinessState(null);
        param.setBusinessStateList(null);
        param.setStorageList(null);
        param.setIsFcyth(null);
        param.setIsFcImportanceCompany(null);
        param.setConfirmType(Integer.valueOf(1));
        param.setIsMatchCompany(null);
        param.setBeginTime(null);
        param.setEndTime(null);
        param.setBeginDate(null);
        param.setEndDate(null);
        param.setSystemDeploymentSource(null);
        param.setIsGuideNewCompany(Boolean.valueOf(false));
        param.setIsClassified(null);
        param.setOnlyShowFcCompany(Boolean.valueOf(false));
        param.setIsDeclare(null);
        param.setAreaLevel(null);
        param.setEnterDecYear(null);
        param.setCompanyRadioactivityType(null);
        SearchParam param1 = new SearchParam();
        BeanUtils.copyProperties((Object)param, (Object)param1);
        param1.setIsCurrent(null);
        RiskVisualDto dto1 = (RiskVisualDto)this.redisClient.get(this.cacheName, "visualEconomicAccountStatementDataFetch" + param1.hashCode(), 10800L, () -> this.reformItemBasicEconomyService.visualEconomicAccountStatementDataFetch(Long.valueOf(330000000000L), Byte.valueOf((byte)1), Integer.valueOf(0), Integer.valueOf(1), null));
        SearchParam param2 = new SearchParam();
        BeanUtils.copyProperties((Object)param, (Object)param2);
        param2.setIsCurrent(Boolean.valueOf(true));
        RiskVisualDto dto2 = (RiskVisualDto)this.redisClient.get(this.cacheName, "visualEconomicAccountStatementDataFetch" + param2.hashCode(), 10800L, () -> this.reformItemBasicEconomyService.visualEconomicAccountStatementDataFetch(Long.valueOf(330000000000L), Byte.valueOf((byte)1), Integer.valueOf(0), Integer.valueOf(1), Boolean.valueOf(true)));
        SearchParam param3 = new SearchParam();
        BeanUtils.copyProperties((Object)param, (Object)param3);
        param3.setIsCurrent(Boolean.valueOf(false));
        RiskVisualDto dto3 = (RiskVisualDto)this.redisClient.get(this.cacheName, "visualEconomicAccountStatementDataFetch" + param3.hashCode(), 10800L, () -> this.reformItemBasicEconomyService.visualEconomicAccountStatementDataFetch(Long.valueOf(330000000000L), Byte.valueOf((byte)1), Integer.valueOf(0), Integer.valueOf(1), Boolean.valueOf(false)));
    }
}

