/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.busilog.service;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.common.framework.Constants;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.modules.busilog.RecordOperationLog;
import cn.smarthse.modules.busilog.RecordOperationLogParam;
import cn.smarthse.modules.busilog.RecordOperationLogVo;
import cn.smarthse.modules.busilog.RecordOperationTypeEnum;
import cn.smarthse.modules.datacentre.enums.CompanyBusinessState;
import cn.smarthse.modules.datacentre.enums.CompanyDataSourceEnum;
import cn.smarthse.modules.datacentre.enums.CompanyGradeReasonEnum;
import cn.smarthse.modules.datacentre.enums.CompanySizeEnum;
import cn.smarthse.modules.datacentre.model.system.SysParamModel;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.datacentre.provider.system.ISysParamProvideService;
import cn.smarthse.modules.datacentre.provider.system.IndustryProvideService;
import cn.smarthse.modules.health.busilog.IBusilogService;
import cn.smarthse.modules.health.busilog.dao.BusiRecordLogMapper;
import cn.smarthse.modules.health.supervise.entity.basic.Organization;
import cn.smarthse.modules.health.supervise.enums.companyChange.CompanyChangeVictimsIdentifyEnum;
import cn.smarthse.modules.health.supervise.service.basic.IOrganizationService;
import cn.smarthse.modules.health.supervise.service.basic.IOrganizationUserService;
import cn.smarthse.modules.health.thirdOrganization.entity.org.ThirdOrganization;
import cn.smarthse.modules.health.thirdOrganization.service.org.IThirdOrganizationService;
import cn.smarthse.modules.platform.model.AreaModel;
import cn.smarthse.services.hfi.api.entity.CheckPlan;
import cn.smarthse.services.hfi.api.service.ICheckPlanService;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageInfo;
import com.github.pagehelper.page.PageMethod;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.transaction.annotation.Transactional;

@DubboService
@Transactional(readOnly=true)
public class BusilogServiceImpl
extends BaseServiceImpl<BusiRecordLogMapper, RecordOperationLog>
implements IBusilogService {
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService areaService;
    @DubboReference
    private IOrganizationService organizationService;
    @DubboReference(version="1.0.0")
    private ISysParamProvideService sysParamService;
    @DubboReference
    private ICheckPlanService checkPlanService;
    @DubboReference
    private IThirdOrganizationService thirdOrganizationService;
    @DubboReference(version="1.0.0")
    private IndustryProvideService industryService;
    @DubboReference
    private IOrganizationUserService organizationUserService;

    public PageInfo<RecordOperationLogVo> getLogPageList(JqGridParam pageParam, RecordOperationLogParam logParam) {
        Page busiLogPage = PageMethod.startPage((int)pageParam.getPage(), (int)pageParam.getRows());
        Byte busiType = Convert.toByte((Object)logParam.getType());
        RecordOperationTypeEnum busiEnum = RecordOperationTypeEnum.getEnum((Byte)busiType);
        List<RecordOperationLogVo> busiLogList = busiEnum == null ? ((BusiRecordLogMapper)this.dao).getAllChangeList(logParam) : (busiEnum == RecordOperationTypeEnum.VICTIMS_CHANGE1 || busiEnum == RecordOperationTypeEnum.VICTIMS_CHANGE2 ? ((BusiRecordLogMapper)this.dao).getVictimsChangeList(logParam) : ((BusiRecordLogMapper)this.dao).getOtherChangeList(logParam));
        ArrayList<Long> regionIdList = new ArrayList<Long>();
        ArrayList<Long> orgIdList = new ArrayList<Long>();
        ArrayList<Long> industryRegisterIdList = new ArrayList<Long>();
        ArrayList<Long> checkSourceIdList = new ArrayList<Long>();
        ArrayList<Long> registerList = new ArrayList<Long>();
        for (RecordOperationLogVo log : busiLogList) {
            Byte type;
            RecordOperationTypeEnum typeEnum;
            if (Objects.equals(log.getCreateBy(), Constants.SYSTEM_AUTOMATIC_CONFIRMATION_KEY)) {
                log.setOperator("\u7cfb\u7edf\u81ea\u52a8\u786e\u8ba4");
            }
            if (Objects.isNull(log.getBusiType()) || Objects.isNull(typeEnum = RecordOperationTypeEnum.getEnum((Byte)(type = Convert.toByte((Object)log.getBusiType()))))) continue;
            String bi = log.getBeforeInfo();
            String ai = log.getAfterInfo();
            switch (typeEnum) {
                case REGION_CHANGE: 
                case REGISTER_ADDRESS_ID: {
                    if (!"null".equalsIgnoreCase(bi) && !"-".equals(bi) && CharSequenceUtil.isNotBlank((CharSequence)bi)) {
                        regionIdList.add(Long.valueOf(bi));
                    }
                    if ("null".equalsIgnoreCase(ai) || "-".equals(ai) || !CharSequenceUtil.isNotBlank((CharSequence)ai)) break;
                    regionIdList.add(Long.valueOf(ai));
                    break;
                }
                case SUP_ORG_CHANGE: {
                    if (!"null".equalsIgnoreCase(bi) && !"-".equals(bi) && CharSequenceUtil.isNotBlank((CharSequence)bi)) {
                        orgIdList.add(Long.valueOf(bi));
                    }
                    if ("null".equalsIgnoreCase(ai) || "-".equals(ai) || !CharSequenceUtil.isNotBlank((CharSequence)ai)) break;
                    orgIdList.add(Long.valueOf(ai));
                    break;
                }
                case INDUSTRY_CATEGORY_CHANGE: {
                    if (!"null".equalsIgnoreCase(bi) && !"-".equals(bi) && CharSequenceUtil.isNotBlank((CharSequence)bi)) {
                        industryRegisterIdList.add(Long.valueOf(bi));
                    }
                    if (!"null".equalsIgnoreCase(ai) && !"-".equals(ai) && CharSequenceUtil.isNotBlank((CharSequence)ai)) {
                        industryRegisterIdList.add(Long.valueOf(ai));
                    }
                    if (Objects.equals(log.getSourceId(), null)) break;
                    checkSourceIdList.add(log.getSourceId());
                    break;
                }
                case REGISTER_TYPE_CHANGE: {
                    if (!"null".equalsIgnoreCase(bi) && !"-".equals(bi) && CharSequenceUtil.isNotBlank((CharSequence)bi)) {
                        registerList.add(Long.valueOf(bi));
                    }
                    if ("null".equalsIgnoreCase(ai) || "-".equals(ai) || !CharSequenceUtil.isNotBlank((CharSequence)ai)) break;
                    registerList.add(Long.valueOf(ai));
                    break;
                }
            }
        }
        Map<Long, AreaModel> regionMap = this.batchGetRegionMap(regionIdList);
        Map<Long, Organization> orgMap = this.batchGetOrgMap(orgIdList);
        Map<Long, SysParamModel> irMap = this.batchGetIndustryRegister(industryRegisterIdList);
        Map<Long, SysParamModel> iMap = this.batchGetRegister(registerList);
        Map<Long, CheckPlan> checkSourceMap = this.batchGetCheckSource(checkSourceIdList);
        ArrayList<Long> victimsChange2OperatorList = new ArrayList<Long>();
        for (RecordOperationLogVo log : busiLogList) {
            boolean isSup;
            boolean businessStateChange;
            Byte type = Convert.toByte((Object)log.getBusiType());
            RecordOperationTypeEnum typeEnum = RecordOperationTypeEnum.getEnum((Byte)type);
            String title = log.getLogTitle();
            Object logTitle = "\u7531 %s \u53d8\u66f4\u4e3a %s ";
            boolean bl = businessStateChange = typeEnum == RecordOperationTypeEnum.BUSI_TYPE_CHANGE;
            if (businessStateChange && CharSequenceUtil.isNotBlank((CharSequence)title) && title.contains("\uff08\u5e02\u573a\u76d1\u7ba1\u6570\u636e\u4e2d\u8be5\u4f01\u4e1a\u5df2\u6ce8\u9500\uff09")) {
                logTitle = (String)logTitle + "\uff08\u5e02\u573a\u76d1\u7ba1\u6570\u636e\u4e2d\u8be5\u4f01\u4e1a\u5df2\u6ce8\u9500\uff09";
            }
            log.setBusiTypeName(RecordOperationTypeEnum.getValue((Byte)type));
            if (Objects.isNull(typeEnum)) continue;
            String bi = log.getBeforeInfo();
            String ai = log.getAfterInfo();
            switch (typeEnum) {
                case BUSI_TYPE_CHANGE: {
                    String befBusinessState = this.getBusinessStateString(Convert.toByte((Object)bi));
                    String aftBusinessState = this.getBusinessStateString(Convert.toByte((Object)ai));
                    logTitle = String.format((String)logTitle, befBusinessState, aftBusinessState);
                    log.setBeforeInfo(befBusinessState);
                    log.setAfterInfo(aftBusinessState);
                    log.setLogTitle((String)logTitle);
                    break;
                }
                case GRADE_REASON_CHANGE: {
                    String befGradeReason = this.getGradeReasonString(Convert.toInt((Object)bi));
                    String aftGradeReason = this.getGradeReasonString(Convert.toInt((Object)ai));
                    logTitle = String.format((String)logTitle, befGradeReason, aftGradeReason);
                    log.setBeforeInfo(befGradeReason);
                    log.setAfterInfo(aftGradeReason);
                    log.setLogTitle((String)logTitle);
                    break;
                }
                case REGION_CHANGE: {
                    String befRegion = "null".equalsIgnoreCase(bi) || "-".equals(bi) || CharSequenceUtil.isBlank((CharSequence)bi) ? "-" : BusilogServiceImpl.fullName(regionMap.get(Convert.toLong((Object)bi)));
                    String aftRegion = "null".equalsIgnoreCase(ai) || "-".equals(ai) || CharSequenceUtil.isBlank((CharSequence)ai) ? "-" : BusilogServiceImpl.fullName(regionMap.get(Convert.toLong((Object)ai)));
                    logTitle = String.format((String)logTitle, befRegion, aftRegion);
                    log.setBeforeInfo(befRegion);
                    log.setAfterInfo(aftRegion);
                    log.setLogTitle((String)logTitle);
                    break;
                }
                case SUP_ORG_CHANGE: {
                    String befSup;
                    String string = "null".equalsIgnoreCase(bi) || "-".equals(bi) || CharSequenceUtil.isBlank((CharSequence)bi) ? "-" : (befSup = Objects.isNull(orgMap.get(Convert.toLong((Object)bi))) ? "-" : orgMap.get(Convert.toLong((Object)bi)).getName());
                    String aftSup = "null".equalsIgnoreCase(ai) || "-".equals(ai) || CharSequenceUtil.isBlank((CharSequence)ai) ? "-" : (Objects.isNull(orgMap.get(Convert.toLong((Object)ai))) ? "-" : orgMap.get(Convert.toLong((Object)ai)).getName());
                    logTitle = String.format((String)logTitle, befSup, aftSup);
                    log.setLogTitle((String)logTitle);
                    break;
                }
                case INDUSTRY_CATEGORY_CHANGE: {
                    String befIndustry;
                    SysParamModel befParam = irMap.get(Convert.toLong((Object)bi));
                    SysParamModel aftParam = irMap.get(Convert.toLong((Object)ai));
                    String string = "null".equalsIgnoreCase(bi) || "-".equals(bi) || CharSequenceUtil.isBlank((CharSequence)bi) ? "-" : (befIndustry = Objects.isNull(befParam) ? "-" : befParam.getParamCode() + "-" + befParam.getParamValue());
                    String aftIndustry = "null".equalsIgnoreCase(ai) || "-".equals(ai) || CharSequenceUtil.isBlank((CharSequence)ai) ? "-" : (Objects.isNull(aftParam) ? "-" : aftParam.getParamCode() + "-" + aftParam.getParamValue());
                    logTitle = String.format((String)logTitle, befIndustry, aftIndustry);
                    log.setBeforeInfo(befIndustry);
                    log.setAfterInfo(aftIndustry);
                    CheckPlan checkPlan = checkSourceMap.get(log.getSourceId());
                    if (checkPlan != null) {
                        log.setCheckDate(DateUtils.localDateTimeToDate((LocalDateTime)checkPlan.getCheckDateBegin()));
                        log.setCheckOrgName(checkPlan.getThirdOrgName());
                    }
                    log.setLogTitle((String)logTitle);
                    break;
                }
                case REGISTER_TYPE_CHANGE: {
                    String befRegName;
                    String string = "null".equalsIgnoreCase(bi) || "-".equals(bi) || CharSequenceUtil.isBlank((CharSequence)bi) ? "-" : (befRegName = Objects.isNull(iMap.get(Convert.toLong((Object)bi))) ? "-" : iMap.get(Convert.toLong((Object)bi)).getParamValue());
                    String aftRegName = "null".equalsIgnoreCase(ai) || "-".equals(ai) || CharSequenceUtil.isBlank((CharSequence)ai) ? "-" : (Objects.isNull(iMap.get(Convert.toLong((Object)ai))) ? "-" : iMap.get(Convert.toLong((Object)ai)).getParamValue());
                    log.setBeforeInfo(befRegName);
                    log.setAfterInfo(aftRegName);
                    logTitle = String.format((String)logTitle, befRegName, aftRegName);
                    log.setLogTitle((String)logTitle);
                    break;
                }
                case DATA_SOURCE_CHANGE: {
                    String befSource = CompanyDataSourceEnum.getName((Integer)Convert.toInt((Object)bi));
                    String aftSource = CompanyDataSourceEnum.getName((Integer)Convert.toInt((Object)ai));
                    logTitle = String.format((String)logTitle, befSource, aftSource);
                    log.setLogTitle((String)logTitle);
                    break;
                }
                case FCYTH_CHANGE: {
                    logTitle = String.format((String)logTitle, Boolean.TRUE.equals(Convert.toBool((Object)bi)) ? "\u662f" : "\u5426", Boolean.TRUE.equals(Convert.toBool((Object)ai)) ? "\u662f" : "\u5426");
                    log.setLogTitle((String)logTitle);
                    break;
                }
                case REGISTER_ADDRESS_ID: {
                    String befAddr = "null".equalsIgnoreCase(bi) || "-".equals(bi) || CharSequenceUtil.isBlank((CharSequence)bi) ? "-" : BusilogServiceImpl.fullName(regionMap.get(Convert.toLong((Object)bi)));
                    String aftAddr = "null".equalsIgnoreCase(ai) || "-".equals(ai) || CharSequenceUtil.isBlank((CharSequence)ai) ? "-" : BusilogServiceImpl.fullName(regionMap.get(Convert.toLong((Object)ai)));
                    log.setBeforeInfo(befAddr);
                    log.setAfterInfo(aftAddr);
                    logTitle = String.format((String)logTitle, befAddr, aftAddr);
                    log.setLogTitle((String)logTitle);
                    break;
                }
                case REGISTER_DETAIL: {
                    logTitle = String.format((String)logTitle, CharSequenceUtil.isBlank((CharSequence)bi) ? "-" : bi, CharSequenceUtil.isBlank((CharSequence)ai) ? "-" : ai);
                    log.setLogTitle((String)logTitle);
                    break;
                }
                case LEGAL_NAME: {
                    logTitle = String.format((String)logTitle, CharSequenceUtil.isBlank((CharSequence)bi) ? "-" : bi, CharSequenceUtil.isBlank((CharSequence)ai) ? "-" : ai);
                    log.setLogTitle((String)logTitle);
                    break;
                }
                case HEALTH_MANAGEMENT_ORG: {
                    String befOrg = this.getOrg(bi);
                    String aftOrg = this.getOrg(ai);
                    logTitle = String.format((String)logTitle, befOrg, aftOrg);
                    log.setBeforeInfo(befOrg);
                    log.setAfterInfo(aftOrg);
                    log.setLogTitle((String)logTitle);
                    break;
                }
                case IDENTIFY_REAL_NUM_CHANGE: {
                    Long befRealNum = Convert.toLong((Object)bi);
                    Long aftRealNum = Convert.toLong((Object)ai);
                    logTitle = String.format((String)logTitle, befRealNum, aftRealNum);
                    log.setLogTitle((String)logTitle);
                    break;
                }
                case WORK_ADDRESS_CHANGE: {
                    logTitle = String.format((String)logTitle, CharSequenceUtil.isBlank((CharSequence)bi) ? "-" : bi, CharSequenceUtil.isBlank((CharSequence)ai) ? "-" : ai);
                    log.setLogTitle((String)logTitle);
                    break;
                }
                case SCALE_CHANGE: {
                    String befScale = CompanySizeEnum.getName((Integer)Convert.toInt((Object)bi));
                    String aftScale = CompanySizeEnum.getName((Integer)Convert.toInt((Object)ai));
                    logTitle = String.format((String)logTitle, befScale, aftScale);
                    log.setBeforeInfo(befScale);
                    log.setAfterInfo(aftScale);
                    log.setLogTitle((String)logTitle);
                    break;
                }
                case SCALE_CHANGE_YCQ: {
                    String befYcqScale = CompanySizeEnum.getName((Integer)Convert.toInt((Object)bi));
                    String aftYcqScale = CompanySizeEnum.getName((Integer)Convert.toInt((Object)ai));
                    logTitle = String.format((String)logTitle, befYcqScale, aftYcqScale);
                    log.setBeforeInfo(befYcqScale);
                    log.setAfterInfo(aftYcqScale);
                    log.setLogTitle((String)logTitle);
                    break;
                }
                case LEGAL_CARD_TYPE_CHANGE: {
                    String befTypeName = this.legalCardTypeName(bi);
                    String aftTypeName = this.legalCardTypeName(ai);
                    befTypeName = CharSequenceUtil.isBlank((CharSequence)befTypeName) ? "\u7a7a" : befTypeName;
                    aftTypeName = CharSequenceUtil.isBlank((CharSequence)aftTypeName) ? "\u7a7a" : aftTypeName;
                    logTitle = String.format((String)logTitle, befTypeName, aftTypeName);
                    log.setBeforeInfo(befTypeName);
                    log.setAfterInfo(aftTypeName);
                    log.setLogTitle((String)logTitle);
                    break;
                }
                case LEGAL_CARD_ID_CHANGE: {
                    String befIdC = "null".equalsIgnoreCase(bi) || "-".equals(bi) || CharSequenceUtil.isBlank((CharSequence)bi) ? "-" : bi;
                    String aftIdC = "null".equalsIgnoreCase(ai) || "-".equals(ai) || CharSequenceUtil.isBlank((CharSequence)ai) ? "-" : ai;
                    befIdC = CharSequenceUtil.isBlank((CharSequence)befIdC) ? "\u7a7a" : befIdC;
                    aftIdC = CharSequenceUtil.isBlank((CharSequence)aftIdC) ? "\u7a7a" : aftIdC;
                    logTitle = String.format((String)logTitle, befIdC, aftIdC);
                    log.setLogTitle((String)logTitle);
                    break;
                }
                case VICTIMS_CHANGE1: {
                    Object befVictims1 = bi + "\u4eba";
                    Object aftVictims1 = ai + "\u4eba";
                    if (CharSequenceUtil.isBlank((CharSequence)bi)) {
                        befVictims1 = "\u7a7a";
                    }
                    if (CharSequenceUtil.isBlank((CharSequence)ai)) {
                        aftVictims1 = "\u7a7a";
                    }
                    logTitle = String.format((String)logTitle, befVictims1, aftVictims1);
                    log.setLogTitle((String)logTitle);
                    break;
                }
                case VICTIMS_CHANGE2: {
                    String befVictims2 = CompanyChangeVictimsIdentifyEnum.getName((Integer)Convert.toInt((Object)bi));
                    String aftVictims2 = CompanyChangeVictimsIdentifyEnum.getName((Integer)Convert.toInt((Object)ai));
                    logTitle = String.format((String)logTitle, befVictims2, aftVictims2);
                    log.setLogTitle((String)logTitle);
                    break;
                }
            }
            boolean bl2 = isSup = log.getSupId() != null && CharSequenceUtil.isNotBlank((CharSequence)log.getSupName());
            if (isSup) {
                log.setCreateBy(log.getSupId());
                log.setOperator(log.getSupName());
            }
            if (typeEnum != RecordOperationTypeEnum.VICTIMS_CHANGE2 || !CharSequenceUtil.isBlank((CharSequence)log.getOperator()) || log.getCreateBy() == null) continue;
            victimsChange2OperatorList.add(log.getCreateBy());
        }
        String victimsChange2Operators = victimsChange2OperatorList.stream().filter(Objects::nonNull).map(String::valueOf).collect(Collectors.joining(","));
        if (CharSequenceUtil.isNotBlank((CharSequence)victimsChange2Operators)) {
            List orgUserList = this.organizationUserService.getListByIds(victimsChange2Operators);
            busiLogList.forEach(l -> orgUserList.stream().filter(u -> Objects.equals(u.getId(), l.getCreateBy())).findFirst().ifPresent(u -> l.setOperator(u.getFullName())));
        }
        return new PageInfo((List)busiLogPage);
    }

    private String getOrg(String code) {
        if (StrUtil.isBlank((CharSequence)code)) {
            return "-";
        }
        return switch (code) {
            case "1" -> "\u5b58\u5728";
            case "2" -> "\u4e0d\u5b58\u5728";
            default -> "-";
        };
    }

    private String legalCardTypeName(String type) {
        if (StrUtil.isBlank((CharSequence)type)) {
            return "-";
        }
        return switch (type) {
            case "1" -> "\u5c45\u6c11\u8eab\u4efd\u8bc1";
            case "2" -> "\u62a4\u7167";
            case "3" -> "\u6e2f\u6fb3\u53f0\u5c45\u6c11\u901a\u884c\u8bc1";
            case "4" -> "\u56de\u4e61\u8bc1";
            case "5" -> "\u519b\u5b98\u8bc1";
            default -> "-";
        };
    }

    @Transactional
    public void addRecordOperationLog(List<RecordOperationLog> list) {
        if (CollectionUtils.isNotEmpty(list)) {
            return;
        }
        for (RecordOperationLog recordOperationLog : list) {
            recordOperationLog.setId(Long.valueOf(this.idworker.nextId()));
            recordOperationLog.setCreateDate(new Date());
        }
        ((BusiRecordLogMapper)this.dao).insertBatch(list);
    }

    private String getBusinessStateString(byte info) {
        switch (info) {
            case 0: {
                return CompanyBusinessState.CLOSE.getName();
            }
            case 1: {
                return CompanyBusinessState.NORMAL.getName();
            }
            case 2: {
                return CompanyBusinessState.STOP.getName();
            }
        }
        return "";
    }

    private String getGradeReasonString(Integer info) {
        return switch (info) {
            case 1 -> CompanyGradeReasonEnum.DECLARATIONIMPORT.getName();
            case 2 -> CompanyGradeReasonEnum.REPORTCOMPLAINTS.getName();
            case 3 -> CompanyGradeReasonEnum.STATUTORYREPORTING.getName();
            case 4 -> CompanyGradeReasonEnum.OTHERCASESINVOLVED.getName();
            case 5 -> CompanyGradeReasonEnum.OTHERREASONS_INSTALLONLINEMONITORING.getName();
            case 6 -> CompanyGradeReasonEnum.ZYB_RISK_PUSH.getName();
            case 7 -> CompanyGradeReasonEnum.SAFETY_SYSTEM_DECLARE.getName();
            case 8 -> CompanyGradeReasonEnum.CHANGE_LABOR_DISPATCH_COMPANY.getName();
            case 9 -> CompanyGradeReasonEnum.NON_MEDICAL_RADIOLOGY_STORAGE_2023.getName();
            default -> "";
        };
    }

    private Map<Long, Organization> batchGetOrgMap(List<Long> orgIdList) {
        Map<Long, Organization> orgMap = new HashMap<Long, Organization>();
        if (CollectionUtils.isNotEmpty(orgIdList)) {
            String orgIds = orgIdList.stream().map(Object::toString).collect(Collectors.joining(","));
            List orgList = this.organizationService.getListByIds(orgIds);
            orgMap = orgList.stream().collect(Collectors.toMap(Organization::getId, r -> r, (a, b) -> a));
        }
        return orgMap;
    }

    private Map<Long, AreaModel> batchGetRegionMap(List<Long> regionIdList) {
        Map<Long, AreaModel> regionMap = new HashMap<Long, AreaModel>();
        if (CollectionUtils.isNotEmpty(regionIdList)) {
            String regionIds = regionIdList.stream().map(Object::toString).collect(Collectors.joining(","));
            List regionList = this.areaService.getAreaListByIds(regionIds);
            regionMap = regionList.stream().collect(Collectors.toMap(AreaModel::getId, r -> r, (a, b) -> a));
        }
        return regionMap;
    }

    private Map<Long, SysParamModel> batchGetIndustryRegister(List<Long> industryRegisterIdList) {
        Map<Long, SysParamModel> irMap = new HashMap<Long, SysParamModel>();
        if (CollectionUtils.isNotEmpty(industryRegisterIdList)) {
            String industryRegisterIds = industryRegisterIdList.stream().map(Object::toString).collect(Collectors.joining(","));
            List industryRegisterList = this.industryService.getListByIds(industryRegisterIds);
            irMap = industryRegisterList.stream().collect(Collectors.toMap(SysParamModel::getId, r -> r, (a, b) -> a));
        }
        return irMap;
    }

    private Map<Long, CheckPlan> batchGetCheckSource(List<Long> checkSourceIdList) {
        if (CollectionUtils.isEmpty(checkSourceIdList)) {
            return new HashMap<Long, CheckPlan>();
        }
        Map map = this.checkPlanService.getMapByIds(checkSourceIdList);
        List orgIdList = map.values().stream().filter(Objects::nonNull).map(CheckPlan::getThirdOrgId).collect(Collectors.toList());
        Map<Long, String> orgNameMap = this.thirdOrganizationService.getAllByIds(orgIdList).stream().filter(Objects::nonNull).collect(Collectors.toMap(ThirdOrganization::getId, ThirdOrganization::getName, (a, b) -> a));
        map.forEach((k, v) -> v.setThirdOrgName((String)orgNameMap.get(v.getThirdOrgId())));
        return map;
    }

    private Map<Long, SysParamModel> batchGetRegister(List<Long> registerIdList) {
        Map<Long, SysParamModel> iMap = new HashMap<Long, SysParamModel>();
        if (CollectionUtils.isNotEmpty(registerIdList)) {
            String registerIds = registerIdList.stream().map(Object::toString).collect(Collectors.joining(","));
            List registerList = this.sysParamService.getListByIds(registerIds);
            iMap = registerList.stream().collect(Collectors.toMap(SysParamModel::getId, r -> r, (a, b) -> a));
        }
        return iMap;
    }

    private static String fullName(AreaModel region) {
        if (region == null) {
            return "-";
        }
        StringBuilder serviceScope = new StringBuilder();
        Byte level = region.getLevel();
        switch (level) {
            case 0: {
                serviceScope.append("\u56fd\u5bb6").append("\u3001");
                break;
            }
            case 1: {
                serviceScope.append(region.getProvinceName()).append("\u3001");
                break;
            }
            case 2: {
                serviceScope.append(region.getProvinceName()).append(region.getCityName()).append("\u3001");
                break;
            }
            case 3: {
                serviceScope.append(region.getProvinceName()).append(region.getCityName()).append(region.getAreaName()).append("\u3001");
                break;
            }
            case 4: {
                serviceScope.append(region.getProvinceName()).append(region.getCityName()).append(region.getAreaName()).append(region.getStreetName()).append("\u3001");
                break;
            }
        }
        if (serviceScope.length() > 0) {
            serviceScope.deleteCharAt(serviceScope.length() - 1);
        }
        return String.valueOf(serviceScope);
    }
}

