/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.bind.service;

import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.redis.RedisClient;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.BeanUtils;
import cn.smarthse.common.util.CommonUtil;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.datacentre.provider.sms.ISMSProviderWelinkService;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.health.bind.dao.SysUserBindMapper;
import cn.smarthse.modules.health.bind.entity.SysUserBind;
import cn.smarthse.modules.health.bind.entity.SysUserBindLog;
import cn.smarthse.modules.health.bind.enums.UserBindLogTypeEnum;
import cn.smarthse.modules.health.bind.model.ConfirmAccountParam;
import cn.smarthse.modules.health.bind.model.ImpeachBindInfoSearchParam;
import cn.smarthse.modules.health.bind.model.SysUserBindParam;
import cn.smarthse.modules.health.bind.service.ISysUserBindLogService;
import cn.smarthse.modules.health.bind.service.ISysUserBindService;
import cn.smarthse.modules.health.bind.vo.ImpeachBindInfoDetailVo;
import cn.smarthse.modules.health.bind.vo.ImpeachBindInfoVo;
import cn.smarthse.modules.health.bind.vo.SysUserBindLogVo;
import cn.smarthse.modules.health.service.base.ICompanyService;
import cn.smarthse.modules.health.supervise.entity.basic.OrganizationUser;
import cn.smarthse.modules.health.supervise.entity.contactRebindAppeal.ContactRebindAppeal;
import cn.smarthse.modules.health.supervise.service.basic.IOrganizationUserService;
import cn.smarthse.modules.health.supervise.service.company.IContactRebindAppealService;
import cn.smarthse.modules.health.thirdOrganization.service.org.IThirdOrganizationService;
import cn.smarthse.modules.sys.enumd.UserSystemWideEnum;
import cn.smarthse.util.common.StringUtils;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.cn.smarthse.modules.health.exception.HealthException;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
public class SysUserBindServiceImpl
extends BaseServiceImpl<SysUserBindMapper, SysUserBind>
implements ISysUserBindService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SysUserBindServiceImpl.class);
    @DubboReference
    private IContactRebindAppealService contactRebindAppealService;
    private static final String unbind_message = "\u3010\u6d59\u6c5f\u7701\u75be\u63a7\u5c40\u3011\u60a8\u7684\u624b\u673a\u53f7\u5df2\u4e0e\u201c\u6d59\u91cc\u536b\u4f01\u5e94\u7528\u201d\u8d26\u53f7\u89e3\u7ed1\u6210\u529f\uff0c\u8bf7\u5c3d\u5feb\u81f3\u201c\u6d59\u91cc\u536b\u4f01\u5e94\u7528\u201d\u7ed1\u5b9a\u65b0\u7684\u624b\u673a\u53f7\u3002";
    private static final String prefix = "zlwq:smarthse:sessionId:";
    private final ISysUserBindLogService userBindLogService;
    @DubboReference
    private ISMSProviderWelinkService smsProvider;
    @DubboReference
    private IOrganizationUserService orgUserService;
    @DubboReference
    private ISysFileProvideService fileProvideService;
    @DubboReference
    private ICompanyService companyService;
    @DubboReference
    private IThirdOrganizationService thirdOrganizationService;
    private static final String VCODECACHENAME_WEB = "bindVcodeCache:web";
    private static final String VCODECACHENAME_ORG = "bindVcodeCache:org";
    private static final String sms_cache_name_web = "sms_login:web:";
    private static final String sms_cache_name_org = "sms_login:org:";
    private static final String change_bind_tel_times = "bind_tel_times:change";
    private static final String appeal_bind_tel_times = "bind_tel_times:appeal";
    @Autowired
    private RedisClient redisClient;

    public SysUserBind getByUserId(Long userId, Long cid, Integer systemSource) {
        if (userId == null && cid == null) {
            return null;
        }
        return ((SysUserBindMapper)this.dao).getBindByUserId(userId, cid, systemSource);
    }

    @Transactional
    public void bindTel(SysUserBindParam vo, Integer source) {
        boolean isNewBind;
        String cache;
        String sms_cache_name;
        Long userId = vo.getUserId();
        Long cid = vo.getCid();
        int times = this.getBindTimes(cid, change_bind_tel_times);
        if (userId == null || cid == null) {
            throw new HealthException("\u7528\u6237\u672a\u767b\u5f55");
        }
        if (StringUtils.isBlank((CharSequence)vo.getBindTel()) || !CommonUtil.checkMobile((String)vo.getBindTel())) {
            throw new HealthException("\u624b\u673a\u53f7\u7801\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        if (StringUtils.isBlank((CharSequence)vo.getBindName())) {
            throw new HealthException("\u8054\u7cfb\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!vo.getBindName().matches("^[\\u4e00-\\u9fa5a-zA-Z\\s]+$")) {
            throw new HealthException("\u8054\u7cfb\u4eba\u683c\u5f0f\u4e0d\u6b63\u786e,\u4e0d\u80fd\u5b58\u5728\u6570\u5b57\u548c\u7279\u6b8a\u5b57\u7b26");
        }
        Object vcodeCacheKey = "";
        if (Objects.equals(UserSystemWideEnum.ZLWQ_COMPANY.getCode(), source)) {
            vcodeCacheKey = VCODECACHENAME_WEB + vo.getBindTel();
        } else if (Objects.equals(UserSystemWideEnum.ZLWQ_ORGANIZATION.getCode(), source)) {
            vcodeCacheKey = VCODECACHENAME_ORG + vo.getBindTel();
        }
        String cachedCode = (String)this.redisClient.get((String)vcodeCacheKey);
        if (StringUtils.isBlank((CharSequence)cachedCode) || !vo.getVcode().equals(cachedCode)) {
            throw new HealthException("\u77ed\u4fe1\u9a8c\u8bc1\u7801\u9519\u8bef\uff0c\u8bf7\u91cd\u8bd5\u3002");
        }
        String string = sms_cache_name = source == 3 ? sms_cache_name_web : sms_cache_name_org;
        if (UserBindLogTypeEnum.REBIND.getValue().equals(vo.getType()) && !"checkSuccess".equals(cache = (String)this.redisClient.get(sms_cache_name + vo.getUserId()))) {
            throw new HealthException("\u65e7\u624b\u673a\u672a\u9a8c\u8bc1\uff0c\u65e0\u6cd5\u6362\u7ed1");
        }
        SysUserBind userBind = this.getByUserId(userId, cid, source);
        boolean bl = isNewBind = userBind == null;
        if (isNewBind) {
            userBind = new SysUserBind();
            BeanUtils.copyBeanProp((Object)userBind, (Object)vo);
            userBind.setId(Long.valueOf(this.idworker.nextId()));
            userBind.setCreateBy(userId);
            userBind.setIsValid(Boolean.valueOf(true));
        } else {
            if (vo.getBindTel().equals(userBind.getBindTel())) {
                throw new HealthException("\u6362\u7ed1\u624b\u673a\u53f7\u4e0e\u5f53\u524d\u7ed1\u5b9a\u624b\u673a\u53f7\u76f8\u540c");
            }
            userBind.setBindName(vo.getBindName());
            userBind.setBindTel(vo.getBindTel());
        }
        userBind.setUserId(userId);
        userBind.setCid(cid);
        userBind.setUpdateDate(new Date());
        userBind.setSystemSource(source);
        if (isNewBind) {
            this.add(userBind);
        } else {
            this.update(userBind, userId);
        }
        this.userBindLogService.addBindLog(userBind, isNewBind ? UserBindLogTypeEnum.BINDING.getValue() : UserBindLogTypeEnum.REBIND.getValue(), userId);
        this.redisClient.del(new String[]{sms_cache_name + vo.getUserId()});
        this.setBindTimes(cid, times, change_bind_tel_times);
    }

    @Transactional
    public Boolean unbindUser(Long currentId, Long cid, Long userid, Byte systemSource) {
        Example example = new Example(SysUserBind.class);
        example.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("userId", (Object)userid).andEqualTo("systemSource", (Object)systemSource).andEqualTo("isValid", (Object)true);
        SysUserBind userBind = (SysUserBind)((SysUserBindMapper)this.dao).selectOneByExample(example);
        if (userBind == null) {
            throw new HealthException("\u672a\u627e\u5230\u7ed1\u5b9a\u4fe1\u606f\uff0c\u8bf7\u91cd\u8bd5\uff01");
        }
        int unbindCount = ((SysUserBindMapper)this.dao).unbindByCidAndUserId(cid, userid, systemSource, currentId);
        if (unbindCount == 0) {
            throw new HealthException("\u624b\u673a\u53f7\u89e3\u7ed1\u5931\u8d25\u8bf7\u91cd\u8bd5");
        }
        this.userBindLogService.addBindLog(userBind, UserBindLogTypeEnum.UNBIND.getValue(), currentId);
        this.smsProvider.singleSendSms(userBind.getBindTel(), unbind_message);
        String sessionId = (String)this.redisClient.get(prefix + cid.toString());
        if (sessionId != null && !sessionId.isEmpty()) {
            String s = "zlwq:shiro:session:smarthse:" + sessionId;
            this.redisClient.del(new String[]{s});
        }
        this.logger.info("\u624b\u673a\u89e3\u7ed1\u6210\u529f\uff0c\u89e3\u7ed1\u624b\u673a\u53f7{}", (Object)userBind.getBindTel());
        return true;
    }

    @Transactional
    public ResponseData<Boolean> toFocusPhone(Long id, Byte focus) {
        if (id == null) {
            return ResponseData.fail((String)"\u4fee\u6539\u5931\u8d25\uff0c\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Example example = new Example(SysUserBind.class);
        example.createCriteria().andEqualTo("id", (Object)id).andEqualTo("isValid", (Object)true);
        String bindTel = ((SysUserBind)((SysUserBindMapper)this.dao).selectOneByExample(example)).getBindTel();
        if (!((SysUserBindMapper)this.dao).toFocusPhone(bindTel, focus).booleanValue()) {
            return ResponseData.fail((String)"\u4fee\u6539\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5");
        }
        return ResponseData.success((Object)true);
    }

    public SysUserBind selectByCidAndBindInfo(Long cid) {
        Example example = new Example(SysUserBind.class);
        example.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)true);
        return (SysUserBind)((SysUserBindMapper)this.dao).selectOneByExample(example);
    }

    @Transactional
    public void updateBindInfo(Long cid, String newContactName, String newContactPhone, String currentContactName, String currentContactPhone) {
        ((SysUserBindMapper)this.dao).updateBindInfo(cid, newContactName, newContactPhone, currentContactName, currentContactPhone);
    }

    public PageInfo<ImpeachBindInfoVo> getImpeachBindInfo(JqGridParam param, ImpeachBindInfoSearchParam searchParam) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<ImpeachBindInfoVo> list = ((SysUserBindMapper)this.dao).getImpeachBindInfo(searchParam);
        return new PageInfo(list);
    }

    public ResponseData<ImpeachBindInfoDetailVo> getDetail(Long id) {
        if (id == null) {
            return ResponseData.fail();
        }
        List<SysUserBind> detail = ((SysUserBindMapper)this.dao).getDetail(id);
        ImpeachBindInfoDetailVo detailVo = ((SysUserBindMapper)this.dao).getBindCount(id);
        if (detailVo == null) {
            return ResponseData.fail((String)"\u6570\u636e\u67e5\u8be2\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5");
        }
        detailVo.setSysUserBindList(detail);
        return ResponseData.success((Object)detailVo);
    }

    @Transactional
    public ResponseData<Object> changeBindInfo(SysUserBindParam vo) throws RuntimeException {
        SysUserBind sysUser;
        ConfirmAccountParam confirmAccountParam = new ConfirmAccountParam();
        confirmAccountParam.setUnifiedSocialCc(vo.getUnifiedSocialCc());
        confirmAccountParam.setUsername(vo.getUsername());
        confirmAccountParam.setSystemWide(vo.getSystemWide());
        try {
            sysUser = this.companyService.confirmAccountByUsernameOrCode(confirmAccountParam);
        }
        catch (Exception e) {
            throw new HealthException("\u67e5\u8be2\u4f01\u4e1a\u4fe1\u606f\u5931\u8d25");
        }
        if (sysUser == null) {
            throw new HealthException("\u67e5\u8be2\u4f01\u4e1a\u4fe1\u606f\u5931\u8d25");
        }
        Long cid = sysUser.getCid();
        Long currentId = sysUser.getId();
        if (cid == null) {
            throw new HealthException("\u4f01\u4e1aid\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u8bd5");
        }
        if (vo.getEvidenceId() == null) {
            throw new HealthException("\u4f50\u8bc1\u6750\u6599\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6dfb\u52a0\u4f50\u8bc1\u6750\u6599");
        }
        int times = this.getBindTimes(cid, appeal_bind_tel_times);
        List contactRebindAppeals = this.contactRebindAppealService.getByCid(cid);
        if (!contactRebindAppeals.isEmpty()) {
            throw new HealthException("\u5f53\u524d\u5df2\u7ecf\u5b58\u5728\u6362\u7ed1\u7533\u8bf7\uff0c\u65e0\u6cd5\u91cd\u590d\u63d0\u4ea4\uff0c\u8bf7\u7b49\u5f85\u5ba1\u6838\u5b8c\u6210\u540e\u3002");
        }
        if (StringUtils.isBlank((CharSequence)vo.getBindTel()) || !CommonUtil.checkMobile((String)vo.getBindTel())) {
            throw new HealthException("\u624b\u673a\u53f7\u7801\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        if (StringUtils.isBlank((CharSequence)vo.getBindName())) {
            throw new HealthException("\u8054\u7cfb\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!vo.getBindName().matches("^[\\u4e00-\\u9fa5a-zA-Z\\s]+$")) {
            throw new HealthException("\u8054\u7cfb\u4eba\u683c\u5f0f\u4e0d\u6b63\u786e,");
        }
        Object vcodeCacheKey = "";
        if (UserSystemWideEnum.ZLWQ_COMPANY.getCode().intValue() == vo.getSystemSource().byteValue()) {
            vcodeCacheKey = VCODECACHENAME_WEB + vo.getBindTel();
        } else if (UserSystemWideEnum.ZLWQ_ORGANIZATION.getCode().intValue() == vo.getSystemSource().byteValue()) {
            vcodeCacheKey = VCODECACHENAME_ORG + vo.getBindTel();
        }
        String cachedCode = (String)this.redisClient.get((String)vcodeCacheKey);
        if (StringUtils.isBlank((CharSequence)cachedCode) || !vo.getVcode().equals(cachedCode)) {
            throw new HealthException("\u77ed\u4fe1\u9a8c\u8bc1\u7801\u9519\u8bef\uff0c\u8bf7\u91cd\u8bd5\u3002");
        }
        ContactRebindAppeal contactRebindAppeal = new ContactRebindAppeal();
        contactRebindAppeal.setCid(cid);
        Example example = new Example(SysUserBind.class);
        example.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)true);
        SysUserBind sysUserBind = (SysUserBind)((SysUserBindMapper)this.dao).selectOneByExample(example);
        if (sysUserBind == null) {
            return ResponseData.fail((String)"\u767b\u5f55\u8d26\u53f7\u672a\u67e5\u8be2\u5230\u7ed1\u5b9a\u4fe1\u606f");
        }
        if (sysUserBind.getBindName() == null || sysUserBind.getBindTel() == null) {
            return ResponseData.fail((String)"\u767b\u5f55\u8d26\u53f7\u672a\u67e5\u8be2\u5230\u7ed1\u5b9a\u4fe1\u606f");
        }
        contactRebindAppeal.setCurrentContactName(sysUserBind.getBindName());
        contactRebindAppeal.setUserId(currentId);
        contactRebindAppeal.setSystemWide(vo.getSystemSource());
        contactRebindAppeal.setCurrentContactPhone(sysUserBind.getBindTel());
        contactRebindAppeal.setNewContactPhone(vo.getBindTel());
        contactRebindAppeal.setNewContactName(vo.getBindName());
        contactRebindAppeal.setEvidenceId(vo.getEvidenceId());
        contactRebindAppeal.setCreateBy(currentId);
        this.contactRebindAppealService.changeBindInfo(contactRebindAppeal);
        SysUserBindLog sysUserBindLog = new SysUserBindLog();
        sysUserBindLog.setUserId(sysUserBind.getUserId());
        sysUserBindLog.setCid(cid);
        sysUserBindLog.setId(Long.valueOf(this.idworker.nextId()));
        sysUserBindLog.setBindTel(sysUserBind.getBindTel());
        sysUserBindLog.setBindName(sysUserBind.getBindName());
        sysUserBindLog.setSystemSource(sysUserBind.getSystemSource());
        sysUserBindLog.setEvidenceId(vo.getEvidenceId());
        sysUserBindLog.setType(UserBindLogTypeEnum.APPEAL.getValue());
        sysUserBindLog.setCreateBy(currentId);
        this.userBindLogService.insertLog(sysUserBindLog);
        this.setBindTimes(cid, times, appeal_bind_tel_times);
        return ResponseData.success();
    }

    public PageInfo<SysUserBindLogVo> getBindLogList(SysUserBindParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List list = this.userBindLogService.getBindLogList(param);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            list.stream().filter(vo -> Objects.equals(UserBindLogTypeEnum.APPEAL_PASS.getValue(), vo.getType()) || Objects.equals(UserBindLogTypeEnum.APPEAL_NOPASS.getValue(), vo.getType()) || Objects.equals(UserBindLogTypeEnum.UNBIND.getValue(), vo.getType())).forEach(vo -> {
                OrganizationUser user;
                if (vo.getCreateBy() != null && (user = (OrganizationUser)this.orgUserService.getById(vo.getCreateBy())) != null) {
                    vo.setUsername(user.getUsername());
                }
            });
            list.stream().filter(vo -> Objects.equals(UserBindLogTypeEnum.APPEAL.getValue(), vo.getType())).forEach(vo -> {
                SysFileModel file;
                if (vo.getEvidenceId() != null && (file = this.fileProvideService.getFileById(vo.getEvidenceId())) != null) {
                    vo.setFileModel(file);
                }
            });
        }
        return new PageInfo(list);
    }

    public SysUserBind getUserBindByCid(Long cid, Integer systemSource) {
        Example example = new Example(SysUserBind.class);
        example.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("systemSource", (Object)systemSource).andEqualTo("isValid", (Object)true);
        return (SysUserBind)((SysUserBindMapper)this.dao).selectOneByExample(example);
    }

    private int getBindTimes(Long cid, String key) {
        Integer times = (Integer)this.redisClient.get(key + cid);
        if (times == null) {
            times = 0;
        }
        if (times >= 2) {
            throw new HealthException("\u6bcf\u65e5\u624b\u673a\u6362\u7ed1\u6b21\u6570\u4e3a2\u6b21\uff0c\u5f53\u524d\u6362\u7ed1\u6b21\u6570\u8d85\u8fc72\u6b21\uff0c\u8bf7\u7b2c\u4e8c\u5929\u91cd\u8bd5");
        }
        return times;
    }

    public void setBindTimes(Long cid, Integer times, String key) {
        LocalDateTime endOfDay;
        LocalDateTime now = LocalDateTime.now();
        long secondsUntilEndOfDay = ChronoUnit.SECONDS.between(now, endOfDay = now.toLocalDate().atTime(23, 59, 59));
        if (secondsUntilEndOfDay <= 0L) {
            secondsUntilEndOfDay = 1L;
        }
        times = times + 1;
        this.redisClient.set(key + cid, (Object)times, secondsUntilEndOfDay, TimeUnit.SECONDS);
    }

    public ResponseData<Object> confirmAccount(ConfirmAccountParam param) {
        Integer systemWide = param.getSystemWide();
        if (systemWide == null) {
            return ResponseData.fail((String)"\u7cfb\u7edf\u8303\u56f4\u4e3a\u7a7a");
        }
        if (systemWide != 6 && systemWide != 3) {
            return ResponseData.fail((String)"\u7cfb\u7edf\u8303\u56f4\u9519\u8bef");
        }
        SysUserBind sysUser = this.companyService.confirmAccountByUsernameOrCode(param);
        if (sysUser == null) {
            return ResponseData.fail((String)"\u7528\u6237\u540d\u79f0\u6216\u4fe1\u7528\u4ee3\u7801\u9a8c\u8bc1\u5931\u8d25\uff0c\u672a\u5728\u7cfb\u7edf\u4e2d\u67e5\u8be2\u5230\u4f01\u4e1a");
        }
        Long cid = sysUser.getCid();
        if (cid != null) {
            Example example = new Example(SysUserBind.class);
            example.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)true);
            try {
                SysUserBind sysUserBind = ((SysUserBindMapper)this.dao).getBindByUserId(null, cid, systemWide);
                if (sysUserBind != null) {
                    return ResponseData.success((Object)0);
                }
                return ResponseData.success((Object)2);
            }
            catch (Exception e) {
                return ResponseData.fail((String)"\u5f53\u524d\u8d26\u53f7\u7ed1\u5b9a\u4fe1\u606f\u5f02\u5e38");
            }
        }
        return ResponseData.fail((String)"\u7528\u6237\u540d\u79f0\u6216\u4fe1\u7528\u4ee3\u7801\u9a8c\u8bc1\u5931\u8d25\uff0c\u672a\u5728\u7cfb\u7edf\u4e2d\u67e5\u8be2\u5230\u4f01\u4e1a");
    }

    @Generated
    public SysUserBindServiceImpl(ISysUserBindLogService userBindLogService) {
        this.userBindLogService = userBindLogService;
    }
}

