/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.enums;

import com.fasterxml.jackson.annotation.JsonFormat;
import java.util.Arrays;
import java.util.List;

@JsonFormat(shape=JsonFormat.Shape.OBJECT)
public enum CheckReportStateEnum {
    feedback("\u88ab\u9000\u56de", (byte)-1, (byte)2),
    draft("\u8349\u7a3f", (byte)0, (byte)1),
    reported("\u5df2\u4e0a\u62a5", (byte)1, (byte)-1);

    private String name;
    private Byte code;
    private Byte sysTipCode;

    private CheckReportStateEnum(String name, Byte code, Byte sysTipCode) {
        this.name = name;
        this.code = code;
        this.sysTipCode = sysTipCode;
    }

    public static Byte getSysTipCode(Byte code) {
        if (code == null) {
            return CheckReportStateEnum.draft.code;
        }
        for (CheckReportStateEnum c : CheckReportStateEnum.values()) {
            if (c.getCode() != code) continue;
            return c.sysTipCode;
        }
        return CheckReportStateEnum.draft.code;
    }

    public static String getName(Byte code) {
        if (code == null) {
            return null;
        }
        for (CheckReportStateEnum c : CheckReportStateEnum.values()) {
            if (c.getCode() != code) continue;
            return c.name;
        }
        return null;
    }

    public static List<Byte> getUnfinishStates() {
        return Arrays.asList(CheckReportStateEnum.feedback.code, CheckReportStateEnum.draft.code);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Byte getCode() {
        return this.code;
    }

    public void setCode(Byte code) {
        this.code = code;
    }

    public Byte getSysTipCode() {
        return this.sysTipCode;
    }

    public void setSysTipCode(Byte sysTipCode) {
        this.sysTipCode = sysTipCode;
    }
}

