/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.compliance.vo.home;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import lombok.Generated;

public class HomeComplianceHeadlineVo
implements Serializable {
    private Long complianceCount;
    private Long compliantCount;
    private String proportion;
    private String freePunishAmount;
    private String unit;
    private Integer companyNum;
    private String complianceProportion;
    private Long provinceAvgCount;
    private BigDecimal provinceAvg;
    private String complianceProportion2024;
    private Integer complianceCount2024;

    public String getComplianceProportion() {
        if (this.companyNum != null && this.compliantCount != null && this.companyNum != 0) {
            BigDecimal compliant = new BigDecimal(this.compliantCount);
            BigDecimal company = new BigDecimal(this.companyNum);
            BigDecimal proportion = compliant.divide(company, 4, RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(100L));
            return proportion.setScale(2, RoundingMode.HALF_UP).toString() + "%";
        }
        return "\u2014\u2014";
    }

    public String getFreePunishAmount() {
        if (this.compliantCount == null) {
            this.unit = "\u4e07\u5143";
            return "0";
        }
        double amount = (double)this.compliantCount.longValue() * 2.25;
        if (amount >= 10000.0) {
            this.unit = "\u4ebf\u5143";
            return String.format("%.2f", amount / 10000.0);
        }
        this.unit = "\u4e07\u5143";
        return String.format("%.2f", amount);
    }

    public String getUnit() {
        if (this.freePunishAmount == null) {
            this.getFreePunishAmount();
        }
        return this.unit;
    }

    @Generated
    public HomeComplianceHeadlineVo() {
    }

    @Generated
    public Long getComplianceCount() {
        return this.complianceCount;
    }

    @Generated
    public Long getCompliantCount() {
        return this.compliantCount;
    }

    @Generated
    public String getProportion() {
        return this.proportion;
    }

    @Generated
    public Integer getCompanyNum() {
        return this.companyNum;
    }

    @Generated
    public Long getProvinceAvgCount() {
        return this.provinceAvgCount;
    }

    @Generated
    public BigDecimal getProvinceAvg() {
        return this.provinceAvg;
    }

    @Generated
    public String getComplianceProportion2024() {
        return this.complianceProportion2024;
    }

    @Generated
    public Integer getComplianceCount2024() {
        return this.complianceCount2024;
    }

    @Generated
    public void setComplianceCount(Long complianceCount) {
        this.complianceCount = complianceCount;
    }

    @Generated
    public void setCompliantCount(Long compliantCount) {
        this.compliantCount = compliantCount;
    }

    @Generated
    public void setProportion(String proportion) {
        this.proportion = proportion;
    }

    @Generated
    public void setFreePunishAmount(String freePunishAmount) {
        this.freePunishAmount = freePunishAmount;
    }

    @Generated
    public void setUnit(String unit) {
        this.unit = unit;
    }

    @Generated
    public void setCompanyNum(Integer companyNum) {
        this.companyNum = companyNum;
    }

    @Generated
    public void setComplianceProportion(String complianceProportion) {
        this.complianceProportion = complianceProportion;
    }

    @Generated
    public void setProvinceAvgCount(Long provinceAvgCount) {
        this.provinceAvgCount = provinceAvgCount;
    }

    @Generated
    public void setProvinceAvg(BigDecimal provinceAvg) {
        this.provinceAvg = provinceAvg;
    }

    @Generated
    public void setComplianceProportion2024(String complianceProportion2024) {
        this.complianceProportion2024 = complianceProportion2024;
    }

    @Generated
    public void setComplianceCount2024(Integer complianceCount2024) {
        this.complianceCount2024 = complianceCount2024;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HomeComplianceHeadlineVo)) {
            return false;
        }
        HomeComplianceHeadlineVo other = (HomeComplianceHeadlineVo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$complianceCount = this.getComplianceCount();
        Long other$complianceCount = other.getComplianceCount();
        if (this$complianceCount == null ? other$complianceCount != null : !((Object)this$complianceCount).equals(other$complianceCount)) {
            return false;
        }
        Long this$compliantCount = this.getCompliantCount();
        Long other$compliantCount = other.getCompliantCount();
        if (this$compliantCount == null ? other$compliantCount != null : !((Object)this$compliantCount).equals(other$compliantCount)) {
            return false;
        }
        Integer this$companyNum = this.getCompanyNum();
        Integer other$companyNum = other.getCompanyNum();
        if (this$companyNum == null ? other$companyNum != null : !((Object)this$companyNum).equals(other$companyNum)) {
            return false;
        }
        Long this$provinceAvgCount = this.getProvinceAvgCount();
        Long other$provinceAvgCount = other.getProvinceAvgCount();
        if (this$provinceAvgCount == null ? other$provinceAvgCount != null : !((Object)this$provinceAvgCount).equals(other$provinceAvgCount)) {
            return false;
        }
        Integer this$complianceCount2024 = this.getComplianceCount2024();
        Integer other$complianceCount2024 = other.getComplianceCount2024();
        if (this$complianceCount2024 == null ? other$complianceCount2024 != null : !((Object)this$complianceCount2024).equals(other$complianceCount2024)) {
            return false;
        }
        String this$proportion = this.getProportion();
        String other$proportion = other.getProportion();
        if (this$proportion == null ? other$proportion != null : !this$proportion.equals(other$proportion)) {
            return false;
        }
        String this$freePunishAmount = this.getFreePunishAmount();
        String other$freePunishAmount = other.getFreePunishAmount();
        if (this$freePunishAmount == null ? other$freePunishAmount != null : !this$freePunishAmount.equals(other$freePunishAmount)) {
            return false;
        }
        String this$unit = this.getUnit();
        String other$unit = other.getUnit();
        if (this$unit == null ? other$unit != null : !this$unit.equals(other$unit)) {
            return false;
        }
        String this$complianceProportion = this.getComplianceProportion();
        String other$complianceProportion = other.getComplianceProportion();
        if (this$complianceProportion == null ? other$complianceProportion != null : !this$complianceProportion.equals(other$complianceProportion)) {
            return false;
        }
        BigDecimal this$provinceAvg = this.getProvinceAvg();
        BigDecimal other$provinceAvg = other.getProvinceAvg();
        if (this$provinceAvg == null ? other$provinceAvg != null : !((Object)this$provinceAvg).equals(other$provinceAvg)) {
            return false;
        }
        String this$complianceProportion2024 = this.getComplianceProportion2024();
        String other$complianceProportion2024 = other.getComplianceProportion2024();
        return !(this$complianceProportion2024 == null ? other$complianceProportion2024 != null : !this$complianceProportion2024.equals(other$complianceProportion2024));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof HomeComplianceHeadlineVo;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $complianceCount = this.getComplianceCount();
        result = result * 59 + ($complianceCount == null ? 43 : ((Object)$complianceCount).hashCode());
        Long $compliantCount = this.getCompliantCount();
        result = result * 59 + ($compliantCount == null ? 43 : ((Object)$compliantCount).hashCode());
        Integer $companyNum = this.getCompanyNum();
        result = result * 59 + ($companyNum == null ? 43 : ((Object)$companyNum).hashCode());
        Long $provinceAvgCount = this.getProvinceAvgCount();
        result = result * 59 + ($provinceAvgCount == null ? 43 : ((Object)$provinceAvgCount).hashCode());
        Integer $complianceCount2024 = this.getComplianceCount2024();
        result = result * 59 + ($complianceCount2024 == null ? 43 : ((Object)$complianceCount2024).hashCode());
        String $proportion = this.getProportion();
        result = result * 59 + ($proportion == null ? 43 : $proportion.hashCode());
        String $freePunishAmount = this.getFreePunishAmount();
        result = result * 59 + ($freePunishAmount == null ? 43 : $freePunishAmount.hashCode());
        String $unit = this.getUnit();
        result = result * 59 + ($unit == null ? 43 : $unit.hashCode());
        String $complianceProportion = this.getComplianceProportion();
        result = result * 59 + ($complianceProportion == null ? 43 : $complianceProportion.hashCode());
        BigDecimal $provinceAvg = this.getProvinceAvg();
        result = result * 59 + ($provinceAvg == null ? 43 : ((Object)$provinceAvg).hashCode());
        String $complianceProportion2024 = this.getComplianceProportion2024();
        result = result * 59 + ($complianceProportion2024 == null ? 43 : $complianceProportion2024.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "HomeComplianceHeadlineVo(complianceCount=" + this.getComplianceCount() + ", compliantCount=" + this.getCompliantCount() + ", proportion=" + this.getProportion() + ", freePunishAmount=" + this.getFreePunishAmount() + ", unit=" + this.getUnit() + ", companyNum=" + this.getCompanyNum() + ", complianceProportion=" + this.getComplianceProportion() + ", provinceAvgCount=" + this.getProvinceAvgCount() + ", provinceAvg=" + String.valueOf(this.getProvinceAvg()) + ", complianceProportion2024=" + this.getComplianceProportion2024() + ", complianceCount2024=" + this.getComplianceCount2024() + ")";
    }
}

