/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.util;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.text.CharSequenceUtil;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javafx.util.Pair;
import javax.smarthse.exception.ServiceException;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.AllColumns;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SelectItemVisitor;
import net.sf.jsqlparser.statement.select.SelectItemVisitorAdapter;
import net.sf.jsqlparser.statement.select.SetOperation;
import net.sf.jsqlparser.statement.select.SetOperationList;
import net.sf.jsqlparser.statement.select.SubSelect;
import net.sf.jsqlparser.statement.select.UnionOp;
import net.sf.jsqlparser.util.TablesNamesFinder;
import net.sf.jsqlparser.util.deparser.ExpressionDeParser;

public class CustomQueryUtil {
    private CustomQueryUtil() {
    }

    public static Boolean isQueryScript(String sql) {
        Statement statement;
        if (CharSequenceUtil.isBlank((CharSequence)sql)) {
            return Boolean.FALSE;
        }
        try {
            statement = CCJSqlParserUtil.parse((String)sql);
        }
        catch (Exception e) {
            return Boolean.TRUE;
        }
        return CustomQueryUtil.isQueryScript(statement);
    }

    public static Boolean isQueryScript(Statement statement) {
        if (statement == null) {
            return Boolean.FALSE;
        }
        if (!(statement instanceof Select)) {
            return Boolean.FALSE;
        }
        new TablesNamesFinder(){

            public void visit(Table table) {
                if (CharSequenceUtil.isBlank((CharSequence)table.getSchemaName())) {
                    throw new ServiceException("\u8bf7\u6307\u5b9a\u5e93\u540d\u8fdb\u884c\u67e5\u8be2\uff01");
                }
            }
        }.getTableList(statement);
        return Boolean.TRUE;
    }

    public static Boolean includeQueryAll(SelectBody selectBody) {
        if (selectBody instanceof PlainSelect) {
            return CustomQueryUtil.includeQueryAll(CollUtil.toList((Object[])new PlainSelect[]{(PlainSelect)selectBody}));
        }
        if (selectBody instanceof SetOperationList) {
            ArrayList<PlainSelect> plainSelectList = new ArrayList<PlainSelect>();
            SetOperationList setOperationList = (SetOperationList)selectBody;
            for (SelectBody subSelectBody : setOperationList.getSelects()) {
                if (!(subSelectBody instanceof PlainSelect)) continue;
                plainSelectList.add((PlainSelect)subSelectBody);
            }
            return CustomQueryUtil.includeQueryAll(plainSelectList);
        }
        return Boolean.FALSE;
    }

    public static Boolean includeQueryAll(List<PlainSelect> plainSelectList) {
        for (PlainSelect plainSelect : plainSelectList) {
            for (SelectItem selectItem : plainSelect.getSelectItems()) {
                final boolean[] containsAllColumns = new boolean[]{Boolean.FALSE};
                selectItem.accept((SelectItemVisitor)new SelectItemVisitorAdapter(){

                    public void visit(AllColumns columns) {
                        containsAllColumns[0] = Boolean.TRUE;
                    }
                });
                if (!containsAllColumns[0]) continue;
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

    public static Boolean isSubquery(SelectBody selectBody) {
        if (selectBody instanceof PlainSelect) {
            return CustomQueryUtil.isSubquery(CollUtil.toList((Object[])new PlainSelect[]{(PlainSelect)selectBody}));
        }
        if (selectBody instanceof SetOperationList) {
            ArrayList<PlainSelect> plainSelectList = new ArrayList<PlainSelect>();
            SetOperationList setOperationList = (SetOperationList)selectBody;
            for (SelectBody subSelectBody : setOperationList.getSelects()) {
                if (!(subSelectBody instanceof PlainSelect)) continue;
                plainSelectList.add((PlainSelect)subSelectBody);
            }
            return CustomQueryUtil.isSubquery(plainSelectList);
        }
        return Boolean.FALSE;
    }

    public static Boolean isSubquery(List<PlainSelect> plainSelectList) {
        for (PlainSelect plainSelect : plainSelectList) {
            SubqueryFinder subqueryFinder = new SubqueryFinder();
            Expression where = plainSelect.getWhere();
            if (where == null) continue;
            where.accept((ExpressionVisitor)subqueryFinder);
            if (!subqueryFinder.hasSubquery()) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static Boolean isUnionSelect(SelectBody selectBody) {
        if (selectBody instanceof SetOperationList) {
            SetOperationList setOperationList = (SetOperationList)selectBody;
            return setOperationList.getOperations().stream().anyMatch(UnionOp.class::isInstance);
        }
        return Boolean.FALSE;
    }

    public static Pair<String, LinkedHashSet<String>> getQueryInfoBySelect(PlainSelect plainSelect) {
        LinkedHashSet<String> columnNameSet = new LinkedHashSet<String>();
        HashMap<String, Byte> columnNumMap = new HashMap<String, Byte>();
        CustomQueryUtil.ensureUniqueColumnNames(plainSelect, columnNameSet, columnNumMap);
        return new Pair((Object)Convert.toStr((Object)plainSelect), columnNameSet);
    }

    public static Pair<String, LinkedHashSet<String>> getQueryInfoBySelect(SetOperationList setOperationList) {
        Pair<List<PlainSelect>, Boolean> pair = CustomQueryUtil.plainSelectsUnionCheck(setOperationList);
        List plainSelectList = (List)pair.getKey();
        boolean union = pair.getValue() != null && (Boolean)pair.getValue() != false;
        LinkedHashSet<String> unionColumnNameSet = new LinkedHashSet<String>();
        LinkedHashSet<String> columnNameSet = new LinkedHashSet<String>();
        HashMap<String, Byte> columnNumMap = new HashMap<String, Byte>();
        for (PlainSelect plainSelect : plainSelectList) {
            CustomQueryUtil.ensureUniqueColumnNames(plainSelect, columnNameSet, columnNumMap);
            if (!union || !unionColumnNameSet.isEmpty()) continue;
            unionColumnNameSet.addAll(columnNameSet);
        }
        return new Pair((Object)Convert.toStr((Object)setOperationList), union ? unionColumnNameSet : columnNameSet);
    }

    /*
     * Unable to fully structure code
     */
    public static Pair<List<PlainSelect>, Boolean> plainSelectsUnionCheck(SetOperationList setOperationList) {
        selectBodyList = setOperationList.getSelects();
        operationList = setOperationList.getOperations();
        plainSelectList = selectBodyList.stream().filter((Predicate<SelectBody>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isInstance(java.lang.Object ), (Lnet/sf/jsqlparser/statement/select/SelectBody;)Z)(PlainSelect.class)).map((Function<SelectBody, PlainSelect>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, cast(java.lang.Object ), (Lnet/sf/jsqlparser/statement/select/SelectBody;)Lnet/sf/jsqlparser/statement/select/PlainSelect;)(PlainSelect.class)).collect(Collectors.toList());
        if (operationList.isEmpty()) ** GOTO lbl-1000
        if (operationList.stream().allMatch((Predicate<SetOperation>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isInstance(java.lang.Object ), (Lnet/sf/jsqlparser/statement/select/SetOperation;)Z)(UnionOp.class))) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = false;
        }
        allUnionOp = v0;
        return new Pair(plainSelectList, (Object)allUnionOp);
    }

    private static void ensureUniqueColumnNames(PlainSelect plainSelect, LinkedHashSet<String> columnNameSet, Map<String, Byte> columnNumMap) {
        for (SelectItem selectItem : plainSelect.getSelectItems()) {
            if (!(selectItem instanceof SelectExpressionItem)) continue;
            SelectExpressionItem selectExpressionItem = (SelectExpressionItem)selectItem;
            Alias alias = selectExpressionItem.getAlias();
            String aliasName = alias != null ? alias.getName() : null;
            String expressionStr = Convert.toStr((Object)selectExpressionItem.getExpression());
            String columnName = expressionStr.contains("concat") || expressionStr.contains("CONCAT") ? expressionStr : expressionStr.substring(expressionStr.lastIndexOf(46) + 1);
            String elementToAdd = aliasName != null ? aliasName : columnName;
            columnNumMap.put(elementToAdd, (byte)(columnNumMap.getOrDefault(elementToAdd, (byte)-1) + 1));
            if (columnNameSet.contains(elementToAdd)) {
                Byte index = columnNumMap.get(elementToAdd);
                String newAlias = String.format("%s_%s", elementToAdd, index);
                selectExpressionItem.setAlias(new Alias(newAlias, Boolean.TRUE.booleanValue()));
                elementToAdd = newAlias;
            }
            columnNameSet.add(elementToAdd);
        }
    }

    private static class SubqueryFinder
    extends ExpressionDeParser {
        private boolean hasSubquery = Boolean.FALSE;

        private SubqueryFinder() {
        }

        public void visit(SubSelect subSelect) {
            this.hasSubquery = Boolean.TRUE;
        }

        public boolean hasSubquery() {
            return this.hasSubquery;
        }
    }
}

