/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.framework.redis.config;

import cn.hutool.core.util.ObjectUtil;
import cn.smarthse.framework.redis.config.properties.RedissonProperties;
import cn.smarthse.framework.redis.handler.KeyPrefixHandler;
import cn.smarthse.framework.redis.handler.KeyPrefixRedisTemplateHandler;
import cn.smarthse.framework.redis.manager.TtlRedisCacheManager;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsontype.PolymorphicTypeValidator;
import com.fasterxml.jackson.databind.jsontype.impl.LaissezFaireSubTypeValidator;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalTimeSerializer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.TimeZone;
import lombok.Generated;
import org.redisson.api.NameMapper;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.StringCodec;
import org.redisson.codec.CompositeCodec;
import org.redisson.codec.TypedJsonJacksonCodec;
import org.redisson.config.ClusterServersConfig;
import org.redisson.config.SingleServerConfig;
import org.redisson.spring.starter.RedissonAutoConfigurationCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.Bean;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.cache.RedisCacheWriter;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.Jackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializationContext;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;

@AutoConfiguration
@EnableCaching(proxyTargetClass=true)
@EnableConfigurationProperties(value={RedissonProperties.class})
public class RedisConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RedisConfig.class);
    private static final String DATE_TIME_PATTERN = "yyyy-MM-dd HH:mm:ss";
    private static final String DATE_PATTERN = "yyyy-MM-dd";
    private static final String TIME_PATTERN = "HH:mm:ss";
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private static final DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ofPattern("HH:mm:ss");
    private final RedissonProperties redissonProperties;

    @Bean
    public RedissonAutoConfigurationCustomizer redissonCustomizer() {
        return config -> {
            RedissonProperties.ClusterServersConfig clusterServersConfig;
            TypedJsonJacksonCodec jsonCodec = new TypedJsonJacksonCodec(Object.class, this.objectMapper());
            CompositeCodec codec = new CompositeCodec((Codec)StringCodec.INSTANCE, (Codec)jsonCodec, (Codec)jsonCodec);
            config.setThreads(this.redissonProperties.getThreads()).setNettyThreads(this.redissonProperties.getNettyThreads()).setUseScriptCache(true).setCodec((Codec)codec);
            RedissonProperties.SingleServerConfig singleServerConfig = this.redissonProperties.getSingleServerConfig();
            if (ObjectUtil.isNotNull((Object)singleServerConfig)) {
                ((SingleServerConfig)((SingleServerConfig)((SingleServerConfig)((SingleServerConfig)config.useSingleServer().setNameMapper((NameMapper)new KeyPrefixHandler(this.redissonProperties.getKeyPrefix()))).setTimeout(singleServerConfig.getTimeout())).setClientName(singleServerConfig.getClientName())).setIdleConnectionTimeout(singleServerConfig.getIdleConnectionTimeout())).setSubscriptionConnectionPoolSize(singleServerConfig.getSubscriptionConnectionPoolSize()).setConnectionMinimumIdleSize(singleServerConfig.getConnectionMinimumIdleSize()).setConnectionPoolSize(singleServerConfig.getConnectionPoolSize());
            }
            if (ObjectUtil.isNotNull((Object)(clusterServersConfig = this.redissonProperties.getClusterServersConfig()))) {
                ((ClusterServersConfig)((ClusterServersConfig)((ClusterServersConfig)((ClusterServersConfig)((ClusterServersConfig)((ClusterServersConfig)((ClusterServersConfig)((ClusterServersConfig)((ClusterServersConfig)((ClusterServersConfig)config.useClusterServers().setNameMapper((NameMapper)new KeyPrefixHandler(this.redissonProperties.getKeyPrefix()))).setTimeout(clusterServersConfig.getTimeout())).setClientName(clusterServersConfig.getClientName())).setIdleConnectionTimeout(clusterServersConfig.getIdleConnectionTimeout())).setSubscriptionConnectionPoolSize(clusterServersConfig.getSubscriptionConnectionPoolSize())).setMasterConnectionMinimumIdleSize(clusterServersConfig.getMasterConnectionMinimumIdleSize())).setMasterConnectionPoolSize(clusterServersConfig.getMasterConnectionPoolSize())).setSlaveConnectionMinimumIdleSize(clusterServersConfig.getSlaveConnectionMinimumIdleSize())).setSlaveConnectionPoolSize(clusterServersConfig.getSlaveConnectionPoolSize())).setReadMode(clusterServersConfig.getReadMode())).setSubscriptionMode(clusterServersConfig.getSubscriptionMode());
            }
            log.info("\u521d\u59cb\u5316 redission \u914d\u7f6e");
        };
    }

    private ObjectMapper objectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        JavaTimeModule timeModule = new JavaTimeModule();
        timeModule.addSerializer((JsonSerializer)new LocalDateTimeSerializer(DATE_TIME_FORMATTER));
        timeModule.addDeserializer(LocalDateTime.class, (JsonDeserializer)new LocalDateTimeDeserializer(DATE_TIME_FORMATTER));
        timeModule.addSerializer((JsonSerializer)new LocalDateSerializer(DATE_FORMATTER));
        timeModule.addDeserializer(LocalDate.class, (JsonDeserializer)new LocalDateDeserializer(DATE_FORMATTER));
        timeModule.addSerializer((JsonSerializer)new LocalTimeSerializer(TIME_FORMATTER));
        timeModule.addDeserializer(LocalTime.class, (JsonDeserializer)new LocalTimeDeserializer(TIME_FORMATTER));
        timeModule.addSerializer(Long.class, (JsonSerializer)ToStringSerializer.instance);
        timeModule.addSerializer(Long.TYPE, (JsonSerializer)ToStringSerializer.instance);
        timeModule.addSerializer(BigInteger.class, (JsonSerializer)ToStringSerializer.instance);
        timeModule.addSerializer(BigDecimal.class, (JsonSerializer)ToStringSerializer.instance);
        objectMapper.registerModule((Module)timeModule);
        objectMapper.setTimeZone(TimeZone.getDefault());
        objectMapper.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.ANY);
        objectMapper.activateDefaultTyping((PolymorphicTypeValidator)LaissezFaireSubTypeValidator.instance, ObjectMapper.DefaultTyping.NON_FINAL, JsonTypeInfo.As.PROPERTY);
        return objectMapper;
    }

    @Bean
    public RedisTemplate<?, ?> redisTemplate(RedisConnectionFactory factory) {
        log.info("\u521d\u59cb\u5316 redisTemplate stringRedisTemplate \u914d\u7f6e");
        RedisTemplate redisTemplate = new RedisTemplate();
        StringRedisSerializer redisSerializer = new StringRedisSerializer();
        KeyPrefixRedisTemplateHandler prefixedRedisSerializer = new KeyPrefixRedisTemplateHandler((RedisSerializer<String>)redisSerializer, this.redissonProperties.getKeyPrefix());
        Jackson2JsonRedisSerializer jackson2JsonRedisSerializer = new Jackson2JsonRedisSerializer(this.objectMapper(), Object.class);
        redisTemplate.setConnectionFactory(factory);
        redisTemplate.setKeySerializer((RedisSerializer)prefixedRedisSerializer);
        redisTemplate.setValueSerializer((RedisSerializer)jackson2JsonRedisSerializer);
        redisTemplate.setHashValueSerializer((RedisSerializer)jackson2JsonRedisSerializer);
        redisTemplate.afterPropertiesSet();
        return redisTemplate;
    }

    @Bean
    public CacheManager cacheManager(RedisConnectionFactory factory) {
        StringRedisSerializer redisSerializer = new StringRedisSerializer();
        Jackson2JsonRedisSerializer jackson2JsonRedisSerializer = new Jackson2JsonRedisSerializer(this.objectMapper(), Object.class);
        RedisCacheConfiguration config = RedisCacheConfiguration.defaultCacheConfig().serializeKeysWith(RedisSerializationContext.SerializationPair.fromSerializer((RedisSerializer)redisSerializer)).serializeValuesWith(RedisSerializationContext.SerializationPair.fromSerializer((RedisSerializer)jackson2JsonRedisSerializer)).disableCachingNullValues();
        return new TtlRedisCacheManager(RedisCacheWriter.lockingRedisCacheWriter((RedisConnectionFactory)factory), config);
    }

    @Generated
    public RedisConfig(RedissonProperties redissonProperties) {
        this.redissonProperties = redissonProperties;
    }
}

