/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.framework.encrypt.core.encryptor;

import cn.smarthse.framework.encrypt.core.EncryptContext;
import cn.smarthse.framework.encrypt.core.encryptor.AbstractEncryptor;
import cn.smarthse.framework.encrypt.enumd.AlgorithmType;
import cn.smarthse.framework.encrypt.enumd.EncodeType;
import cn.smarthse.framework.encrypt.utils.EncryptUtils;

public class Sm4Encryptor
extends AbstractEncryptor {
    private final EncryptContext context;

    public Sm4Encryptor(EncryptContext context) {
        super(context);
        this.context = context;
    }

    @Override
    public AlgorithmType algorithm() {
        return AlgorithmType.SM4;
    }

    @Override
    public String encrypt(String value, EncodeType encodeType) {
        if (encodeType == EncodeType.HEX) {
            return EncryptUtils.encryptBySm4Hex(value, this.context.getPassword());
        }
        return EncryptUtils.encryptBySm4(value, this.context.getPassword());
    }

    @Override
    public String decrypt(String value) {
        return EncryptUtils.decryptBySm4(value, this.context.getPassword());
    }
}

