/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.framework.encrypt.config;

import cn.smarthse.framework.encrypt.config.properties.EncryptorProperties;
import cn.smarthse.framework.encrypt.core.EncryptorManager;
import cn.smarthse.framework.encrypt.interceptor.MybatisDecryptInterceptor;
import cn.smarthse.framework.encrypt.interceptor.MybatisEncryptInterceptor;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@EnableConfigurationProperties(value={EncryptorProperties.class})
@ConditionalOnProperty(value={"mybatis-encryptor.enable"}, havingValue="true")
public class EncryptorAutoConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EncryptorAutoConfiguration.class);
    private final EncryptorProperties properties;

    @Bean
    public EncryptorManager encryptorManager() {
        log.info("\u521d\u59cb\u5316 EncryptorManager \u914d\u7f6e");
        return new EncryptorManager(this.properties.getTypeAliasesPackage());
    }

    @Bean
    public MybatisEncryptInterceptor mybatisEncryptInterceptor(EncryptorManager encryptorManager) {
        log.info("\u521d\u59cb\u5316 MybatisEncryptInterceptor \u914d\u7f6e");
        return new MybatisEncryptInterceptor(encryptorManager, this.properties);
    }

    @Bean
    public MybatisDecryptInterceptor mybatisDecryptInterceptor(EncryptorManager encryptorManager) {
        log.info("\u521d\u59cb\u5316 MybatisDecryptInterceptor \u914d\u7f6e");
        return new MybatisDecryptInterceptor(encryptorManager, this.properties);
    }

    @Generated
    public EncryptorAutoConfiguration(EncryptorProperties properties) {
        this.properties = properties;
    }
}

