/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.framework.core.config;

import cn.hutool.core.util.ArrayUtil;
import cn.smarthse.framework.core.utils.SpringUtils;
import java.util.Arrays;
import java.util.concurrent.Executor;
import javax.smarthse.framework.exception.ServiceException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.interceptor.AsyncUncaughtExceptionHandler;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.core.task.VirtualThreadTaskExecutor;
import org.springframework.scheduling.annotation.AsyncConfigurer;

@AutoConfiguration
public class AsyncConfig
implements AsyncConfigurer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AsyncConfig.class);

    public Executor getAsyncExecutor() {
        log.info("\u521d\u59cb\u5316 AsyncExecutor \u914d\u7f6e");
        if (SpringUtils.isVirtual()) {
            return new VirtualThreadTaskExecutor("async-");
        }
        return (Executor)SpringUtils.getBean((String)"scheduledExecutorService");
    }

    public AsyncUncaughtExceptionHandler getAsyncUncaughtExceptionHandler() {
        return (throwable, method, objects) -> {
            throwable.printStackTrace();
            StringBuilder sb = new StringBuilder();
            sb.append("Exception message - ").append(throwable.getMessage()).append(", Method name - ").append(method.getName());
            if (ArrayUtil.isNotEmpty((Object[])objects)) {
                sb.append(", Parameter value - ").append(Arrays.toString(objects));
            }
            throw new ServiceException(sb.toString());
        };
    }
}

