/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.task;

import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.health.service.work.assign.IRiskAssignService;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicCommandService;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xxl.job.core.context.XxlJobHelper;
import com.xxl.job.core.handler.annotation.XxlJob;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component
public class RiskAssignTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RiskAssignTask.class);
    @Autowired
    private IReformItemBasicCommandService commandService;
    @Autowired
    private IRiskAssignService riskAssignService;

    @XxlJob(value="RiskTask-syncRiskStatus")
    @Transactional(readOnly=false, propagation=Propagation.REQUIRED)
    public void syncRiskAssign() {
        log.info("\u5b9a\u65f6\u4efb\u52a1->\u4ea4\u529e\u98ce\u9669\u53cd\u9988\u7ed3\u679c\u540c\u6b65\u5f00\u59cb==========================");
        long startTime = System.currentTimeMillis();
        this.riskAssignService.syncRiskList();
        log.info("\u5b9a\u65f6\u4efb\u52a1->\u4ea4\u529e\u98ce\u9669\u53cd\u9988\u7ed3\u679c\u540c\u6b65\uff0c\u8017\u65f6\uff1a{}", (Object)((System.currentTimeMillis() - startTime) / 1000L));
    }

    @XxlJob(value="RiskAssignTask-changeToPilotCompanyByType")
    public void changeToPilotCompanyByType() {
        String jobParam = XxlJobHelper.getJobParam();
        JSONObject jsonObj = JSON.parseObject((String)jobParam);
        String cids = "";
        if (jsonObj != null && jsonObj.containsKey((Object)"cids") && StringUtils.isNotBlank((CharSequence)jsonObj.getString("cids"))) {
            cids = jsonObj.getString("cids");
        }
        this.commandService.changeToPilotCompanyByType(StringUtils.parseToLongList((String)cids));
    }

    @XxlJob(value="RiskAssignTask-generatePilotReform")
    public void generatePilotReform() {
        String jobParam = XxlJobHelper.getJobParam();
        JSONObject jsonObj = JSON.parseObject((String)jobParam);
        String cids = "";
        if (jsonObj != null && jsonObj.containsKey((Object)"cids") && StringUtils.isNotBlank((CharSequence)jsonObj.getString("cids"))) {
            cids = jsonObj.getString("cids");
        }
        this.commandService.generatePilotReform(cids);
    }

    @XxlJob(value="RiskAssignTask-generatePhcFangSheTime")
    public void generatePhcFangSheTime() {
        String jobParam = XxlJobHelper.getJobParam();
        JSONObject jsonObj = JSON.parseObject((String)jobParam);
        String cids = "";
        if (jsonObj != null && jsonObj.containsKey((Object)"cids") && StringUtils.isNotBlank((CharSequence)jsonObj.getString("cids"))) {
            cids = jsonObj.getString("cids");
        }
        this.commandService.generatePhcFangSheTime(cids);
    }

    @XxlJob(value="RiskAssignTask-autoAcceptance")
    public void autoAcceptance() throws Exception {
        String jobParam = XxlJobHelper.getJobParam();
        JSONObject jsonObj = JSON.parseObject((String)jobParam);
        String cids = "";
        if (jsonObj != null && jsonObj.containsKey((Object)"cids") && StringUtils.isNotBlank((CharSequence)jsonObj.getString("cids"))) {
            cids = jsonObj.getString("cids");
        }
        this.commandService.autoAcceptance(cids);
    }

    @XxlJob(value="RiskAssignTask-autoAddReformByGRJLCL")
    public void autoAddReformByGRJLCL() throws Exception {
        String jobParam = XxlJobHelper.getJobParam();
        JSONObject jsonObj = JSON.parseObject((String)jobParam);
        String cids = "";
        if (jsonObj != null && jsonObj.containsKey((Object)"cids") && StringUtils.isNotBlank((CharSequence)jsonObj.getString("cids"))) {
            cids = jsonObj.getString("cids");
        }
        this.commandService.autoAddReformByGRJLCL(cids);
    }
}

