/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.task;

import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.health.service.base.selfjudge.ISelfInspectionRiskAssessmentReportInfoService;
import cn.smarthse.modules.health.service.work.reform.ICompanyRiskCompletionService;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicNewService;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicService;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xxl.job.core.context.XxlJobHelper;
import com.xxl.job.core.handler.annotation.XxlJob;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component
public class ReformItemBasicTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReformItemBasicTask.class);
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IReformItemBasicService reformItemBasicService;
    @Autowired
    private IReformItemBasicNewService reformItemBasicNewService;
    @Autowired
    private ICompanyRiskCompletionService riskCompletionService;
    @Autowired
    private ISelfInspectionRiskAssessmentReportInfoService reportInfoService;

    @XxlJob(value="ReformItemBasicTask-doTask")
    public void doTask() {
        JSONObject jsonObj;
        String jobParam = XxlJobHelper.getJobParam();
        String cids = "";
        if (StringUtils.isNotBlank((CharSequence)jobParam) && (jsonObj = JSON.parseObject((String)jobParam)) != null && StringUtils.isNotBlank((CharSequence)jsonObj.getString("cids"))) {
            cids = jsonObj.getString("cids");
        }
        this.reformItemBasicService.autoGenKeyFactorReform(cids);
    }

    @XxlJob(value="ReformItemBasicTask-doAutoAcceptanceTask")
    public void doAutoAcceptanceTask() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        String startTime = dateFormat.format(new Date());
        this.logger.info("\u81ea\u52a8\u9a8c\u6536\u6574\u6539\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb\u65f6\u95f4 \uff1a " + startTime);
        try {
            this.reformItemBasicService.autoAcceptance("");
            String endTime = dateFormat.format(new Date());
            this.logger.info("\u81ea\u52a8\u9a8c\u6536\u6574\u6539\u5b9a\u65f6\u4efb\u52a1\u7ed3\u675f\u65f6\u95f4 \uff1a " + endTime);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.info("\u81ea\u52a8\u9a8c\u6536\u6574\u6539\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25");
        }
    }

    @XxlJob(value="ReformItemBasicTask-generateCompanyRiskCompletionTask")
    public void generateCompanyRiskCompletionTask() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        String startTime = dateFormat.format(new Date());
        this.logger.info("\u98ce\u9669\u5316\u89e3\u5b8c\u6210\u60c5\u51b5\u4f01\u4e1a\u6e05\u5355\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb \uff1a " + startTime);
        try {
            this.riskCompletionService.generateCompanyRiskCompletion(Collections.emptyList(), Boolean.valueOf(true));
            String endTime = dateFormat.format(new Date());
            this.logger.info("\u98ce\u9669\u5316\u89e3\u5b8c\u6210\u60c5\u51b5\u4f01\u4e1a\u6e05\u5355\u5b9a\u65f6\u4efb\u52a1\u7ed3\u675f\u65f6\u95f4 \uff1a " + endTime);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.info("\u98ce\u9669\u5316\u89e3\u5b8c\u6210\u60c5\u51b5\u4f01\u4e1a\u6e05\u5355\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25");
        }
    }

    @XxlJob(value="ReformItemBasicTask-threeTimeStatusTask")
    public void threeTimeStatusTask() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        String startTime = dateFormat.format(new Date());
        this.logger.info("\u4e09\u540c\u65f6\u98ce\u9669\u72b6\u6001\u4fee\u6539\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb\u65f6\u95f4 \uff1a " + startTime);
        this.reformItemBasicService.threeTimeStatusChange(null);
        String endTime = dateFormat.format(new Date());
        this.logger.info("\u4e09\u540c\u65f6\u98ce\u9669\u72b6\u6001\u4fee\u6539\u5b9a\u65f6\u4efb\u52a1\u7ed3\u675f\u65f6\u95f4 \uff1a " + endTime);
    }

    @XxlJob(value="ReformItemBasicTask-autoAddReformByRiskToCheck")
    public void autoAddReformByRiskToCheck() {
        JSONObject jsonObj;
        String jobParam = XxlJobHelper.getJobParam();
        String cids = null;
        if (StringUtils.isNotBlank((CharSequence)jobParam) && (jsonObj = JSON.parseObject((String)jobParam)) != null && StringUtils.isNotBlank((CharSequence)jsonObj.getString("cids"))) {
            cids = jsonObj.getString("cids");
            XxlJobHelper.log((String)cids, (Object[])new Object[0]);
        }
        this.reformItemBasicNewService.autoAddReformByCheck(cids);
    }

    @XxlJob(value="ReformItemBasicTask-autoAddReformByPhy")
    public void autoAddReformByPhy() {
        String jobParam = XxlJobHelper.getJobParam();
        JSONObject jsonObj = JSON.parseObject((String)jobParam);
        String cids = "";
        String dateStr = "";
        Boolean isNotPush = false;
        if (jsonObj != null) {
            if (jsonObj.containsKey((Object)"isNotPush") && jsonObj.getBoolean("isNotPush") != null) {
                isNotPush = jsonObj.getBoolean("isNotPush");
            }
            if (jsonObj.containsKey((Object)"cids") && StringUtils.isNotBlank((CharSequence)jsonObj.getString("cids"))) {
                cids = jsonObj.getString("cids");
            }
            if (jsonObj.containsKey((Object)"dateStr") && StringUtils.isNotBlank((CharSequence)jsonObj.getString("dateStr"))) {
                dateStr = jsonObj.getString("dateStr");
            }
        }
        XxlJobHelper.log((String)String.valueOf(isNotPush), (Object[])new Object[0]);
        XxlJobHelper.log((String)cids, (Object[])new Object[0]);
        XxlJobHelper.log((String)dateStr, (Object[])new Object[0]);
        this.reformItemBasicNewService.autoAddReformByPhy(isNotPush, cids, dateStr);
    }

    @XxlJob(value="ReformItemBasicTask-mergerAdiationAndWandaRisk")
    @Transactional(readOnly=false, propagation=Propagation.REQUIRED)
    public void mergerAdiationAndWandaRisk() {
        this.logger.info("\u5408\u5e76\u653e\u5c04\u4f01\u4e1a\u66b4\u9732\u98ce\u9669\u5f00\u59cb-->" + DateUtils.formatDateTime((Date)new Date()));
        this.reportInfoService.mergerAdiationAndWandaRisk(null);
        this.logger.info("\u5408\u5e76\u653e\u5c04\u4f01\u4e1a\u66b4\u9732\u98ce\u9669\u7ed3\u675f -->" + DateUtils.formatDateTime((Date)new Date()));
    }

    @XxlJob(value="ReformItemBasicTask-mergeReformItemBasic")
    @Transactional(readOnly=false, propagation=Propagation.REQUIRED)
    public void mergeReformItemBasic() {
        this.logger.info("\u5408\u5e76\u591a\u6570\u636e\u6e90\u98ce\u9669\u5f00\u59cb-->" + DateUtils.formatDateTime((Date)new Date()));
        this.logger.info("\u5408\u5e76\u591a\u6570\u636e\u6e90\u98ce\u9669\u7ed3\u675f -->" + DateUtils.formatDateTime((Date)new Date()));
    }

    @XxlJob(value="ReformItemBasicTask-test1")
    public void test1() {
        JSONObject jsonObj;
        String jobParam = XxlJobHelper.getJobParam();
        String cids = "";
        if (StringUtils.isNotBlank((CharSequence)jobParam) && (jsonObj = JSON.parseObject((String)jobParam)) != null && StringUtils.isNotBlank((CharSequence)jsonObj.getString("cids"))) {
            cids = jsonObj.getString("cids");
        }
        this.reformItemBasicNewService.deleteReform(StringUtils.parseToLongList((String)cids), List.of(Byte.valueOf("3")), null);
        this.reformItemBasicNewService.autoAddReformByCheck(cids);
    }
}

