/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.task;

import cn.hutool.core.text.CharSequenceUtil;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.date.DateUtil;
import cn.smarthse.modules.health.service.work.check.checkV3221.IPhcPhysicalCheckV3221Service;
import cn.smarthse.modules.health.service.work.check.checkV3221.IPhcPhysicalStaffCheckInfoService;
import cn.smarthse.modules.health.service.work.check.checkV3221.IZyjjzStatementService;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xxl.job.core.context.XxlJobHelper;
import com.xxl.job.core.handler.annotation.XxlJob;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.Date;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional(readOnly=true)
public class PhcPhysicalCheckTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PhcPhysicalCheckTask.class);
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${schedule.phcPhysicalCheckTask.end}")
    private String end;
    @Autowired
    private IPhcPhysicalCheckV3221Service checkV3221Service;
    @Autowired
    IPhcPhysicalStaffCheckInfoService phcPhysicalStaffCheckInfoService;
    @Autowired
    IZyjjzStatementService zyjjzStatementService;

    @XxlJob(value="PhcPhysicalCheckTask-doTask")
    public void doTask() {
        Date start = new Date();
        int startHour = DateUtils.getHour((Date)start);
        String dateString = DateUtil.getDateString((int)DateUtil.getYear(), (int)DateUtil.getMonth(), (int)DateUtil.getDay()) + " " + this.end;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        String startTime = dateFormat.format(new Date());
        this.logger.info("\u4f53\u68c0V3221\u6570\u636e\u8f6c\u6362\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb");
        this.checkV3221Service.phcPhysicalCheckTask(null, null);
        String endTime = dateFormat.format(new Date());
        this.logger.info("\u4f53\u68c0V3221\u6570\u636e\u8f6c\u6362\u5b9a\u65f6\u4efb\u52a1\u7ed3\u675f" + endTime);
        long l = System.currentTimeMillis();
    }

    @XxlJob(value="PhcPhysicalCheckResetTask-doTask")
    public void doResetTask() {
        Date start = new Date();
        int startHour = DateUtils.getHour((Date)start);
        String dateString = DateUtil.getDateString((int)DateUtil.getYear(), (int)DateUtil.getMonth(), (int)DateUtil.getDay()) + " " + this.end;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        String startTime = dateFormat.format(new Date());
        this.logger.info("\u4f53\u68c0V3221\u6570\u636e\u8f6c\u6362\u91cd\u7f6e\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb");
        this.checkV3221Service.phcPhysicalCheckResetTask(null, null);
        String endTime = dateFormat.format(new Date());
        this.logger.info("\u4f53\u68c0V3221\u6570\u636e\u8f6c\u6362\u91cd\u7f6e\u5b9a\u65f6\u4efb\u52a1\u7ed3\u675f" + endTime);
        long l = System.currentTimeMillis();
    }

    @XxlJob(value="PhcPhysicalCheckTask-resetConverted")
    @Transactional(readOnly=false, rollbackFor={Exception.class})
    public void resetConverted() {
        try {
            int batchSize = 500;
            String param = XxlJobHelper.getJobParam();
            if (StringUtils.isNotBlank((CharSequence)param)) {
                try {
                    batchSize = Integer.parseInt(param);
                    XxlJobHelper.log((String)"\u4f7f\u7528\u81ea\u5b9a\u4e49\u6279\u6b21\u5927\u5c0f: {}", (Object[])new Object[]{batchSize});
                }
                catch (Exception e) {
                    XxlJobHelper.log((String)"\u53c2\u6570\u683c\u5f0f\u9519\u8bef\uff0c\u4f7f\u7528\u9ed8\u8ba4\u6279\u6b21\u5927\u5c0f", (Object[])new Object[0]);
                }
            }
            this.checkV3221Service.resetConverted(Integer.valueOf(batchSize));
            XxlJobHelper.handleSuccess((String)"\u6267\u884c\u6210\u529f");
        }
        catch (Exception e) {
            XxlJobHelper.log((String)"\u4efb\u52a1\u5931\u8d25: {}", (Object[])new Object[]{e.getMessage(), e});
            XxlJobHelper.handleFail((String)e.getMessage());
        }
    }

    @XxlJob(value="PhcPhysicalCheckTask-correctData")
    @Transactional(readOnly=false, propagation=Propagation.REQUIRED)
    public void task2() {
        this.checkV3221Service.correctData(null);
    }

    @XxlJob(value="PhcPhysicalCheckTask-task3")
    @Transactional(readOnly=false, propagation=Propagation.REQUIRED)
    public void test3(Long cid) {
        this.checkV3221Service.checkAndCorrect(cid);
    }

    @XxlJob(value="PhcPhysicalCheckTask-test4")
    @Transactional(readOnly=false, propagation=Propagation.REQUIRED)
    public void test4(Long cid, Integer year, Integer size) {
        String sizeStr;
        String yearStr;
        String cidStr;
        if (cid == null && StringUtils.isNotBlank((CharSequence)(cidStr = this.getParamValue("cid")))) {
            cid = Long.parseLong(cidStr);
        }
        if (year == null && StringUtils.isNotBlank((CharSequence)(yearStr = this.getParamValue("year")))) {
            year = Integer.parseInt(yearStr);
        }
        if (size == null && StringUtils.isNotBlank((CharSequence)(sizeStr = this.getParamValue("size")))) {
            size = Integer.parseInt(sizeStr);
        }
        XxlJobHelper.log((String)"\u63a5\u6536\u5230\u53c2\u6570\uff1acid {}\uff0c year {}\uff0c size {}", (Object[])new Object[]{cid, year, size});
        this.checkV3221Service.updateCheckNum(cid, year, size);
    }

    @XxlJob(value="PhcPhysicalCheckTask-test5")
    @Transactional(readOnly=false, propagation=Propagation.REQUIRED)
    public void test5() {
        JSONObject jsonObj;
        String unifiedSocialCcs = null;
        String jobParam = XxlJobHelper.getJobParam();
        if (StringUtils.isNotBlank((CharSequence)jobParam) && (jsonObj = JSON.parseObject((String)jobParam)) != null) {
            unifiedSocialCcs = jsonObj.getString("unifiedSocialCcs");
        }
        this.checkV3221Service.appendEmpCreditCodeData(unifiedSocialCcs);
    }

    @XxlJob(value="PhcPhysicalCheckTask-test6")
    @Transactional(readOnly=false, propagation=Propagation.REQUIRED)
    public void test6() {
        this.checkV3221Service.staticsCompanyAppendInfo();
    }

    private String getParamValue(String paramName) {
        JSONObject jsonObj;
        String paramValue = null;
        String jobParam = XxlJobHelper.getJobParam();
        if (CharSequenceUtil.isNotBlank((CharSequence)jobParam) && (jsonObj = JSON.parseObject((String)jobParam)) != null) {
            paramValue = jsonObj.getString(paramName);
        }
        return paramValue;
    }

    @XxlJob(value="PhcPhysicalCheckTask-countZyjjzAndSendSms")
    @Transactional(readOnly=false, propagation=Propagation.REQUIRED)
    public void countZyjjzAndSendSms() {
        long start = System.currentTimeMillis();
        XxlJobHelper.log((String)"\u4efb\u52a1\u5f00\u59cb\u6267\u884c\u65f6\u95f4\uff1a{}", (Object[])new Object[]{LocalDateTime.now()});
        this.zyjjzStatementService.countZyjjzAndSendSms();
        long end = System.currentTimeMillis();
        XxlJobHelper.log((String)"\u4efb\u52a1\u7ed3\u675f\u6267\u884c\u65f6\u95f4\uff1a{}", (Object[])new Object[]{LocalDateTime.now()});
        XxlJobHelper.log((String)"\u6267\u884c\u6210\u529f\u4efb\u52a1\u603b\u8017\u65f6\uff1a{}", (Object[])new Object[]{end - start});
    }
}

