/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.task;

import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.health.compliance.service.IComplianceCompanyInfoService;
import cn.smarthse.modules.health.entity.work.check.checkV3221.PhcPhysicalCheckV3221;
import cn.smarthse.modules.health.entity.work.reform.ReformItemBasic;
import cn.smarthse.modules.health.enums.reform.ReformGenerationSourceEnum;
import cn.smarthse.modules.health.service.litearchive.ILiteArchiveService;
import cn.smarthse.modules.health.service.litearchive.ILiteArchiveUpdateService;
import cn.smarthse.modules.health.service.litearchive.imp.LiteArchiveTaskParam;
import cn.smarthse.modules.health.service.work.certificate.ICertificateStaffDetailService;
import cn.smarthse.modules.health.service.work.check.checkV3221.IPhcPhysicalCheckV3221Service;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicService;
import cn.smarthse.modules.health.task.LiteAchiveParamUtils;
import cn.smarthse.services.hfi.api.entity.CheckPlan;
import cn.smarthse.services.hfi.api.service.ICheckPlanService;
import cn.smarthse.snowflake.IdWorker;
import com.xxl.job.core.context.XxlJobHelper;
import com.xxl.job.core.handler.annotation.XxlJob;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LiteArchiveTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LiteArchiveTask.class);
    @Autowired
    protected IdWorker idworker;
    @Autowired
    private IPhcPhysicalCheckV3221Service physicalCheckV3221Service;
    @DubboReference
    private ICheckPlanService checkPlanService;
    @Autowired
    private IReformItemBasicService reformService;
    @Autowired
    private ICertificateStaffDetailService certificateStaffDetailService;
    @DubboReference
    private IComplianceCompanyInfoService complianceInfoService;
    @Autowired
    private ILiteArchiveService liteArchiveService;
    @Autowired
    private ILiteArchiveUpdateService archiveUpdateService;

    @XxlJob(value="LiteArchiveTask-generateLiteArchiveReform")
    public void generateLiteArchiveReform() throws InterruptedException {
        LiteArchiveTaskParam xxlParam = LiteAchiveParamUtils.getXxlParam();
        List reformItemBasics = this.reformService.lastApproveReform(xxlParam.getUpdateDate());
        if (CollectionUtils.isEmpty((Collection)reformItemBasics)) {
            return;
        }
        XxlJobHelper.log((String)"reformItemBasics size:{}", (Object[])new Object[]{reformItemBasics.size()});
        List allCidList = reformItemBasics.stream().map(ReformItemBasic::getCid).filter(f -> f != null).distinct().collect(Collectors.toList());
        HashSet<String> fileNameIds = new HashSet<String>();
        for (ReformItemBasic reformItemBasic : reformItemBasics) {
            Byte generationSource = reformItemBasic.getGenerationSource();
            if (Objects.equals(ReformGenerationSourceEnum.PROTECTION.getValue(), generationSource)) {
                fileNameIds.addAll(Set.of("206", "210", "410"));
                continue;
            }
            if (Objects.equals(ReformGenerationSourceEnum.WARNING_SIGNS.getValue(), generationSource)) {
                fileNameIds.addAll(Set.of("211"));
                continue;
            }
            if (Objects.equals(ReformGenerationSourceEnum.TRAIN.getValue(), generationSource)) {
                fileNameIds.addAll(Set.of("302"));
                continue;
            }
            if (!Objects.equals(ReformGenerationSourceEnum.DETECTION.getValue(), generationSource)) continue;
            fileNameIds.addAll(Set.of("404"));
        }
        if (CollectionUtils.isEmpty(fileNameIds)) {
            return;
        }
        this.archiveUpdateService.asyncRefreshArchiveV2(allCidList, StringUtils.join(fileNameIds, (String)","));
    }

    @XxlJob(value="LiteArchiveTask-generateLiteArchivePhcCheck")
    public void generateLiteArchivePhcCheck() {
        log.info("\u5f00\u59cb\u751f\u6210\u4f53\u68c0\u76f8\u5173\u6863\u6848-start");
        List phcPhysicalCheckV3221s = this.physicalCheckV3221Service.lastUpdatePhcCheck(null);
        if (CollectionUtils.isEmpty((Collection)phcPhysicalCheckV3221s)) {
            return;
        }
        List phyCidList = phcPhysicalCheckV3221s.stream().filter(p -> p.getCid() != null).map(PhcPhysicalCheckV3221::getCid).collect(Collectors.toList());
        String titles = DateUtils.getThisYear() + "," + (DateUtils.getThisYear() - 1);
        this.liteArchiveService.batchRefreshAchiveByNameIds(phyCidList, "502");
        log.info("\u5f00\u59cb\u751f\u6210\u4f53\u68c0\u76f8\u5173\u6863\u6848-end");
    }

    @XxlJob(value="LiteArchiveTask-refreshComplianceCompanyArchive")
    public void refreshComplianceCompanyArchive() {
        log.info("\u5408\u89c4\u4f01\u4e1a\u5b9a\u65f6\u5237\u65b0\u6863\u6848-start");
        List cidList = this.complianceInfoService.getCidList();
        if (CollectionUtils.isEmpty((Collection)cidList)) {
            return;
        }
        this.archiveUpdateService.asyncRefreshArchiveV2(cidList, "204,216");
        log.info("\u5408\u89c4\u4f01\u4e1a\u5b9a\u65f6\u5237\u65b0\u6863\u6848-end");
    }

    @XxlJob(value="LiteArchiveTask-generateLiteArchiveCheck")
    public void generateLiteArchiveCheck() {
        log.info("\u5f00\u59cb\u751f\u6210\u68c0\u6d4b\u76f8\u5173\u6863\u6848-start");
        LiteArchiveTaskParam xxlParam = LiteAchiveParamUtils.getXxlParam();
        List checkPlanList = this.checkPlanService.getLastUpdateCid(xxlParam.getUpdateDate());
        XxlJobHelper.log((String)"\u9700\u66f4\u65b0\u4f01\u4e1a\u6863\u6848\u6570\uff1a{}", (Object[])new Object[]{checkPlanList.size()});
        if (CollectionUtils.isEmpty((Collection)checkPlanList)) {
            return;
        }
        if (CollectionUtils.isNotEmpty(xxlParam.getCids())) {
            checkPlanList = checkPlanList.stream().filter(f -> xxlParam.getCids().contains(f.getCid())).collect(Collectors.toList());
        }
        List checkCidList = checkPlanList.stream().map(CheckPlan::getCid).filter(f -> f != null).collect(Collectors.toList());
        XxlJobHelper.log((String)"\u9700\u5904\u7406\u66f4\u65b0\u4f01\u4e1a\u6863\u6848\u6570\uff1a{}", (Object[])new Object[]{checkPlanList.size()});
        this.archiveUpdateService.asyncRefreshArchiveV2(checkCidList, "404");
        log.info("\u5f00\u59cb\u751f\u6210\u68c0\u6d4b\u76f8\u5173\u6863\u6848-end");
    }

    @XxlJob(value="LiteArchiveTask-generateLiteArchiveCerfi")
    public void generateLiteArchiveCerfi() {
        log.info("\u5f00\u59cb\u751f\u6210\u8bc1\u4e66\u76f8\u5173\u6863\u6848-start");
        LiteArchiveTaskParam xxlParam = LiteAchiveParamUtils.getXxlParam();
        List cerList = this.certificateStaffDetailService.getLastUpdate(xxlParam.getCid(), xxlParam.getUpdateDate());
        XxlJobHelper.log((String)"\u9700\u66f4\u65b0\u4f01\u4e1a\u6863\u68483\u6570\uff1a{}", (Object[])new Object[]{cerList.size()});
        if (CollectionUtils.isEmpty((Collection)cerList)) {
            return;
        }
        List certCidList = cerList.stream().filter(f -> f != null && f.getCid() != null).map(f -> f.getCid()).collect(Collectors.toList());
        String titles = DateUtils.getThisYear() + "," + (DateUtils.getThisYear() - 1);
        this.archiveUpdateService.asyncRefreshArchiveV2(certCidList, "302");
        log.info("\u5f00\u59cb\u751f\u6210\u8bc1\u4e66\u76f8\u5173\u6863\u6848-end");
    }
}

