/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.task;

import cn.smarthse.modules.datacentre.provider.ICompanyProvideBySuperviseService;
import cn.smarthse.modules.health.entity.litearchive.LiteArchive;
import cn.smarthse.modules.health.model.litearchive.AddLiteArchiveModel;
import cn.smarthse.modules.health.model.litearchive.LiteArchiveLastdateCollectorModel;
import cn.smarthse.modules.health.newcompliance.service.INewComplianceCompanyInfoService;
import cn.smarthse.modules.health.service.archive.ILiteArchiveLastdateCollectorService;
import cn.smarthse.modules.health.service.litearchive.ILiteArchiveFileItemService;
import cn.smarthse.modules.health.service.litearchive.ILiteArchiveService;
import cn.smarthse.modules.health.service.litearchive.imp.LiteArchiveTaskParam;
import cn.smarthse.modules.health.task.LiteAchiveParamUtils;
import cn.smarthse.snowflake.IdWorker;
import com.alibaba.fastjson.JSON;
import com.github.pagehelper.PageHelper;
import com.xxl.job.core.context.XxlJobHelper;
import com.xxl.job.core.handler.annotation.XxlJob;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LiteArchiveLastTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LiteArchiveLastTask.class);
    @Autowired
    private ILiteArchiveLastdateCollectorService archiveCatchallService;
    @Autowired
    private ILiteArchiveService liteArchiveService;
    @Autowired
    private ILiteArchiveFileItemService archiveFileItemService;
    @DubboReference
    private INewComplianceCompanyInfoService complianceInfoService;
    @Autowired
    private RedissonClient redisson;
    @Autowired
    protected IdWorker idworker;
    @DubboReference(version="1.0.0")
    private ICompanyProvideBySuperviseService companyProvideBySuperviseService;

    @XxlJob(value="LiteArchiveLastTask-generateLastReport")
    public void generateLastReport() {
        log.info("\u7edf\u8ba1\u6863\u6848\u4e1a\u52a1\u6570\u636e\u66f4\u65b0\u65f6\u95f4\u60c5\u51b5\u3010\u6b65\u9aa4\u4e00\u3011-start");
        this.archiveCatchallService.resetliteArchiveLastdateCollector();
        this.archiveCatchallService.processArchive202();
        this.archiveCatchallService.processArchive204();
        this.archiveCatchallService.processArchive206();
        this.archiveCatchallService.processArchive210();
        this.archiveCatchallService.processArchive211();
        this.archiveCatchallService.processArchive216();
        this.archiveCatchallService.processArchive302();
        this.archiveCatchallService.processArchive303();
        this.archiveCatchallService.processArchive404();
        log.info("\u7edf\u8ba1\u6863\u6848\u4e1a\u52a1\u6570\u636e\u66f4\u65b0\u65f6\u95f4\u60c5\u51b5\u3010\u6b65\u9aa4\u4e00\u3011-end");
    }

    @XxlJob(value="LiteArchiveLastTask-processRefreshArchive")
    public void processRefreshArchive() {
        log.info("\u7edf\u8ba1\u6863\u6848\u9700\u8981\u5237\u65b0\u7684\u60c5\u51b5\u3010\u6b65\u9aa4\u4e8c\u3011-start");
        this.archiveCatchallService.processRefreshArchive();
        log.info("\u7edf\u8ba1\u6863\u6848\u9700\u8981\u5237\u65b0\u7684\u60c5\u51b5\u3010\u6b65\u9aa4\u4e8c\u3011-end");
    }

    private boolean needRefresh(Map<Long, Map<Integer, Map<String, String>>> cidTypeTitleMap, long cid, Integer type, String title) {
        Map<Integer, Map<String, String>> integerMapMap = cidTypeTitleMap.get(cid);
        if (integerMapMap == null) {
            return false;
        }
        Map<String, String> stringDateMap = integerMapMap.get(type);
        if (stringDateMap == null) {
            return false;
        }
        return stringDateMap.containsKey(title);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @XxlJob(value="LiteArchiveLastTask-refreshArchiteItem234ByRefreshCollector")
    public void refreshArchiteItem234ByefreshCollector() throws InterruptedException {
        log.info("\u6863\u6848\u5237\u65b0\u515c\u5e95\u4efb\u52a1\u3010\u6b65\u9aa4\u4e09\u3011-start");
        LiteArchiveTaskParam xxlParam = LiteAchiveParamUtils.getXxlParam();
        String lockName = "LiteArchiveLastTask:refreshArchiteItem234ByRefreshCollector:hot";
        Set complianceIdSet = this.complianceInfoService.getSubmitComplianceCidSet(null);
        RLock lock = this.redisson.getLock(lockName);
        if (lock.tryLock()) {
            try {
                List liteArchiveLastdateCollectorModels = this.archiveCatchallService.selectRefreshCollector(xxlParam.getYearTitleList());
                if (CollectionUtils.isEmpty((Collection)liteArchiveLastdateCollectorModels)) {
                    return;
                }
                Map<Long, Map<Integer, Map<String, String>>> cidTypeTitleMap = liteArchiveLastdateCollectorModels.stream().collect(Collectors.groupingBy(LiteArchiveLastdateCollectorModel::getCid, Collectors.groupingBy(LiteArchiveLastdateCollectorModel::getArchiveType, Collectors.toMap(LiteArchiveLastdateCollectorModel::getTitle, LiteArchiveLastdateCollectorModel::getTitle))));
                List cidList = liteArchiveLastdateCollectorModels.stream().map(LiteArchiveLastdateCollectorModel::getCid).collect(Collectors.toList());
                List liteArchives = this.liteArchiveService.allLiteArchive(null, cidList, xxlParam.getArchiveTypeList(), xxlParam.getYearTitleList());
                ArrayList<LiteArchive> needRefreshArchiveIdList = new ArrayList<LiteArchive>();
                for (LiteArchive liteArchive : liteArchives) {
                    Long cid = liteArchive.getCid();
                    Integer archiveType = liteArchive.getArchiveType();
                    String title = liteArchive.getTitle();
                    if (!this.needRefresh(cidTypeTitleMap, cid, archiveType, title)) continue;
                    needRefreshArchiveIdList.add(liteArchive);
                }
                liteArchives.clear();
                if (CollectionUtils.isEmpty(needRefreshArchiveIdList)) {
                    return;
                }
                log.error("refreshArchiteItem234ByefreshCollector\u672c\u6b21\u9700\u66f4\u65b0\u6863\u6848\u6570:{}", (Object)needRefreshArchiveIdList.size());
                XxlJobHelper.log((String)"\u672c\u6b21\u9700\u66f4\u65b0\u6863\u6848\u6570:{}", (Object[])new Object[]{needRefreshArchiveIdList.size()});
                this.archiveFileItemService.handRefreshAchiveV2(needRefreshArchiveIdList, complianceIdSet, null, Boolean.valueOf(false), Boolean.valueOf(true));
            }
            catch (Exception e) {
                log.error("\u6279\u91cf\u751f\u6210\u6863\u6848\u62a5\u9519\uff1a lockName:{}", (Object)lockName, (Object)e);
            }
            finally {
                lock.unlock();
            }
        } else {
            log.error("refreshArchiteItem234ByefreshCollector\uff0c lockName:{}", (Object)lockName);
        }
        log.info("\u6863\u6848\u5237\u65b0\u515c\u5e95\u4efb\u52a1\u3010\u6b65\u9aa4\u4e09\u3011-end");
    }

    private LiteArchive generateLiteArchive(Long cid, Integer archiveType, String archiveTitle) {
        LiteArchive la = new LiteArchive();
        la.setId(Long.valueOf(this.idworker.nextId()));
        la.setCid(cid);
        la.setArchiveType(archiveType);
        la.setTitle(archiveTitle);
        la.setIsValid(Boolean.valueOf(true));
        la.setCreateDate(new Date());
        la.setCreateBy(Long.valueOf(7890L));
        la.setArchiveUpdateTime(new Date());
        la.setStatus(Integer.valueOf(0));
        la.setUpdateVersion(Integer.valueOf(0));
        return la;
    }

    private boolean hasArchive(Map<Long, Map<Integer, Map<String, String>>> cidTypeTitleMap, Long cid, Integer archiveType, String archiveTitle) {
        Map<Integer, Map<String, String>> integerMapMap = cidTypeTitleMap.get(cid);
        if (integerMapMap == null) {
            return false;
        }
        Map<String, String> stringStringMap = integerMapMap.get(archiveType);
        if (stringStringMap == null) {
            return false;
        }
        return stringStringMap.containsKey(archiveTitle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @XxlJob(value="LiteArchiveLastTask-reAddLiteArchive")
    public void reAddLiteArchive() throws InterruptedException {
        log.info("\u5237\u65b0\u6ca1\u6709234\u6863\u6848\u6570\u636e\u7684\u4f01\u4e1a\uff08\u6839\u636e\u6307\u5b9a\u5e74\u4efd\u3001\u4f01\u4e1a\uff09-start");
        LiteArchiveTaskParam xxlParam = LiteAchiveParamUtils.getXxlParam();
        Set compliceCidSet = this.complianceInfoService.getSubmitComplianceCidSet(null);
        String lockName = "LiteArchiveLastTask:reAddLiteArchive:hot";
        RLock lock = this.redisson.getLock(lockName);
        if (lock.tryLock()) {
            try {
                for (String yearTime : xxlParam.getYearTitleList()) {
                    List addLiteArchiveModels = this.archiveCatchallService.selectAddLiteArchiveModel(yearTime, xxlParam.getCids());
                    if (CollectionUtils.isEmpty((Collection)addLiteArchiveModels)) {
                        return;
                    }
                    XxlJobHelper.log((String)"\u6ca1\u6709\u6863\u6848234\u7684\u4f01\u4e1a\u6570:{}", (Object[])new Object[]{addLiteArchiveModels.size()});
                    List tempCids = addLiteArchiveModels.stream().map(AddLiteArchiveModel::getCid).collect(Collectors.toList());
                    List liteArchives = this.liteArchiveService.listLiteArchiveByCids(tempCids, xxlParam.getArchiveTypeList(), Arrays.asList(yearTime));
                    HashMap<Long, Map<Integer, Map<String, String>>> cidTypeTitleMap = new HashMap();
                    if (CollectionUtils.isNotEmpty((Collection)liteArchives)) {
                        cidTypeTitleMap = liteArchives.stream().collect(Collectors.groupingBy(LiteArchive::getCid, Collectors.groupingBy(LiteArchive::getArchiveType, Collectors.toMap(LiteArchive::getTitle, LiteArchive::getTitle, (v1, v2) -> v1))));
                    }
                    ArrayList<LiteArchive> addList = new ArrayList<LiteArchive>();
                    for (AddLiteArchiveModel addModel : addLiteArchiveModels) {
                        Long cid = addModel.getId();
                        Long currarchive2 = addModel.getCurrarchive2();
                        Long currarchive3 = addModel.getCurrarchive3();
                        Long currarchive4 = addModel.getCurrarchive4();
                        if (currarchive2 == null && !this.hasArchive(cidTypeTitleMap, cid, 2, yearTime)) {
                            addList.add(this.generateLiteArchive(cid, 2, yearTime));
                        }
                        if (currarchive3 == null && !this.hasArchive(cidTypeTitleMap, cid, 3, yearTime)) {
                            addList.add(this.generateLiteArchive(cid, 3, yearTime));
                        }
                        if (currarchive4 != null || this.hasArchive(cidTypeTitleMap, cid, 4, yearTime)) continue;
                        addList.add(this.generateLiteArchive(cid, 4, yearTime));
                    }
                    if (!CollectionUtils.isNotEmpty(addList)) continue;
                    this.liteArchiveService.batchInsertArchives(addList);
                    XxlJobHelper.log((String)"\u672c\u6b21\u9700\u65b0\u589e\u6863\u6848\u6570:{}", (Object[])new Object[]{addList.size()});
                    this.archiveFileItemService.handRefreshAchiveV2(addList, compliceCidSet, null, Boolean.valueOf(false), Boolean.valueOf(true));
                }
            }
            catch (Exception e) {
                log.error("reAddLiteArchive\u6279\u91cf\u751f\u6210\u6863\u6848\u62a5\u9519\uff1a lockName:{}", (Object)lockName, (Object)e);
            }
            finally {
                lock.unlock();
            }
        } else {
            log.error("reAddLiteArchive \u9501\u83b7\u53d6\u5931\u8d25\uff0c lockName:{}", (Object)lockName);
        }
        log.info("\u5237\u65b0\u6ca1\u6709234\u6863\u6848\u6570\u636e\u7684\u4f01\u4e1a\uff08\u6839\u636e\u6307\u5b9a\u5e74\u4efd\u3001\u4f01\u4e1a\uff09--end");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @XxlJob(value="LiteArchiveLastTask-reAddrefreshNoFileItem")
    public void refreshNoFileItem() throws InterruptedException {
        log.info("\u8865\u5145\u6863\u6848\u5237\u65b0\u4efb\u52a1(\u6863\u6848\u65e0\u9644\u4ef6)-start");
        LiteArchiveTaskParam xxlParam = LiteAchiveParamUtils.getXxlParam();
        Set compliceCidSet = this.complianceInfoService.getSubmitComplianceCidSet(null);
        String lockName = "LiteArchiveLastTask:reAddrefreshNoFileItem:hot";
        RLock lock = this.redisson.getLock(lockName);
        if (lock.tryLock()) {
            try {
                if (xxlParam.getPageSize() != null) {
                    PageHelper.startPage((int)1, (int)xxlParam.getPageSize());
                }
                List liteArchives = this.liteArchiveService.listNoFileItemArchive(xxlParam.getCids(), xxlParam.getArchiveTypeList(), xxlParam.getYearTitleList(), xxlParam.getStatus());
                log.info("-start,\u8865\u5145\u6863\u6848\u9700\u8981\u91cd\u65b0\u5237\u65b0\u6570:{}", (Object)liteArchives.size());
                XxlJobHelper.log((String)"\u8865\u5145\u6863\u6848\u9700\u8981\u91cd\u65b0\u5237\u65b0\u6570:{}", (Object[])new Object[]{liteArchives.size()});
                if (CollectionUtils.isEmpty((Collection)liteArchives)) {
                    return;
                }
                this.archiveFileItemService.handRefreshAchiveV2(liteArchives, compliceCidSet, null, Boolean.valueOf(false), Boolean.valueOf(true));
            }
            catch (Exception e) {
                log.error("reAddrefreshNoFileItem \u8865\u5145\u6863\u6848\u9700\u8981\u91cd\u65b0\u5237\u65b0\u62a5\u9519\uff1a lockName:{}", (Object)lockName, (Object)e);
            }
            finally {
                lock.unlock();
            }
        } else {
            log.error("reAddrefreshNoFileItem \u9501\u83b7\u53d6\u5931\u8d25\uff0c lockName:{}", (Object)lockName);
        }
        log.info("\u8865\u5145\u6863\u6848\u5237\u65b0\u4efb\u52a1(\u6863\u6848\u65e0\u9644\u4ef6)-end");
    }

    @XxlJob(value="LiteArchiveLastTask-listNoFinishLiteArchive")
    public void listNoFinishLiteArchive() throws InterruptedException {
        List liteArchives;
        log.info("\u5237\u65b0\u672a\u5b8c\u6210\u7684\u6863\u6848\u4efb\u52a1-start");
        LiteArchiveTaskParam xxlParam = LiteAchiveParamUtils.getXxlParam();
        if (xxlParam.getPageSize() != null) {
            PageHelper.startPage((int)1, (int)xxlParam.getPageSize());
        }
        if (CollectionUtils.isEmpty((Collection)(liteArchives = this.liteArchiveService.listNoFinishLiteArchive(xxlParam.getCids(), xxlParam.getArchiveTypeList(), xxlParam.getYearTitleList(), xxlParam.getStatusList())))) {
            return;
        }
        XxlJobHelper.log((String)"\u67e5\u8be2\u53c2\u6570\uff1a{}\uff0c \u672c\u6b21\u9700\u5904\u7406\u6863\u6848\u6570\u636e:{}", (Object[])new Object[]{JSON.toJSONString((Object)xxlParam), liteArchives.size()});
        Set compliceIdSet = liteArchives.stream().filter(f -> Objects.equals(f.getIsCompliance(), 1)).map(LiteArchive::getCid).collect(Collectors.toSet());
        this.archiveFileItemService.handRefreshAchiveV2(liteArchives, compliceIdSet, null, Boolean.valueOf(false), Boolean.valueOf(true));
        log.info("\u5237\u65b0\u672a\u5b8c\u6210\u7684\u6863\u6848\u4efb\u52a1-end");
    }
}

