/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.task;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.modules.health.compliance.enums.ComplianceCodeEnum;
import cn.smarthse.modules.health.compliance.service.IBusinessDataUpdateRefreshService;
import cn.smarthse.modules.health.entity.base.company.CompanyFunctionalOrganizationMember;
import cn.smarthse.modules.health.entity.base.company.CompanyFunctionalOrganizationMemberCert;
import cn.smarthse.modules.health.entity.work.certificate.CertificateName;
import cn.smarthse.modules.health.entity.work.certificate.CertificateStaffDetail;
import cn.smarthse.modules.health.newcompliance.enums.NewComplianceCodeEnum;
import cn.smarthse.modules.health.newcompliance.service.INewBusinessDataUpdateRefreshService;
import cn.smarthse.modules.health.service.base.ICompanyService;
import cn.smarthse.modules.health.service.base.company.ICompanyFunctionalOrganizationMemberCertService;
import cn.smarthse.modules.health.service.base.company.ICompanyFunctionalOrganizationMemberService;
import cn.smarthse.modules.health.service.work.certificate.ICertificateNameService;
import cn.smarthse.modules.health.service.work.certificate.ICertificateStaffDetailService;
import com.github.pagehelper.PageInfo;
import com.xxl.job.core.context.XxlJobHelper;
import com.xxl.job.core.handler.annotation.XxlJob;
import java.util.Date;
import java.util.List;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CertificateStaffDetailTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CertificateStaffDetailTask.class);
    @DubboReference(check=false)
    IBusinessDataUpdateRefreshService businessDataUpdateRefreshService;
    @DubboReference
    private ICertificateStaffDetailService certificateStaffDetailService;
    @Autowired
    private ICompanyFunctionalOrganizationMemberService iCompanyFunctionalOrganizationMemberService;
    @DubboReference
    private ICompanyFunctionalOrganizationMemberCertService memberCertService;
    @DubboReference
    private ICertificateNameService certificateNameService;
    @DubboReference
    INewBusinessDataUpdateRefreshService newBusinessDataUpdateRefreshService;
    @Autowired
    ICompanyService companyService;

    @XxlJob(value="CertificateTask-AutoAddCer")
    public void CertificateTask() {
        List cids = this.companyService.getCids();
        int total = cids.size();
        int count = 0;
        for (Long cid : cids) {
            if (++count % 1000 == 0 || count == 1 || count == total) {
                log.info("\u8bc1\u4e66\u81ea\u52a8\u5173\u8054\u4efb\u52a1\u8fdb\u5ea6: {}/{} ({}%)", new Object[]{count, total, count * 100 / total});
            }
            try {
                List certificateStaffDetails = this.certificateStaffDetailService.selectAutoData(cid);
                for (CertificateStaffDetail validCertificate : certificateStaffDetails) {
                    boolean hasAdd = false;
                    String staffName = validCertificate.getStaffName();
                    Date validityDate = validCertificate.getValidityDate();
                    Date certCreateDate = validCertificate.getCertCreateDate();
                    CompanyFunctionalOrganizationMember me = this.iCompanyFunctionalOrganizationMemberService.getByStaffName(cid, staffName);
                    if (me != null) {
                        JqGridParam jqGridParam;
                        Long id = me.getId();
                        PageInfo pageInfo = this.memberCertService.memberCertList(id, jqGridParam = new JqGridParam(10, 1));
                        List list = pageInfo.getList();
                        if (list != null) {
                            for (CompanyFunctionalOrganizationMemberCert companyFunctionalOrganizationMemberCert : list) {
                                if (!companyFunctionalOrganizationMemberCert.getValidityDate().equals(validityDate) || !certCreateDate.equals(companyFunctionalOrganizationMemberCert.getCertCreateDate())) continue;
                                hasAdd = true;
                            }
                        }
                        if (hasAdd) continue;
                    }
                    Long certId = validCertificate.getCertId();
                    CertificateName certificateName = (CertificateName)this.certificateNameService.getById(certId);
                    String certName = certificateName.getName();
                    List listByExample = this.iCompanyFunctionalOrganizationMemberService.selectCerType(cid, staffName);
                    if (listByExample != null) {
                        listByExample.forEach(data -> {
                            if (certName.equals("\u804c\u4e1a\u5065\u5eb7\u7ba1\u7406\u4eba\u5458\u804c\u4e1a\u536b\u751f\u7ba1\u7406\u57f9\u8bad\u5408\u683c\u8bc1\u4e66") && data.getManagerCert() == 1) {
                                this.iCompanyFunctionalOrganizationMemberService.delete(data, cid);
                                this.businessDataUpdateRefreshService.addBusinessDataUpdateMsg(cid, null, new ComplianceCodeEnum[]{ComplianceCodeEnum.CODE03, ComplianceCodeEnum.CODE09, ComplianceCodeEnum.CODE15});
                                this.newBusinessDataUpdateRefreshService.addBusinessDataUpdateMsg(cid, null, new NewComplianceCodeEnum[]{NewComplianceCodeEnum.CODE03, NewComplianceCodeEnum.CODE09, NewComplianceCodeEnum.CODE15});
                            } else if (certName.equals("\u4e3b\u8981\u8d1f\u8d23\u4eba\u804c\u4e1a\u536b\u751f\u7ba1\u7406\u57f9\u8bad\u5408\u683c\u8bc1\u4e66") && data.getLeaderCert() == 1) {
                                this.iCompanyFunctionalOrganizationMemberService.delete(data, cid);
                                this.businessDataUpdateRefreshService.addBusinessDataUpdateMsg(cid, null, new ComplianceCodeEnum[]{ComplianceCodeEnum.CODE03, ComplianceCodeEnum.CODE09, ComplianceCodeEnum.CODE15});
                                this.newBusinessDataUpdateRefreshService.addBusinessDataUpdateMsg(cid, null, new NewComplianceCodeEnum[]{NewComplianceCodeEnum.CODE03, NewComplianceCodeEnum.CODE09, NewComplianceCodeEnum.CODE15});
                            }
                        });
                    }
                    CompanyFunctionalOrganizationMember member = new CompanyFunctionalOrganizationMember();
                    member.setStaffName(staffName);
                    member.setCid(cid);
                    if (validCertificate.getCertId() == 12L) {
                        member.setOrgStaffType("1");
                    } else if (validCertificate.getCertId() == 13L) {
                        member.setMemberType(Byte.valueOf((byte)2));
                        member.setOrgStaffType("2");
                    }
                    member.setIsAutoGenerated(Byte.valueOf((byte)1));
                    member.setIsValid(Boolean.valueOf(true));
                    Long memberId = this.iCompanyFunctionalOrganizationMemberService.updateOrgStaff(member, cid);
                    this.businessDataUpdateRefreshService.addBusinessDataUpdateMsg(member.getCid(), null, new ComplianceCodeEnum[]{ComplianceCodeEnum.CODE03, ComplianceCodeEnum.CODE09, ComplianceCodeEnum.CODE15});
                    this.newBusinessDataUpdateRefreshService.addBusinessDataUpdateMsg(member.getCid(), null, new NewComplianceCodeEnum[]{NewComplianceCodeEnum.CODE03, NewComplianceCodeEnum.CODE09, NewComplianceCodeEnum.CODE15});
                    Long cerIds = validCertificate.getId();
                    try {
                        this.memberCertService.relateCert(cid, memberId, String.valueOf(cerIds), cid);
                    }
                    catch (Exception e) {
                        log.error("\u5173\u8054\u8bc1\u4e66\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0: " + e.getMessage() + "\u5931\u8d25\u4f01\u4e1a\u4e3a\uff1a" + cid + "\u8bc1\u4e66\u4e3b\u8868id\u4e3a\uff1a" + memberId);
                    }
                    this.businessDataUpdateRefreshService.addBusinessDataUpdateMsg(cid, null, new ComplianceCodeEnum[]{ComplianceCodeEnum.CODE03, ComplianceCodeEnum.CODE09, ComplianceCodeEnum.CODE15});
                    this.newBusinessDataUpdateRefreshService.addBusinessDataUpdateMsg(cid, null, new NewComplianceCodeEnum[]{NewComplianceCodeEnum.CODE03, NewComplianceCodeEnum.CODE09, NewComplianceCodeEnum.CODE15});
                }
            }
            catch (Exception e) {
                log.error("\u6267\u884c\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\u4e3a: " + e.getMessage());
            }
        }
        XxlJobHelper.handleSuccess((String)("\u8bc1\u4e66\u81ea\u52a8\u5173\u8054\u4efb\u52a1\u6210\u529f\uff0c\u5171\u5904\u7406 " + total + " \u5bb6\u516c\u53f8"));
    }
}

