/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.trusteeship;

import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.health.dao.work.trusteeship.TrusteeshipInfoMapper;
import cn.smarthse.modules.health.dao.work.trusteeship.TrusteeshipServiceOrgInfoMapper;
import cn.smarthse.modules.health.entity.work.trusteeship.TrusteeshipInfo;
import cn.smarthse.modules.health.entity.work.trusteeship.TrusteeshipOrg;
import cn.smarthse.modules.health.entity.work.trusteeship.TrusteeshipServiceOrgInfo;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicService;
import cn.smarthse.modules.health.service.work.trusteeship.ITrusteeshipInfoService;
import cn.smarthse.modules.health.service.work.trusteeship.ITrusteeshipOrgService;
import cn.smarthse.modules.health.service.work.trusteeship.ITrusteeshipServiceOrgInfoService;
import cn.smarthse.modules.health.vo.work.trusteeship.TrusteeshipAllowReasonParam;
import cn.smarthse.modules.health.vo.work.trusteeship.TrusteeshipAppStatisticsVo;
import cn.smarthse.modules.health.vo.work.trusteeship.TrusteeshipOrgParam;
import cn.smarthse.modules.health.vo.work.trusteeship.TrusteeshipServiceOrgModel;
import cn.smarthse.modules.platform.model.AreaModel;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class TrusteeshipServiceOrgInfoServiceImpl
extends BaseServiceImpl<TrusteeshipServiceOrgInfoMapper, TrusteeshipServiceOrgInfo>
implements ITrusteeshipServiceOrgInfoService {
    @Autowired
    private TrusteeshipServiceOrgInfoMapper trusteeshipServiceOrgInfoMapper;
    @Autowired
    private ITrusteeshipOrgService trusteeshipOrgService;
    @Autowired
    private IReformItemBasicService reformItemBasicService;
    @Autowired
    private ITrusteeshipInfoService infoService;
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService areaService;
    @Autowired
    private SqlSessionFactory sqlSessionFactory;

    public TrusteeshipServiceOrgInfo selectOne(Long areaId, Integer year, Integer quarter) {
        TrusteeshipServiceOrgInfo orgInfo = new TrusteeshipServiceOrgInfo();
        orgInfo.setAreaId(areaId);
        orgInfo.setYear(year);
        orgInfo.setQuarter(quarter);
        return (TrusteeshipServiceOrgInfo)((TrusteeshipServiceOrgInfoMapper)this.dao).selectOne(orgInfo);
    }

    public PageInfo<TrusteeshipServiceOrgInfo> selectList(JqGridParam jParam, Long trusteeshipOrgId, Integer year) {
        PageHelper.startPage((int)jParam.getPage(), (int)jParam.getRows());
        List data = Optional.ofNullable(this.trusteeshipServiceOrgInfoMapper.selectAllCompanyByTrusteeshipAndYear(trusteeshipOrgId, year)).orElse(Collections.emptyList());
        return new PageInfo(data);
    }

    @Transactional(readOnly=false)
    public boolean changeStatus(TrusteeshipAllowReasonParam param) {
        if (param.getTrusteeshipOrgId() == null || param.getYear() == null || param.getQuarter() == null) {
            return false;
        }
        List cidList = this.infoService.selectAllNoCompletedCompanyByTrusteeship(param);
        int i = this.infoService.changeStatus(cidList, param.getYear(), param.getQuarter(), (byte)5, param.getReason());
        int j = this.trusteeshipServiceOrgInfoMapper.changeStatus(param.getTrusteeshipOrgId(), param.getYear(), param.getQuarter(), (byte)3);
        return i == cidList.size() && j > 0;
    }

    public List<TrusteeshipServiceOrgModel> queryListByOrgParam(TrusteeshipOrgParam param) {
        List<TrusteeshipServiceOrgModel> orgModel = ((TrusteeshipServiceOrgInfoMapper)this.dao).queryListByOrgParam(param);
        for (TrusteeshipServiceOrgModel model : orgModel) {
            Example example = new Example(TrusteeshipServiceOrgInfo.class);
            example.createCriteria().andEqualTo("trusteeshipOrgId", (Object)model.getTrusteeshipOrgId());
            List orgInfoList = this.getListByExample(example);
            model.setOrgInfoList(orgInfoList);
        }
        return orgModel;
    }

    @Transactional(readOnly=false)
    public PageInfo<TrusteeshipServiceOrgModel> queryListPageByOrgParam(JqGridParam jParam, TrusteeshipOrgParam param) {
        PageHelper.startPage((int)jParam.getPage(), (int)jParam.getRows());
        List orgModel = Optional.ofNullable(((TrusteeshipServiceOrgInfoMapper)this.dao).queryListPageByOrgParam(param)).orElse(Collections.emptyList());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        for (TrusteeshipServiceOrgModel model : orgModel) {
            List<TrusteeshipServiceOrgInfo> orgInfoList = ((TrusteeshipServiceOrgInfoMapper)this.dao).getSumServiceNum(model.getYear(), model.getTrusteeshipOrgId());
            if (model.getUpdateDate() != null) {
                String updateDateStr = simpleDateFormat.format(model.getUpdateDate());
                model.setUpdateDateStr(updateDateStr);
            }
            model.setOrgInfoList(orgInfoList);
        }
        this.updateNumOfCompletedService();
        return new PageInfo(orgModel);
    }

    @Transactional(readOnly=false)
    public void updateNumOfCompletedService() {
        int month = LocalDateTime.now().getMonthValue();
        int year = LocalDateTime.now().getYear();
        int quarter = (month + 2) / 3;
        Example example = new Example(TrusteeshipServiceOrgInfo.class);
        example.createCriteria().andEqualTo("year", (Object)year).andEqualTo("quarter", (Object)quarter);
        List orgInfoList = ((TrusteeshipServiceOrgInfoMapper)this.dao).selectByExample(example);
        for (TrusteeshipServiceOrgInfo orgInfo : orgInfoList) {
            Byte status = 2;
            AreaModel areaById = this.areaService.getAreaById(orgInfo.getAreaId());
            Integer count = this.infoService.getFinishedInfoGroupByAreaId(orgInfo, areaById.getLevel(), status);
            orgInfo.setNumOfCompletedService(count);
            this.update(orgInfo);
        }
    }

    public TrusteeshipServiceOrgInfo selectOneInfoByOrgId(Long orgId, Integer year, Integer quarter) {
        TrusteeshipOrg org = this.trusteeshipOrgService.getByOrgId(orgId, year);
        if (org != null) {
            TrusteeshipServiceOrgInfo orgInfo = new TrusteeshipServiceOrgInfo();
            orgInfo.setTrusteeshipOrgId(org.getId());
            orgInfo.setYear(year);
            orgInfo.setQuarter(quarter);
            List orgs = ((TrusteeshipServiceOrgInfoMapper)this.dao).select(orgInfo);
            if (orgs != null) {
                int numOfService = 0;
                int numOfCompletedService = 0;
                for (TrusteeshipServiceOrgInfo ship : orgs) {
                    if (ship.getNumOfService() != null) {
                        numOfService += ship.getNumOfService().intValue();
                    }
                    if (ship.getNumOfCompletedService() == null) continue;
                    numOfCompletedService += ship.getNumOfCompletedService().intValue();
                }
                orgInfo.setNumOfCompletedService(Integer.valueOf(numOfCompletedService));
                orgInfo.setNumOfService(Integer.valueOf(numOfService));
            }
            return orgInfo;
        }
        return null;
    }

    public List<TrusteeshipAppStatisticsVo> getAnnualStatistics(Long orgId, Integer year) {
        int month = LocalDateTime.now().getMonth().getValue();
        int quarter = (month + 2) / 3;
        List<TrusteeshipAppStatisticsVo> list = ((TrusteeshipServiceOrgInfoMapper)this.dao).getByYearAndQuarterRange(orgId, year, quarter);
        for (TrusteeshipAppStatisticsVo vo : list) {
            Integer findReformNum = this.reformItemBasicService.getFindReformNumByOrg(orgId, vo.getYear(), vo.getQuarter());
            vo.setFindReformNum(findReformNum);
            Integer acceptanceReformNum = this.reformItemBasicService.getAcceptanceReformNumByOrg(orgId, vo.getYear(), vo.getQuarter());
            vo.setAcceptanceReformNum(acceptanceReformNum);
        }
        return list;
    }

    @Transactional(readOnly=false)
    public void endOfQuarterlyStatisticsTask() {
        int month = LocalDateTime.now().getMonthValue();
        int year = LocalDateTime.now().getYear();
        int quarter = (month + 2) / 3;
        Example example = new Example(TrusteeshipServiceOrgInfo.class);
        example.createCriteria().andEqualTo("year", (Object)year).andEqualTo("quarter", (Object)quarter);
        List orgInfoList = Optional.ofNullable(this.getListByExample(example)).orElse(Collections.emptyList());
        for (TrusteeshipServiceOrgInfo orgInfo : orgInfoList) {
            Example e = new Example(TrusteeshipInfo.class);
            e.createCriteria().andEqualTo("year", (Object)orgInfo.getYear()).andEqualTo("quarter", (Object)orgInfo.getQuarter()).andEqualTo("status", (Object)2).andEqualTo("isValid", (Object)Global.TRUE).andEqualTo("trusteeshipOrgId", (Object)orgInfo.getTrusteeshipOrgId());
            List infoList = Optional.ofNullable(this.infoService.getListByExample(e)).orElse(Collections.emptyList());
            if (orgInfo.getNumOfService() > infoList.size()) {
                orgInfo.setStatus(Byte.valueOf((byte)3));
            }
            if (orgInfo.getNumOfService().intValue() == infoList.size()) {
                orgInfo.setStatus(Byte.valueOf((byte)1));
            }
            orgInfo.setExecutionTime(new Date());
            orgInfo.setNumOfCompletedService(Integer.valueOf(infoList.size()));
            this.update(orgInfo);
        }
    }

    @Transactional(readOnly=false)
    public void statusChanges() {
        int month = LocalDateTime.now().getMonthValue();
        int year = LocalDateTime.now().getYear();
        int quarter = (month + 2) / 3;
        Example example = new Example(TrusteeshipServiceOrgInfo.class);
        example.createCriteria().andEqualTo("year", (Object)year).andEqualTo("quarter", (Object)quarter);
        List orgInfoList = Optional.ofNullable(this.getListByExample(example)).orElse(Collections.emptyList());
        for (TrusteeshipServiceOrgInfo orgInfo : orgInfoList) {
            orgInfo.setStatus(Byte.valueOf((byte)2));
            this.update(orgInfo);
        }
        Example ex = new Example(TrusteeshipInfo.class);
        ex.createCriteria().andEqualTo("year", (Object)year).andEqualTo("quarter", (Object)quarter).andEqualTo("isValid", (Object)Global.TRUE);
        List<TrusteeshipInfo> infoList = Optional.ofNullable(this.infoService.getListByExample(ex)).orElse(Collections.emptyList());
        for (TrusteeshipInfo info : infoList) {
            info.setStatus(Byte.valueOf((byte)3));
        }
        this.updateDetailsForInfo(infoList);
    }

    @Transactional(readOnly=false)
    public void updateDetailsForInfo(List<TrusteeshipInfo> list) {
        SqlSession session = this.sqlSessionFactory.openSession(ExecutorType.BATCH, false);
        TrusteeshipInfoMapper mapper = (TrusteeshipInfoMapper)session.getMapper(TrusteeshipInfoMapper.class);
        list.stream().forEach(arg_0 -> ((TrusteeshipInfoMapper)mapper).updateByPrimaryKeySelective(arg_0));
        session.commit();
        session.clearCache();
    }

    public TrusteeshipServiceOrgInfo selectOneInfoByOrgIdAndAreaId(Long trusteeshipOrgId, Long areaId, Integer year, Integer quarter) {
        Example example = new Example(TrusteeshipServiceOrgInfo.class);
        example.createCriteria().andEqualTo("trusteeshipOrgId", (Object)trusteeshipOrgId).andEqualTo("areaId", (Object)areaId).andEqualTo("year", (Object)year).andEqualTo("quarter", (Object)quarter);
        return (TrusteeshipServiceOrgInfo)((TrusteeshipServiceOrgInfoMapper)this.dao).selectOneByExample(example);
    }

    @Transactional(readOnly=false)
    public Integer insertBatch(List<TrusteeshipServiceOrgInfo> list) {
        if (list == null || list.size() == 0) {
            return 0;
        }
        return ((TrusteeshipServiceOrgInfoMapper)this.dao).insertBatch(list);
    }
}

