/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.trusteeship;

import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideBySuperviseService;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.health.dao.work.trusteeship.TrusteeshipInfoMapper;
import cn.smarthse.modules.health.dao.work.trusteeship.TrusteeshipOrgMapper;
import cn.smarthse.modules.health.entity.work.trusteeship.TrusteeshipInfo;
import cn.smarthse.modules.health.entity.work.trusteeship.TrusteeshipInfoDetail;
import cn.smarthse.modules.health.entity.work.trusteeship.TrusteeshipOrg;
import cn.smarthse.modules.health.entity.work.trusteeship.TrusteeshipServiceOrgInfo;
import cn.smarthse.modules.health.service.work.trusteeship.ITrusteeshipInfoDetailService;
import cn.smarthse.modules.health.service.work.trusteeship.ITrusteeshipInfoService;
import cn.smarthse.modules.health.service.work.trusteeship.ITrusteeshipOrgService;
import cn.smarthse.modules.health.service.work.trusteeship.ITrusteeshipServiceOrgInfoService;
import cn.smarthse.modules.health.supervise.service.company.IThirdCompanyService;
import cn.smarthse.modules.health.thirdOrganization.entity.org.ThirdOrganization;
import cn.smarthse.modules.health.thirdOrganization.service.org.IThirdOrganizationService;
import cn.smarthse.modules.health.vo.work.trusteeship.TrusteeshipCompanyVo;
import cn.smarthse.snowflake.IdWorker;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
@DubboService
@Transactional(readOnly=true)
public class TrusteeshipOrgServiceImpl
extends BaseServiceImpl<TrusteeshipOrgMapper, TrusteeshipOrg>
implements ITrusteeshipOrgService {
    @Autowired
    private TrusteeshipInfoMapper trusteeshipInfoMapper;
    @DubboReference(version="1.0.0")
    private ICompanyProvideBySuperviseService companyProvideBySuperviseService;
    @DubboReference
    private IThirdCompanyService companyService;
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService areaService;
    @Autowired
    private ITrusteeshipServiceOrgInfoService orgInfoService;
    @Autowired
    private ITrusteeshipInfoService infoService;
    @Autowired
    private ITrusteeshipInfoDetailService infoDetailService;
    @Autowired
    private TrusteeshipOrgMapper trusteeshipOrgMapper;
    @DubboReference
    private IThirdOrganizationService organizationService;
    @Autowired
    protected IdWorker idworker;

    public PageInfo<TrusteeshipCompanyVo> getCompanyList(JqGridParam jParam, String companyName, String orgName) {
        if (orgName == null) {
            return new PageInfo();
        }
        PageHelper.startPage((int)jParam.getPage(), (int)jParam.getRows());
        List<TrusteeshipCompanyVo> result = this.trusteeshipOrgMapper.getCompanyList(companyName, orgName);
        return new PageInfo(result);
    }

    public PageInfo<TrusteeshipCompanyVo> getLastCompanyList(JqGridParam jParam, String companyName, String orgName) {
        if (orgName == null) {
            return new PageInfo();
        }
        PageHelper.startPage((int)jParam.getPage(), (int)jParam.getRows());
        List<TrusteeshipCompanyVo> result = this.trusteeshipOrgMapper.getLastCompanyList(companyName, orgName);
        return new PageInfo(result);
    }

    public TrusteeshipOrg getByAreaId(Long areaId) {
        if (areaId == null) {
            return null;
        }
        Example example = new Example(TrusteeshipOrg.class);
        example.createCriteria().andEqualTo("isValid", (Object)Global.TRUE);
        List trusteeshipOrgList = ((TrusteeshipOrgMapper)this.dao).selectByExample(example);
        for (TrusteeshipOrg trusteeshipOrg : trusteeshipOrgList) {
            String orgAreaId = trusteeshipOrg.getAreaId();
            if (!orgAreaId.contains(String.valueOf(areaId))) continue;
            return trusteeshipOrg;
        }
        return null;
    }

    public TrusteeshipOrg getTrusteeshipService(Long cid, Byte type) {
        if (cid == null || type == null) {
            return null;
        }
        Example example = new Example(TrusteeshipOrg.class);
        example.createCriteria().andEqualTo("orgId", (Object)cid).andEqualTo("type", (Object)type).andEqualTo("isValid", (Object)Global.TRUE);
        return (TrusteeshipOrg)this.getOneByExample(example);
    }

    public TrusteeshipOrg getByOrgId(Long orgId, Integer year) {
        if (orgId == null) {
            return null;
        }
        Example example = new Example(TrusteeshipOrg.class);
        example.createCriteria().andEqualTo("orgId", (Object)orgId).andEqualTo("year", (Object)year).andEqualTo("isValid", (Object)Global.TRUE);
        return (TrusteeshipOrg)this.getOneByExample(example);
    }

    public TrusteeshipOrg getByOrgId(Long orgId) {
        if (orgId == null) {
            return null;
        }
        Example example = new Example(TrusteeshipOrg.class);
        example.createCriteria().andEqualTo("orgId", (Object)orgId).andEqualTo("isValid", (Object)Global.TRUE);
        return (TrusteeshipOrg)this.getOneByExample(example);
    }

    public TrusteeshipOrg getTrusteeshipIdByTypeAndId(Long orgId, Integer type) {
        if (orgId == null || type == null) {
            return null;
        }
        Example example = new Example(TrusteeshipOrg.class);
        example.createCriteria().andEqualTo("orgId", (Object)orgId).andEqualTo("type", (Object)type).andEqualTo("isValid", (Object)Global.TRUE);
        return (TrusteeshipOrg)this.getOneByExample(example);
    }

    public boolean isTrusteeship(String orgName, Long cid) {
        if (orgName == null || cid == null) {
            return false;
        }
        List<TrusteeshipInfo> list = this.trusteeshipInfoMapper.isTrusteeship(orgName, cid);
        return list.size() > 0;
    }

    @Transactional(readOnly=false, timeout=5000000)
    public void statisticsTask() {
        Example example = new Example(TrusteeshipOrg.class);
        Example.Criteria criteria = example.createCriteria().andEqualTo("isValid", (Object)Global.TRUE);
        List orgList = Optional.ofNullable(this.getListByExample(example)).orElse(Collections.emptyList());
        int month = LocalDateTime.now().getMonthValue();
        int year = LocalDateTime.now().getYear();
        int quarter = (month + 2) / 3;
        for (TrusteeshipOrg trusteeshipOrg : orgList) {
            this.addTrusteeshipMethod(trusteeshipOrg, year, quarter, month);
        }
    }

    @Transactional(readOnly=false, timeout=5000000)
    public void addTrusteeshipMethod(TrusteeshipOrg trusteeshipOrg, int year, int quarter, int month) {
        ArrayList<TrusteeshipOrg> orgList = new ArrayList<TrusteeshipOrg>();
        orgList.add(trusteeshipOrg);
        this.addTrusteeshipServiceOrgInfo(orgList, year, quarter);
        this.addTrusteeshipInfo(orgList, year, quarter);
        if (month == 1 || month == 4 || month == 7 || month == 10) {
            this.orgInfoService.statusChanges();
        }
    }

    public List<TrusteeshipOrg> getAllTrusteeshipOrg() {
        Example example = new Example(TrusteeshipOrg.class);
        example.createCriteria().andEqualTo("isValid", (Object)Global.TRUE);
        return ((TrusteeshipOrgMapper)this.dao).selectByExample(example);
    }

    @Transactional(readOnly=false, timeout=5000000)
    public void createDataForNewTrusteeshipOrg(TrusteeshipOrg org) {
        int month = LocalDateTime.now().getMonthValue();
        int year = LocalDateTime.now().getYear();
        int quarter = (month + 2) / 3;
        ArrayList<TrusteeshipOrg> orgList = new ArrayList<TrusteeshipOrg>();
        orgList.add(org);
        this.addTrusteeshipServiceOrgInfo(orgList, year, quarter);
        this.addTrusteeshipInfo(orgList, year, quarter);
    }

    @Transactional(readOnly=false, timeout=5000000)
    public void addNewTrusteeshipOrg(Long loginUserId, TrusteeshipOrg org) {
        org.setId(null);
        org.setYear(Integer.valueOf(LocalDateTime.now().getYear()));
        org.setStatus(Byte.valueOf((byte)0));
        org.setCreateBy(loginUserId);
        org.setCreateDate(new Date());
        org.setUpdateBy(loginUserId);
        org.setUpdateDate(new Date());
        org.setIsValid(Boolean.valueOf(true));
        TrusteeshipOrg trusteeshipOrg = this.add(org);
        this.createDataForNewTrusteeshipOrg(trusteeshipOrg);
        this.addOrUpdateThirdOrganization(trusteeshipOrg, loginUserId);
    }

    private void addOrUpdateThirdOrganization(TrusteeshipOrg trusteeshipOrg, Long loginUserId) {
        if (trusteeshipOrg.getType() == 1) {
            CompanySuperviseModel companyInfoById = this.companyProvideBySuperviseService.getCompanyInfoById(trusteeshipOrg.getOrgId());
            ThirdOrganization thirdOrganization = new ThirdOrganization();
            thirdOrganization.setId(null);
            thirdOrganization.setName(companyInfoById.getName());
            thirdOrganization.setLegalPerson(companyInfoById.getLegalName());
            thirdOrganization.setLegalPersonPhone(companyInfoById.getLegalTel());
            thirdOrganization.setAreaId(companyInfoById.getAreaId());
            thirdOrganization.setAddress(companyInfoById.getAreaName());
            thirdOrganization.setOrgType(Integer.valueOf(10));
            thirdOrganization.setOrgTypes("10");
            thirdOrganization.setCreateDate(new Date());
            thirdOrganization.setCreateBy(loginUserId);
            thirdOrganization.setUpdateDate(new Date());
            thirdOrganization.setUpdateBy(loginUserId);
            thirdOrganization.setIsValid(Boolean.valueOf(true));
            thirdOrganization.setTrusteeshipCid(companyInfoById.getId());
            this.organizationService.add((Object)thirdOrganization);
        } else {
            ThirdOrganization thirdOrganization = (ThirdOrganization)this.organizationService.getById(trusteeshipOrg.getOrgId());
            thirdOrganization.setOrgType(Integer.valueOf(10));
            String orgTypes = thirdOrganization.getOrgTypes();
            if (StringUtils.isEmpty((CharSequence)orgTypes)) {
                thirdOrganization.setOrgTypes("10");
            } else {
                thirdOrganization.setOrgTypes(orgTypes + ",10");
            }
            thirdOrganization.setTrusteeshipCid(null);
            this.organizationService.update((Object)thirdOrganization);
        }
    }

    @Transactional(readOnly=false, timeout=5000000)
    public void addTrusteeshipServiceOrgInfo(List<TrusteeshipOrg> orgList, Integer year, Integer quarter) {
        ArrayList<TrusteeshipServiceOrgInfo> list = new ArrayList<TrusteeshipServiceOrgInfo>();
        for (TrusteeshipOrg org : orgList) {
            String[] areaIdArr;
            for (String areaIdStr : areaIdArr = org.getAreaId().split(",")) {
                Long areaId = Long.parseLong(areaIdStr);
                Byte level = this.areaService.getAreaById(areaId).getLevel();
                int num = this.companyService.countCompanyNumByAreaId2(areaId, level, null);
                TrusteeshipServiceOrgInfo one = this.orgInfoService.selectOneInfoByOrgIdAndAreaId(org.getId(), areaId, year, quarter);
                if (one == null) {
                    for (int q = quarter.intValue(); q <= 4; ++q) {
                        one = new TrusteeshipServiceOrgInfo();
                        one.setId(Long.valueOf(this.idworker.nextId()));
                        one.setNumOfCompletedService(Integer.valueOf(0));
                        one.setOrgName(org.getOrgName());
                        one.setYear(year);
                        one.setQuarter(Integer.valueOf(q));
                        one.setNumOfService(Integer.valueOf(num));
                        one.setTrusteeshipOrgId(org.getId());
                        one.setAreaId(areaId);
                        one.setStatus(Byte.valueOf((byte)4));
                        one.setExecutionTime(new Date());
                        one.setCreateDate(new Date());
                        list.add(one);
                    }
                    continue;
                }
                one.setExecutionTime(new Date());
                one.setNumOfService(Integer.valueOf(num));
                this.orgInfoService.update((Object)one);
            }
            this.orgInfoService.insertBatch(list);
        }
    }

    @Transactional(readOnly=false, timeout=5000000)
    public void addTrusteeshipInfo(List<TrusteeshipOrg> orgList, int year, int quarter) {
        ArrayList<TrusteeshipInfo> trusteeshipInfos = new ArrayList<TrusteeshipInfo>();
        for (TrusteeshipOrg org : orgList) {
            String[] areaIdArr;
            for (String areaIdStr : areaIdArr = org.getAreaId().split(",")) {
                ArrayList<TrusteeshipInfo> infoList = new ArrayList<TrusteeshipInfo>();
                Long areaId = Long.parseLong(areaIdStr);
                Byte level = this.areaService.getAreaById(areaId).getLevel();
                List<Long> cidList = ((TrusteeshipOrgMapper)this.dao).selectCidsByAreaId(areaId, level);
                for (Long cid : cidList) {
                    TrusteeshipInfo info = this.infoService.getByCidAndYearQuarter(cid, year, quarter);
                    if (info != null) continue;
                    for (int q = quarter; q <= 4; ++q) {
                        info = new TrusteeshipInfo();
                        info.setId(Long.valueOf(this.idworker.nextId()));
                        info.setTrusteeshipOrgId(org.getId());
                        info.setYear(Integer.valueOf(year));
                        info.setQuarter(Integer.valueOf(q));
                        info.setCid(cid);
                        info.setStatus(Byte.valueOf((byte)1));
                        info.setCreateDate(new Date());
                        info.setUpdateDate(new Date());
                        info.setIsValid(Global.TRUE);
                        trusteeshipInfos.add(info);
                        infoList.add(info);
                    }
                }
                this.infoService.insertBatch(infoList);
                infoList.clear();
            }
        }
        this.addTrusteeshipInfoDetail(trusteeshipInfos);
    }

    @Transactional(readOnly=false, timeout=5000000)
    public void addTrusteeshipInfoDetail(List<TrusteeshipInfo> trusteeshipInfos) {
        int num = this.infoDetailService.getItemsTotalNum();
        for (TrusteeshipInfo info : trusteeshipInfos) {
            ArrayList<TrusteeshipInfoDetail> detailList = new ArrayList<TrusteeshipInfoDetail>();
            for (int i = 1; i <= num; ++i) {
                TrusteeshipInfoDetail detail = new TrusteeshipInfoDetail();
                detail.setId(Long.valueOf(this.idworker.nextId()));
                detail.setTrusteeshipInfoId(info.getId());
                detail.setCheckItemId(Long.valueOf(i));
                detail.setResult(Byte.valueOf((byte)0));
                detail.setCreateDate(new Date());
                detail.setUpdateDate(new Date());
                detail.setIsValid(Global.TRUE);
                detailList.add(detail);
            }
            this.infoDetailService.insertBatch(detailList);
        }
    }

    @Transactional(readOnly=false, timeout=5000000)
    public void createTrusteeshipInfosByYearAndQuarter(Integer year, Integer quarter) {
        Example example = new Example(TrusteeshipOrg.class);
        example.createCriteria().andEqualTo("isValid", (Object)Global.TRUE);
        List orgList = this.getListByExample(example);
        for (TrusteeshipOrg trusteeshipOrg : orgList) {
            this.addByYearAndQuarter(trusteeshipOrg, year, quarter);
        }
    }

    @Transactional(readOnly=false, timeout=5000000)
    public void addByYearAndQuarter(TrusteeshipOrg trusteeshipOrg, Integer year, Integer quarter) {
        this.addTrusteeshipServiceOrgInfoByYearAndQuarter(trusteeshipOrg, year, quarter);
        this.addTrusteeshipInfoByYearAndQuarter(trusteeshipOrg, year, quarter);
    }

    @Transactional(readOnly=false, timeout=5000000)
    public void addTrusteeshipInfoByYearAndQuarter(TrusteeshipOrg trusteeshipOrg, Integer year, Integer quarter) {
        String[] areaIdArr;
        ArrayList<TrusteeshipInfo> trusteeshipInfos = new ArrayList<TrusteeshipInfo>();
        for (String areaIdStr : areaIdArr = trusteeshipOrg.getAreaId().split(",")) {
            ArrayList<TrusteeshipInfo> infoList = new ArrayList<TrusteeshipInfo>();
            Long areaId = Long.parseLong(areaIdStr);
            Byte level = this.areaService.getAreaById(areaId).getLevel();
            List<Long> cidList = ((TrusteeshipOrgMapper)this.dao).selectCidsByAreaId(areaId, level);
            for (Long cid : cidList) {
                TrusteeshipInfo info = this.infoService.getByCidAndYearQuarter(cid, year.intValue(), quarter.intValue());
                if (info != null) continue;
                info = new TrusteeshipInfo();
                info.setId(Long.valueOf(this.idworker.nextId()));
                info.setTrusteeshipOrgId(trusteeshipOrg.getId());
                info.setYear(year);
                info.setQuarter(quarter);
                info.setCid(cid);
                info.setStatus(Byte.valueOf((byte)3));
                info.setCreateDate(new Date());
                info.setUpdateDate(new Date());
                info.setIsValid(Global.TRUE);
                trusteeshipInfos.add(info);
                infoList.add(info);
            }
            this.infoService.insertBatch(infoList);
            infoList.clear();
        }
        this.addTrusteeshipInfoDetail(trusteeshipInfos);
    }

    @Transactional(readOnly=false, timeout=5000000)
    public void addTrusteeshipServiceOrgInfoByYearAndQuarter(TrusteeshipOrg trusteeshipOrg, Integer year, Integer quarter) {
        String[] areaIdArr;
        for (String areaIdStr : areaIdArr = trusteeshipOrg.getAreaId().split(",")) {
            Long areaId = Long.parseLong(areaIdStr);
            Byte level = this.areaService.getAreaById(areaId).getLevel();
            int num = this.companyService.countCompanyNumByAreaId2(areaId, level, null);
            TrusteeshipServiceOrgInfo one = this.orgInfoService.selectOneInfoByOrgIdAndAreaId(trusteeshipOrg.getId(), areaId, year, quarter);
            if (one == null) {
                one = new TrusteeshipServiceOrgInfo();
                one.setId(Long.valueOf(this.idworker.nextId()));
                one.setNumOfCompletedService(Integer.valueOf(0));
                one.setOrgName(trusteeshipOrg.getOrgName());
                one.setYear(year);
                one.setQuarter(quarter);
                one.setNumOfService(Integer.valueOf(num));
                one.setTrusteeshipOrgId(trusteeshipOrg.getId());
                one.setAreaId(areaId);
                one.setStatus(Byte.valueOf((byte)3));
                one.setExecutionTime(new Date());
                one.setCreateDate(new Date());
                this.orgInfoService.add((Object)one);
                continue;
            }
            one.setExecutionTime(new Date());
            one.setNumOfService(Integer.valueOf(num));
            this.orgInfoService.update((Object)one);
        }
    }
}

