/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.trusteeship;

import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.dao.work.trusteeship.TrusteeshipInfoMapper;
import cn.smarthse.modules.health.dao.work.trusteeship.TrusteeshipManagerMapper;
import cn.smarthse.modules.health.entity.work.trusteeship.TrusteeshipManager;
import cn.smarthse.modules.health.entity.work.trusteeship.TrusteeshipOrg;
import cn.smarthse.modules.health.entity.work.trusteeship.TrusteeshipServiceOrgInfo;
import cn.smarthse.modules.health.service.work.trusteeship.ITrusteeshipInfoDetailService;
import cn.smarthse.modules.health.service.work.trusteeship.ITrusteeshipManagerService;
import cn.smarthse.modules.health.service.work.trusteeship.ITrusteeshipOrgService;
import cn.smarthse.modules.health.service.work.trusteeship.ITrusteeshipServiceOrgInfoService;
import cn.smarthse.modules.health.vo.work.trusteeship.QuarterDataVo;
import cn.smarthse.modules.health.vo.work.trusteeship.TrusteeshipInfoParam;
import com.github.pagehelper.PageInfo;
import java.time.LocalDateTime;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class TrusteeshipManagerServiceImpl
extends BaseServiceImpl<TrusteeshipManagerMapper, TrusteeshipManager>
implements ITrusteeshipManagerService {
    @Autowired
    TrusteeshipInfoMapper trusteeshipInfoMapper;
    @Autowired
    ITrusteeshipInfoDetailService trusteeshipInfoDetailService;
    @Autowired
    ITrusteeshipOrgService trusteeshipOrgService;
    @Autowired
    ITrusteeshipServiceOrgInfoService orgInfoService;

    @Transactional(readOnly=false)
    public PageInfo<TrusteeshipManager> getManagerData(TrusteeshipInfoParam param, JqGridParam jparam) {
        if (jparam == null) {
            return new PageInfo();
        }
        HashMap<Integer, Map<Integer, QuarterDataVo>> map = new HashMap<Integer, Map<Integer, QuarterDataVo>>();
        Example example = new Example(TrusteeshipServiceOrgInfo.class);
        example.setOrderByClause("year desc");
        example.createCriteria();
        List orgInfoList = this.orgInfoService.getListByExample(example);
        for (TrusteeshipServiceOrgInfo data : orgInfoList) {
            Long orgId;
            QuarterDataVo dataVo;
            HashMap<Integer, QuarterDataVo> quMap = (HashMap<Integer, QuarterDataVo>)map.get(data.getYear());
            if (quMap == null) {
                quMap = new HashMap<Integer, QuarterDataVo>();
                map.put(data.getYear(), quMap);
            }
            if ((dataVo = (QuarterDataVo)quMap.get(data.getQuarter())) == null) {
                dataVo = new QuarterDataVo();
                quMap.put(data.getQuarter(), dataVo);
            }
            if ((orgId = data.getTrusteeshipOrgId()) == null) continue;
            dataVo.getOrgSet().add(orgId);
            if (data.getStatus() == 1) {
                dataVo.getOrgFinishedSet().add(orgId);
            }
            TrusteeshipOrg org = (TrusteeshipOrg)this.trusteeshipOrgService.getById(orgId);
            if (data.getStatus() != 3 && org.getStatus() != 1) continue;
            dataVo.getOrgUnFinishedSet().add(orgId);
        }
        Example e = new Example(TrusteeshipManager.class);
        e.createCriteria().andEqualTo("isValid", (Object)Global.TRUE);
        List trusteeshipManagerList = ((TrusteeshipManagerMapper)this.dao).selectByExample(e);
        List<TrusteeshipManager> modelList = this.encapsulateModel(trusteeshipManagerList, map);
        modelList.sort(new Comparator<TrusteeshipManager>(){

            @Override
            public int compare(TrusteeshipManager o1, TrusteeshipManager o2) {
                return o2.getYear() - o1.getYear();
            }
        });
        return new PageInfo(modelList);
    }

    @Transactional(readOnly=false)
    public void createYearOfTrusteeshipManager() {
        int year = LocalDateTime.now().getYear() + 1;
        Example example = new Example(TrusteeshipManager.class);
        example.createCriteria().andEqualTo("year", (Object)year).andEqualTo("isValid", (Object)Global.TRUE);
        TrusteeshipManager manager = (TrusteeshipManager)this.getOneByExample(example);
        if (manager == null) {
            TrusteeshipManager trusteeshipManager = new TrusteeshipManager();
            trusteeshipManager.setId(null);
            trusteeshipManager.setYear(Integer.valueOf(year));
            trusteeshipManager.setCreateDate(new Date());
            this.add(trusteeshipManager);
        }
    }

    @Transactional(readOnly=false)
    public void createCurrYearOfTrusteeshipManager() {
        int year = LocalDateTime.now().getYear();
        Example example = new Example(TrusteeshipManager.class);
        example.createCriteria().andEqualTo("year", (Object)year).andEqualTo("isValid", (Object)Global.TRUE);
        TrusteeshipManager manager = (TrusteeshipManager)this.getOneByExample(example);
        if (manager == null) {
            TrusteeshipManager trusteeshipManager = new TrusteeshipManager();
            trusteeshipManager.setId(null);
            trusteeshipManager.setYear(Integer.valueOf(year));
            trusteeshipManager.setCreateDate(new Date());
            this.add(trusteeshipManager);
        }
    }

    private List<TrusteeshipManager> encapsulateModel(List<TrusteeshipManager> trusteeshipManagerList, Map<Integer, Map<Integer, QuarterDataVo>> map) {
        for (TrusteeshipManager m : trusteeshipManagerList) {
            Integer year = m.getYear();
            Map<Integer, QuarterDataVo> quMap = map.get(year);
            if (quMap == null) continue;
            QuarterDataVo quarter = quMap.get(1);
            if (quarter == null) {
                quarter = new QuarterDataVo();
            }
            m.setQuarterOneOrg(Integer.valueOf(quarter.getOrgSet().size()));
            m.setQuarterOneFinishedOrg(Integer.valueOf(quarter.getOrgFinishedSet().size()));
            m.setQuarterOneUnfinishedOrg(Integer.valueOf(quarter.getOrgUnFinishedSet().size()));
            quarter = quMap.get(2);
            if (quarter == null) {
                quarter = new QuarterDataVo();
            }
            m.setQuarterTwoOrg(Integer.valueOf(quarter.getOrgSet().size()));
            m.setQuarterTwoFinishedOrg(Integer.valueOf(quarter.getOrgFinishedSet().size()));
            m.setQuarterTwoUnfinishedOrg(Integer.valueOf(quarter.getOrgUnFinishedSet().size()));
            quarter = quMap.get(3);
            if (quarter == null) {
                quarter = new QuarterDataVo();
            }
            m.setQuarterThreeOrg(Integer.valueOf(quarter.getOrgSet().size()));
            m.setQuarterThreeFinishedOrg(Integer.valueOf(quarter.getOrgFinishedSet().size()));
            m.setQuarterThreeUnfinishedOrg(Integer.valueOf(quarter.getOrgUnFinishedSet().size()));
            quarter = quMap.get(4);
            if (quarter == null) {
                quarter = new QuarterDataVo();
            }
            m.setQuarterFourOrg(Integer.valueOf(quarter.getOrgSet().size()));
            m.setQuarterFourFinishedOrg(Integer.valueOf(quarter.getOrgFinishedSet().size()));
            m.setQuarterFourUnfinishedOrg(Integer.valueOf(quarter.getOrgUnFinishedSet().size()));
            ((TrusteeshipManagerMapper)this.dao).updateByPrimaryKey(m);
        }
        return trusteeshipManagerList;
    }
}

