/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.trusteeship;

import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideByHSEService;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideBySuperviseService;
import cn.smarthse.modules.health.dao.work.trusteeship.TrusteeshipInfoMapper;
import cn.smarthse.modules.health.entity.work.reform.ReformItemBasic;
import cn.smarthse.modules.health.entity.work.reform.vo.MobileReformItemListVo;
import cn.smarthse.modules.health.entity.work.trusteeship.TrusteeshipInfo;
import cn.smarthse.modules.health.entity.work.trusteeship.TrusteeshipInfoDetail;
import cn.smarthse.modules.health.entity.work.trusteeship.TrusteeshipOrg;
import cn.smarthse.modules.health.entity.work.trusteeship.TrusteeshipRisk;
import cn.smarthse.modules.health.entity.work.trusteeship.TrusteeshipServiceOrgInfo;
import cn.smarthse.modules.health.enums.trusteeship.RiskWarningTypeEnum;
import cn.smarthse.modules.health.enums.trusteeship.TrusteeshipCommonTypeEnum;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicService;
import cn.smarthse.modules.health.service.work.trusteeship.ITrusteeshipInfoDetailService;
import cn.smarthse.modules.health.service.work.trusteeship.ITrusteeshipInfoService;
import cn.smarthse.modules.health.service.work.trusteeship.ITrusteeshipOrgService;
import cn.smarthse.modules.health.service.work.trusteeship.ITrusteeshipRiskService;
import cn.smarthse.modules.health.service.work.trusteeship.ITrusteeshipServiceOrgInfoService;
import cn.smarthse.modules.health.vo.work.trusteeship.QuarterDataVo;
import cn.smarthse.modules.health.vo.work.trusteeship.RiskWarningParam;
import cn.smarthse.modules.health.vo.work.trusteeship.RiskWarningVo;
import cn.smarthse.modules.health.vo.work.trusteeship.TrusteeshipAllowReasonParam;
import cn.smarthse.modules.health.vo.work.trusteeship.TrusteeshipCheckedVo;
import cn.smarthse.modules.health.vo.work.trusteeship.TrusteeshipInfoParam;
import cn.smarthse.modules.health.vo.work.trusteeship.TrusteeshipInfoQueryVo;
import cn.smarthse.modules.health.vo.work.trusteeship.TrusteeshipInfoThirdVo;
import cn.smarthse.modules.health.vo.work.trusteeship.TrusteeshipInfoVo;
import cn.smarthse.modules.health.vo.work.trusteeship.TrusteeshipManagerModel;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class TrusteeshipInfoServiceImpl
extends BaseServiceImpl<TrusteeshipInfoMapper, TrusteeshipInfo>
implements ITrusteeshipInfoService {
    @Autowired
    TrusteeshipInfoMapper trusteeshipInfoMapper;
    @Autowired
    ITrusteeshipInfoDetailService trusteeshipInfoDetailService;
    @DubboReference(version="1.0.0")
    ICompanyProvideByHSEService companyProvideByHSEService;
    @DubboReference(version="1.0.0")
    ICompanyProvideBySuperviseService companyProvideBySuperviseService;
    @Autowired
    ITrusteeshipOrgService trusteeshipOrgService;
    @Autowired
    ITrusteeshipServiceOrgInfoService orgInfoService;
    @Autowired
    ITrusteeshipRiskService trusteeshipRiskService;
    @Autowired
    IReformItemBasicService reformItemBasicService;

    public PageInfo<TrusteeshipInfoVo> getTrusteeshipList(JqGridParam param, TrusteeshipInfoParam trusteeshipInfoParam) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<TrusteeshipInfoVo> list = this.trusteeshipInfoMapper.getTrusteeshipList(trusteeshipInfoParam);
        if (list != null && list.size() > 0) {
            for (TrusteeshipInfoVo data : list) {
                data.setToReformNum(this.trusteeshipInfoDetailService.getTobeReformNum(data.getId()));
                data.setToAcceptanceNum(this.trusteeshipInfoDetailService.getTobeAcceNum(data.getId()));
            }
        }
        return new PageInfo(list);
    }

    public PageInfo<TrusteeshipInfoVo> getTrusteeshipPagingQuery(JqGridParam param, TrusteeshipInfoParam trusteeshipInfoParam) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<TrusteeshipInfoVo> list = this.trusteeshipInfoMapper.getTrusteeshipList(trusteeshipInfoParam);
        return new PageInfo(list);
    }

    public TrusteeshipInfo getDetailInfoById(Long id) {
        if (id == null) {
            return null;
        }
        TrusteeshipInfo info = (TrusteeshipInfo)this.getById(id);
        if (info != null) {
            String companyName = this.companyProvideByHSEService.getCompanyNameById(info.getCid());
            info.setCompanyName(companyName);
            TrusteeshipOrg trusteeshipOrg = (TrusteeshipOrg)this.trusteeshipOrgService.getById(info.getTrusteeshipOrgId());
            info.setOrgName(trusteeshipOrg.getOrgName());
            List list = this.trusteeshipInfoDetailService.getDetailListByTrusteeshipId(id);
            for (TrusteeshipInfoDetail detail : list) {
                if (detail.getResult() == null) continue;
                switch (detail.getResult()) {
                    case 1: {
                        info.setUnCheckNum(Integer.valueOf(info.getUnCheckNum() + 1));
                        break;
                    }
                    case 3: {
                        info.setUnConformityNum(Integer.valueOf(info.getUnConformityNum() + 1));
                        break;
                    }
                    case 4: {
                        info.setReasonableNum(Integer.valueOf(info.getReasonableNum() + 1));
                        break;
                    }
                }
            }
            Integer toReformNum = this.trusteeshipInfoDetailService.getTobeReformNum(info.getId());
            Integer toAcceptanceNum = this.trusteeshipInfoDetailService.getTobeAcceNum(info.getId());
            info.setToReformNum(toReformNum);
            info.setToAcceptanceNum(toAcceptanceNum);
        }
        return info;
    }

    public TrusteeshipInfoQueryVo getTrusteeshipInfoVoById(Long id) {
        TrusteeshipInfoQueryVo info = ((TrusteeshipInfoMapper)this.dao).selectOneById(id);
        if (info == null) {
            return new TrusteeshipInfoQueryVo();
        }
        List list = this.trusteeshipInfoDetailService.getByInfoId(id);
        for (TrusteeshipInfoDetail detail : list) {
            if (detail.getResult() == null) continue;
            if (detail.getResult() == 1) {
                info.setUncheckedItem(Integer.valueOf(info.getUncheckedItem() + 1));
                continue;
            }
            if (detail.getResult() == 2) {
                info.setConformanceItem(Integer.valueOf(info.getConformanceItem() + 1));
                continue;
            }
            if (detail.getResult() == 3) {
                info.setNonConformanceItem(Integer.valueOf(info.getNonConformanceItem() + 1));
                continue;
            }
            if (detail.getResult() != 4) continue;
            info.setReasonableItem(Integer.valueOf(info.getReasonableItem() + 1));
        }
        Integer toReformNum = this.trusteeshipInfoDetailService.getTobeReformNum(info.getId());
        Integer toAcceptanceNum = this.trusteeshipInfoDetailService.getTobeAcceNum(info.getId());
        info.setRectifiedingItem(toReformNum);
        info.setCheckItem(toAcceptanceNum);
        return info;
    }

    public PageInfo<TrusteeshipManagerModel> getManagerData(TrusteeshipInfoParam param, JqGridParam jparam) {
        if (jparam == null) {
            return new PageInfo();
        }
        HashMap<Integer, Map<Integer, QuarterDataVo>> map = new HashMap<Integer, Map<Integer, QuarterDataVo>>();
        Example example = new Example(TrusteeshipServiceOrgInfo.class);
        example.setOrderByClause("year desc");
        example.createCriteria();
        List orgInfoList = this.orgInfoService.getListByExample(example);
        for (TrusteeshipServiceOrgInfo data : orgInfoList) {
            Long orgId;
            QuarterDataVo dataVo;
            HashMap<Integer, QuarterDataVo> quMap = (HashMap<Integer, QuarterDataVo>)map.get(data.getYear());
            if (quMap == null) {
                quMap = new HashMap<Integer, QuarterDataVo>();
                map.put(data.getYear(), quMap);
            }
            if ((dataVo = (QuarterDataVo)quMap.get(data.getQuarter())) == null) {
                dataVo = new QuarterDataVo();
                quMap.put(data.getQuarter(), dataVo);
            }
            if ((orgId = data.getTrusteeshipOrgId()) == null) continue;
            dataVo.getOrgSet().add(orgId);
            if (data.getStatus() == 1) {
                dataVo.getOrgFinishedSet().add(orgId);
            }
            TrusteeshipOrg org = (TrusteeshipOrg)this.trusteeshipOrgService.getById(orgId);
            if (data.getStatus() != 3 && org.getStatus() != 1) continue;
            dataVo.getOrgUnFinishedSet().add(orgId);
        }
        List<TrusteeshipManagerModel> modelList = this.encapsulateModel(map);
        modelList.sort(new Comparator<TrusteeshipManagerModel>(){

            @Override
            public int compare(TrusteeshipManagerModel o1, TrusteeshipManagerModel o2) {
                return o2.getYear() - o1.getYear();
            }
        });
        return new PageInfo(modelList);
    }

    private List<TrusteeshipManagerModel> encapsulateModel(Map<Integer, Map<Integer, QuarterDataVo>> map) {
        ArrayList<TrusteeshipManagerModel> models = new ArrayList<TrusteeshipManagerModel>();
        for (Map.Entry<Integer, Map<Integer, QuarterDataVo>> entry : map.entrySet()) {
            TrusteeshipManagerModel m = new TrusteeshipManagerModel();
            m.setYear(entry.getKey());
            Map<Integer, QuarterDataVo> quMap = entry.getValue();
            QuarterDataVo quarter = quMap.get(1);
            if (quarter == null) {
                quarter = new QuarterDataVo();
            }
            m.setQuarterOneOrg(Integer.valueOf(quarter.getOrgSet().size()));
            m.setQuarterOneFinishedOrg(Integer.valueOf(quarter.getOrgFinishedSet().size()));
            m.setQuarterOneUnfinishedOrg(Integer.valueOf(quarter.getOrgUnFinishedSet().size()));
            quarter = quMap.get(2);
            if (quarter == null) {
                quarter = new QuarterDataVo();
            }
            m.setQuarterTwoOrg(Integer.valueOf(quarter.getOrgSet().size()));
            m.setQuarterTwoFinishedOrg(Integer.valueOf(quarter.getOrgFinishedSet().size()));
            m.setQuarterTwoUnfinishedOrg(Integer.valueOf(quarter.getOrgUnFinishedSet().size()));
            quarter = quMap.get(3);
            if (quarter == null) {
                quarter = new QuarterDataVo();
            }
            m.setQuarterThreeOrg(Integer.valueOf(quarter.getOrgSet().size()));
            m.setQuarterThreeFinishedOrg(Integer.valueOf(quarter.getOrgFinishedSet().size()));
            m.setQuarterThreeUnfinishedOrg(Integer.valueOf(quarter.getOrgUnFinishedSet().size()));
            quarter = quMap.get(4);
            if (quarter == null) {
                quarter = new QuarterDataVo();
            }
            m.setQuarterFourOrg(Integer.valueOf(quarter.getOrgSet().size()));
            m.setQuarterFourFinishedOrg(Integer.valueOf(quarter.getOrgFinishedSet().size()));
            m.setQuarterFourUnfinishedOrg(Integer.valueOf(quarter.getOrgUnFinishedSet().size()));
            models.add(m);
        }
        return models;
    }

    public List<TrusteeshipCheckedVo> getCheckWorkList(Long cid, Integer tab, Integer year, String orgName) {
        if (cid == null) {
            return Collections.emptyList();
        }
        List<TrusteeshipCheckedVo> result = this.trusteeshipInfoMapper.selectCheckWorkList(cid, tab, year, orgName);
        if (result == null || result.isEmpty()) {
            return Collections.emptyList();
        }
        return result;
    }

    public PageInfo<RiskWarningVo> getWarningList(JqGridParam jParam, RiskWarningParam searchVo) {
        PageHelper.startPage((int)jParam.getPage(), (int)jParam.getRows());
        List data = Optional.ofNullable(this.trusteeshipInfoMapper.getWarningList(searchVo)).orElse(Collections.emptyList());
        return new PageInfo(data);
    }

    @Transactional(readOnly=false, rollbackFor={Exception.class})
    public Boolean updateStatus(Long trusteeshipInfoId, Long cid, Integer riskWarningType, Integer status) {
        if (trusteeshipInfoId == null || status == null || riskWarningType == null) {
            return false;
        }
        if (riskWarningType.equals(RiskWarningTypeEnum.closed.getValue())) {
            if (status.equals(TrusteeshipCommonTypeEnum.confirm.getValue())) {
                TrusteeshipInfo info = new TrusteeshipInfo();
                info.setId(trusteeshipInfoId);
                info.setStatus(Byte.valueOf((byte)2));
                int i = ((TrusteeshipInfoMapper)this.dao).updateByPrimaryKeySelective(info);
                CompanySuperviseModel company = new CompanySuperviseModel();
                company.setBusinessState(Byte.valueOf((byte)0));
                int j = 0;
                int z = this.trusteeshipRiskService.isConfirm(trusteeshipInfoId, TrusteeshipCommonTypeEnum.confirm.getValue());
                return i > 0 && j > 0 && z > 0;
            }
            if (status.equals(TrusteeshipCommonTypeEnum.noConfirm.getValue())) {
                TrusteeshipInfo info = new TrusteeshipInfo();
                info.setId(trusteeshipInfoId);
                info.setStatus(Byte.valueOf((byte)3));
                int i = ((TrusteeshipInfoMapper)this.dao).updateByPrimaryKeySelective(info);
                int z = this.trusteeshipRiskService.isConfirm(trusteeshipInfoId, TrusteeshipCommonTypeEnum.confirm.getValue());
                return i > 0 && z > 0;
            }
        }
        if (riskWarningType.equals(RiskWarningTypeEnum.suspensionOfBusiness.getValue())) {
            if (status.equals(TrusteeshipCommonTypeEnum.confirm.getValue())) {
                TrusteeshipInfo info = new TrusteeshipInfo();
                info.setId(trusteeshipInfoId);
                info.setStatus(Byte.valueOf((byte)2));
                int i = ((TrusteeshipInfoMapper)this.dao).updateByPrimaryKeySelective(info);
                CompanySuperviseModel company = new CompanySuperviseModel();
                company.setBusinessState(Byte.valueOf((byte)2));
                int j = 0;
                int z = this.trusteeshipRiskService.isConfirm(trusteeshipInfoId, TrusteeshipCommonTypeEnum.confirm.getValue());
                return i > 0 && j > 0 && z > 0;
            }
            if (status.equals(TrusteeshipCommonTypeEnum.noSuspend.getValue())) {
                TrusteeshipInfo info = new TrusteeshipInfo();
                info.setId(trusteeshipInfoId);
                info.setStatus(Byte.valueOf((byte)3));
                int i = ((TrusteeshipInfoMapper)this.dao).updateByPrimaryKeySelective(info);
                int z = this.trusteeshipRiskService.isConfirm(trusteeshipInfoId, TrusteeshipCommonTypeEnum.confirm.getValue());
                return i > 0 && z > 0;
            }
        }
        return false;
    }

    public List<TrusteeshipInfoThirdVo> getTrusteeshipInfoVoListById(Long realCid, Long cid, int i, Integer year) {
        if (realCid == null || cid == null || year == null || i == 0) {
            return Collections.emptyList();
        }
        TrusteeshipOrg trusteeshipOrg = this.trusteeshipOrgService.getTrusteeshipIdByTypeAndId(cid, Integer.valueOf(i));
        String orgName = trusteeshipOrg.getOrgName();
        Example example = new Example(TrusteeshipInfo.class);
        example.createCriteria().andEqualTo("cid", (Object)realCid).andEqualTo("trusteeshipOrgId", (Object)trusteeshipOrg.getId()).andEqualTo("year", (Object)year).andEqualTo("isValid", (Object)Global.TRUE);
        List TrusteeshipInfoList = ((TrusteeshipInfoMapper)this.dao).selectByExample(example);
        if (CollectionUtils.isEmpty((Collection)TrusteeshipInfoList)) {
            return Collections.emptyList();
        }
        ArrayList<TrusteeshipInfoThirdVo> result = new ArrayList<TrusteeshipInfoThirdVo>(TrusteeshipInfoList.size());
        for (TrusteeshipInfo trusteeshipInfo : TrusteeshipInfoList) {
            List byInfoId = this.trusteeshipInfoDetailService.getByInfoId(trusteeshipInfo.getId());
            TrusteeshipInfoThirdVo vo = new TrusteeshipInfoThirdVo();
            BeanUtils.copyProperties((Object)trusteeshipInfo, (Object)vo);
            vo.setOrgName(orgName);
            for (TrusteeshipInfoDetail trusteeshipInfoDetail : byInfoId) {
                if (trusteeshipInfoDetail.getResult() == null) continue;
                if (trusteeshipInfoDetail.getResult() == 1) {
                    vo.setUncheckedItem(Integer.valueOf(vo.getUncheckedItem() + 1));
                } else if (trusteeshipInfoDetail.getResult() == 2) {
                    vo.setConformanceItem(Integer.valueOf(vo.getConformanceItem() + 1));
                } else if (trusteeshipInfoDetail.getResult() == 3) {
                    vo.setNonConformanceItem(Integer.valueOf(vo.getNonConformanceItem() + 1));
                } else if (trusteeshipInfoDetail.getResult() == 4) {
                    vo.setReasonableItem(Integer.valueOf(vo.getReasonableItem() + 1));
                }
                Integer toReformNum = this.trusteeshipInfoDetailService.getTobeReformNum(vo.getId());
                Integer toAcceptanceNum = this.trusteeshipInfoDetailService.getTobeAcceNum(vo.getId());
                vo.setRectifiedingItem(toReformNum);
                vo.setCheckItem(toAcceptanceNum);
            }
            result.add(vo);
        }
        return result.stream().sorted(Comparator.comparing(TrusteeshipInfo::getQuarter)).collect(Collectors.toList());
    }

    public Integer getRecordingNumByOrg(Long orgId, Integer year, Integer quarter) {
        TrusteeshipOrg org = this.trusteeshipOrgService.getByOrgId(orgId, year);
        if (org != null) {
            Example example = new Example(TrusteeshipInfo.class);
            example.createCriteria().andEqualTo("trusteeshipOrgId", (Object)org.getId()).andEqualTo("year", (Object)year).andEqualTo("quarter", (Object)quarter).andEqualTo("isValid", (Object)Global.TRUE).andBetween("status", (Object)4, (Object)5);
            return ((TrusteeshipInfoMapper)this.dao).selectCountByExample(example);
        }
        return 0;
    }

    public TrusteeshipInfo getByCidAndYearQuarter(Long cid, int year, int quarter) {
        Example example = new Example(TrusteeshipInfo.class);
        example.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("year", (Object)year).andEqualTo("quarter", (Object)quarter);
        return (TrusteeshipInfo)this.getOneByExample(example);
    }

    public List<Long> selectAllNoCompletedCompanyByTrusteeship(TrusteeshipAllowReasonParam param) {
        Example example = new Example(TrusteeshipInfo.class);
        example.createCriteria().andEqualTo("trusteeshipOrgId", (Object)param.getTrusteeshipOrgId()).andEqualTo("year", (Object)param.getYear()).andEqualTo("quarter", (Object)param.getQuarter()).andEqualTo("isValid", (Object)Global.TRUE);
        List list = ((TrusteeshipInfoMapper)this.dao).selectByExample(example);
        List<Long> idList = list.stream().filter(i -> i.getStatus() != 2).map(TrusteeshipInfo::getCid).collect(Collectors.toList());
        return idList;
    }

    @Transactional(readOnly=false)
    public int changeStatus(List<Long> cidList, Integer year, Integer quarter, byte b, String reason) {
        return ((TrusteeshipInfoMapper)this.dao).changeStatus(cidList, year, quarter, b, reason);
    }

    @Transactional(readOnly=false)
    public Integer insertBatch(List<TrusteeshipInfo> list) {
        if (list == null || list.size() == 0) {
            return 0;
        }
        return ((TrusteeshipInfoMapper)this.dao).insertBatch(list);
    }

    @Transactional(readOnly=false)
    public void updateBatchToStatusChanges(List<TrusteeshipInfo> infoList, Integer infoStatus) {
        if (infoList == null || infoStatus == null) {
            return;
        }
        ((TrusteeshipInfoMapper)this.dao).updateBatchToStatusChanges(infoList, infoStatus);
    }

    @Transactional(readOnly=false)
    public void deleteReformInfoByTrusteeshipInfoId(Long trusteeshipInfoId) {
        if (trusteeshipInfoId != null) {
            ((TrusteeshipInfoMapper)this.dao).deleteReformInfoByTrusteeshipInfoId(trusteeshipInfoId);
        }
    }

    public Integer getFinishedInfoGroupByAreaId(TrusteeshipServiceOrgInfo orgInfo, Byte areaLevel, Byte status) {
        if (orgInfo == null) {
            return 0;
        }
        return ((TrusteeshipInfoMapper)this.dao).getFinishedInfoGroupByAreaId(orgInfo, areaLevel, status);
    }

    @Transactional(readOnly=false)
    public void updateForChangeTrusteeshipOrg(TrusteeshipOrg trusteeshipOrgAfter, TrusteeshipOrg trusteeshipOrgBefore, Long cid, Long loginStaffId, Long afterAreaId, Long beforeAreaId) {
        int month = LocalDateTime.now().getMonthValue();
        int year = LocalDateTime.now().getYear();
        int quarter = (month + 2) / 3;
        if (trusteeshipOrgBefore == null) {
            return;
        }
        if (trusteeshipOrgAfter == null) {
            TrusteeshipInfo info = this.logicDeleteTrusteeshipInfoAndDetail(cid, year, quarter, loginStaffId);
            this.initTrusteeshipRisk(info, loginStaffId);
            this.initReformItemBasic(info, loginStaffId);
            this.updateTrusteeshipServiceOrgInfo(trusteeshipOrgBefore.getId(), 0, 1, year, quarter, beforeAreaId);
            return;
        }
        if (trusteeshipOrgBefore.getId().equals(trusteeshipOrgAfter.getId())) {
            this.updateTrusteeshipServiceOrgInfo(trusteeshipOrgBefore.getId(), 0, 1, year, quarter, beforeAreaId);
            this.updateTrusteeshipServiceOrgInfo(trusteeshipOrgAfter.getId(), 1, 0, year, quarter, afterAreaId);
        } else {
            Long trusteeshipOrgId = trusteeshipOrgAfter.getId();
            TrusteeshipInfo info = this.changeTrusteeshipInfo(trusteeshipOrgId, cid, loginStaffId);
            if (info == null) {
                return;
            }
            this.initTrusteeshipInfoDetail(info, loginStaffId);
            this.initTrusteeshipRisk(info, loginStaffId);
            this.initReformItemBasic(info, loginStaffId);
            this.updateTrusteeshipServiceOrgInfo(trusteeshipOrgBefore.getId(), 0, 1, year, quarter, beforeAreaId);
            this.updateTrusteeshipServiceOrgInfo(trusteeshipOrgAfter.getId(), 1, 0, year, quarter, afterAreaId);
        }
    }

    private void updateTrusteeshipServiceOrgInfo(Long trusteeshipOrgId, int addNum, int subNum, int year, int quarter, Long areaId) {
        Example example = new Example(TrusteeshipServiceOrgInfo.class);
        example.createCriteria().andEqualTo("trusteeshipOrgId", (Object)trusteeshipOrgId).andEqualTo("year", (Object)year).andGreaterThanOrEqualTo("quarter", (Object)quarter).andEqualTo("areaId", (Object)areaId);
        List orgInfoList = this.orgInfoService.getListByExample(example);
        for (TrusteeshipServiceOrgInfo orgInfo : orgInfoList) {
            Integer numOfService = orgInfo.getNumOfService() + addNum - subNum;
            orgInfo.setNumOfService(numOfService);
            this.orgInfoService.update((Object)orgInfo);
        }
    }

    private TrusteeshipInfo logicDeleteTrusteeshipInfoAndDetail(Long cid, int year, int quarter, Long loginStaffId) {
        TrusteeshipInfo trusteeshipInfo = new TrusteeshipInfo();
        Example example = new Example(TrusteeshipInfo.class);
        example.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("year", (Object)year).andGreaterThanOrEqualTo("quarter", (Object)quarter).andEqualTo("isValid", (Object)Global.TRUE);
        List infoList = ((TrusteeshipInfoMapper)this.dao).selectByExample(example);
        for (TrusteeshipInfo info : infoList) {
            List infoDetailList = this.trusteeshipInfoDetailService.getDetailListByTrusteeshipId(info.getId());
            this.trusteeshipInfoDetailService.logicDelete(infoDetailList, loginStaffId);
            info.setIsValid(Global.FALSE);
            info.setUpdateDate(new Date());
            info.setUpdateBy(loginStaffId);
            ((TrusteeshipInfoMapper)this.dao).updateByPrimaryKey(info);
            if (info.getQuarter() != quarter) continue;
            trusteeshipInfo = info;
        }
        return trusteeshipInfo;
    }

    private TrusteeshipInfo changeTrusteeshipInfo(Long trusteeshipOrgId, Long cid, Long loginStaffId) {
        TrusteeshipInfo trusteeshipInfo = new TrusteeshipInfo();
        int month = LocalDateTime.now().getMonthValue();
        int year = LocalDateTime.now().getYear();
        int quarter = (month + 2) / 3;
        Example example = new Example(TrusteeshipInfo.class);
        example.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("year", (Object)year).andGreaterThanOrEqualTo("quarter", (Object)quarter).andEqualTo("isValid", (Object)Global.TRUE);
        List infoList = ((TrusteeshipInfoMapper)this.dao).selectByExample(example);
        if (infoList == null) {
            return null;
        }
        for (int i = infoList.size() - 1; i >= 0; --i) {
            TrusteeshipInfo info = (TrusteeshipInfo)infoList.get(i);
            info.setTrusteeshipOrgId(trusteeshipOrgId);
            if (info.getQuarter() == quarter && info.getStatus() != 2) {
                info.setCheckPerson(null);
                info.setDescription(null);
                info.setCheckTime(null);
                info.setResult(null);
                info.setContacts(null);
                info.setTelephone(null);
                info.setFileStr(null);
                info.setUpdateDate(new Date());
                info.setUpdateBy(loginStaffId);
                trusteeshipInfo = info;
            }
            ((TrusteeshipInfoMapper)this.dao).updateByPrimaryKey(info);
        }
        return trusteeshipInfo;
    }

    private void initTrusteeshipInfoDetail(TrusteeshipInfo info, Long loginStaffId) {
        if (info == null || info.getId() == null) {
            return;
        }
        Example example = new Example(TrusteeshipInfoDetail.class);
        example.createCriteria().andEqualTo("trusteeshipInfoId", (Object)info.getId()).andEqualTo("isValid", (Object)Global.TRUE);
        List infoDetailList = this.trusteeshipInfoDetailService.getListByExample(example);
        infoDetailList.stream().forEach(detail -> {
            detail.setResult(Byte.valueOf((byte)0));
            detail.setDescription(null);
            detail.setUpdateDate(new Date());
            detail.setUpdateBy(loginStaffId);
            this.trusteeshipInfoDetailService.update(detail);
        });
    }

    private void initTrusteeshipRisk(TrusteeshipInfo info, Long loginStaffId) {
        if (info == null || info.getId() == null) {
            return;
        }
        Example example = new Example(TrusteeshipRisk.class);
        example.createCriteria().andEqualTo("trusteeshipInfoId", (Object)info.getId()).andEqualTo("isValid", (Object)Global.TRUE);
        List riskList = this.trusteeshipRiskService.getListByExample(example);
        riskList.stream().forEach(risk -> {
            risk.setIsValid(Global.FALSE);
            risk.setUpdateDate(new Date());
            risk.setUpdateBy(loginStaffId);
            this.trusteeshipRiskService.update(risk);
        });
    }

    private void initReformItemBasic(TrusteeshipInfo info, Long loginStaffId) {
        List reformList = this.reformItemBasicService.getReformListByTrusteeshipId(info.getId());
        for (MobileReformItemListVo vo : reformList) {
            ReformItemBasic reformItemBasic = (ReformItemBasic)this.reformItemBasicService.getById(vo.getId());
            reformItemBasic.setIsValid(Boolean.valueOf(false));
            this.reformItemBasicService.updateByPrimaryKey((Object)reformItemBasic, loginStaffId);
        }
    }
}

