/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.trusteeship;

import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.dao.work.trusteeship.TrusteeshipInfoDetailMapper;
import cn.smarthse.modules.health.entity.work.trusteeship.TrusteeshipInfoDetail;
import cn.smarthse.modules.health.service.work.trusteeship.ITrusteeshipInfoDetailService;
import cn.smarthse.modules.health.service.work.trusteeship.ITrusteeshipInfoService;
import cn.smarthse.modules.health.vo.work.trusteeship.TrusteeshipInfoDetailQueryVo;
import cn.smarthse.modules.health.vo.work.trusteeship.TrusteeshipInfoDetailView;
import cn.smarthse.modules.health.vo.work.trusteeship.TrusteeshipInfoQueryVo;
import cn.smarthse.snowflake.IdWorker;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboService;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class TrusteeshipInfoDetailServiceImpl
extends BaseServiceImpl<TrusteeshipInfoDetailMapper, TrusteeshipInfoDetail>
implements ITrusteeshipInfoDetailService {
    @Autowired
    private ITrusteeshipInfoService infoService;
    @Autowired
    private TrusteeshipInfoDetailMapper mapper;
    @Autowired
    private SqlSessionFactory sqlSessionFactory;
    @Autowired
    protected IdWorker idworker;

    public List<TrusteeshipInfoDetail> getDetailListByTrusteeshipId(Long trusteeshipId) {
        List<TrusteeshipInfoDetail> list = ((TrusteeshipInfoDetailMapper)this.dao).selectByTrusteeshipId(trusteeshipId);
        return list;
    }

    public Integer getUnregisteredNum(Long trusteeshipId) {
        return ((TrusteeshipInfoDetailMapper)this.dao).getUnregisteredNum(trusteeshipId);
    }

    public Integer getReformDraftNum(Long trusteeshipId) {
        return ((TrusteeshipInfoDetailMapper)this.dao).getReformDraftNum(trusteeshipId);
    }

    public List<TrusteeshipInfoDetail> getByInfoId(Long id) {
        Example e = new Example(TrusteeshipInfoDetail.class);
        Example.Criteria c = e.createCriteria();
        c.andEqualTo("trusteeshipInfoId", (Object)id).andEqualTo("isValid", (Object)Global.TRUE);
        return this.getListByExample(e);
    }

    public TrusteeshipInfoDetailQueryVo getDetailQueryVoByInfoId(Long id) {
        TrusteeshipInfoDetailQueryVo detailVo = new TrusteeshipInfoDetailQueryVo();
        TrusteeshipInfoQueryVo vo = this.infoService.getTrusteeshipInfoVoById(id);
        BeanUtils.copyProperties((Object)vo, (Object)detailVo);
        List<TrusteeshipInfoDetailView> viewList = ((TrusteeshipInfoDetailMapper)this.dao).getDetailViewByInfoId(id);
        for (TrusteeshipInfoDetailView view : viewList) {
            if (view.getResult() == null) continue;
            if (view.getResult() == 1) {
                detailVo.getUncheckedItemList().add(view);
                continue;
            }
            if (view.getResult() == 3) {
                detailVo.getNonConformanceItemList().add(view);
                continue;
            }
            if (view.getResult() != 4) continue;
            detailVo.getReasonableItemList().add(view);
        }
        detailVo.setDetailList(viewList);
        return detailVo;
    }

    public Integer getTobeReformNum(Long trusteeshipId) {
        return ((TrusteeshipInfoDetailMapper)this.dao).getTobeReformNum(trusteeshipId);
    }

    public Integer getTobeAcceNum(Long trusteeshipId) {
        return ((TrusteeshipInfoDetailMapper)this.dao).getTobeAcceNum(trusteeshipId);
    }

    @Transactional(readOnly=false)
    public Integer insertBatch(List<TrusteeshipInfoDetail> list) {
        if (list == null || list.size() == 0) {
            return 0;
        }
        return ((TrusteeshipInfoDetailMapper)this.dao).insertBatch(list);
    }

    @Transactional(readOnly=false)
    public void deleteReformInfoByDetailId(Long detailId) {
        ((TrusteeshipInfoDetailMapper)this.dao).deleteReformInfoByDetailId(detailId);
    }

    public int getItemsTotalNum() {
        return ((TrusteeshipInfoDetailMapper)this.dao).getItemsTotalNum();
    }

    @Transactional(readOnly=false)
    public void addDetailsForInfo(Long itemNo) {
        List<Long> infoIds = ((TrusteeshipInfoDetailMapper)this.dao).getAllInfoIdExcludeItemNo(itemNo);
        ArrayList<TrusteeshipInfoDetail> infoDetailList = new ArrayList<TrusteeshipInfoDetail>();
        for (Long id : infoIds) {
            TrusteeshipInfoDetail detail = new TrusteeshipInfoDetail();
            detail.setId(Long.valueOf(this.idworker.nextId()));
            detail.setTrusteeshipInfoId(id);
            detail.setCheckItemId(itemNo);
            detail.setResult(Byte.valueOf((byte)0));
            detail.setCreateDate(new Date());
            detail.setUpdateDate(new Date());
            detail.setIsValid(Boolean.valueOf(true));
            infoDetailList.add(detail);
        }
        this.addDetailsForInfo(infoDetailList);
    }

    @Transactional(readOnly=false)
    public void addDetailsForInfo(List<TrusteeshipInfoDetail> list) {
        SqlSession session = this.sqlSessionFactory.openSession(ExecutorType.BATCH, false);
        for (int i = 0; i < list.size(); ++i) {
            this.mapper.insertSelective(list.get(i));
            if (i % 1000 != 0 && list.size() >= 1000) continue;
            session.commit();
            session.clearCache();
        }
        session.commit();
        session.clearCache();
    }

    public void logicDelete(List<TrusteeshipInfoDetail> infoDetailList, Long loginStaffId) {
        if (infoDetailList == null) {
            return;
        }
        for (TrusteeshipInfoDetail infoDetail : infoDetailList) {
            infoDetail.setUpdateBy(loginStaffId);
            infoDetail.setUpdateDate(new Date());
            infoDetail.setIsValid(Global.FALSE);
            ((TrusteeshipInfoDetailMapper)this.dao).updateByPrimaryKey(infoDetail);
        }
    }
}

