/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.train;

import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.framework.service.datascope.DataScopeHelper;
import cn.smarthse.modules.health.dao.work.train.TrainSummarizeMapper;
import cn.smarthse.modules.health.entity.work.train.TrainPaperFile;
import cn.smarthse.modules.health.entity.work.train.TrainSummarize;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.work.train.ITrainPaperFileService;
import cn.smarthse.modules.health.service.work.train.ITrainSummarizeService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@DubboService
@Transactional(readOnly=true)
public class TrainSummarizeServiceImpl
extends BaseServiceImpl<TrainSummarizeMapper, TrainSummarize>
implements ITrainSummarizeService {
    @Autowired
    TrainSummarizeMapper trainSummarizeMapper;
    @Autowired
    ITrainPaperFileService trainPaperFileService;
    @Autowired
    IStaffInfoService staffInfoService;

    public PageInfo<TrainSummarize> getFinishedList(JqGridParam param) {
        if (param == null) {
            return new PageInfo();
        }
        if (param.getCid() == null || param.getCid() == 0L) {
            return new PageInfo();
        }
        TrainSummarize info = new TrainSummarize();
        info.setCid(param.getCid());
        info.setIsFinish(Boolean.valueOf(true));
        info.setIsValid(Boolean.valueOf(true));
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        DataScopeHelper.startDataScope("trainPlan", "train_summarize");
        List<TrainSummarize> list = this.trainSummarizeMapper.getFinishedList(info);
        for (TrainSummarize tr : list) {
            tr.setCreateName(this.staffInfoService.getStaffNameIncludeDelStatusByStaffId(tr.getCreateBy()));
        }
        return new PageInfo(list);
    }

    public PageInfo<TrainSummarize> getUnFinishedList(JqGridParam param) {
        if (param == null) {
            return new PageInfo();
        }
        if (param.getCid() == null || param.getCid() == 0L) {
            return new PageInfo();
        }
        TrainSummarize info = new TrainSummarize();
        info.setCid(param.getCid());
        info.setIsFinish(Boolean.valueOf(false));
        info.setIsValid(Boolean.valueOf(true));
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        DataScopeHelper.startDataScope("trainPlan", "train_summarize");
        List<TrainSummarize> list = this.trainSummarizeMapper.getListByExample(info);
        for (TrainSummarize tr : list) {
            tr.setCreateName(this.staffInfoService.getStaffNameIncludeDelStatusByStaffId(tr.getCreateBy()));
        }
        return new PageInfo(list);
    }

    public List<TrainSummarize> getFinishedByCid(Long cid) {
        TrainSummarize info = new TrainSummarize();
        info.setCid(cid);
        info.setIsFinish(Boolean.valueOf(true));
        info.setIsValid(Boolean.valueOf(true));
        DataScopeHelper.startDataScope("trainPlan", "train_summarize");
        List<TrainSummarize> list = this.trainSummarizeMapper.getListByExample(info);
        for (TrainSummarize tr : list) {
            tr.setCreateName(this.staffInfoService.getStaffNameIncludeDelStatusByStaffId(tr.getCreateBy()));
        }
        return list;
    }

    @Transactional(readOnly=false)
    public TrainSummarize updateAndFile(TrainSummarize info, Long staffid) {
        List fileList = info.getFileList();
        this.update(info, staffid);
        TrainPaperFile entity = new TrainPaperFile();
        entity.setTrainSummaryId(info.getId());
        this.trainPaperFileService.delete((Object)entity);
        if (fileList != null && fileList.size() != 0) {
            for (TrainPaperFile file : fileList) {
                file.setTrainSummaryId(info.getId());
                this.trainPaperFileService.add((Object)file, staffid, info.getCid());
            }
        }
        return info;
    }

    @Transactional(readOnly=false)
    public TrainSummarize addAndFile(TrainSummarize info, Long staffid, Long cid) {
        List fileList = info.getFileList();
        TrainSummarize ts = this.add(info, staffid, cid);
        if (fileList != null && fileList.size() != 0) {
            for (TrainPaperFile file : fileList) {
                file.setTrainSummaryId(ts.getId());
                this.trainPaperFileService.add((Object)file, staffid, cid);
            }
        }
        return info;
    }

    public TrainSummarize getByIdWithFile(Long id) {
        TrainSummarize info = (TrainSummarize)this.getById(id);
        List paperList = this.trainPaperFileService.getBySummarizeId(id);
        info.setFileList(paperList);
        return info;
    }

    public int getUnFinishedNum(Long cid) {
        int num = 0;
        TrainSummarize info = new TrainSummarize();
        info.setCid(cid);
        info.setIsFinish(Boolean.valueOf(false));
        List<TrainSummarize> list = this.trainSummarizeMapper.getListByExample(info);
        if (list != null) {
            num = list.size();
        }
        return num;
    }

    public int getFinishedNum(Long cid) {
        int num = 0;
        TrainSummarize info = new TrainSummarize();
        info.setCid(cid);
        info.setIsFinish(Boolean.valueOf(true));
        List<TrainSummarize> list = this.trainSummarizeMapper.getListByExample(info);
        if (list != null) {
            num = list.size();
        }
        return num;
    }

    public Boolean haveTrainThisYear(Long cid, Integer year) {
        if (cid == null || year == null) {
            return Global.FALSE;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("year", year);
        params.put("cid", cid);
        List<TrainSummarize> list = this.trainSummarizeMapper.listOfTrainByYear(params);
        if (list != null && list.size() != 0) {
            return Global.TRUE;
        }
        return Global.FALSE;
    }

    public TrainSummarize getEarliestTrain(Long cid, Integer year) {
        if (cid == null || year == null) {
            return null;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("year", year);
        params.put("cid", cid);
        List<TrainSummarize> list = this.trainSummarizeMapper.listOfTrainByYear(params);
        if (list != null && list.size() != 0) {
            return list.get(0);
        }
        return null;
    }

    public Boolean haveTrainSummarize(Long cid, Integer yea) {
        if (this.haveTrainThisYear(cid, yea).booleanValue()) {
            return Global.FALSE;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
        Date date = new Date();
        String formatDate = sdf.format(date);
        Integer year = Integer.parseInt(formatDate);
        if (this.haveTrainThisYear(cid, year - 1).booleanValue()) {
            TrainSummarize plan = this.getEarliestTrain(cid, year - 1);
            Date time = plan.getUpdateDate();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(time);
            calendar.add(1, 1);
            calendar.add(2, -1);
            calendar.add(5, -1);
            Date date1 = calendar.getTime();
            if (date.after(date1)) {
                return Global.TRUE;
            }
            return Global.FALSE;
        }
        Date date2 = null;
        String dateStr = formatDate + "-10-1";
        String[] dateDivide = dateStr.split("-");
        if (dateDivide.length == 3) {
            int year1 = Integer.parseInt(dateDivide[0].trim());
            int month = Integer.parseInt(dateDivide[1].trim());
            int day = Integer.parseInt(dateDivide[2].trim());
            Calendar c = Calendar.getInstance();
            c.set(year1, month - 1, day);
            date2 = c.getTime();
        }
        if (date.after(date2)) {
            return Global.TRUE;
        }
        return Global.FALSE;
    }
}

