/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.train;

import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.enums.BusinessNoTypeEnum;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.framework.service.datascope.DataScopeHelper;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.common.model.PageParamModel;
import cn.smarthse.modules.datacentre.model.CompanyBaseInfoModel;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideByHSEService;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideBySuperviseService;
import cn.smarthse.modules.health.component.event.HomeDataEvent;
import cn.smarthse.modules.health.dao.work.train.TrainAttendMapper;
import cn.smarthse.modules.health.dao.work.train.TrainPlanMapper;
import cn.smarthse.modules.health.entity.base.staff.StaffBasicInfo;
import cn.smarthse.modules.health.entity.base.staff.StaffInfo;
import cn.smarthse.modules.health.entity.base.staff.StaffWorkRole;
import cn.smarthse.modules.health.entity.base.staff.vo.StaffBasicVo;
import cn.smarthse.modules.health.entity.datascope.DataScope;
import cn.smarthse.modules.health.entity.work.certificate.CertificateStaff;
import cn.smarthse.modules.health.entity.work.planyear.vo.PlanYearSyncSO;
import cn.smarthse.modules.health.entity.work.train.Month;
import cn.smarthse.modules.health.entity.work.train.QueryTrainParam;
import cn.smarthse.modules.health.entity.work.train.StaffOnlineTrainTest;
import cn.smarthse.modules.health.entity.work.train.StaffTrainInfo;
import cn.smarthse.modules.health.entity.work.train.TrainAttend;
import cn.smarthse.modules.health.entity.work.train.TrainBook;
import cn.smarthse.modules.health.entity.work.train.TrainExam;
import cn.smarthse.modules.health.entity.work.train.TrainPaperFile;
import cn.smarthse.modules.health.entity.work.train.TrainPlan;
import cn.smarthse.modules.health.entity.work.train.TrainPlanSummary;
import cn.smarthse.modules.health.enums.certificate.CertificateStaffNameTypeEnum;
import cn.smarthse.modules.health.enums.homedata.HomeDataEventEnum;
import cn.smarthse.modules.health.enums.sys.StatusEnum;
import cn.smarthse.modules.health.enums.sys.coreWork.CoreWorkEnum;
import cn.smarthse.modules.health.enums.sys.coreWork.TodlistInfoTypeEnum;
import cn.smarthse.modules.health.enums.train.TrainPlanTypeEnum;
import cn.smarthse.modules.health.model.HTrainingDetailModel;
import cn.smarthse.modules.health.model.HTrainingModel;
import cn.smarthse.modules.health.service.base.IBusinessNoService;
import cn.smarthse.modules.health.service.base.staff.IStaffBasicInfoService;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.base.staff.IStaffWorkRoleService;
import cn.smarthse.modules.health.service.out.IZjTrainService;
import cn.smarthse.modules.health.service.sys.ISysCoreWorkModuleCorrelationService;
import cn.smarthse.modules.health.service.work.certificate.ICertificateStaffDetailService;
import cn.smarthse.modules.health.service.work.train.IStaffOnlineTrainTestService;
import cn.smarthse.modules.health.service.work.train.ITrainAttendService;
import cn.smarthse.modules.health.service.work.train.ITrainBookService;
import cn.smarthse.modules.health.service.work.train.ITrainExamService;
import cn.smarthse.modules.health.service.work.train.ITrainPaperFileService;
import cn.smarthse.modules.health.service.work.train.ITrainPlanExamRecordService;
import cn.smarthse.modules.health.service.work.train.ITrainPlanService;
import cn.smarthse.modules.health.service.work.train.ITrainSummarizeService;
import cn.smarthse.modules.health.supervise.entity.basic.Organization;
import cn.smarthse.modules.health.supervise.service.basic.IOrganizationService;
import cn.smarthse.modules.health.supervise.service.healthpoints.IHealthTalentPointsService;
import cn.smarthse.modules.health.vo.summary.BaseSummaryVO;
import cn.smarthse.modules.health.vo.summary.TrainPlanSummaryVo;
import cn.smarthse.modules.health.vo.work.judge.TrainEducationInfo;
import cn.smarthse.modules.health.vo.work.train.OutTrainInfoVo;
import cn.smarthse.modules.health.vo.work.train.TrainPlanCountView;
import cn.smarthse.modules.health.vo.work.train.TrainWorkItemVo;
import cn.smarthse.modules.training.model.HealthTalentPointsModel;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.lang.invoke.CallSite;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Service
@Transactional(readOnly=true)
public class TrainPlanServiceImpl
extends BaseServiceImpl<TrainPlanMapper, TrainPlan>
implements ITrainPlanService {
    @Autowired
    TrainPlanMapper trainPlanMapper;
    @Autowired
    TrainAttendMapper trainAttendMapper;
    @Autowired
    ITrainAttendService trainAttendService;
    @Autowired
    ITrainBookService trainBookService;
    @Autowired
    ITrainExamService trainExamService;
    @Autowired
    ITrainPaperFileService trainPaperFileService;
    @Autowired
    IStaffInfoService staffInfoService;
    @Autowired
    IStaffBasicInfoService staffBasicInfoService;
    @Autowired
    ITrainSummarizeService trainSummarizeService;
    @Autowired
    ISysCoreWorkModuleCorrelationService sysCoreWorkModuleCorrelationService;
    @Autowired
    IBusinessNoService businessNoService;
    @Autowired
    IStaffWorkRoleService staffWorkRoleService;
    @Autowired
    IStaffOnlineTrainTestService staffOnlineTrainTestService;
    @DubboReference(version="1.0.0")
    ICompanyProvideByHSEService companyProvideByHSEService;
    @Autowired
    IZjTrainService zjTrainService;
    @Autowired
    ICertificateStaffDetailService certificateStaffDetailService;
    @DubboReference
    IHealthTalentPointsService healthTalentPointsService;
    @Autowired
    ITrainPlanExamRecordService trainPlanExamRecordService;
    @DubboReference(version="1.0.0")
    private ICompanyProvideBySuperviseService companyProvideBySuperviseService;
    @DubboReference
    private IOrganizationService organizationService;
    @Autowired
    ApplicationContext ac;
    @Value(value="${isActualize}")
    private String isActualize;
    @Value(value="${isSharingSystem}")
    private String isSharingSystem;

    @Transactional(readOnly=false)
    public TrainPlan updateAllInfo(TrainPlan info, Long staffid) {
        this.ac.publishEvent((ApplicationEvent)new HomeDataEvent(info.getCid(), HomeDataEventEnum.EDU_TRAINING));
        this.setVideoIds(info);
        this.update(info, staffid);
        Long cid = info.getCid();
        this.addTrainAttends(info.getAttends(), info.getId(), staffid, cid);
        if ("true".equals(this.isActualize)) {
            this.addTrainBook(info.getTrainBooks(), info.getId(), staffid, cid);
            this.addTrainExam(info.getTrainExams(), info.getId(), staffid, cid);
            this.addPaperFiles(info.getScoreFiles(), info.getId(), staffid, cid, (byte)2);
            this.addPaperFiles(info.getMedioFiles(), info.getId(), staffid, cid, (byte)3);
            this.addPaperFiles(info.getOtherFiles(), info.getId(), staffid, cid, (byte)5);
            this.trainAttendService.andUnTrainAttendInfo(info.getId());
        }
        this.trainAttendService.andUnTrainAttendInfo(info.getId());
        this.addPaperFiles(info.getSignFiles(), info.getId(), staffid, cid, (byte)1);
        if (info.getFromType() != null && info.getIsFinish().booleanValue()) {
            this.doCompleteCoreWork(info, staffid, cid);
        }
        if ("true".equals(this.isSharingSystem)) {
            // empty if block
        }
        return info;
    }

    @Transactional(readOnly=false)
    public TrainPlan addAllInfo(TrainPlan info, Long staffid, Long cid) {
        this.ac.publishEvent((ApplicationEvent)new HomeDataEvent(cid, HomeDataEventEnum.EDU_TRAINING));
        this.setVideoIds(info);
        this.add(info, staffid, cid);
        this.addTrainAttends(info.getAttends(), info.getId(), staffid, cid);
        if ("true".equals(this.isActualize)) {
            this.addTrainBook(info.getTrainBooks(), info.getId(), staffid, cid);
            this.addTrainExam(info.getTrainExams(), info.getId(), staffid, cid);
            this.addPaperFiles(info.getScoreFiles(), info.getId(), staffid, cid, (byte)2);
            this.addPaperFiles(info.getMedioFiles(), info.getId(), staffid, cid, (byte)3);
            this.addPaperFiles(info.getOtherFiles(), info.getId(), staffid, cid, (byte)5);
            this.trainAttendService.andUnTrainAttendInfo(info.getId());
        }
        this.addPaperFiles(info.getSignFiles(), info.getId(), staffid, cid, (byte)1);
        if (info.getFromType() != null) {
            this.doStartCoreWork(info, staffid, cid);
            if (info.getIsFinish().booleanValue()) {
                this.doCompleteCoreWork(info, staffid, cid);
            }
        }
        if (!("true".equals(this.isSharingSystem) && info.getIsFinish().booleanValue() && info.getOnlineTrain() != null && info.getOnlineTrain().booleanValue() && info.getTrainMaterialsIds() == null)) {
            // empty if block
        }
        return info;
    }

    private void setVideoIds(TrainPlan info) {
        if (info.getVideos() != null) {
            List videos = info.getVideos();
            StringBuilder videoIds = null;
            for (TrainBook vi : videos) {
                if (videoIds == null) {
                    videoIds = new StringBuilder(vi.getId().toString());
                    continue;
                }
                videoIds.append(",").append(vi.getId().toString());
            }
            assert (videoIds != null);
            info.setTrainMaterialsIds(videoIds.toString());
        }
    }

    @Transactional(readOnly=false)
    public void addPaperFiles(List<TrainPaperFile> files, Long id, Long staffid, Long cid, Byte type) {
        TrainPaperFile entity = new TrainPaperFile();
        entity.setTrainId(id);
        entity.setType(type);
        this.trainPaperFileService.delete((Object)entity);
        if (files != null && files.size() != 0) {
            for (TrainPaperFile file : files) {
                file.setTrainId(id);
                file.setType(type);
                this.trainPaperFileService.add((Object)file, staffid, cid);
            }
        }
    }

    @Transactional(readOnly=false)
    public void addTrainExam(List<TrainExam> exams, Long id, Long staffid, Long cid) {
        TrainExam entity = new TrainExam();
        entity.setTrainId(id);
        this.trainExamService.delete((Object)entity);
        if (exams != null && exams.size() != 0) {
            for (TrainExam exam : exams) {
                if (exam.getExamId() == null) continue;
                exam.setTrainId(id);
                this.trainExamService.add((Object)exam, staffid, cid);
            }
        }
    }

    @Transactional(readOnly=false)
    public void addTrainBook(List<TrainBook> books, Long id, Long staffid, Long cid) {
        TrainBook entity = new TrainBook();
        entity.setTrainId(id);
        this.trainBookService.delete((Object)entity);
        if (books != null && books.size() != 0) {
            for (TrainBook book : books) {
                if (book.getBookId() == null) continue;
                book.setTrainId(id);
                this.trainBookService.add((Object)book, staffid, cid);
            }
        }
    }

    @Transactional(readOnly=false)
    public void addTrainAttends(List<TrainAttend> attends, Long trainId, Long staffid, Long cid) {
        TrainAttend entity = new TrainAttend();
        entity.setTrainId(trainId);
        this.trainAttendService.delete((Object)entity);
        if (attends != null && attends.size() != 0) {
            for (TrainAttend attend : attends) {
                if (attend.getStaffId() == null) continue;
                attend.setTrainId(trainId);
                StaffInfo staff = this.staffInfoService.getStaffInfoWorkAndDeptById(attend.getStaffId());
                if (staff != null) {
                    if (staff.getStaffBasicWork() != null) {
                        attend.setDeptId(staff.getStaffBasicWork().getOrgId());
                        if (staff.getStaffBasicWork().getCompanyOrganization() != null) {
                            attend.setDeptName(staff.getStaffBasicWork().getCompanyOrganization().getOrganizationName());
                        }
                    }
                    if (staff.getStaffWorkRole() != null && staff.getStaffWorkRole().getWorkRoleInfo() != null) {
                        attend.setWorkroleId(staff.getStaffWorkRole().getWorkRoleInfo().getId());
                        attend.setWorkroleName(staff.getStaffWorkRole().getWorkRoleInfo().getWorkName());
                    }
                }
                this.trainAttendService.add((Object)attend, staffid, cid);
            }
        }
    }

    public TrainPlan getByIdWithAllInfo(Long id) {
        CompanySuperviseModel company;
        TrainPlan info = (TrainPlan)this.getById(id);
        ArrayList<TrainAttend> attends = this.trainAttendService.getByTid(id);
        List signFiles = this.trainPaperFileService.getByTidAndType(id, Byte.valueOf((byte)1));
        if ("true".equals(this.isActualize)) {
            List trainBooks = this.trainBookService.getByTid(id);
            List trainExams = this.trainExamService.getByTid(id);
            List books = this.trainPaperFileService.getByTidAndType(id, Byte.valueOf((byte)6));
            List exams = this.trainPaperFileService.getByTidAndType(id, Byte.valueOf((byte)7));
            List scoreFiles = this.trainPaperFileService.getByTidAndType(id, Byte.valueOf((byte)2));
            List medioFiles = this.trainPaperFileService.getByTidAndType(id, Byte.valueOf((byte)3));
            List otherFiles = this.trainPaperFileService.getByTidAndType(id, Byte.valueOf((byte)5));
            info.setTrainBooks(trainBooks);
            info.setTrainExams(trainExams);
            info.setScoreFiles(scoreFiles);
            info.setMedioFiles(medioFiles);
            info.setOtherFiles(otherFiles);
            info.setExams(exams);
            info.setBooks(books);
        }
        if ("true".equals(this.isSharingSystem)) {
            // empty if block
        }
        if (info.getReportId() != null && info.getTeacherDept() == null && (company = this.companyProvideBySuperviseService.getCompanyInfoById(info.getCid())) != null) {
            Organization org;
            if (company.getSupervisionUnit() != null) {
                org = (Organization)this.organizationService.getById(company.getSupervisionUnit());
                info.setOrganizeDept(org.getName());
            } else if (company.getBelongType() != null && company.getBelongType() > 0) {
                if (company.getBelongType() == 1) {
                    org = this.organizationService.getOrganizationByAreaId(company.getProvinceId());
                    if (org != null) {
                        info.setOrganizeDept(org.getName());
                    }
                } else {
                    org = this.organizationService.getOrganizationByAreaId(company.getCityId());
                    if (org != null) {
                        info.setOrganizeDept(org.getName());
                    }
                }
            } else if (company.getAreaId() != null && (org = this.organizationService.getOrganizationByAreaId(company.getAreaId())) != null) {
                info.setOrganizeDept(org.getName());
            }
        }
        if (info.getDataSource() != null && info.getDataSource() == 2 && StringUtils.isNotEmpty((String)info.getTrainAttend())) {
            String[] attendStrs = info.getTrainAttend().split(",");
            attends = new ArrayList<TrainAttend>();
            for (String attendStr : attendStrs) {
                StaffBasicVo vo;
                if (!StringUtils.isNumber((String)attendStr) || (vo = this.staffInfoService.getStaffBasicVoFromOrgById(Long.valueOf(Long.parseLong(attendStr)))) == null) continue;
                TrainAttend attend = new TrainAttend();
                attend.setStaffName(vo.getStaffName());
                attends.add(attend);
            }
        }
        if (info.getCoordinationDept() != null) {
            List depts = StringUtils.parseToLongList((String)info.getCoordinationDept(), (String)",");
            info.setCoordDeptIds(depts);
        }
        info.setSignFiles(signFiles);
        info.setAttends((List)attends);
        return info;
    }

    public PageInfo<TrainPlan> getUnFinishedList(JqGridParam param, String hsType, Integer year) {
        if (param == null) {
            return new PageInfo();
        }
        if (param.getCid() == null || param.getCid() == 0L) {
            return new PageInfo();
        }
        TrainPlan info = new TrainPlan();
        info.setCid(param.getCid());
        info.setIsFinish(Boolean.valueOf(false));
        info.setIsValid(Boolean.valueOf(true));
        if (hsType != null && !hsType.equals("")) {
            info.setHsType(hsType);
        }
        info.setYear(year);
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        DataScopeHelper.startDataScope("trainPlan", "train_plan");
        List<TrainPlan> list = this.trainPlanMapper.getListByExample(info);
        for (TrainPlan tp : list) {
            if (tp.getCreateBy() == null) continue;
            tp.setCreateName(this.staffInfoService.getStaffNameIncludeDelStatusByStaffId(tp.getCreateBy()));
        }
        return new PageInfo(list);
    }

    public PageInfo<TrainPlan> getFinishedList(JqGridParam param, TrainPlan info) {
        if (param == null) {
            return new PageInfo();
        }
        if (info.getCid() == null || info.getCid() == 0L) {
            return new PageInfo();
        }
        info.setIsFinish(Boolean.valueOf(true));
        info.setIsValid(Boolean.valueOf(true));
        if (info.getTrainTypes() != null) {
            ArrayList<CallSite> trainTypes = new ArrayList<CallSite>();
            for (String type : info.getTrainTypes()) {
                trainTypes.add((CallSite)((Object)("," + type + ",")));
            }
            info.setTrainTypes(trainTypes);
        }
        if (info.getHsType() == null) {
            info.setHsType(info.getWayDesc());
        }
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        DataScopeHelper.startDataScope("trainPlan", "train_plan");
        List<TrainPlan> list = this.trainPlanMapper.getListByExampleWithVoid(info);
        if ("true".equals(this.isSharingSystem)) {
            List attendVos = this.staffOnlineTrainTestService.getNeedAttends(info.getCid());
            HashMap attendVoMap = new HashMap();
            attendVos.forEach(s -> attendVoMap.put(s.getTrainId(), s.getAttends()));
        }
        for (TrainPlan tp : list) {
            if (tp.getCreateBy() != null) {
                tp.setCreateName(this.staffInfoService.getStaffNameIncludeDelStatusByStaffId(tp.getCreateBy()));
            }
            tp.setTypeName(this.getTypeName(tp.getType()));
            tp.setStatusName("\u5df2\u5b8c\u6210");
            if ("true".equals(this.isSharingSystem) && tp.getOnlineTrain() != null && !tp.getOnlineTrain().booleanValue()) continue;
        }
        return new PageInfo(list);
    }

    public List<TrainPlan> getFinishedListNoPage(TrainPlan info) {
        info.setIsFinish(Boolean.valueOf(true));
        info.setIsValid(Boolean.valueOf(true));
        DataScopeHelper.startDataScope("trainPlan", "train_plan");
        List<TrainPlan> list = this.trainPlanMapper.getListByExampleWithVoid(info);
        if (CollectionUtils.isNotEmpty(list)) {
            list.forEach(i -> {
                i.setHsTypeName(i.getHsType());
                i.setWayAndOnLine(i.getWay(), i.getOnLine());
                if (i.getCreateBy() != null) {
                    i.setCreateName(this.staffInfoService.getStaffNameIncludeDelStatusByStaffId(i.getCreateBy()));
                }
                List attends = this.trainAttendService.getByTid(i.getId());
                StringBuilder attendNames = new StringBuilder();
                if (attends != null && attends.size() > 0) {
                    for (int j = 0; j < attends.size(); ++j) {
                        String staffName = this.staffInfoService.getStaffNameAndWorkNoAndIncludeDelStatusByStaffId(((TrainAttend)attends.get(j)).getStaffId());
                        if (staffName != null && !staffName.equals("")) {
                            attendNames.append(staffName);
                        }
                        if (j >= attends.size() - 1) continue;
                        attendNames.append("\u3001");
                    }
                    i.setAttendNames(attendNames.toString());
                }
            });
            return list;
        }
        return new ArrayList<TrainPlan>();
    }

    public int getUnFinishedNum(Long cid) {
        int num = 0;
        TrainPlan info = new TrainPlan();
        info.setCid(cid);
        info.setIsFinish(Boolean.valueOf(false));
        DataScopeHelper.startDataScope("trainPlan", "train_plan");
        List<TrainPlan> list = this.trainPlanMapper.getListByExample(info);
        if (list != null) {
            num = list.size();
        }
        return num;
    }

    public int getFinishedNum(Long cid) {
        int num = 0;
        TrainPlan info = new TrainPlan();
        info.setCid(cid);
        info.setIsFinish(Boolean.valueOf(true));
        DataScopeHelper.startDataScope("trainPlan", "train_plan");
        List<TrainPlan> list = this.trainPlanMapper.getListByExample(info);
        if (list != null) {
            num = list.size();
        }
        return num;
    }

    public Boolean haveTrainThisYear(Long cid, Integer year) {
        if (cid == null || year == null) {
            return Global.FALSE;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("year", year);
        params.put("cid", cid);
        List<TrainPlan> list = this.trainPlanMapper.listOfTrainByYear(params);
        if (list != null && list.size() != 0) {
            return Global.TRUE;
        }
        return Global.FALSE;
    }

    public Boolean haveOccTrainThisYear(Long cid, Integer year) {
        if (cid == null || year == null) {
            return Global.FALSE;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("year", year);
        params.put("cid", cid);
        params.put("type", 1);
        List<TrainPlan> list = this.trainPlanMapper.listOfOccTrainPlanByYear(params);
        if (list != null && list.size() != 0) {
            return Global.TRUE;
        }
        return Global.FALSE;
    }

    public TrainPlan getEarliestTrain(Long cid, Integer year) {
        if (cid == null || year == null) {
            return null;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("year", year);
        params.put("cid", cid);
        List<TrainPlan> list = this.trainPlanMapper.listOfTrainByYear(params);
        if (list != null && list.size() != 0) {
            return list.get(0);
        }
        return null;
    }

    public Boolean haveTrain(Long cid, Integer yea) {
        if (this.haveTrainThisYear(cid, yea).booleanValue()) {
            return Global.FALSE;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
        Date date = new Date();
        String formatDate = sdf.format(date);
        Integer year = Integer.parseInt(formatDate);
        if (this.haveTrainThisYear(cid, year - 1).booleanValue()) {
            TrainPlan plan = this.getEarliestTrain(cid, year - 1);
            Date time = plan.getRegisterTime();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(time);
            calendar.add(1, 1);
            calendar.add(2, -1);
            calendar.add(5, -1);
            Date date1 = calendar.getTime();
            if (date.after(date1)) {
                return Global.TRUE;
            }
            return Global.FALSE;
        }
        Date date2 = null;
        String dateStr = formatDate + "-10-1";
        String[] dateDivide = dateStr.split("-");
        if (dateDivide.length == 3) {
            int year1 = Integer.parseInt(dateDivide[0].trim());
            int month = Integer.parseInt(dateDivide[1].trim());
            int day = Integer.parseInt(dateDivide[2].trim());
            Calendar c = Calendar.getInstance();
            c.set(year1, month - 1, day);
            date2 = c.getTime();
        }
        if (date.after(date2)) {
            return Global.TRUE;
        }
        return Global.FALSE;
    }

    private String getTypeName(String type) {
        Object typeName = null;
        if (!StringUtils.isEmpty((CharSequence)type)) {
            List types = new ArrayList();
            types = StringUtils.parseToIntegerList((String)type, (String)",");
            Iterator iterator = types.iterator();
            while (iterator.hasNext()) {
                int t = (Integer)iterator.next();
                for (TrainPlanTypeEnum tpType : TrainPlanTypeEnum.values()) {
                    if ((byte)t != tpType.getCode()) continue;
                    typeName = typeName == null ? tpType.getName() : (String)typeName + "," + tpType.getName();
                }
            }
            return typeName;
        }
        return null;
    }

    public PageInfo<StaffTrainInfo> getStaffTrainInfo(JqGridParam gparam, QueryTrainParam param) {
        if (param == null || gparam == null) {
            return new PageInfo();
        }
        if (param.getCid() == null || param.getStaffid() == null) {
            return new PageInfo();
        }
        param.setIsFinish(Boolean.valueOf(true));
        param.setIsValid(Boolean.valueOf(true));
        PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows());
        List list = this.trainAttendService.getStaffTrainInfo(param);
        for (StaffTrainInfo tp : list) {
            List tests;
            tp.setTypeName(this.getTypeName(tp.getType()));
            StaffWorkRole workRole = this.staffWorkRoleService.getStaffWorkRoleHistoryByStaffIdAndTime(param.getStaffid(), tp.getTrainTime(), null);
            if (workRole != null) {
                tp.setStaffWorkroleName(workRole.getWorkRoleInfo().getWorkName());
            }
            if ((tests = this.staffOnlineTrainTestService.getLastTestByStaffId(tp.getTid(), tp.getStaffId(), param.getCid())).size() <= 0) continue;
            tp.setPassScore(((StaffOnlineTrainTest)tests.get(0)).getPassScore());
            tp.setTestScore(Long.valueOf(0L));
            tests.forEach(s -> {
                if (s.getIsRight() != null && s.getIsRight().booleanValue()) {
                    tp.setTestScore(Long.valueOf(tp.getTestScore() + s.getQuestionScore()));
                }
            });
        }
        return new PageInfo(list);
    }

    @Transactional
    public TrainWorkItemVo getTrainToDoVoInfo(Long cid) {
        Integer tipNum = 0;
        TrainWorkItemVo vo = new TrainWorkItemVo();
        vo.setIsDisplayTrainFile(Boolean.valueOf(true));
        DataScopeHelper.startDataScope("trainPlan", "train_plan");
        DataScope dataScope = DataScopeHelper.getDataScope();
        Integer numOfUnFinishedTrainPlan = this.getUnFinishedNum(cid);
        DataScopeHelper.setDataScope(dataScope);
        Integer numOfFinishedTrainPlan = this.getFinishedNum(cid);
        vo.setNumOfUnFinishedTrainPlan(numOfUnFinishedTrainPlan);
        dataScope.setMainTableName("train_summarize");
        DataScopeHelper.setDataScope(dataScope);
        Integer numOfUnFinishedTrainSumm = this.trainSummarizeService.getUnFinishedNum(cid);
        vo.setNumOfUnFinishedTrainSumm(numOfUnFinishedTrainSumm);
        DataScopeHelper.setDataScope(dataScope);
        Integer numOfFinishedTrainSumm = this.trainSummarizeService.getFinishedNum(cid);
        int num = numOfUnFinishedTrainPlan + numOfUnFinishedTrainSumm + numOfFinishedTrainSumm + numOfFinishedTrainPlan;
        if (num == 0) {
            vo.setIsDislayAdd(Boolean.valueOf(true));
        }
        Calendar cal = Calendar.getInstance();
        int year = cal.get(1);
        Boolean haveTrainPlanThisYear = this.haveOccTrainThisYear(cid, year);
        vo.setHaveTrainPlanThisYear(haveTrainPlanThisYear);
        if (!haveTrainPlanThisYear.booleanValue()) {
            Boolean isIgnore = this.sysCoreWorkModuleCorrelationService.hasIgnoreData(TodlistInfoTypeEnum.trainPlan_thisYearOcc, cid, year);
            if (isIgnore.booleanValue()) {
                vo.setHaveTrainPlanThisYear(Boolean.valueOf(true));
            } else {
                tipNum = tipNum + 1;
            }
        }
        Boolean haveTrainSummThisYear = this.trainSummarizeService.haveTrainSummarize(cid, Integer.valueOf(year));
        vo.setHaveTrainSummThisYear(haveTrainSummThisYear);
        if (haveTrainSummThisYear.booleanValue()) {
            Boolean isIgnore = this.sysCoreWorkModuleCorrelationService.hasIgnoreData(TodlistInfoTypeEnum.trainPlan_thisYear, cid, year);
            if (isIgnore.booleanValue()) {
                vo.setHaveTrainSummThisYear(Boolean.valueOf(false));
            } else {
                tipNum = tipNum + 1;
            }
        }
        List sysList = this.sysCoreWorkModuleCorrelationService.getListToRemind(CoreWorkEnum.accidentManement, CoreWorkEnum.trainPlan, cid);
        int accNum = 0;
        if (sysList != null && sysList.size() > 0) {
            accNum = sysList.size();
            tipNum = tipNum + 1;
        }
        vo.setAccidentCount(Integer.valueOf(accNum));
        List list = this.sysCoreWorkModuleCorrelationService.getListToRemind(CoreWorkEnum.threeSimultaneityManagement, CoreWorkEnum.trainPlan, cid);
        vo.setThirdTimeList(list);
        if (list != null && list.size() > 0) {
            tipNum = tipNum + list.size();
        }
        List appearOrgTrainPlanList = this.sysCoreWorkModuleCorrelationService.getListToRemind(CoreWorkEnum.trainPlan, CoreWorkEnum.trainPlan, cid);
        vo.setAppearOrgTrainPlanList(appearOrgTrainPlanList);
        if (appearOrgTrainPlanList != null && appearOrgTrainPlanList.size() > 0) {
            tipNum = tipNum + appearOrgTrainPlanList.size();
        }
        vo.setTipNum(tipNum);
        return vo;
    }

    @Transactional(readOnly=false)
    public void doStartCoreWork(TrainPlan data, Long staffid, Long cid) {
        if (data.getFromType() != null) {
            if (data.getFromType().equals(CoreWorkEnum.threeSimultaneityManagement.getValue())) {
                this.sysCoreWorkModuleCorrelationService.businessStart(CoreWorkEnum.trainPlan, CoreWorkEnum.threeSimultaneityManagement, data.getId(), staffid, cid, new Long[]{data.getFromId()});
            } else if (data.getFromType().equals(CoreWorkEnum.accidentManement.getValue())) {
                this.sysCoreWorkModuleCorrelationService.businessStart(CoreWorkEnum.trainPlan, CoreWorkEnum.accidentManement, data.getId(), staffid, cid, new Long[]{data.getFromId()});
            }
        }
    }

    @Transactional(readOnly=false)
    public void doCompleteCoreWork(TrainPlan data, Long staffid, Long cid) {
        if (data.getFromType() != null) {
            if (data.getFromType().equals(CoreWorkEnum.threeSimultaneityManagement.getValue())) {
                this.sysCoreWorkModuleCorrelationService.businessComplete(CoreWorkEnum.trainPlan, CoreWorkEnum.threeSimultaneityManagement, data.getId(), staffid, cid, new Long[]{data.getFromId()});
            } else if (data.getFromType().equals(CoreWorkEnum.accidentManement.getValue())) {
                this.sysCoreWorkModuleCorrelationService.businessComplete(CoreWorkEnum.trainPlan, CoreWorkEnum.accidentManement, data.getId(), staffid, cid, new Long[]{data.getFromId()});
            }
        }
    }

    @Transactional(readOnly=false)
    public void logicDelete(TrainPlan info, Long staffid) {
        this.update(info, staffid);
        if (!info.getIsValid().booleanValue() && info.getFromType() != null) {
            this.sysCoreWorkModuleCorrelationService.businessDelete(CoreWorkEnum.trainPlan, info.getId(), staffid, info.getCid());
        }
    }

    public BaseSummaryVO getSummaryData(Long cid, String year) {
        TrainPlanSummaryVo vo = new TrainPlanSummaryVo();
        Integer unFinishedNum = 0;
        Integer finishedNum = 0;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("year", year);
        params.put("cid", cid);
        List<TrainPlan> trainList = this.trainPlanMapper.getTrainByYear(params);
        if (trainList != null && trainList.size() > 0) {
            for (TrainPlan train : trainList) {
                if (train.getIsFinish() != null && train.getIsFinish().booleanValue()) {
                    if (!StringUtils.isNotEmpty((String)train.getHsType()) || !train.getHsType().contains("1")) continue;
                    finishedNum = finishedNum + 1;
                    continue;
                }
                if (!StringUtils.isNotEmpty((String)train.getHsType()) || !train.getHsType().contains("1")) continue;
                unFinishedNum = unFinishedNum + 1;
            }
        }
        vo.setFinishedNum(finishedNum);
        vo.setUnFinishedNum(unFinishedNum);
        return vo;
    }

    public String addString(String str) {
        if (str == null) {
            str = "";
        }
        int len = StringUtils.getStringLength((String)str);
        StringBuffer sb = new StringBuffer();
        sb.append(str);
        if (len <= 20) {
            for (int i = len; i <= 20; ++i) {
                sb.append("_");
            }
        }
        return sb.toString();
    }

    @Transactional(readOnly=false)
    public Long syncAddPlanYearByBL(PlanYearSyncSO detail) {
        if (detail == null) {
            return null;
        }
        TrainPlan train = new TrainPlan();
        train.setName(detail.getBusinessName());
        train.setNo(this.businessNoService.getBusinessNo(detail.getCid(), BusinessNoTypeEnum.TRAINPLAN.getCode()));
        train.setRegisterTime(detail.getBusinessPlantime());
        train.setTeacher(detail.getManagerId());
        train.setIsFinish(Boolean.valueOf(false));
        train.setType("," + detail.getWorkSubtype() + ",");
        train.setOrgId("" + detail.getOrgId());
        this.add(train, detail.getCreatorBy(), detail.getCid());
        this.sysCoreWorkModuleCorrelationService.businessStartPlan(CoreWorkEnum.trainPlan, train.getId(), detail.getTipCreateBy(), detail.getCid(), detail.getBusinessName(), detail.getDetailId());
        return train.getId();
    }

    public TrainPlanSummary getTrainSumm(Long cid, String year) {
        TrainPlanSummary summ = new TrainPlanSummary();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("year", year);
        params.put("cid", cid);
        params.put("isFinished", 1);
        DataScopeHelper.startDataScope("trainPlan", "train_plan");
        List<TrainPlan> finishedlist = this.trainPlanMapper.getTrainByYear(params);
        int attendNum = 0;
        if (finishedlist != null && finishedlist.size() > 0) {
            summ.setFinishedNum(Integer.valueOf(finishedlist.size()));
        }
        attendNum = this.trainPlanMapper.getTrainStaffNumByYear(params);
        summ.setAttendNnm(Integer.valueOf(attendNum));
        return summ;
    }

    public PageInfo<HTrainingModel> getTrainingPage(PageParamModel paramModel) {
        QueryTrainParam param = new QueryTrainParam();
        param.setBeginTime(paramModel.getStartDate());
        param.setEndTime(paramModel.getEndDate());
        if (paramModel.getIdCard() != null) {
            List infoList = this.staffInfoService.getStaffInfoByCardId(paramModel.getIdCard(), paramModel.getCid());
            Object staffIds = "-9";
            for (StaffInfo s : infoList) {
                staffIds = (String)staffIds + "," + s.getId();
            }
            param.setCid(paramModel.getCid());
            param.setStaffIds((String)staffIds);
            if (paramModel.getPageInfo() != null) {
                PageHelper.startPage((int)paramModel.getPageInfo().getPageNum(), (int)paramModel.getPageInfo().getPageSize());
            }
            List<HTrainingDetailModel> detailList = this.trainAttendMapper.getHTrainingDetailModel(param);
            ArrayList<HTrainingModel> list = new ArrayList<HTrainingModel>();
            if (detailList != null && detailList.size() > 0) {
                for (HTrainingDetailModel detail : detailList) {
                    if (detail.getTrainingTypeName() != null) {
                        String typeName = this.getTypeName(detail.getTrainingTypeName());
                        detail.setTrainingTypeName(typeName);
                    }
                    Integer testState = this.isPass(detail.getTrainId(), detail.getStaffId(), detail.getTrainId());
                    detail.setTestState(testState);
                    HTrainingModel model = new HTrainingModel();
                    model.setStartDate(detail.getTrainTime());
                    model.setStaffId(detail.getStaffId());
                    ArrayList<HTrainingDetailModel> del = new ArrayList<HTrainingDetailModel>();
                    del.add(detail);
                    model.setTrainDetailList(del);
                    list.add(model);
                }
            }
            return new PageInfo(list);
        }
        return null;
    }

    public PageInfo<HTrainingDetailModel> getTrainingPageInfo(PageParamModel paramModel) {
        QueryTrainParam param = new QueryTrainParam();
        param.setBeginTime(paramModel.getStartDate());
        param.setEndTime(paramModel.getEndDate());
        if (paramModel.getIdCard() != null) {
            List<HTrainingDetailModel> list;
            List infoList = this.staffInfoService.getStaffInfoByCardId(paramModel.getIdCard(), paramModel.getCid());
            Object staffIds = "-9";
            for (StaffInfo s : infoList) {
                staffIds = (String)staffIds + "," + s.getId();
            }
            param.setCid(paramModel.getCid());
            param.setStaffIds((String)staffIds);
            if (paramModel.getPageInfo() != null) {
                PageHelper.startPage((int)paramModel.getPageInfo().getPageNum(), (int)paramModel.getPageInfo().getPageSize());
            }
            if ((list = this.trainAttendMapper.getHTrainingDetailModel(param)) != null && list.size() > 0) {
                for (HTrainingDetailModel detail : list) {
                    if (detail.getTrainingTypeName() != null) {
                        String typeName = this.getTypeName(detail.getTrainingTypeName());
                        detail.setTrainingTypeName(typeName);
                    }
                    if (detail.getNeedTrain() == 0 && detail.getNeedTest() == 0) {
                        detail.setTrainState(Integer.valueOf(0));
                        continue;
                    }
                    if (detail.getNeedTrain() == 1 || detail.getTestState() == null) continue;
                    if (detail.getTestState() == 0) {
                        detail.setTrainState(Integer.valueOf(4));
                        continue;
                    }
                    if (detail.getTestState() == 1) {
                        detail.setTrainState(Integer.valueOf(5));
                        continue;
                    }
                    detail.setTrainState(Integer.valueOf(6));
                }
            }
            return new PageInfo(list);
        }
        return null;
    }

    @Transactional(readOnly=false)
    public void toVoid(Long id, Long staffid) {
        TrainPlan info = (TrainPlan)this.getById(id);
        info.setStatus(StatusEnum.toVoid.getValue());
        this.update(info, staffid);
    }

    public TrainEducationInfo getTrainEducationInfo(Long cid) {
        TrainEducationInfo count = new TrainEducationInfo();
        TrainPlan info = new TrainPlan();
        info.setCid(cid);
        info.setIsFinish(Boolean.valueOf(true));
        info.setIsValid(Boolean.valueOf(true));
        info.setHsType("1");
        List<TrainPlan> list = this.trainPlanMapper.getListByExample(info);
        if (list != null) {
            int GQNum = 0;
            int ZGDQNum = 0;
            count.setTrainNumEhs(list.size());
            for (TrainPlan tr : list) {
                if (tr.getType() == null) continue;
                if (tr.getType().contains(",1,")) {
                    ++GQNum;
                }
                if (!tr.getType().contains(",4,")) continue;
                ++ZGDQNum;
            }
            count.setTrainPreJobNum(GQNum);
            count.setTrainJobingNum(ZGDQNum);
        }
        return count;
    }

    public Integer getcontactHarmTrainNumByCid(Long cid, Integer year) {
        return this.trainPlanMapper.getcontactHarmTrainNumByCid(cid, year);
    }

    public List<TrainPlan> listOfOccTrainPlan(Map<String, Object> params) {
        List<TrainPlan> list = this.trainPlanMapper.listOfOccTrainPlan(params);
        list.forEach(s -> {
            s.setTypeName(this.getTypeName(s.getType()));
            List attends = this.trainAttendService.getByTid(s.getId());
            if (attends != null && attends.size() > 0) {
                s.setAttendOrgNames(attends.stream().filter(sa -> StringUtils.isNotEmpty((String)sa.getDeptName())).map(sa -> sa.getDeptName()).distinct().collect(Collectors.joining("\u3001")));
            }
        });
        return list;
    }

    public List<TrainPlan> needOnlineTrainList(Long cid, Long trainStaffId) {
        List<TrainPlan> list = this.trainPlanMapper.needOnlineTrainList(cid, trainStaffId);
        list.forEach(s -> s.setTypeName(this.getTypeName(s.getType())));
        return list;
    }

    public PageInfo<TrainAttend> trainAttendsData(JqGridParam param, Long trainId) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List list = this.trainAttendService.getByTid(trainId);
        TrainPlan train = (TrainPlan)this.getById(trainId);
        list.forEach(s -> {
            s.setOnlineTrain(train.getOnlineTrain());
            s.setOnlineTest(train.getOnlineTest());
            s.setWorkroleName(this.staffInfoService.getStaffCurrentWorkNameByStaffId(s.getStaffId()));
        });
        return new PageInfo(list);
    }

    @Transactional(readOnly=false)
    public List<OutTrainInfoVo> getOutTrainInfo(TrainPlan info) {
        ArrayList<OutTrainInfoVo> list = new ArrayList<OutTrainInfoVo>();
        List attends = info.getAttends();
        if (attends != null && attends.size() > 0) {
            CompanyBaseInfoModel companyBaseInfoModel = this.companyProvideByHSEService.getCompanyById(info.getCid());
            for (TrainAttend att : attends) {
                OutTrainInfoVo vo = new OutTrainInfoVo();
                vo.setCreaditCode(companyBaseInfoModel.getUnifiedSocialCc());
                vo.setWorkerName(att.getStaffName());
                vo.setTrainHours(info.getClassCount());
                vo.setTrainDate(info.getRegisterTime());
                vo.setTrainCourse(info.getName());
                if (info.getNeedOnlineTrain() != null && info.getNeedOnlineTrain().booleanValue()) {
                    vo.setTrainType(Integer.valueOf(1));
                } else {
                    vo.setTrainType(Integer.valueOf(2));
                }
                list.add(vo);
            }
            this.zjTrainService.updateTrainInfo(list);
        }
        return list;
    }

    public TrainPlanCountView getTrainPlanCountView(Long cid) {
        TrainPlanCountView summ = new TrainPlanCountView();
        HashMap<String, Object> params = new HashMap<String, Object>();
        Integer year = DateUtils.getYear((Date)new Date());
        params.put("cid", cid);
        params.put("type", 1);
        Integer totalNum = ((TrainPlanMapper)this.dao).getOccTrainPlanNumByYear(params);
        params.put("year", DateUtils.getYear());
        Integer thisYearNum = ((TrainPlanMapper)this.dao).getOccTrainPlanNumByYear(params);
        if (thisYearNum != null && thisYearNum > 0) {
            summ.setTrainNm("" + thisYearNum);
        } else {
            summ.setTrainNm("\u672a\u8fdb\u884c");
        }
        params.put("year", DateUtils.getThisYear() - 1);
        Integer lastYearNum = ((TrainPlanMapper)this.dao).getOccTrainPlanNumByYear(params);
        if (lastYearNum != null && lastYearNum > 0) {
            summ.setPreTrainNm("" + lastYearNum);
        } else {
            summ.setPreTrainNm("\u672a\u8fdb\u884c");
        }
        totalNum = totalNum - thisYearNum;
        if (totalNum > 0) {
            summ.setTotalTrainNum("" + totalNum);
        } else {
            summ.setTotalTrainNum("\u672a\u8fdb\u884c");
        }
        HashMap<String, Long> params1 = new HashMap<String, Long>();
        params1.put("cid", cid);
        params1.put("nameId", CertificateStaffNameTypeEnum.MainTrain.getId());
        List certs = this.certificateStaffDetailService.getCertStaffNumByCid(cid);
        if (certs != null) {
            for (CertificateStaff cert : certs) {
                if (cert.getNameId() != null && cert.getNameId().equals(CertificateStaffNameTypeEnum.MainTrain.getId())) {
                    summ.setMainCert("" + cert.getStaffNum());
                }
                if (cert.getNameId() == null || !cert.getNameId().equals(CertificateStaffNameTypeEnum.ManaTrain.getId())) continue;
                summ.setManageCert("" + cert.getStaffNum());
            }
        }
        if (summ.getMainCert() == null) {
            summ.setMainCert("\u65e0\u8bc1\u4e66");
        }
        if (summ.getManageCert() == null) {
            summ.setManageCert("\u65e0\u8bc1\u4e66");
        }
        return summ;
    }

    public List<TrainPlan> getTrainByYear(Long cid, Integer year) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("year", year);
        params.put("cid", cid);
        params.put("type", 1);
        List<TrainPlan> list = ((TrainPlanMapper)this.dao).getTrainByYear(params);
        if (list == null) {
            return new ArrayList<TrainPlan>();
        }
        return list;
    }

    public List<TrainPlan> getOnWorkTrainByCid(Long cid, Integer year) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("year", year);
        params.put("cid", cid);
        List<TrainPlan> list = ((TrainPlanMapper)this.dao).getOnWorkTrainByCid(params);
        if (list == null) {
            return new ArrayList<TrainPlan>();
        }
        return list;
    }

    public Integer isPass(Long trainId, Long staffId, Long cid) {
        List tests = this.staffOnlineTrainTestService.getLastTestByStaffId(trainId, staffId, cid);
        if (tests.size() > 0) {
            Long passScore = ((StaffOnlineTrainTest)tests.get(0)).getPassScore();
            Long totalScore = 0L;
            for (StaffOnlineTrainTest test : tests) {
                if (!test.getIsRight().booleanValue()) continue;
                totalScore = totalScore + test.getQuestionScore();
            }
            if (totalScore - passScore > 0L) {
                return 1;
            }
            return 2;
        }
        return 3;
    }

    public List<HealthTalentPointsModel> getHealthTalentPointsModelsByCid(Long cid) {
        List list = this.healthTalentPointsService.getListDataByCid(cid);
        return list.stream().map(s -> {
            HealthTalentPointsModel healthTalentPointsModel = new HealthTalentPointsModel();
            BeanUtils.copyProperties((Object)s, (Object)healthTalentPointsModel);
            return healthTalentPointsModel;
        }).collect(Collectors.toList());
    }

    public PageInfo<HealthTalentPointsModel> getHealthTalentPointsModelsPageByCid(Integer pageNum, Integer pageSize, Long cid) {
        PageInfo pageInfo = this.healthTalentPointsService.getListDataPageByCid(pageNum, pageSize, cid);
        PageInfo finalPageInfo = new PageInfo();
        finalPageInfo.setList(pageInfo.getList().stream().map(s -> {
            StaffBasicInfo staffBasicInfo;
            StaffInfo staffInfo;
            HealthTalentPointsModel healthTalentPointsModel = new HealthTalentPointsModel();
            BeanUtils.copyProperties((Object)s, (Object)healthTalentPointsModel);
            if (healthTalentPointsModel.getStaffId() != null && (staffInfo = (StaffInfo)this.staffInfoService.getById(healthTalentPointsModel.getStaffId())) != null && staffInfo.getStaffBasicId() != null && (staffBasicInfo = (StaffBasicInfo)this.staffBasicInfoService.getById(staffInfo.getStaffBasicId())) != null) {
                healthTalentPointsModel.setFaceId(staffBasicInfo.getFaceId());
            }
            return healthTalentPointsModel;
        }).collect(Collectors.toList()));
        BeanUtils.copyProperties((Object)pageInfo, (Object)finalPageInfo, (String[])new String[]{"list"});
        return finalPageInfo;
    }

    public Date getLastOnWorkTrainTime(Long cid) {
        return ((TrainPlanMapper)this.dao).getLastOnWorkTrainTime(cid);
    }

    public Date getFirstOnWorkTrainTimeByYear(Long cid, Integer year) {
        return ((TrainPlanMapper)this.dao).getFirstOnWorkTrainTimeByYear(cid, year);
    }

    public int getFinishedTrainPlanCount(Long cid) {
        TrainPlan info = new TrainPlan();
        info.setCid(cid);
        info.setIsFinish(Boolean.valueOf(true));
        info.setIsValid(Boolean.valueOf(true));
        List<TrainPlan> list = this.trainPlanMapper.getListByExampleWithVoid(info);
        if (list != null) {
            return list.size();
        }
        return 0;
    }

    public List<Month> getTrainNumByTime(Integer search, Long cid) {
        List<Month> trainingNumBytime = this.trainPlanMapper.getTrainNumByTime(search, cid);
        return trainingNumBytime;
    }

    public Integer getTrainStaffNumByYear(Integer year, Long cid) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("year", year);
        params.put("cid", cid);
        params.put("isFinished", 1);
        return this.trainPlanMapper.getTrainStaffNumByYear(params);
    }

    public TrainPlan getTrainInfoByCidAndReportId(Long cid, Long reportId) {
        if (cid == null || reportId == null) {
            return null;
        }
        TrainPlan info = new TrainPlan();
        info.setCid(cid);
        info.setIsValid(Boolean.valueOf(true));
        info.setReportId(reportId);
        List<TrainPlan> list = this.trainPlanMapper.getListByExample(info);
        if (list != null && list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    public TrainPlan getByCidAndReportId(Long cid, Long reportId) {
        if (cid == null || reportId == null) {
            return null;
        }
        Example example = new Example(TrainPlan.class);
        example.createCriteria().andEqualTo("isValid", (Object)Global.TRUE).andEqualTo("cid", (Object)cid).andEqualTo("reportId", (Object)reportId);
        List listByExample = this.getListByExample(example);
        if (CollectionUtils.isNotEmpty(listByExample)) {
            return (TrainPlan)listByExample.get(0);
        }
        return new TrainPlan();
    }

    @Transactional(readOnly=false)
    public void updateStatusByReportIdAndCid(TrainPlan trainPlan) {
        ((TrainPlanMapper)this.dao).updateStatusByReportIdAndCid(trainPlan);
    }

    public List<TrainPlan> getListByCidOrReportId(Long cid, Long reportId) {
        Example example = new Example(TrainPlan.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("isValid", (Object)Global.TRUE);
        if (cid != null) {
            criteria.andEqualTo("cid", (Object)cid);
        }
        if (reportId != null) {
            criteria.andEqualTo("reportId", (Object)reportId);
        }
        return this.getListByExample(example);
    }
}

