/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.train;

import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideByHSEService;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.datacentre.provider.system.ISysParamProvideService;
import cn.smarthse.modules.health.entity.base.staff.StaffBasicInfo;
import cn.smarthse.modules.health.entity.base.staff.StaffBasicWork;
import cn.smarthse.modules.health.entity.base.staff.StaffInfo;
import cn.smarthse.modules.health.entity.base.staff.StaffWorkRole;
import cn.smarthse.modules.health.entity.base.staff.WorkNatureInfo;
import cn.smarthse.modules.health.entity.base.staff.importstaff.StaffInfoExcelImportVo;
import cn.smarthse.modules.health.entity.base.workinfo.WorkRoleInfo;
import cn.smarthse.modules.health.enums.staff.StaffWorkPropertyEnum;
import cn.smarthse.modules.health.enums.staff.WorkNatureEnum;
import cn.smarthse.modules.health.service.base.staff.IStaffBasicInfoService;
import cn.smarthse.modules.health.service.base.staff.IStaffBasicWorkService;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.base.staff.IStaffWorkRoleService;
import cn.smarthse.modules.health.service.base.staff.IWorkNatureInfoService;
import cn.smarthse.modules.health.service.base.workinfo.IWorkRoleInfoService;
import cn.smarthse.modules.health.service.work.train.ITrainPlanOnlineService;
import java.util.Date;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.springframework.beans.factory.annotation.Autowired;

@DubboService
public class TrainPlanOnlineServiceImpl
implements ITrainPlanOnlineService {
    @Autowired
    private IWorkRoleInfoService workRoleInfoService;
    @DubboReference(version="1.0.0")
    private ISysParamProvideService sysParamProvideService;
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService sysAreaService;
    @Autowired
    private IStaffBasicInfoService staffBasicInfoService;
    @Autowired
    private IStaffInfoService staffInfoService;
    @Autowired
    private IWorkNatureInfoService workNatureInfoService;
    @Autowired
    private IStaffWorkRoleService staffWorkRoleService;
    @Autowired
    private IStaffBasicWorkService staffBasicWorkService;
    @DubboReference(version="1.0.0")
    ICompanyProvideByHSEService companyProvideByHSEService;

    private Long addStaffInfo(StaffInfoExcelImportVo vo, Long cid, Long loginStaffId) {
        StaffInfo staffInfo = vo.getStaffInfo();
        StaffBasicInfo staffBasicInfo = vo.getStaffBasicInfo();
        StaffBasicWork staffBasicWork = vo.getStaffBasicWork();
        StaffWorkRole currentStaffWorkRole = vo.getCurrentStaffWorkRole();
        staffBasicWork.setWorkNo(vo.getWorkNo());
        staffBasicWork.setOrgId(vo.getDeptId());
        currentStaffWorkRole.setWorkRoleId(vo.getWorkId());
        staffBasicWork.setOrgId(vo.getDeptId());
        this.staffBasicInfoService.add((Object)staffBasicInfo, loginStaffId, cid);
        staffInfo.setStaffBasicId(staffBasicInfo.getId());
        staffInfo.setOrgId(staffBasicWork.getOrgId());
        this.staffInfoService.add((Object)staffInfo, loginStaffId, cid);
        staffBasicWork.setStaffId(staffInfo.getId());
        this.staffBasicWorkService.add((Object)staffBasicWork, loginStaffId, cid);
        WorkNatureInfo radiationWork = new WorkNatureInfo();
        radiationWork.setIsWork(vo.getIsRadiation());
        radiationWork.setIsDefault(Boolean.valueOf(true));
        if (vo.getRadiationYear() != null) {
            radiationWork.setWorkBeginTime(vo.getRadiationYear());
        }
        radiationWork.setWorkType(vo.getRadiationTypeName());
        radiationWork.setNature(Byte.valueOf(WorkNatureEnum.RadiationWork.getValue()));
        radiationWork.setNatureName(WorkNatureEnum.RadiationWork.getName());
        radiationWork.setStaffId(staffInfo.getId());
        radiationWork.setCid(cid);
        this.workNatureInfoService.add((Object)radiationWork, loginStaffId, cid);
        WorkNatureInfo particularWork = new WorkNatureInfo();
        if (vo.getSpecialOperationsName() != null) {
            particularWork.setIsWork(Boolean.valueOf(true));
            particularWork.setWorkType(vo.getSpecialOperationsName());
        }
        particularWork.setIsDefault(Boolean.valueOf(true));
        particularWork.setNature(Byte.valueOf(WorkNatureEnum.ParticularWork.getValue()));
        particularWork.setNatureName(WorkNatureEnum.ParticularWork.getName());
        particularWork.setStaffId(staffInfo.getId());
        particularWork.setCid(cid);
        this.workNatureInfoService.add((Object)particularWork, loginStaffId, cid);
        WorkNatureInfo specialWork = new WorkNatureInfo();
        if (vo.getSpecialWorkName() != null) {
            specialWork.setIsWork(Boolean.valueOf(true));
            specialWork.setWorkType(vo.getSpecialWorkName());
        }
        specialWork.setIsDefault(Boolean.valueOf(true));
        specialWork.setNature(Byte.valueOf(WorkNatureEnum.SpecialWork.getValue()));
        specialWork.setNatureName(WorkNatureEnum.SpecialWork.getName());
        specialWork.setStaffId(staffInfo.getId());
        specialWork.setCid(cid);
        this.workNatureInfoService.add((Object)specialWork, loginStaffId, cid);
        currentStaffWorkRole.setStaffId(staffInfo.getId());
        this.staffWorkRoleService.add((Object)currentStaffWorkRole, loginStaffId, cid);
        StaffWorkRole curHistoryStaffWorkRole = new StaffWorkRole();
        curHistoryStaffWorkRole.setCid(cid);
        curHistoryStaffWorkRole.setBeginTime(currentStaffWorkRole.getBeginTime());
        curHistoryStaffWorkRole.setIsHistory(Boolean.valueOf(true));
        curHistoryStaffWorkRole.setIsThirdParty(currentStaffWorkRole.getIsThirdParty());
        curHistoryStaffWorkRole.setLeaveTime(currentStaffWorkRole.getLeaveTime());
        curHistoryStaffWorkRole.setStaffId(currentStaffWorkRole.getStaffId());
        curHistoryStaffWorkRole.setStatus(currentStaffWorkRole.getStatus());
        curHistoryStaffWorkRole.setWorkProperty(StaffWorkPropertyEnum.WORKED.getValue());
        curHistoryStaffWorkRole.setWorkRoleId(currentStaffWorkRole.getWorkRoleId());
        this.staffWorkRoleService.add((Object)curHistoryStaffWorkRole, loginStaffId, cid);
        return staffInfo.getId();
    }

    private String getExcelColName(int index) {
        if (index <= 26) {
            return String.valueOf((char)(65 + index - 1));
        }
        int a = index / 26;
        int b = index % 26;
        return String.valueOf((char)(65 + a - 1)) + String.valueOf((char)(65 + b - 1));
    }

    private static void dateHandle(Cell cell) {
        String dateStr;
        if (cell.getCellType() == CellType.STRING && StringUtils.isNotEmpty((String)(dateStr = cell.getStringCellValue()))) {
            Date date = DateUtils.parseDate((Object)dateStr.trim());
            if (date == null) {
                cell.setCellType(CellType.BLANK);
            } else {
                cell.setCellValue(date);
            }
        }
    }

    private WorkRoleInfo getWorkByNameAndCid(String workName, Long cid) {
        String[] workAndDeptname;
        if (workName == null || cid == null) {
            return null;
        }
        if (workName.contains("/") && (workAndDeptname = workName.split("/")).length == 2) {
            String jobName = workAndDeptname[0];
            String deptName = workAndDeptname[1];
            WorkRoleInfo work = this.workRoleInfoService.getWorkRoleInfoByNameAndOrgName(jobName, deptName, cid);
            if (work != null && work.getId() != null) {
                return work;
            }
            work = new WorkRoleInfo();
            work.setWorkName(jobName);
            work.setOrgName(deptName);
            return work;
        }
        return null;
    }
}

