/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.train;

import cn.smarthse.common.framework.enums.BusinessNoTypeEnum;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.excel.ExcelUtil;
import cn.smarthse.modules.health.entity.base.staff.StaffBasicInfo;
import cn.smarthse.modules.health.entity.base.staff.StaffBasicWork;
import cn.smarthse.modules.health.entity.base.staff.StaffInfo;
import cn.smarthse.modules.health.entity.base.staff.StaffWorkRole;
import cn.smarthse.modules.health.entity.work.train.TrainAttend;
import cn.smarthse.modules.health.entity.work.train.TrainPlan;
import cn.smarthse.modules.health.entity.work.train.TrainPlanImportVo;
import cn.smarthse.modules.health.enums.staff.StaffInfoImportStateEnum;
import cn.smarthse.modules.health.service.base.IBusinessNoService;
import cn.smarthse.modules.health.service.base.staff.IStaffBasicInfoService;
import cn.smarthse.modules.health.service.base.staff.IStaffBasicWorkService;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.base.staff.IStaffWorkRoleService;
import cn.smarthse.modules.health.service.work.train.ITrainAttendService;
import cn.smarthse.modules.health.service.work.train.ITrainPlanImportService;
import cn.smarthse.modules.health.service.work.train.ITrainPlanService;
import cn.smarthse.snowflake.IdWorker;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboService;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@DubboService
@Transactional(readOnly=true)
public class TrainPlanImportServiceImpl
implements ITrainPlanImportService {
    @Autowired
    private IStaffInfoService staffInfoService;
    @Autowired
    private IStaffBasicInfoService staffBasicInfoService;
    @Autowired
    private IStaffBasicWorkService staffBasicWorkService;
    @Autowired
    private IStaffWorkRoleService staffWorkRoleService;
    @Autowired
    private IBusinessNoService businessNoService;
    @Autowired
    private ITrainPlanService trainPlanService;
    @Autowired
    private ITrainAttendService trainAttendService;
    @Autowired
    protected IdWorker idworker;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TrainPlanImportVo> getTrainInfoFromExcel(String ossfile, Long loginStaffId, Long cid) {
        List<TrainPlanImportVo> list = new ArrayList<TrainPlanImportVo>();
        HSSFWorkbook wb = null;
        try {
            wb = new HSSFWorkbook(ExcelUtil.getInstance().getOssInputStream(ossfile));
        }
        catch (Exception sheet) {
        }
        finally {
            if (wb != null) {
                try {
                    HSSFSheet sheet = wb.getSheetAt(0);
                    list = this.parseTrainInfofromExcel((Sheet)sheet, loginStaffId, cid);
                    wb.close();
                }
                catch (IOException sheet) {}
            }
        }
        return list;
    }

    private List<TrainPlanImportVo> parseTrainInfofromExcel(Sheet sheet, Long loginStaffId, Long cid) {
        ArrayList<TrainPlanImportVo> list = new ArrayList<TrainPlanImportVo>();
        int rowIndex = 0;
        int cellIndex = 6;
        Iterator iter = sheet.rowIterator();
        while (iter.hasNext()) {
            Boolean isNullRow = true;
            Row row = (Row)iter.next();
            if (++rowIndex == 1 || rowIndex == 2) continue;
            HashMap<String, TrainPlanImportVo> needAddTrain = new HashMap<String, TrainPlanImportVo>();
            HashMap<String, StaffInfo> trainStaff = new HashMap<String, StaffInfo>();
            HashMap deptMap = new HashMap();
            HashMap workMap = new HashMap();
            TrainPlanImportVo vo = new TrainPlanImportVo();
            vo.setCid(cid);
            vo.setLoginStaffId(loginStaffId);
            vo.setErrorReason("");
            block10: for (int i = 0; i <= cellIndex; ++i) {
                Cell cell = row.getCell(i);
                if (i != 6 && cell != null) {
                    cell.setCellType(CellType.STRING);
                }
                switch (i) {
                    case 0: {
                        StaffInfo staff;
                        if (cell != null && StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                            isNullRow = false;
                            String workNo = cell.getStringCellValue().trim();
                            vo.setWorkNo(workNo);
                            staff = (StaffInfo)trainStaff.get(workNo);
                            if (staff == null) {
                                staff = this.staffInfoService.getStaffInfoByWorkNo(workNo, cid);
                                if (staff == null) {
                                    vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                                    vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u8be5\u5de5\u53f7\u4eba\u5458\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u8bf7\u6838\u5b9e\u540e\u91cd\u65b0\u586b\u5199;<br/>");
                                } else {
                                    StaffBasicInfo basicInfo = (StaffBasicInfo)this.staffBasicInfoService.getById(staff.getStaffBasicId());
                                    staff.setStaffBasicInfo(basicInfo);
                                    vo.setStaffId(staff.getId());
                                    trainStaff.put(workNo, staff);
                                }
                            } else {
                                vo.setStaffId(staff.getId());
                            }
                            if (vo.getDataState() != null && vo.getDataState().byteValue() != StaffInfoImportStateEnum.normal.getValue()) continue block10;
                            vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                            continue block10;
                        }
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                        vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u5de5\u53f7\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a;<br/>");
                        continue block10;
                    }
                    case 1: {
                        StaffInfo staff;
                        if (cell != null && StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                            isNullRow = false;
                            String staffName = cell.getStringCellValue().trim();
                            vo.setStaffName(staffName);
                            if (vo.getWorkNo() != null && (staff = (StaffInfo)trainStaff.get(vo.getWorkNo())) != null && !staffName.equals(staff.getStaffBasicInfo().getRealName())) {
                                vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                                vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u4eba\u5458\u59d3\u540d\u4e0e\u5de5\u53f7\u5bf9\u5e94\u7684\u4eba\u5458\u59d3\u540d\u4e0d\u7b26\u8bf7\u6838\u5b9e\u540e\u91cd\u65b0\u586b\u5199;<br/>");
                            }
                            if (vo.getDataState() != null && vo.getDataState().byteValue() != StaffInfoImportStateEnum.normal.getValue()) continue block10;
                            vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                            continue block10;
                        }
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                        vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u4eba\u5458\u59d3\u540d\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a;<br/>");
                        continue block10;
                    }
                    case 2: {
                        TrainPlanImportVo train;
                        if (cell != null && StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                            isNullRow = false;
                            String trainName = cell.getStringCellValue().trim();
                            vo.setName(trainName);
                            vo.setRowIndex(Integer.valueOf(rowIndex));
                            train = (TrainPlanImportVo)needAddTrain.get(trainName);
                            if (train == null) {
                                train = new TrainPlanImportVo();
                                train.setName(trainName);
                                train.setRowIndex(Integer.valueOf(rowIndex));
                                needAddTrain.put(trainName, train);
                            }
                            if (vo.getDataState() != null && vo.getDataState().byteValue() != StaffInfoImportStateEnum.normal.getValue()) continue block10;
                            vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                            continue block10;
                        }
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                        vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u8bfe\u7a0b\u540d\u79f0\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a;<br/>");
                        continue block10;
                    }
                    case 3: {
                        String type;
                        TrainPlanImportVo train;
                        if (cell != null && StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                            isNullRow = false;
                            type = cell.getStringCellValue().trim();
                            vo.setHsType(type);
                            train = (TrainPlanImportVo)needAddTrain.get(vo.getName());
                            if (train != null) {
                                if (train.getHsType() == null) {
                                    train.setHsType(type);
                                    needAddTrain.put(vo.getName(), train);
                                } else if (!type.equals(train.getHsType())) {
                                    vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                                    vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u4e0e\u7b2c" + train.getRowIndex() + "\u884c\u8bfe\u7a0b\u540d\u79f0\u76f8\u540c\u4f46\u8bfe\u7a0b\u5206\u7c7b\u4e0d\u540c\u8bf7\u6838\u5b9e\u540e\u91cd\u65b0\u586b\u5199;<br/>");
                                }
                            }
                            if (vo.getDataState() != null && vo.getDataState().byteValue() != StaffInfoImportStateEnum.normal.getValue()) continue block10;
                            vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                            continue block10;
                        }
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                        vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u8bfe\u7a0b\u5206\u7c7b\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a;<br/>");
                        continue block10;
                    }
                    case 4: {
                        String type;
                        TrainPlanImportVo train;
                        if (cell != null && StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                            isNullRow = false;
                            type = cell.getStringCellValue().trim();
                            vo.setType(type);
                            train = (TrainPlanImportVo)needAddTrain.get(vo.getName());
                            if (train != null) {
                                if (train.getType() == null) {
                                    train.setType(type);
                                    needAddTrain.put(vo.getName(), train);
                                } else if (!type.equals(train.getType())) {
                                    vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                                    vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u4e0e\u7b2c" + train.getRowIndex() + "\u884c\u8bfe\u7a0b\u540d\u79f0\u76f8\u540c\u4f46\u8bfe\u7a0b\u7c7b\u578b\u4e0d\u540c\u8bf7\u6838\u5b9e\u540e\u91cd\u65b0\u586b\u5199;<br/>");
                                }
                            }
                            if (vo.getDataState() != null && vo.getDataState().byteValue() != StaffInfoImportStateEnum.normal.getValue()) continue block10;
                            vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                            continue block10;
                        }
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                        vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u8bfe\u7a0b\u7c7b\u578b\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a;<br/>");
                        continue block10;
                    }
                    case 5: {
                        String type;
                        TrainPlanImportVo train;
                        if (cell != null && StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                            isNullRow = false;
                            type = cell.getStringCellValue().trim();
                            vo.setClassCount(type);
                            train = (TrainPlanImportVo)needAddTrain.get(vo.getName());
                            if (train != null) {
                                if (train.getClassCount() == null) {
                                    train.setClassCount(type);
                                    needAddTrain.put(vo.getName(), train);
                                } else if (!type.equals(train.getClassCount())) {
                                    vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                                    vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u4e0e\u7b2c" + train.getRowIndex() + "\u884c\u8bfe\u7a0b\u540d\u79f0\u76f8\u540c\u4f46\u8bfe\u7a0b\u5b66\u65f6\u4e0d\u540c\u8bf7\u6838\u5b9e\u540e\u91cd\u65b0\u586b\u5199;<br/>");
                                }
                            }
                            if (vo.getDataState() != null && vo.getDataState().byteValue() != StaffInfoImportStateEnum.normal.getValue()) continue block10;
                            vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                            continue block10;
                        }
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                        vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u8bfe\u7a0b\u5b66\u65f6\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a;<br/>");
                        continue block10;
                    }
                    case 6: {
                        if (cell != null && cell.getCellType() != CellType.BLANK) {
                            isNullRow = false;
                            TrainPlanImportServiceImpl.dateHandle(cell);
                            if (cell.getCellType() == CellType.BLANK) {
                                vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                                vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u5b8c\u6210\u65f6\u95f4\u89e3\u6790\u9519\u8bef;<br/>");
                                continue block10;
                            }
                            vo.setUpdateDate(cell.getDateCellValue());
                            TrainPlanImportVo train = (TrainPlanImportVo)needAddTrain.get(vo.getName());
                            if (train == null) continue block10;
                            if (train.getUpdateDate() == null) {
                                train.setUpdateDate(vo.getUpdateDate());
                                needAddTrain.put(vo.getName(), train);
                                continue block10;
                            }
                            if (vo.getUpdateDate().equals(train.getUpdateDate())) continue block10;
                            vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                            vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u4e0e\u7b2c" + train.getRowIndex() + "\u884c\u8bfe\u7a0b\u540d\u79f0\u76f8\u540c\u4f46\u5b8c\u6210\u65f6\u95f4\u4e0d\u540c\u8bf7\u6838\u5b9e\u540e\u91cd\u65b0\u586b\u5199;<br/>");
                            continue block10;
                        }
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                        vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u8bfe\u7a0b\u5b66\u65f6\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a;<br/>");
                    }
                }
            }
            if (isNullRow.booleanValue()) break;
            list.add(vo);
        }
        return list;
    }

    @Transactional(readOnly=false)
    public int importTrainInfo(List<TrainPlanImportVo> list, Long cid, Long loginStaffId) throws Exception {
        if (list != null) {
            HashMap<String, TrainPlan> trainMap = new HashMap<String, TrainPlan>();
            for (TrainPlanImportVo vo : list) {
                if (vo.getName() == null) continue;
                TrainPlan train = (TrainPlan)trainMap.get(vo.getName());
                if (train == null) {
                    train = new TrainPlan();
                    train.setName(vo.getName());
                    String no = this.businessNoService.getBusinessNo(cid, BusinessNoTypeEnum.TRAINPLAN.getCode());
                    train.setNo(no);
                    train.setCid(cid);
                    train.setId(Long.valueOf(this.idworker.nextId()));
                    if (vo.getHsType() != null) {
                        if (vo.getHsType().contains("\u5b89\u5168")) {
                            train.setHsType("2,");
                        } else {
                            train.setHsType("1,");
                        }
                    }
                    train.setWay(Byte.valueOf((byte)1));
                    if (vo.getType() != null) {
                        if (vo.getType().contains("\u7535\u5b50\u5b66\u4e60") || vo.getType().contains("\u7ebf\u4e0a")) {
                            train.setOnLine(Byte.valueOf((byte)2));
                        } else {
                            train.setOnLine(Byte.valueOf((byte)1));
                        }
                    }
                    train.setClassCount(vo.getClassCount());
                    train.setRegisterTime(vo.getUpdateDate());
                    train.setIsFinish(Boolean.valueOf(true));
                    this.trainPlanService.add((Object)train, loginStaffId, cid);
                    trainMap.put(vo.getName(), train);
                }
                TrainAttend attend = new TrainAttend();
                attend.setTrainId(train.getId());
                attend.setCid(cid);
                attend.setStaffId(vo.getStaffId());
                attend.setStaffName(vo.getStaffName());
                if (vo.getStaffId() != null) {
                    StaffWorkRole staffWorkRole;
                    StaffBasicWork staffBasicWork = this.staffBasicWorkService.getStaffBasicWorkByStaffId(vo.getStaffId());
                    if (staffBasicWork != null) {
                        attend.setDeptId(staffBasicWork.getOrgId());
                        if (staffBasicWork.getCompanyOrganization() != null) {
                            attend.setDeptName(staffBasicWork.getCompanyOrganization().getOrganizationName());
                        }
                    }
                    if ((staffWorkRole = this.staffWorkRoleService.getCurrentStaffWorkRoleByStaffId(vo.getStaffId())) != null && staffWorkRole.getWorkRoleInfo() != null) {
                        attend.setWorkroleId(staffWorkRole.getWorkRoleInfo().getId());
                        attend.setWorkroleName(staffWorkRole.getWorkRoleInfo().getWorkName());
                    }
                }
                this.trainAttendService.add((Object)attend, loginStaffId, cid);
            }
            for (TrainPlan value : trainMap.values()) {
                this.trainAttendService.andUnTrainAttendInfo(value.getId());
            }
        } else {
            return 0;
        }
        return list.size();
    }

    private String getExcelColName(int index) {
        if (index <= 26) {
            return String.valueOf((char)(65 + index - 1));
        }
        int a = index / 26;
        int b = index % 26;
        return String.valueOf((char)(65 + a - 1)) + String.valueOf((char)(65 + b - 1));
    }

    private static void dateHandle(Cell cell) {
        String dateStr;
        if ((cell.getCellType() == CellType.STRING || cell.getCellType() == CellType.FORMULA) && StringUtils.isNotEmpty((String)(dateStr = cell.getStringCellValue()))) {
            Date date = DateUtils.parseDate((Object)dateStr.trim());
            if (date == null) {
                cell.setCellType(CellType.BLANK);
            } else {
                Integer year = date.getYear();
                if (year > 9999) {
                    cell.setCellType(CellType.BLANK);
                } else {
                    cell.setCellValue(date);
                }
            }
        }
    }
}

