/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.train;

import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.datacentre.model.CompanyBaseInfoModel;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseModel;
import cn.smarthse.modules.health.dao.work.train.TrainPlanCountMapper;
import cn.smarthse.modules.health.entity.work.check.vo.count.CompanyCountInfo;
import cn.smarthse.modules.health.entity.work.train.TrainPlanCount;
import cn.smarthse.modules.health.service.base.ICompanyService;
import cn.smarthse.modules.health.service.work.train.ITrainPlanCountService;
import cn.smarthse.modules.health.supervise.service.declare.IDeclareBaseService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import tk.mybatis.mapper.entity.Example;

@DubboService
public class TrainPlanCountServiceImpl
extends BaseServiceImpl<TrainPlanCountMapper, TrainPlanCount>
implements ITrainPlanCountService {
    @Autowired
    TrainPlanCountMapper trainPlanCountMapper;
    @DubboReference
    IDeclareBaseService declareBaseService;
    @Autowired
    ICompanyService companyService;
    @Autowired
    private DataSourceTransactionManager txManager;

    private void clearAll() {
        Example example = new Example(TrainPlanCount.class);
        this.trainPlanCountMapper.deleteByExample(example);
    }

    @Transactional(readOnly=false)
    public void addCountData() {
        this.clearAll();
        Integer companyCount = this.companyService.countSuperviseCompanyData();
        if (companyCount == null || companyCount == 0) {
            return;
        }
        Map<Long, Integer> certEffectiveCount = this.companyCertEffectiveCount();
        Map<Long, Integer> certEffectiveMainCount = this.certEffectiveMainCount();
        Map<Long, Integer> manaTrainCount = this.companyManaTrainInfoCount();
        ArrayList<Long> declareCids = this.declareBaseService.getTrainCidListByYear(null, null, null);
        if (declareCids == null) {
            declareCids = new ArrayList<Long>();
        }
        int pages = (int)Math.ceil((double)companyCount.intValue() / 1000.0);
        for (int i = 1; i <= pages; ++i) {
            this.commitOneBatch(i, 1000, certEffectiveMainCount, certEffectiveCount, manaTrainCount, declareCids);
        }
        this.logger.info("\u3010\u4f01\u4e1a\u804c\u4e1a\u536b\u751f\u6559\u80b2\u57f9\u8bad\u7edf\u8ba1\u5b8c\u6210\u3011");
        this.logger.error("\u4f01\u4e1a\u57f9\u8bad\u60c5\u51b5=" + manaTrainCount.values().size());
    }

    private Map<Long, Integer> certEffectiveMainCount() {
        List<CompanyCountInfo> count = this.trainPlanCountMapper.certEffectiveMainCount();
        Map<Long, Integer> countMap = this.convertList(count);
        return countMap;
    }

    private void commitOneBatch(int page, int pageSize, Map<Long, Integer> certEffectiveMainCount, Map<Long, Integer> certEffectiveCount, Map<Long, Integer> manaTrainCount, List<Long> declareCids) {
        TransactionStatus status = null;
        try {
            List compaines = this.companyService.listSuperviseCompanyData(page, pageSize);
            ArrayList<TrainPlanCount> counts = new ArrayList<TrainPlanCount>();
            for (CompanySuperviseModel company : compaines) {
                TrainPlanCount data = new TrainPlanCount();
                Long cid = company.getId();
                data.setId(Long.valueOf(this.idworker.nextId()));
                data.setCertEffectiveNum(certEffectiveCount.get(cid));
                if (certEffectiveCount.get(cid) != null && certEffectiveCount.get(cid) > 0) {
                    data.setEquipmentHseMana(Integer.valueOf(1));
                } else {
                    data.setEquipmentHseMana(Integer.valueOf(0));
                }
                data.setCertEffectiveNumMain(certEffectiveMainCount.get(cid));
                if (certEffectiveMainCount.get(cid) != null && certEffectiveMainCount.get(cid) > 0) {
                    data.setMainHseMana(Integer.valueOf(1));
                } else {
                    data.setMainHseMana(Integer.valueOf(0));
                }
                if (manaTrainCount.get(cid) != null && manaTrainCount.get(cid) > 0 || declareCids.contains(cid)) {
                    data.setManaTrainInfo(Integer.valueOf(1));
                } else {
                    data.setManaTrainInfo(Integer.valueOf(0));
                }
                data.setCid(company.getId());
                data.setAreaId(company.getAreaId());
                data.setIndustryCategory(company.getIndustryCategory());
                data.setOccupationalRiskClassify(company.getOccupationalRiskClassify() == null ? null : Byte.valueOf(Byte.parseByte("" + company.getOccupationalRiskClassify())));
                data.setRegisterType(company.getRegisterType());
                data.setScale(company.getScale());
                data.setCreateDate(new Date());
                data.setUpdateDate(new Date());
                if (!(data.getManaTrainInfo() != null && data.getManaTrainInfo() != 0 || data.getCertEffectiveNumMain() != null && data.getCertEffectiveNumMain() != 0 || data.getCertEffectiveNum() != null && data.getCertEffectiveNum() != 0 || data.getEquipmentHseMana() != 0) && data.getMainHseMana() == 0) continue;
                counts.add(data);
            }
            if (counts.size() > 0) {
                DefaultTransactionDefinition def = new DefaultTransactionDefinition();
                def.setPropagationBehavior(3);
                status = this.txManager.getTransaction((TransactionDefinition)def);
                ((TrainPlanCountMapper)this.dao).insertBatch(counts);
                this.txManager.commit(status);
            }
        }
        catch (Exception e) {
            if (status != null) {
                this.txManager.rollback(status);
            }
            e.printStackTrace();
            this.logger.error("\u3010\u4f01\u4e1a\u57fa\u7840\u4fe1\u606f\u540c\u6b65\u51fa\u9519\u3011", (Throwable)e);
        }
    }

    public void addCountData1() {
        this.clearAll();
        List companies = this.companyService.listSuperviseCompanyData();
        if (companies == null || companies.isEmpty()) {
            return;
        }
        Map<Long, Integer> certEffectiveCount = this.companyCertEffectiveCount();
        Map<Long, Integer> manaTrainCount = this.companyManaTrainInfoCount();
        ArrayList<Object> counts = new ArrayList<TrainPlanCount>();
        for (CompanyBaseInfoModel company : companies) {
            TrainPlanCount data = new TrainPlanCount();
            Long cid = company.getId();
            data.setId(Long.valueOf(this.idworker.nextId()));
            data.setCertEffectiveNum(certEffectiveCount.get(cid));
            if (certEffectiveCount.get(cid) != null && certEffectiveCount.get(cid) > 0) {
                data.setEquipmentHseMana(Integer.valueOf(1));
            } else {
                data.setEquipmentHseMana(Integer.valueOf(0));
            }
            if (manaTrainCount.get(cid) != null && manaTrainCount.get(cid) > 0) {
                data.setManaTrainInfo(Integer.valueOf(1));
            } else {
                data.setManaTrainInfo(Integer.valueOf(0));
            }
            data.setCid(company.getId());
            data.setAreaId(company.getAreaId());
            data.setIndustryCategory(company.getIndustryCategory());
            data.setOccupationalRiskClassify(company.getOccupationalRiskClassify() == null ? null : Byte.valueOf(Byte.parseByte("" + company.getOccupationalRiskClassify())));
            data.setRegisterType(company.getRegisterType());
            data.setScale(company.getScale());
            data.setCreateDate(new Date());
            data.setUpdateDate(new Date());
            counts.add(data);
            if (counts.size() != 1000) continue;
            this.commitOne(counts);
            counts = new ArrayList();
        }
        if (counts.size() > 0) {
            this.commitOne(counts);
        }
        this.logger.info("\u3010\u4f01\u4e1a\u804c\u4e1a\u536b\u751f\u6559\u80b2\u57f9\u8bad\u7edf\u8ba1\u5b8c\u6210\u3011");
    }

    private void commitOne(List<TrainPlanCount> counts) {
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setPropagationBehavior(3);
        TransactionStatus status = this.txManager.getTransaction((TransactionDefinition)def);
        try {
            this.trainPlanCountMapper.insertBatch(counts);
            this.txManager.commit(status);
        }
        catch (Exception e) {
            this.txManager.rollback(status);
            e.printStackTrace();
            this.logger.error("\u3010\u4f01\u4e1a\u804c\u4e1a\u536b\u751f\u6559\u80b2\u57f9\u8bad\u7edf\u8ba1\u51fa\u9519\u3011", (Throwable)e);
        }
    }

    private Map<Long, Integer> companyFullTimeCount() {
        List<CompanyCountInfo> count = this.trainPlanCountMapper.companyFullTimeCount();
        Map<Long, Integer> countMap = this.convertList(count);
        return countMap;
    }

    private Map<Long, Integer> companyPartTimeCount() {
        List<CompanyCountInfo> count = this.trainPlanCountMapper.companyPartTimeCount();
        Map<Long, Integer> countMap = this.convertList(count);
        return countMap;
    }

    private Map<Long, Integer> companyHseManaCount() {
        List<CompanyCountInfo> count = this.trainPlanCountMapper.companyHseManagCount();
        Map<Long, Integer> countMap = this.convertList(count);
        return countMap;
    }

    private Map<Long, Integer> companyCertEffectiveCount() {
        List<CompanyCountInfo> count = this.trainPlanCountMapper.companyCertEffectiveCount();
        Map<Long, Integer> countMap = this.convertList(count);
        return countMap;
    }

    private Map<Long, Integer> companyManaTrainInfoCount() {
        List<CompanyCountInfo> count = this.trainPlanCountMapper.companyManaTrainInfoCount();
        Map<Long, Integer> countMap = this.convertList(count);
        return countMap;
    }

    private Map<Long, Integer> convertList(List<CompanyCountInfo> list) {
        HashMap<Long, Integer> result = new HashMap<Long, Integer>();
        if (list == null || list.isEmpty()) {
            return result;
        }
        for (CompanyCountInfo l : list) {
            result.put(l.getCid(), l.getTotal());
        }
        return result;
    }
}

