/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.train;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.dao.work.train.TrainFileTypeMapper;
import cn.smarthse.modules.health.entity.work.train.TrainFileType;
import cn.smarthse.modules.health.service.work.train.ITrainFileTypeService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@DubboService
@Transactional(readOnly=true)
public class TrainFileTypeServiceImpl
extends BaseServiceImpl<TrainFileTypeMapper, TrainFileType>
implements ITrainFileTypeService {
    @Autowired
    TrainFileTypeMapper trainFileTypeMapper;

    public List<TrainFileType> listByType(TrainFileType type) {
        return this.trainFileTypeMapper.selectByType(type);
    }

    public PageInfo<TrainFileType> getTypePage(Long cid, byte type, JqGridParam param) {
        if (cid == null) {
            return null;
        }
        TrainFileType info = new TrainFileType();
        info.setCid(cid);
        info.setType(Byte.valueOf(type));
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<TrainFileType> list = this.trainFileTypeMapper.selectByType(info);
        PageInfo pageInfo = new PageInfo(list);
        return pageInfo;
    }

    public PageInfo<TrainFileType> getTrainFileList(TrainFileType type, JqGridParam param) {
        if (type.getCid() == null) {
            return null;
        }
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<TrainFileType> list = this.trainFileTypeMapper.selectByType(type);
        PageInfo pageInfo = new PageInfo(list);
        return pageInfo;
    }

    @Transactional(readOnly=false)
    public void updateWithHistory(TrainFileType info, Long staffid) {
        this.update(info, staffid);
    }

    @Transactional(readOnly=false)
    public void addWithHistory(TrainFileType info, Long staffid, Long cid) {
        info = this.add(info, staffid, cid);
    }

    @Transactional(readOnly=false)
    public void deleteWithHis(TrainFileType type, Long staffid, Long cid) {
        this.update(type, staffid);
    }
}

