/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.train;

import cn.hutool.core.collection.CollectionUtil;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.encrypt.spring.utils.SpringEncryptUtils;
import cn.smarthse.modules.health.dao.work.train.TrainAttendMapper;
import cn.smarthse.modules.health.entity.work.train.QueryTrainParam;
import cn.smarthse.modules.health.entity.work.train.StaffTrainInfo;
import cn.smarthse.modules.health.entity.work.train.TrainAttend;
import cn.smarthse.modules.health.entity.work.train.TrainAttendCountModel;
import cn.smarthse.modules.health.model.HTrainingDetailModel;
import cn.smarthse.modules.health.model.HTrainingModel;
import cn.smarthse.modules.health.service.work.train.ITrainAttendService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class TrainAttendServiceImpl
extends BaseServiceImpl<TrainAttendMapper, TrainAttend>
implements ITrainAttendService {
    @Autowired
    TrainAttendMapper trainAttendMapper;

    public List<TrainAttend> getByTid(Long id) {
        Example example = new Example(TrainAttend.class);
        example.createCriteria().andEqualTo("trainId", (Object)id).andEqualTo("isValid", (Object)true).andEqualTo("isTrain", (Object)true);
        return this.trainAttendMapper.selectByExample(example);
    }

    public List<StaffTrainInfo> getStaffTrainInfo(QueryTrainParam param) {
        return this.trainAttendMapper.getStaffTrainInfo(param);
    }

    public List<HTrainingModel> getHTrainingModel(QueryTrainParam param) {
        List<HTrainingModel> list = this.trainAttendMapper.getHTrainingModel(param);
        if (list != null && list.size() > 0) {
            for (HTrainingModel trainMOdel : list) {
                param.setBeginTime(trainMOdel.getStartDate());
                List<HTrainingDetailModel> detailList = this.trainAttendMapper.getHTrainingDetailModel(param);
                trainMOdel.setTrainDetailList(detailList);
            }
        }
        return list;
    }

    @Transactional(readOnly=false, propagation=Propagation.REQUIRES_NEW)
    public void updateScore(Long staffId, Long trainId, Integer score, Integer examStatus) {
        this.trainAttendMapper.updateScore(staffId, trainId, score, examStatus);
    }

    public PageInfo<StaffTrainInfo> getTrainRecordListDataGroupByStaffId(JqGridParam param, QueryTrainParam queryTrainParam) {
        if (param == null || queryTrainParam == null || queryTrainParam.getCid() == null) {
            return new PageInfo();
        }
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<StaffTrainInfo> list = this.trainAttendMapper.getTrainRecordListDataGroupByStaffId(queryTrainParam);
        return new PageInfo(list);
    }

    public List<StaffTrainInfo> getTrainRecordListData(QueryTrainParam queryTrainParam) {
        List<StaffTrainInfo> trainRecordListData = this.trainAttendMapper.getTrainRecordListData(queryTrainParam);
        if (CollectionUtils.isNotEmpty(trainRecordListData)) {
            trainRecordListData.forEach(i -> {
                i.setHsTypeName(i.getHsType());
                i.setWayAndOnLine(i.getWay(), i.getOnLine());
            });
            return trainRecordListData;
        }
        return new ArrayList<StaffTrainInfo>();
    }

    public Integer getTrainStaffNum(QueryTrainParam queryTrainParam) {
        return this.trainAttendMapper.getTrainStaffNum(queryTrainParam);
    }

    public TrainAttend getByStaffIdAndTrainId(Long staffId, Long trainPlanId) {
        Example example = new Example(TrainAttend.class);
        example.createCriteria().andEqualTo("isValid", (Object)true).andEqualTo("trainId", (Object)trainPlanId).andEqualTo("staffId", (Object)staffId);
        List list = this.getListByExample(example);
        if (list != null && !list.isEmpty()) {
            return (TrainAttend)list.get(0);
        }
        return null;
    }

    public List<TrainAttend> getListByStaffId(Long staffId) {
        if (staffId == null) {
            return null;
        }
        Example example = new Example(TrainAttend.class);
        example.createCriteria().andEqualTo("isValid", (Object)true).andEqualTo("staffId", (Object)staffId);
        return this.getListByExample(example);
    }

    @Transactional(readOnly=false)
    public int batchUpdateStaffName(List<TrainAttend> trainAttendList, String staffName) {
        if (CollectionUtils.isEmpty(trainAttendList)) {
            return 0;
        }
        int i = this.batchUpdateOrInsert(trainAttendList, TrainAttendMapper.class, (item, d) -> {
            item.setStaffName(staffName);
            item.setUpdateDate(new Date());
            return d.updateByPrimaryKeySelective(item);
        });
        return i;
    }

    public PageInfo<TrainAttendCountModel> getTrainAttendListByDept(JqGridParam param, Long trainId, Boolean isTrain) {
        if (param == null || trainId == null) {
            return new PageInfo();
        }
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<TrainAttendCountModel> list = this.trainAttendMapper.getTrainAttendListByDept(trainId, isTrain);
        return new PageInfo(list);
    }

    @Transactional(readOnly=false)
    public void andUnTrainAttendInfo(Long trainId) {
        if (trainId != null) {
            List<TrainAttend> unTrains = this.trainAttendMapper.getUnTrainAttendInfo(trainId);
            if (CollectionUtil.isNotEmpty(unTrains)) {
                unTrains.forEach(u -> u.setStaffName(SpringEncryptUtils.decrypt((String)u.getStaffName())));
            }
            int n = this.batchUpdateOrInsert(unTrains, TrainAttendMapper.class, (item, d) -> {
                item.setId(Long.valueOf(this.idworker.nextId()));
                item.setIsValid(Boolean.valueOf(true));
                item.setIsTrain(Boolean.valueOf(false));
                return d.insertSelective(item);
            });
        }
    }
}

