/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.train;

import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.health.dao.work.certificate.CertificateStaffDetailMapper;
import cn.smarthse.modules.health.dao.work.train.TrainAttendMapper;
import cn.smarthse.modules.health.dao.work.train.TrainPlanMapper;
import cn.smarthse.modules.health.dao.work.train.TrainSummarizeMapper;
import cn.smarthse.modules.health.entity.work.certificate.CertificateFiles;
import cn.smarthse.modules.health.entity.work.certificate.CertificateStaffDetail;
import cn.smarthse.modules.health.entity.work.planyear.PlanYearDetail;
import cn.smarthse.modules.health.entity.work.train.TrainAttend;
import cn.smarthse.modules.health.entity.work.train.TrainPlan;
import cn.smarthse.modules.health.entity.work.train.TrainSummarize;
import cn.smarthse.modules.health.enums.sys.coreWork.CoreWorkEnum;
import cn.smarthse.modules.health.enums.train.TrainPlanTypeEnum;
import cn.smarthse.modules.health.service.base.staff.IStaffBasicWorkService;
import cn.smarthse.modules.health.service.work.certificate.ICertificateFilesService;
import cn.smarthse.modules.health.service.work.planyear.IPlanYearDetailService;
import cn.smarthse.modules.health.service.work.train.ITrainArchiveService;
import cn.smarthse.modules.health.service.work.train.ITrainBookService;
import cn.smarthse.modules.health.service.work.train.ITrainExamService;
import cn.smarthse.modules.health.service.work.train.ITrainFileService;
import cn.smarthse.modules.health.service.work.train.ITrainPaperFileService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@DubboService
@Transactional(readOnly=true)
public class TrainArchiveServiceImpl
implements ITrainArchiveService {
    @Autowired
    TrainPlanMapper trainPlanMapper;
    @Autowired
    CertificateStaffDetailMapper certificateStaffDetailMapper;
    @Autowired
    ICertificateFilesService certificateFilesService;
    @Autowired
    TrainSummarizeMapper trainSummarizeMapper;
    @Autowired
    ITrainPaperFileService trainPaperFileService;
    @Autowired
    ITrainBookService trainBookService;
    @Autowired
    ITrainExamService trainExamService;
    @Autowired
    TrainAttendMapper trainAttendMapper;
    @Autowired
    IStaffBasicWorkService staffBasicWorkService;
    @Autowired
    IPlanYearDetailService iPlanYearDetailService;
    @Autowired
    ITrainFileService trainFileService;
    @DubboReference
    ISysFileProvideService fileService;

    public List<TrainPlan> getOccHealthTrainPlanByYear(Long cid, Integer year) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("year", year);
        params.put("cid", cid);
        params.put("type", "1");
        List<TrainPlan> list1 = this.trainPlanMapper.listOfOccTrainPlanByYear(params);
        List list2 = this.iPlanYearDetailService.getPlanYearDetailListByCidAndYearAndBussnissModularId(cid, year, Long.valueOf(CoreWorkEnum.trainPlan.getValue().longValue()));
        for (TrainPlan train : list1) {
            for (PlanYearDetail plan : list2) {
                if (!train.getId().equals(plan.getBussnissId())) continue;
                list2.remove(plan);
                break;
            }
            if (train.getType() == null) continue;
            train.setTypeName(this.getTypeName(train.getType()));
        }
        for (PlanYearDetail plan : list2) {
            TrainPlan p = (TrainPlan)this.trainPlanMapper.selectByPrimaryKey(plan.getBussnissId());
            if (p == null || p.getIsValid() == null || !p.getIsValid().booleanValue() || p == null || p.getType() == null || !p.getType().contains("7")) continue;
            p.setTypeName(this.getTypeName(p.getType()));
            list1.add(p);
        }
        if (list1 == null) {
            return new ArrayList<TrainPlan>();
        }
        return list1;
    }

    public List<TrainPlan> getOccHealthTrainByYear(Long cid, Integer year) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("year", year);
        params.put("cid", cid);
        params.put("type", "1");
        List<TrainPlan> list = this.trainPlanMapper.listOfOccTrainPlan(params);
        if (list == null) {
            return new ArrayList<TrainPlan>();
        }
        for (TrainPlan info : list) {
            if (info.getType() != null) {
                info.setTypeName(this.getTypeName(info.getType()));
            }
            List books = this.trainPaperFileService.getByTidAndType(info.getId(), Byte.valueOf((byte)6));
            List exams = this.trainPaperFileService.getByTidAndType(info.getId(), Byte.valueOf((byte)7));
            List signFiles = this.trainPaperFileService.getByTidAndType(info.getId(), Byte.valueOf((byte)1));
            List scoreFiles = this.trainPaperFileService.getByTidAndType(info.getId(), Byte.valueOf((byte)2));
            List medioFiles = this.trainPaperFileService.getByTidAndType(info.getId(), Byte.valueOf((byte)3));
            info.setSignFiles(signFiles);
            info.setScoreFiles(scoreFiles);
            info.setMedioFiles(medioFiles);
            info.setExams(exams);
            info.setBooks(books);
            List<TrainAttend> attlist = this.getAttendTrainDept(cid, info.getId());
            Object deptName = null;
            if (attlist != null && attlist.size() > 0) {
                for (TrainAttend att : attlist) {
                    if (att == null || att.getDeptName() == null) continue;
                    if (deptName == null) {
                        deptName = att.getDeptName();
                        continue;
                    }
                    deptName = (String)deptName + "," + att.getDeptName();
                }
            }
            info.setAttendDepts(deptName);
        }
        return list;
    }

    public List<TrainPlan> getOccHealthTrainByYearPre(Long cid, Integer year) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("year", year);
        params.put("cid", cid);
        params.put("type", "1");
        List<TrainPlan> list = this.trainPlanMapper.listOfOccTrainPlan(params);
        if (list == null) {
            return new ArrayList<TrainPlan>();
        }
        for (TrainPlan info : list) {
            if (info.getType() != null) {
                info.setTypeName(this.getTypeName(info.getType()));
            }
            List books = this.trainPaperFileService.getByTidAndType(info.getId(), Byte.valueOf((byte)6));
            List exams = this.trainPaperFileService.getByTidAndType(info.getId(), Byte.valueOf((byte)7));
            List signFiles = this.trainPaperFileService.getByTidAndType(info.getId(), Byte.valueOf((byte)1));
            List scoreFiles = this.trainPaperFileService.getByTidAndType(info.getId(), Byte.valueOf((byte)2));
            List medioFiles = this.trainPaperFileService.getByTidAndType(info.getId(), Byte.valueOf((byte)3));
            ArrayList btFiles = new ArrayList();
            ArrayList otherFile = new ArrayList();
            otherFile.addAll(signFiles);
            otherFile.addAll(scoreFiles);
            otherFile.addAll(medioFiles);
            info.setBtFiles(btFiles);
            info.setSignFiles(otherFile);
            info.setExams(exams);
            info.setBooks(books);
            List<TrainAttend> attlist = this.getAttendTrainDept(cid, info.getId());
            Object deptName = null;
            if (attlist != null && attlist.size() > 0) {
                for (TrainAttend att : attlist) {
                    if (att == null || att.getDeptName() == null) continue;
                    if (deptName == null) {
                        deptName = att.getDeptName();
                        continue;
                    }
                    deptName = (String)deptName + "," + att.getDeptName();
                }
            }
            info.setAttendDepts(deptName);
        }
        return list;
    }

    private String getTypeName(String type) {
        Object typeName = null;
        if (!StringUtils.isEmpty((CharSequence)type)) {
            List types = new ArrayList();
            types = StringUtils.parseToIntegerList((String)type, (String)",");
            Iterator iterator = types.iterator();
            while (iterator.hasNext()) {
                int t = (Integer)iterator.next();
                for (TrainPlanTypeEnum tpType : TrainPlanTypeEnum.values()) {
                    if ((byte)t != tpType.getCode()) continue;
                    typeName = typeName == null ? tpType.getName() : (String)typeName + "," + tpType.getName();
                }
            }
            return typeName;
        }
        return null;
    }

    public List<CertificateStaffDetail> getManagerCertByYear(Long cid, Integer year) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("year", year);
        params.put("cid", cid);
        List<CertificateStaffDetail> list = this.certificateStaffDetailMapper.getHseCertByYear(params);
        if (list == null) {
            return new ArrayList<CertificateStaffDetail>();
        }
        int serial = 1;
        for (CertificateStaffDetail certUser : list) {
            Object filename = null;
            String staffName = certUser.getStaffName();
            certUser.setSerial(Integer.valueOf(serial));
            ++serial;
            List files = this.certificateFilesService.getByCerid(certUser.getId());
            if (files == null || files.size() == 0) continue;
            certUser.setFiles(files);
            for (CertificateFiles file : files) {
                if (filename == null) {
                    filename = file.getFileName();
                    continue;
                }
                filename = (String)filename + "," + file.getFileName();
            }
            certUser.setFilesName(filename);
            certUser.setFiles(files);
        }
        return list;
    }

    public List<TrainSummarize> getTrainSummarizeByYear(Long cid, Integer year) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("year", year);
        params.put("cid", cid);
        List<TrainSummarize> list = this.trainSummarizeMapper.getTrainSummByYear(params);
        if (list == null || list.size() < 1) {
            return new ArrayList<TrainSummarize>();
        }
        for (TrainSummarize summ : list) {
            List paperList = this.trainPaperFileService.getBySummarizeId(summ.getId());
            summ.setFileList(paperList);
            if (summ.getOutlay() != null) {
                summ.setBudget(String.valueOf(summ.getOutlay()) + "\u4e07\u5143");
                continue;
            }
            summ.setBudget("");
        }
        return list;
    }

    public List<TrainAttend> getAttendTrainDept(Long cid, Long tid) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("tid", tid);
        params.put("cid", cid);
        List<TrainAttend> list = this.trainAttendMapper.getAttendTrainDept(params);
        return list;
    }
}

