/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.train;

import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.health.dao.work.train.StaffOnlineTrainTestMapper;
import cn.smarthse.modules.health.entity.work.train.OnlineTrainTestAttendVo;
import cn.smarthse.modules.health.entity.work.train.StaffOnLineTrainTestSubmitVo;
import cn.smarthse.modules.health.entity.work.train.StaffOnlineTrainTest;
import cn.smarthse.modules.health.service.work.train.IStaffOnlineTrainTestService;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class StaffOnlineTrainTestServiceImpl
extends BaseServiceImpl<StaffOnlineTrainTestMapper, StaffOnlineTrainTest>
implements IStaffOnlineTrainTestService {
    @Transactional(readOnly=false)
    public void beginTest(StaffOnlineTrainTest test) {
        if (!this.getTestCountByStaffId(test.getStaffId(), test.getCid())) {
            test.setTestBeginDate(new Date());
            test.setTestBatchId(UUID.randomUUID().toString());
            this.add(test, test.getStaffId(), test.getCid());
        }
    }

    @Transactional(readOnly=false)
    public boolean submitTests(StaffOnLineTrainTestSubmitVo vo) {
        boolean flag = false;
        if (vo != null && vo.getTests() != null & vo.getTests().size() > 0) {
            Date curDate = new Date();
            if (((StaffOnlineTrainTest)vo.getTests().get(0)).getTestEndDate().getTime() - ((StaffOnlineTrainTest)vo.getTests().get(0)).getTestBeginDate().getTime() >= curDate.getTime() - ((StaffOnlineTrainTest)vo.getTests().get(0)).getTestBeginDate().getTime()) {
                flag = true;
            }
            vo.getTests().forEach(s -> {
                if (StringUtils.isEmpty((CharSequence)s.getQuestionAnswer()) || StringUtils.isEmpty((CharSequence)s.getQuestionRightAnswer())) {
                    s.setIsRight(Boolean.valueOf(false));
                } else if (s.getQuestionAnswer().equals(s.getQuestionRightAnswer())) {
                    s.setIsRight(Boolean.valueOf(true));
                } else {
                    s.setIsRight(Boolean.valueOf(false));
                }
                s.setTestEndDate(curDate);
                this.add(s, s.getStaffId(), s.getCid());
            });
        }
        return flag;
    }

    public List<StaffOnlineTrainTest> getLastTestByStaffId(Long trainId, Long staffId, Long cid) {
        return ((StaffOnlineTrainTestMapper)this.dao).getTestsByStaffId(trainId, staffId, cid);
    }

    public List<OnlineTrainTestAttendVo> getNeedAttends(Long cid) {
        List<OnlineTrainTestAttendVo> list = ((StaffOnlineTrainTestMapper)this.dao).getNeedAttends(cid);
        list.forEach(s -> {
            if (StringUtils.isNotEmpty((String)s.getAttends())) {
                s.setAttends(Arrays.stream(s.getAttends().split(",")).filter(a -> StringUtils.isNumber((String)a)).collect(Collectors.joining(",")));
            }
        });
        return list;
    }

    public Boolean isPassTestByStaffId(Long trainId, Long staffId, Long cid) {
        return ((StaffOnlineTrainTestMapper)this.dao).isPassTestByStaffId(trainId, staffId, cid);
    }

    private boolean getTestCountByStaffId(Long staffId, Long cid) {
        Example e = new Example(StaffOnlineTrainTest.class);
        e.createCriteria().andEqualTo("isValid", (Object)true).andEqualTo("staffId", (Object)staffId).andEqualTo("cid", (Object)cid);
        boolean flag = false;
        if (this.getCountByExample(e) > 0) {
            StaffOnlineTrainTest test = ((StaffOnlineTrainTestMapper)this.dao).getLastTestByStaffId(staffId, cid);
            flag = true;
        }
        return flag;
    }
}

