/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.thirdtime.simple;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.database.persistence.LayUiResponseResult;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.datacentre.entity.Company;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.health.compliance.enums.ComplianceCodeEnum;
import cn.smarthse.modules.health.compliance.service.IBusinessDataUpdateRefreshService;
import cn.smarthse.modules.health.compliance.service.IComplianceScoreRefreshService;
import cn.smarthse.modules.health.component.event.HomeDataEvent;
import cn.smarthse.modules.health.dao.litearchive.LiteArchiveMapper;
import cn.smarthse.modules.health.dao.work.thirdtime.LiteArchiveTsLinkMapper;
import cn.smarthse.modules.health.dao.work.thirdtime.simple.TsProjectSimpleMapper;
import cn.smarthse.modules.health.entity.base.staff.StaffInfo;
import cn.smarthse.modules.health.entity.litearchive.LiteArchive;
import cn.smarthse.modules.health.entity.work.thirdtime.LiteArchiveTsLink;
import cn.smarthse.modules.health.entity.work.thirdtime.TsProjectSimple;
import cn.smarthse.modules.health.enums.homedata.HomeDataEventEnum;
import cn.smarthse.modules.health.enums.reform.ReformGenerationSourceEnum;
import cn.smarthse.modules.health.enums.reform.ReformStatusEnum;
import cn.smarthse.modules.health.enums.thirdtime.TsProjectSimpleDataSourceEnum;
import cn.smarthse.modules.health.enums.thirdtime.TsProjectSimpleRelatedEnum;
import cn.smarthse.modules.health.enums.thirdtime.TsProjectSimpleStatusEnum;
import cn.smarthse.modules.health.param.SearchParam;
import cn.smarthse.modules.health.param.threeTime.EditParam;
import cn.smarthse.modules.health.pojo.ComplianceTsProjectCount;
import cn.smarthse.modules.health.pojo.self.TsProjectInfo;
import cn.smarthse.modules.health.service.base.ICompanyService;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.litearchive.ILiteArchiveService;
import cn.smarthse.modules.health.service.litearchive.simple.ILiteArchiveSimpleService;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicService;
import cn.smarthse.modules.health.service.work.thirdtime.ILiteArchiveTsLinkService;
import cn.smarthse.modules.health.service.work.thirdtime.simple.ITsProjectSimpleService;
import cn.smarthse.modules.health.supervise.entity.keyFactory.KeyFactory;
import cn.smarthse.modules.health.supervise.entity.keyFactory.KeyFactoryApprovalHistory;
import cn.smarthse.modules.health.supervise.enums.keyFactory.HistoryStatusEnum;
import cn.smarthse.modules.health.supervise.enums.keyFactory.KeyFactoryStatusEnum;
import cn.smarthse.modules.health.supervise.enums.keyFactory.KeyFactoryTypeEnum;
import cn.smarthse.modules.health.supervise.service.keyFactory.IKeyFactoryApprovalHistoryService;
import cn.smarthse.modules.health.supervise.service.keyFactory.IKeyFactoryService;
import cn.smarthse.modules.health.thirdOrganization.util.StringUtil;
import cn.smarthse.services.wanda.api.entity.threeTime.ThreeTimeData;
import cn.smarthse.services.wanda.api.service.threeTime.IThreeTimeDataService;
import com.alibaba.fastjson.JSON;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.smarthse.exception.ServiceException;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.annotation.Lazy;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class TsProjectSimpleServiceImpl
extends BaseServiceImpl<TsProjectSimpleMapper, TsProjectSimple>
implements ITsProjectSimpleService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TsProjectSimpleServiceImpl.class);
    @Autowired
    private ILiteArchiveSimpleService liteArchiveSimpleService;
    @Autowired
    private ApplicationContext ac;
    @DubboReference
    IThreeTimeDataService threeTimeDataService;
    @Autowired(required=false)
    @Lazy
    private ILiteArchiveTsLinkService liteArchiveTsLinkService;
    @Autowired
    ICompanyService companyService;
    @Autowired
    IReformItemBasicService reformItemBasicService;
    @Autowired
    private DataSourceTransactionManager txManager;
    @DubboReference
    IKeyFactoryService keyFactoryService;
    @DubboReference
    IKeyFactoryApprovalHistoryService keyFactoryApprovalHistoryService;
    @DubboReference
    ISysFileProvideService sysFileProvideService;
    @Autowired
    private RedissonClient redissonClient;
    @DubboReference
    IComplianceScoreRefreshService scoreRefreshService;
    @DubboReference
    IBusinessDataUpdateRefreshService businessDataUpdateRefreshService;
    @Autowired
    IStaffInfoService staffInfoService;
    @Autowired
    ILiteArchiveService liteArchiveService;

    public PageInfo<TsProjectSimple> pageTsProjectSimple(JqGridParam param, Integer year, Byte type) {
        TsProjectSimple paramts = new TsProjectSimple();
        paramts.setCid(param.getCid());
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<TsProjectSimple> tsProjectSimpleList = ((TsProjectSimpleMapper)this.dao).pageTsProjectSimple(param.getCid(), year, type);
        return new PageInfo(tsProjectSimpleList);
    }

    @Transactional(readOnly=false)
    public TsProjectSimple saveOrUpdateTsProject(TsProjectSimple tsProjectSimple, Long loginStaffId, Long cid) throws Exception {
        this.verifyParam(tsProjectSimple);
        if (tsProjectSimple.getId() != null) {
            TsProjectSimple oldTsProjectSimple = (TsProjectSimple)this.getById(tsProjectSimple.getId());
            LiteArchiveTsLink link = this.liteArchiveTsLinkService.getTsLinkByTs(oldTsProjectSimple.getId());
            if (link == null) {
                this.liteArchiveSimpleService.addThreeArchiveSimple(tsProjectSimple, loginStaffId, cid);
            }
            if (!oldTsProjectSimple.getProjectName().equals(tsProjectSimple.getProjectName())) {
                this.liteArchiveSimpleService.updateThreeArchiveSimple(tsProjectSimple, loginStaffId);
            }
            this.update(tsProjectSimple, loginStaffId);
            ((TsProjectSimpleMapper)this.dao).updateStates(tsProjectSimple);
        } else {
            tsProjectSimple.setIsValid(Boolean.valueOf(true));
            tsProjectSimple = this.add(tsProjectSimple, loginStaffId, cid);
            this.liteArchiveSimpleService.addThreeArchiveSimple(tsProjectSimple, loginStaffId, cid);
        }
        this.ac.publishEvent((ApplicationEvent)new HomeDataEvent(cid, HomeDataEventEnum.THIRD_TIME));
        return tsProjectSimple;
    }

    @Transactional(readOnly=false)
    public void delTsProject(TsProjectSimple tsProjectSimple, Long loginStaffId) throws Exception {
        tsProjectSimple.setIsValid(Global.FALSE);
        this.liteArchiveSimpleService.updateThreeArchiveSimple(tsProjectSimple, loginStaffId);
        this.delete(tsProjectSimple, loginStaffId);
        this.ac.publishEvent((ApplicationEvent)new HomeDataEvent(tsProjectSimple.getCid(), HomeDataEventEnum.THIRD_TIME));
    }

    public Map<String, Map<Integer, Integer>> getCountForVisualize(Long cid) {
        String[] thirdTimeArr = new String[]{"\u9884\u8bc4", "\u5b9e\u65bd", "\u63a7\u8bc4"};
        int yearCurr = LocalDateTime.now().getYear();
        HashMap<String, Map<Integer, Integer>> map = new HashMap<String, Map<Integer, Integer>>();
        List<Object> countMap = new ArrayList();
        for (int type = 0; type < thirdTimeArr.length; ++type) {
            if (type == 0) {
                countMap = ((TsProjectSimpleMapper)this.dao).getHarmEvalCount(cid, yearCurr);
            } else if (type == 1) {
                countMap = ((TsProjectSimpleMapper)this.dao).getDesignCount(cid, yearCurr);
            } else if (type == 2) {
                countMap = ((TsProjectSimpleMapper)this.dao).getConCount(cid, yearCurr);
            }
            Map<Integer, Integer> converMap = this.converMap(countMap);
            map.put(thirdTimeArr[type], converMap);
        }
        return map;
    }

    private Map<Integer, Integer> converMap(List<Map<Integer, Integer>> countMap) {
        HashMap<Integer, Integer> converMap = new HashMap<Integer, Integer>();
        if (countMap == null) {
            return converMap;
        }
        for (Map<Integer, Integer> map : countMap) {
            converMap.put(map.get("year"), map.get("num"));
        }
        return converMap;
    }

    private void verifyParam(TsProjectSimple tsProjectSimple) throws Exception {
        if (StringUtils.isEmpty((CharSequence)tsProjectSimple.getProjectName())) {
            throw new Exception("\u9879\u76ee\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (tsProjectSimple.getProjectTime() == null) {
            throw new Exception("\u9879\u76ee\u7acb\u9879\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public LayUiResponseResult<TsProjectSimple> pageList(SearchParam param) {
        PageHelper.startPage((int)param.getPageNum(), (int)param.getPageSize());
        List<TsProjectSimple> list = ((TsProjectSimpleMapper)this.dao).list(param);
        for (TsProjectSimple ts : list) {
            if (ts.getStatus() == null || !Objects.equals(TsProjectSimpleStatusEnum.BACK.getCode(), ts.getStatus())) continue;
            ts.setReason(this.keyFactoryApprovalHistoryService.getReasonByBusinessId(ts.getId()));
        }
        PageInfo pageInfo = new PageInfo(list);
        return LayUiResponseResult.success((PageInfo)pageInfo);
    }

    public List<TsProjectSimple> list(SearchParam param) {
        List<TsProjectSimple> list = ((TsProjectSimpleMapper)this.dao).list(param);
        return CollectionUtils.isEmpty(list) ? Collections.emptyList() : list;
    }

    @Transactional
    public void syncData(Long cid) {
        List cidList = this.threeTimeDataService.getCidList(Integer.valueOf(50000), cid);
        if (CollUtil.isEmpty((Collection)cidList)) {
            return;
        }
        List irsList1 = this.threeTimeDataService.getProjectListByStorageDate(cidList);
        List irsList2 = this.threeTimeDataService.getProjectListByNowProjSituation(cidList);
        List irsList = Stream.concat(irsList1.stream(), irsList2.stream()).distinct().collect(Collectors.toList());
        int i = 0;
        while (CollUtil.isNotEmpty(irsList)) {
            log.error("\u65e5\u5fd7\u6253\u5370::\u7b2c{}\u6279\u4e09\u540c\u65f6\u540c\u6b65\u6570\u636e::{}", (Object)(++i), irsList);
            ArrayList<TsProjectSimple> projectModList = new ArrayList<TsProjectSimple>();
            ArrayList<LiteArchive> archiveList = new ArrayList<LiteArchive>();
            ArrayList<LiteArchiveTsLink> linkList = new ArrayList<LiteArchiveTsLink>();
            List<TsProjectSimple> projectList = irsList.stream().filter(d -> DateUtils.getYear((Date)d.getApplyDate()) >= 2021).peek(d -> d.setIsSync(Boolean.TRUE)).map(this::convertToTsProjectSimple).distinct().collect(Collectors.toList());
            if (CollUtil.isNotEmpty(projectList)) {
                Set<Long> cidSet = projectList.stream().map(TsProjectSimple::getCid).collect(Collectors.toSet());
                List<TsProjectSimple> dbProjectList = this.getTsListByCid(cidSet);
                dbProjectList.forEach(dbProj -> projectList.removeIf(proj -> this.chooseNeedUpdateProjectList((TsProjectSimple)proj, (TsProjectSimple)dbProj, (List<TsProjectSimple>)projectModList)));
            }
            this.prepareArchiveData(projectList, archiveList, linkList);
            ArrayList<ThreeTimeData> threeTimeList = new ArrayList<ThreeTimeData>(irsList);
            ArrayList<TsProjectSimple> projectAddList = new ArrayList<TsProjectSimple>(projectList);
            log.error("\u65e5\u5fd7\u6253\u5370::\u7b2c{}\u6279\u4e09\u540c\u65f6\u540c\u6b65\u5f00\u59cb::{},{},{},{},{}", new Object[]{++i, threeTimeList.size(), projectAddList.size(), projectModList.size(), archiveList.size(), linkList.size()});
            this.performSyncData(threeTimeList, projectAddList, projectModList, archiveList, linkList);
            log.error("\u65e5\u5fd7\u6253\u5370::\u7b2c{}\u6279\u4e09\u540c\u65f6\u540c\u6b65\u7ed3\u675f::{},{},{},{},{}", new Object[]{++i, threeTimeList.size(), projectAddList.size(), projectModList.size(), archiveList.size(), linkList.size()});
            cidList.clear();
            irsList1.clear();
            irsList2.clear();
            irsList.clear();
            cidList = this.threeTimeDataService.getCidList(Integer.valueOf(2000), cid);
            irsList1 = this.threeTimeDataService.getProjectListByStorageDate(cidList);
            irsList2 = this.threeTimeDataService.getProjectListByNowProjSituation(cidList);
            irsList = Stream.concat(irsList1.stream(), irsList2.stream()).distinct().collect(Collectors.toList());
        }
    }

    private TsProjectSimple convertToTsProjectSimple(ThreeTimeData threeTime) {
        TsProjectSimple project = new TsProjectSimple();
        project.setId(Long.valueOf(this.idworker.nextId()));
        project.setCid(threeTime.getCid());
        project.setStatus(TsProjectSimpleStatusEnum.DRAFT.getCode());
        project.setProjectCode(threeTime.getProjectCode());
        project.setProjectName(threeTime.getProjectName());
        project.setProjectTime(threeTime.getApplyDate());
        project.setDataSource(TsProjectSimpleDataSourceEnum.WANDA.getCode());
        return project;
    }

    private boolean chooseNeedUpdateProjectList(TsProjectSimple proj, TsProjectSimple dbProj, List<TsProjectSimple> projectUpdateList) {
        boolean isComplete;
        boolean sameName;
        boolean sameCode = CharSequenceUtil.isNotBlank((CharSequence)proj.getProjectCode()) && StrUtil.equalsIgnoreCase((CharSequence)proj.getProjectCode(), (CharSequence)dbProj.getProjectCode()) && Objects.equals(dbProj.getDataSource(), TsProjectSimpleDataSourceEnum.WANDA.getCode()) && Objects.equals(proj.getCid(), dbProj.getCid());
        boolean bl = sameName = CharSequenceUtil.isBlank((CharSequence)dbProj.getProjectCode()) && StrUtil.equalsIgnoreCase((CharSequence)proj.getProjectName(), (CharSequence)dbProj.getProjectName()) && Objects.equals(dbProj.getDataSource(), TsProjectSimpleDataSourceEnum.WANDA.getCode()) && Objects.equals(proj.getCid(), dbProj.getCid());
        if (!sameCode && !sameName) {
            return Boolean.FALSE;
        }
        boolean bl2 = isComplete = Objects.equals(dbProj.getStatus(), TsProjectSimpleStatusEnum.AUDITED.getCode()) || Objects.equals(dbProj.getStatus(), TsProjectSimpleStatusEnum.NO_NEED_AUDITED.getCode());
        if (isComplete) {
            return Boolean.TRUE;
        }
        if (Objects.equals(dbProj.getStatus(), TsProjectSimpleStatusEnum.DRAFT.getCode())) {
            TsProjectSimple needUpdate = new TsProjectSimple();
            BeanUtils.copyProperties((Object)proj, (Object)needUpdate);
            needUpdate.setId(dbProj.getId());
            projectUpdateList.add(needUpdate);
        }
        return Boolean.TRUE;
    }

    private void performSyncData(List<ThreeTimeData> threeTimeList, List<TsProjectSimple> projectAddList, List<TsProjectSimple> projectModList, List<LiteArchive> archiveList, List<LiteArchiveTsLink> linkList) {
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setPropagationBehavior(3);
        TransactionStatus status = this.txManager.getTransaction((TransactionDefinition)def);
        Date now = new Date();
        try {
            if (CollUtil.isNotEmpty(threeTimeList)) {
                threeTimeList.forEach(data -> {
                    data.setIsSync(Boolean.TRUE);
                    data.setUpdateDate(now);
                });
                this.threeTimeDataService.updateBatchById(threeTimeList);
            }
            if (CollUtil.isNotEmpty(projectAddList)) {
                this.batchUpdateOrInsert(projectAddList, TsProjectSimpleMapper.class, (item, mapper) -> mapper.insertDb((TsProjectSimple)item));
                this.liteArchiveSimpleService.batchUpdateOrInsert(archiveList, LiteArchiveMapper.class, (item, mapper) -> mapper.insertDb((LiteArchive)item));
                this.liteArchiveTsLinkService.batchUpdateOrInsert(linkList, LiteArchiveTsLinkMapper.class, (item, mapper) -> mapper.insertDb((LiteArchiveTsLink)item));
            }
            if (CollUtil.isNotEmpty(projectModList)) {
                this.batchUpdateOrInsert(projectModList, TsProjectSimpleMapper.class, (item, mapper) -> mapper.updateDb((TsProjectSimple)item));
            }
            this.txManager.commit(status);
        }
        catch (Exception e) {
            this.txManager.rollback(status);
            this.logger.error("\u3010\u4e09\u540c\u65f6\u6570\u636e\u540c\u6b65\u5f02\u5e38\u3011", (Throwable)e);
            throw new ServiceException("\u4e09\u540c\u65f6\u6570\u636e\u540c\u6b65\u5f02\u5e38", (Throwable)e);
        }
    }

    @Transactional(readOnly=false)
    public void deleteSyncData(Long cid) {
        Example example = new Example(TsProjectSimple.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("isValid", (Object)true).andEqualTo("dataSource", (Object)2);
        if (cid != null) {
            criteria.andEqualTo("cid", (Object)cid);
        }
        List tsProjectSimpleList = this.getListByExample(example);
        Set cidSet = tsProjectSimpleList.stream().map(TsProjectSimple::getCid).collect(Collectors.toSet());
        List threeTimeDataList = this.threeTimeDataService.listByCIdSet(cidSet);
        ArrayList<Long> tsId = new ArrayList<Long>();
        for (TsProjectSimple tsProjectSimple : tsProjectSimpleList) {
            if (!this.hasData(threeTimeDataList, tsProjectSimple.getProjectName()).booleanValue() || !TsProjectSimpleStatusEnum.DRAFT.getCode().equals(tsProjectSimple.getStatus())) continue;
            tsId.add(tsProjectSimple.getId());
        }
        if (CollectionUtils.isNotEmpty(tsId)) {
            ((TsProjectSimpleMapper)this.dao).logicDel(tsId);
        }
    }

    private Boolean hasData(List<ThreeTimeData> threeTimeDataList, String projectName) {
        ThreeTimeData threeTimeData = threeTimeDataList.stream().filter(item -> item.getProjectName().equalsIgnoreCase(projectName)).findFirst().orElse(null);
        return Objects.isNull(threeTimeData);
    }

    private ThreeTimeData getByName(List<ThreeTimeData> threeTimeDataList, String projectName) {
        return threeTimeDataList.stream().filter(item -> item.getProjectName().equalsIgnoreCase(projectName)).findFirst().orElse(null);
    }

    private List<TsProjectSimple> getTsListByCid(Set<Long> cidSet) {
        if (CollUtil.isEmpty(cidSet)) {
            return Collections.emptyList();
        }
        Example example = new Example(TsProjectSimple.class);
        example.createCriteria().andEqualTo("isValid", (Object)Boolean.TRUE).andIn("cid", cidSet);
        return this.getListByExample(example);
    }

    public TsProjectInfo getFinishAndTotalNum(Long cid) {
        TsProjectInfo finishAndTotalNum = ((TsProjectSimpleMapper)this.dao).getFinishAndTotalNum(cid);
        int num = this.reformItemBasicService.getUnReformNumByCid(cid, ReformGenerationSourceEnum.THREE_TIME);
        finishAndTotalNum.setHasReform(Boolean.valueOf(num > 0));
        return finishAndTotalNum;
    }

    @Transactional(readOnly=false)
    public void close(TsProjectSimple dbData, Company currentCompany, StaffInfo loginStaff) {
        dbData.setStatus(TsProjectSimpleStatusEnum.CLOSED.getCode());
        dbData.setIsClose(Boolean.valueOf(true));
        KeyFactory keyFactory = this.keyFactoryService.getByBusinessId(dbData.getId());
        keyFactory.setStatus(KeyFactoryStatusEnum.CLOSED.getCode());
        this.keyFactoryService.update((Object)keyFactory);
        this.update(dbData);
        this.keyFactoryApprovalHistoryService.addCloseRecord(currentCompany, loginStaff, dbData.getId(), KeyFactoryTypeEnum.THREE_TIME);
        this.reformItemBasicService.changeStatusByCidAndGenerationSource(currentCompany.getId(), ReformGenerationSourceEnum.THREE_TIME.getValue(), ReformStatusEnum.DYS.getValue(), loginStaff.getId(), null);
    }

    public int countClosedNum(Long cid) {
        Example example = new Example(TsProjectSimple.class);
        example.createCriteria().andEqualTo("isValid", (Object)true).andEqualTo("cid", (Object)cid).andEqualTo("status", (Object)TsProjectSimpleStatusEnum.CLOSED.getCode());
        return this.getCountByExample(example);
    }

    public int countLast2YearNum(Long cid) {
        return ((TsProjectSimpleMapper)this.dao).countLast2YearNum(cid);
    }

    public TsProjectSimple getDetailById(Long id) {
        ThreeTimeData threeTimeData;
        TsProjectSimple simple = (TsProjectSimple)this.getById(id);
        if (simple.getDataSource() != null && simple.getDataSource() == 2 && StringUtil.isEmpty((String)simple.getScaleContent()) && Objects.nonNull(threeTimeData = this.threeTimeDataService.getByCidAndProjectName(simple.getCid(), simple.getProjectName()))) {
            simple.setScaleContent(threeTimeData.getScaleContent());
        }
        this.setFiles(simple);
        return simple;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(readOnly=false)
    public TsProjectSimple saveInfo(TsProjectSimple tsProjectSimple, EditParam param) throws Exception {
        RLock lock = this.redissonClient.getLock("keyFactor:tsProjectSimple:" + tsProjectSimple.getId() + ":hot");
        if (lock.tryLock()) {
            try {
                Long keyFactoryId = this.saveInfoDetail(tsProjectSimple, param);
                tsProjectSimple.setKeyFactoryId(keyFactoryId);
            }
            finally {
                lock.unlock();
            }
        } else {
            this.logger.error("\u672a\u83b7\u5f97\u9501\u8d44\u6e90keyFactor:tsProjectSimple id:{}", (Object)tsProjectSimple.getId());
        }
        return tsProjectSimple;
    }

    public Long saveInfoDetail(TsProjectSimple tsProjectSimple, EditParam param) throws Exception {
        Long keyFactoryId = null;
        TsProjectSimple dbData = null;
        if (param.getId() != null) {
            dbData = (TsProjectSimple)this.getById(param.getId());
        }
        Company currentCompany = param.getCurrentCompany();
        StaffInfo staffInfo = param.getStaffInfo();
        tsProjectSimple = this.saveOrUpdateTsProject(tsProjectSimple, staffInfo.getId(), currentCompany.getId());
        if (param.getEditType() == 2) {
            if (!param.getIsComplete().booleanValue()) {
                this.keyFactoryApprovalHistoryService.addNewRecord(currentCompany, staffInfo, tsProjectSimple.getId(), KeyFactoryTypeEnum.THREE_TIME);
                keyFactoryId = this.keyFactoryService.submitKeyFactory(currentCompany, staffInfo.getId(), tsProjectSimple.getId(), KeyFactoryTypeEnum.THREE_TIME);
            } else {
                this.liteArchiveService.syncTsProjectArchive(tsProjectSimple);
                if (dbData != null && (TsProjectSimpleStatusEnum.BACK.getCode().equals(dbData.getStatus()) || TsProjectSimpleStatusEnum.AUDITED.getCode().equals(dbData.getStatus()))) {
                    KeyFactory keyFactory = this.keyFactoryService.getByBusinessId(dbData.getId());
                    keyFactoryId = keyFactory.getId();
                    keyFactory.setStatus(KeyFactoryStatusEnum.NOT_NEED_AUDIT.getCode());
                    this.keyFactoryService.update((Object)keyFactory);
                    KeyFactoryApprovalHistory his = this.addPassRecord(dbData.getId(), staffInfo, currentCompany);
                    this.keyFactoryApprovalHistoryService.add((Object)his);
                } else {
                    keyFactoryId = this.keyFactoryService.submitNotNeedAudit(currentCompany, staffInfo.getId(), tsProjectSimple.getId(), KeyFactoryTypeEnum.THREE_TIME);
                    KeyFactoryApprovalHistory his = this.addPassRecord(tsProjectSimple.getId(), staffInfo, currentCompany);
                    this.keyFactoryApprovalHistoryService.add((Object)his);
                }
                this.businessDataUpdateRefreshService.addBusinessDataUpdateMsg(currentCompany.getId(), null, new ComplianceCodeEnum[]{ComplianceCodeEnum.CODE04});
            }
            this.reformItemBasicService.changeStatusByCidAndGenerationSource(currentCompany.getId(), ReformGenerationSourceEnum.THREE_TIME.getValue(), null, staffInfo.getId(), null);
            this.reformItemBasicService.changeStatusByCidAndGenerationSource(currentCompany.getId(), ReformGenerationSourceEnum.ARCHIVES.getValue(), null, staffInfo.getId(), null);
        }
        return keyFactoryId;
    }

    @Transactional(readOnly=false)
    public void superviseBack2Default(Long id, Long loginStaffId, String superviseFullName) throws Exception {
        TsProjectSimple dbData = (TsProjectSimple)this.getById(id);
        if (dbData == null) {
            throw new RuntimeException("\u4f20\u5165id\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5");
        }
        if (dbData.getStatus() == null || !TsProjectSimpleStatusEnum.NO_NEED_AUDITED.getCode().equals(dbData.getStatus())) {
            throw new RuntimeException("\u53ea\u6709\u65e0\u9700\u5f00\u5c55\u7684\u9879\u76ee\u53ef\u4ee5\u9000\u56de\u5230\u8349\u7a3f");
        }
        dbData.setStatus(TsProjectSimpleStatusEnum.BACK.getCode());
        KeyFactory keyFactory = this.keyFactoryService.getByBusinessId(id);
        keyFactory.setStatus(KeyFactoryStatusEnum.BACK.getCode());
        this.keyFactoryService.update((Object)keyFactory);
        KeyFactoryApprovalHistory his = this.addBackRecord(loginStaffId, dbData, superviseFullName);
        this.keyFactoryApprovalHistoryService.add((Object)his);
        this.saveOrUpdateTsProject(dbData, loginStaffId, dbData.getCid());
    }

    public int countUnFinishNum(Long cid) {
        Example example = new Example(TsProjectSimple.class);
        example.createCriteria().andEqualTo("isValid", (Object)true).andEqualTo("cid", (Object)cid).andIn("status", Arrays.asList(TsProjectSimpleStatusEnum.DRAFT.getCode(), TsProjectSimpleStatusEnum.BACK.getCode(), TsProjectSimpleStatusEnum.AUDIT.getCode()));
        return this.getCountByExample(example);
    }

    public Boolean existFinishedProjects(Long cid, Date date) {
        Example example = new Example(TsProjectSimple.class);
        example.createCriteria().andEqualTo("isValid", (Object)true).andEqualTo("cid", (Object)cid).andLessThan("projectTime", (Object)date).andIn("status", Arrays.asList(3, 4));
        List listByExample = this.getListByExample(example);
        return CollectionUtils.isNotEmpty(listByExample);
    }

    @Transactional(rollbackFor={Exception.class})
    public void changeLastYearINGProjectStatus(Long cid) {
        Example example = new Example(TsProjectSimple.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("isValid", (Object)true).andIn("status", Arrays.asList(TsProjectSimpleStatusEnum.NO_NEED_AUDITED.getCode(), TsProjectSimpleStatusEnum.AUDITED.getCode())).andCondition("(eval_state = 3 OR design_state = 3 OR control_state = 3)");
        if (cid != null) {
            criteria.andEqualTo("cid", (Object)cid);
        }
        List tsProjectSimpleList = this.getListByExample(example);
        String backReason = "\u8fdb\u884c\u4e2d\u7684\u4e09\u540c\u65f6\u9879\u76ee\u5c06\u4e8e2025\u5e743\u67081\u65e5\u91cd\u65b0\u8bc6\u522b\u5e76\u63a8\u9001\u98ce\u9669\u3002";
        ArrayList<KeyFactory> keyFactoryList = new ArrayList<KeyFactory>();
        ArrayList<KeyFactoryApprovalHistory> operaLogList = new ArrayList<KeyFactoryApprovalHistory>();
        for (TsProjectSimple ts : tsProjectSimpleList) {
            ts.setStatus(TsProjectSimpleStatusEnum.BACK.getCode());
            ts.setRemark(backReason);
            ts.setEvalStateOld(ts.getEvalState());
            ts.setDesignStateOld(ts.getDesignState());
            ts.setControlStateOld(ts.getControlState());
            KeyFactory keyFactory = new KeyFactory();
            keyFactory.setBusinessId(ts.getId());
            keyFactory.setStatus(KeyFactoryStatusEnum.BACK.getCode());
            keyFactoryList.add(keyFactory);
            KeyFactoryApprovalHistory operaLog = new KeyFactoryApprovalHistory();
            operaLog.setStatus(HistoryStatusEnum.BACK.getCode());
            operaLog.setType(KeyFactoryTypeEnum.THREE_TIME.getCode());
            operaLog.setOperator("\u7cfb\u7edf");
            operaLog.setOperatorCompanyName("/");
            operaLog.setCid(ts.getCid());
            operaLog.setBusinessId(ts.getId());
            operaLog.setReason(backReason);
            operaLogList.add(operaLog);
        }
        this.batchUpdateOrInsert(tsProjectSimpleList, TsProjectSimpleMapper.class, (item, mapper) -> mapper.updateByPrimaryKey(item));
        this.keyFactoryService.batchUpdate(keyFactoryList);
        this.keyFactoryApprovalHistoryService.addRecord(operaLogList);
    }

    public List<ComplianceTsProjectCount> getComplianceTsProjectCount(List<Long> cids, Integer recentYears) {
        if (CollectionUtils.isEmpty(cids)) {
            return Collections.emptyList();
        }
        return ((TsProjectSimpleMapper)this.dao).getComplianceTsProjectCount(cids, recentYears);
    }

    public TsProjectSimple getTsProjectSimpleByArchiveId(Long archiveId) {
        if (archiveId == null) {
            return null;
        }
        return ((TsProjectSimpleMapper)this.dao).getTsProjectSimpleByArchiveId(archiveId);
    }

    public TsProjectSimple getByProjectCode(String projectCode) {
        Example example = new Example(TsProjectSimple.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("isValid", (Object)true).andEqualTo("projectCode", (Object)projectCode);
        TsProjectSimple ts = (TsProjectSimple)this.getOneByExample(example);
        if (ts == null) {
            ts = new TsProjectSimple();
        }
        return ts;
    }

    public List<TsProjectSimple> getNewGuideProjectList(List<Long> cidList, Boolean isValid) {
        Example example = new Example(TsProjectSimple.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andIn("newCompanyGuideRelated", Arrays.asList(0, 1)).andIn("cid", cidList);
        if (isValid != null) {
            criteria.andEqualTo("isValid", (Object)isValid);
        }
        return this.getListByExample(example);
    }

    @Transactional
    public void submitNewCompanyGuideTsProject(Long projectId, Company company, StaffInfo loginStaff) throws Exception {
        TsProjectSimple tsProjectSimple = (TsProjectSimple)this.getById(projectId);
        if (tsProjectSimple == null) {
            throw new RuntimeException("\u4e09\u540c\u65f6\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u4f20\u53c2");
        }
        if (!TsProjectSimpleStatusEnum.DRAFT.getCode().equals(tsProjectSimple.getStatus()) && !TsProjectSimpleStatusEnum.BACK.getCode().equals(tsProjectSimple.getStatus())) {
            throw new RuntimeException("\u4e09\u540c\u65f6\u5df2\u63d0\u4ea4\uff0c\u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4");
        }
        if (!TsProjectSimpleRelatedEnum.RELATED.getCode().equals(tsProjectSimple.getNewCompanyGuideRelated())) {
            throw new RuntimeException("\u8be5\u4e09\u540c\u65f6\u4e0d\u662f\u5173\u8054\u65b0\u5efa\u4f01\u4e1a\u7684\u4e09\u540c\u65f6\uff0c\u8bf7\u68c0\u67e5\u6570\u636e");
        }
        tsProjectSimple.setStatus(TsProjectSimpleStatusEnum.AUDIT.getCode());
        this.saveOrUpdateTsProject(tsProjectSimple, loginStaff.getId(), company.getId());
        this.keyFactoryApprovalHistoryService.addNewRecord(company, loginStaff, tsProjectSimple.getId(), KeyFactoryTypeEnum.THREE_TIME);
        this.keyFactoryService.submitKeyFactory(company, loginStaff.getId(), tsProjectSimple.getId(), KeyFactoryTypeEnum.THREE_TIME);
        this.businessDataUpdateRefreshService.addBusinessDataUpdateMsg(company.getId(), null, new ComplianceCodeEnum[]{ComplianceCodeEnum.CODE04});
    }

    @Transactional
    public void resetTsProject(Long cid) {
        Example e = new Example(TsProjectSimple.class);
        e.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("dataSource", (Object)TsProjectSimpleDataSourceEnum.TRAINING_BASE.getCode());
        List list = this.getListByExample(e);
        List collect = list.stream().map(db -> {
            TsProjectSimple ts = new TsProjectSimple();
            ts.setId(db.getId());
            ts.setProjectName(db.getProjectName());
            ts.setProjectTime(db.getProjectTime());
            ts.setDataSource(TsProjectSimpleDataSourceEnum.TRAINING_BASE.getCode());
            ts.setIsValid(Boolean.valueOf(true));
            return ts;
        }).collect(Collectors.toList());
        Long tsId = list.stream().map(TsProjectSimple::getId).distinct().collect(Collectors.toList()).stream().findFirst().orElse(null);
        if (CollectionUtils.isNotEmpty(collect)) {
            this.batchUpdateOrInsert(collect, TsProjectSimpleMapper.class, (item, mapper) -> mapper.updateByPrimaryKey(item));
        }
        if (tsId != null) {
            this.keyFactoryService.delByBusinessId(tsId);
            this.keyFactoryApprovalHistoryService.delByBusinessId(tsId);
        }
    }

    private KeyFactoryApprovalHistory addBackRecord(Long loginStaffId, TsProjectSimple dbData, String superviseFullName) {
        KeyFactoryApprovalHistory approvalNewRecord = new KeyFactoryApprovalHistory();
        approvalNewRecord.setCid(dbData.getCid());
        approvalNewRecord.setType(KeyFactoryTypeEnum.THREE_TIME.getCode());
        approvalNewRecord.setBusinessId(dbData.getId());
        approvalNewRecord.setUpdateDate(new Date());
        approvalNewRecord.setUpdateBy(loginStaffId);
        approvalNewRecord.setOperator(superviseFullName);
        approvalNewRecord.setOperatorCompanyName(superviseFullName);
        approvalNewRecord.setStatus(HistoryStatusEnum.BACK.getCode());
        return approvalNewRecord;
    }

    private KeyFactoryApprovalHistory addPassRecord(Long businessId, StaffInfo info, Company currentCompany) {
        KeyFactoryApprovalHistory his = new KeyFactoryApprovalHistory();
        his.setBusinessId(businessId);
        his.setType(KeyFactoryTypeEnum.THREE_TIME.getCode());
        if (his.getId() == null) {
            his.setId(Long.valueOf(this.idworker.nextId()));
        }
        his.setOperator(info.getStaffBasicInfo() == null ? null : info.getStaffBasicInfo().getRealName());
        his.setOperatorCompanyName(currentCompany.getName());
        his.setStatus(HistoryStatusEnum.NO_NEED_AUDITED.getCode());
        his.setUpdateBy(info.getId());
        his.setCreateBy(info.getId());
        his.setUpdateDate(new Date());
        his.setCreateDate(new Date());
        his.setIsValid(Boolean.valueOf(true));
        return his;
    }

    private void setFiles(TsProjectSimple tsProjectSimple) {
        List fileModelList;
        if (tsProjectSimple.getCommitment() != null) {
            tsProjectSimple.setFile(this.sysFileProvideService.getFileById(tsProjectSimple.getCommitment()));
        }
        if (tsProjectSimple.getEvidence() != null && CollectionUtils.isNotEmpty((Collection)(fileModelList = this.sysFileProvideService.getListByIds(tsProjectSimple.getEvidence())))) {
            fileModelList.forEach(file -> file.setIdStr("" + file.getId()));
            tsProjectSimple.setEvidenceFileList(fileModelList);
            String jsonString = JSON.toJSONString((Object)tsProjectSimple.getEvidenceFileList());
            tsProjectSimple.setEvidenceFileJsonString(jsonString);
        }
        if (!StringUtil.isEmpty((String)tsProjectSimple.getEvalEvidenceId1())) {
            tsProjectSimple.setEvalEvidenceFile1(this.sysFileProvideService.getFileById(Long.valueOf(Long.parseLong(tsProjectSimple.getEvalEvidenceId1()))));
        }
        if (!StringUtil.isEmpty((String)tsProjectSimple.getEvalEvidenceId2())) {
            tsProjectSimple.setEvalEvidenceFile2(this.sysFileProvideService.getFileById(Long.valueOf(Long.parseLong(tsProjectSimple.getEvalEvidenceId2()))));
        }
        if (!StringUtil.isEmpty((String)tsProjectSimple.getDesignEvidenceId())) {
            tsProjectSimple.setDesignEvidenceFile(this.sysFileProvideService.getFileById(Long.valueOf(Long.parseLong(tsProjectSimple.getDesignEvidenceId()))));
        }
        if (!StringUtil.isEmpty((String)tsProjectSimple.getControlEvidenceId1())) {
            tsProjectSimple.setControlEvidenceFile1(this.sysFileProvideService.getFileById(Long.valueOf(Long.parseLong(tsProjectSimple.getControlEvidenceId1()))));
        }
        if (!StringUtil.isEmpty((String)tsProjectSimple.getControlEvidenceId2())) {
            tsProjectSimple.setControlEvidenceFile2(this.sysFileProvideService.getFileById(Long.valueOf(Long.parseLong(tsProjectSimple.getControlEvidenceId2()))));
        }
    }

    private void prepareArchiveData(List<TsProjectSimple> projectList, List<LiteArchive> archiveList, List<LiteArchiveTsLink> linkList) {
        Date now = new Date();
        for (TsProjectSimple proj : projectList) {
            LiteArchive archive = new LiteArchive();
            archive.setId(Long.valueOf(this.idworker.nextId()));
            archive.setCid(proj.getCid());
            archive.setArchiveType(Integer.valueOf(1));
            archive.setArchiveUpdateTime(now);
            archive.setTitle(proj.getProjectName());
            archive.setStatus(Integer.valueOf(2));
            archive.setProcStatus(Integer.valueOf(0));
            archive.setIsValid(Boolean.TRUE);
            LiteArchiveTsLink link = new LiteArchiveTsLink();
            link.setId(Long.valueOf(this.idworker.nextId()));
            link.setTsId(proj.getId());
            link.setLiteArchiveId(archive.getId());
            link.setIsValid(Boolean.TRUE);
            archiveList.add(archive);
            linkList.add(link);
        }
    }

    @Transactional(readOnly=false)
    public int approval(KeyFactory keyFactory, Byte status) {
        TsProjectSimple tsProjectSimple = (TsProjectSimple)this.getById(keyFactory.getBusinessId());
        Byte statusTemp = null;
        if (status.equals(KeyFactoryStatusEnum.BACK.getCode())) {
            statusTemp = 1;
            tsProjectSimple.setStatus(TsProjectSimpleStatusEnum.BACK.getCode());
            if (tsProjectSimple.getMissingItem() != null) {
                tsProjectSimple.setMissingItem(null);
            }
        }
        if (status.equals(KeyFactoryStatusEnum.PASS.getCode())) {
            statusTemp = 3;
            tsProjectSimple.setStatus(TsProjectSimpleStatusEnum.AUDITED.getCode());
            tsProjectSimple.setIsFinish(Boolean.valueOf(true));
            this.liteArchiveService.syncTsProjectArchive(tsProjectSimple);
        }
        ((TsProjectSimpleMapper)this.dao).updateStatusItem(tsProjectSimple);
        this.reformItemBasicService.changeStatusByCidAndGenerationSource(keyFactory.getCid(), ReformGenerationSourceEnum.THREE_TIME.getValue(), statusTemp, keyFactory.getUpdateBy(), keyFactory.getBusinessId());
        this.reformItemBasicService.changeStatusByCidAndGenerationSource(keyFactory.getCid(), ReformGenerationSourceEnum.ARCHIVES.getValue(), statusTemp, keyFactory.getUpdateBy(), keyFactory.getBusinessId());
        return 1;
    }
}

