/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.thirdtime;

import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.CommonUtil;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.health.component.OssUploadComponent;
import cn.smarthse.modules.health.dao.work.thirdtime.LiteArchiveTsLinkMapper;
import cn.smarthse.modules.health.entity.litearchive.LiteArchive;
import cn.smarthse.modules.health.entity.work.thirdtime.LiteArchiveTsLink;
import cn.smarthse.modules.health.service.archive.impl.TsProjectArchiveService;
import cn.smarthse.modules.health.service.litearchive.ILiteArchiveFileItemService;
import cn.smarthse.modules.health.service.litearchive.ILiteArchiveFileNameService;
import cn.smarthse.modules.health.service.litearchive.ILiteArchiveService;
import cn.smarthse.modules.health.service.work.thirdtime.ILiteArchiveTsLinkService;
import cn.smarthse.modules.health.vo.litearchive.TsLiteArchiveVo;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class LiteArchiveTsLinkServiceImpl
extends BaseServiceImpl<LiteArchiveTsLinkMapper, LiteArchiveTsLink>
implements ILiteArchiveTsLinkService {
    @DubboReference
    private ISysFileProvideService fileService;
    @Autowired
    private TsProjectArchiveService tsProjectArchiveService;
    @Autowired
    private ILiteArchiveService liteArchiveService;
    @Autowired
    private ILiteArchiveFileItemService fileItemService;
    @Autowired
    private ILiteArchiveFileNameService fileNameService;
    @Autowired
    private OssUploadComponent ossUploadComponent;

    public String getEvaluateIdsByArchiveId(Long archiveId) {
        String evaluateIdsByArchiveId = ((LiteArchiveTsLinkMapper)this.dao).getEvaluateIdsByArchiveId(archiveId);
        return evaluateIdsByArchiveId;
    }

    public TsLiteArchiveVo getTsLiteArchiveVoByArchiveId(Long archiveId) {
        if (archiveId == null) {
            return null;
        }
        LiteArchive archive = (LiteArchive)this.liteArchiveService.getById(archiveId);
        if (archive == null) {
            return null;
        }
        TsLiteArchiveVo vo = new TsLiteArchiveVo();
        BeanUtils.copyProperties((Object)archive, (Object)vo);
        String evaluateIds = this.getEvaluateIdsByArchiveId(archiveId);
        if (StringUtils.isNotBlank((CharSequence)evaluateIds)) {
            // empty if block
        }
        return vo;
    }

    @Transactional(readOnly=false)
    public void delArchiveTsLink(Long liteAchiveId, Long loginUserId) {
        LiteArchive liteArchive = new LiteArchive();
        liteArchive.setId(liteAchiveId);
        this.liteArchiveService.delete((Object)liteArchive, loginUserId);
        Example e = new Example(LiteArchiveTsLink.class);
        e.createCriteria().andEqualTo("liteArchiveId", (Object)liteAchiveId);
        LiteArchiveTsLink link = new LiteArchiveTsLink();
        link.setIsValid(Boolean.valueOf(false));
        link.setUpdateBy(loginUserId);
        link.setUpdateDate(new Date());
        ((LiteArchiveTsLinkMapper)this.dao).updateByExampleSelective(link, e);
    }

    private void addEvaluateLink(Long liteArchiveId, String evaluteIds, Long loginUserId) {
        List evaluateIdList = CommonUtil.str2LongList((String)evaluteIds, (String)",");
        if (liteArchiveId != null && CollectionUtils.isNotEmpty((Collection)evaluateIdList)) {
            for (Long evaluateId : evaluateIdList) {
                LiteArchiveTsLink link = new LiteArchiveTsLink();
                link.setLiteArchiveId(liteArchiveId);
                link.setEvaluateId(evaluateId);
                this.add(link, loginUserId, null);
            }
        }
    }

    public void addTsLink(Long liteArchiveId, Long tsId, Long loginUserId) {
        Example e = new Example(LiteArchiveTsLink.class);
        e.createCriteria().andEqualTo("isValid", (Object)true).andEqualTo("tsId", (Object)tsId);
        int tsNum = this.getCountByExample(e);
        if (tsNum == 0) {
            LiteArchiveTsLink link = new LiteArchiveTsLink();
            link.setLiteArchiveId(liteArchiveId);
            link.setTsId(tsId);
            this.add(link, loginUserId, null);
        }
    }

    public int countTsLinkByEvaluate(List<Long> evaluateIdList) {
        if (CollectionUtils.isEmpty(evaluateIdList)) {
            return 0;
        }
        LiteArchiveTsLink tsLink = new LiteArchiveTsLink();
        Example e = new Example(LiteArchiveTsLink.class);
        e.createCriteria().andIn("evaluateId", evaluateIdList).andEqualTo("isValid", (Object)true);
        int count = ((LiteArchiveTsLinkMapper)this.dao).selectCountByExample(e);
        return count;
    }

    public LiteArchiveTsLink getTsLinkByTs(Long tsId) {
        if (tsId == null) {
            return null;
        }
        LiteArchiveTsLink tsLink = new LiteArchiveTsLink();
        Example e = new Example(LiteArchiveTsLink.class);
        e.createCriteria().andEqualTo("tsId", (Object)tsId).andEqualTo("isValid", (Object)true);
        LiteArchiveTsLink result = (LiteArchiveTsLink)((LiteArchiveTsLinkMapper)this.dao).selectOneByExample(e);
        return result;
    }

    public LiteArchiveTsLink getTsLinkByArchiveId(Long archiveId) {
        if (archiveId == null) {
            return null;
        }
        LiteArchiveTsLink tsLink = new LiteArchiveTsLink();
        Example e = new Example(LiteArchiveTsLink.class);
        e.createCriteria().andEqualTo("liteArchiveId", (Object)archiveId).andEqualTo("isValid", (Object)true).andIsNotNull("tsId");
        LiteArchiveTsLink result = (LiteArchiveTsLink)((LiteArchiveTsLinkMapper)this.dao).selectOneByExample(e);
        return result;
    }

    public List<LiteArchiveTsLink> getTsLinkByArchiveIdBatch(List<Long> archiveIdList) {
        Example e = new Example(LiteArchiveTsLink.class);
        e.createCriteria().andIn("liteArchiveId", archiveIdList).andEqualTo("isValid", (Object)Boolean.TRUE).andIsNotNull("tsId");
        return ((LiteArchiveTsLinkMapper)this.dao).selectByExample(e);
    }
}

