/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.shield;

import cn.smarthse.common.framework.service.datascope.DataScopeHelper;
import cn.smarthse.modules.health.entity.datascope.DataScope;
import cn.smarthse.modules.health.enums.sys.coreWork.CoreWorkEnum;
import cn.smarthse.modules.health.enums.sys.coreWork.TodlistInfoTypeEnum;
import cn.smarthse.modules.health.service.sys.ISysCoreWorkModuleCorrelationService;
import cn.smarthse.modules.health.service.work.shield.IShieldPurchaseService;
import cn.smarthse.modules.health.service.work.shield.IShieldSendService;
import cn.smarthse.modules.health.service.work.shield.IShieldTipService;
import cn.smarthse.modules.health.vo.shield.ShieldTipVO;
import cn.smarthse.modules.health.vo.summary.BaseSummaryVO;
import cn.smarthse.modules.health.vo.summary.ShieldSendSummaryVo;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@DubboService
@Transactional(readOnly=true)
public class ShieldTipServiceImpl
implements IShieldTipService {
    @Autowired
    IShieldSendService shieldSendService;
    @Autowired
    IShieldPurchaseService shieldPurchaseService;
    @Autowired
    ISysCoreWorkModuleCorrelationService sysService;

    @Transactional
    public ShieldTipVO getShieldTips(Long cid) {
        List workChanges;
        List diseases;
        int dayInterval = 180;
        byte status = 0;
        ShieldTipVO vo = new ShieldTipVO();
        int total = 0;
        DataScopeHelper.startDataScope("shield", "shield_send");
        DataScope dataScope = DataScopeHelper.getDataScope();
        int unfinishSend = this.shieldSendService.getListSize(cid, Byte.valueOf(status));
        DataScopeHelper.setDataScope(dataScope);
        int finishSend = this.shieldSendService.getListSize(cid, Byte.valueOf((byte)1));
        boolean isSendIgnored = this.sysService.hasMonthIgnoreData(TodlistInfoTypeEnum.personalProtectionEquipment_halfYearProvide, cid, 6);
        Boolean isNeedSend = isSendIgnored ? false : this.shieldSendService.isNeedSend(cid, dayInterval);
        dataScope.setMainTableName("shield_purchase");
        DataScopeHelper.setDataScope(dataScope);
        int unfinishPurchase = this.shieldPurchaseService.getListSize(cid, Byte.valueOf(status));
        DataScopeHelper.setDataScope(dataScope);
        int finishPurchase = this.shieldPurchaseService.getListSize(cid, Byte.valueOf((byte)1));
        boolean isPurchaseIgnored = this.sysService.hasMonthIgnoreData(TodlistInfoTypeEnum.personalProtectionEquipment_halfYearPruchase, cid, 6);
        Boolean isNeedPurchase = isPurchaseIgnored ? false : this.shieldPurchaseService.isNeedPurchase(cid, dayInterval);
        vo.setSendTotal(Integer.valueOf(unfinishSend + finishSend));
        vo.setPurchaseTotal(Integer.valueOf(unfinishPurchase + finishPurchase));
        if (unfinishSend > 0) {
            vo.setUnfinishSend(Integer.valueOf(unfinishSend));
        }
        if (isNeedSend != null && isNeedSend.booleanValue()) {
            ++total;
            vo.setIsNeedSend(isNeedSend);
        }
        if (unfinishPurchase > 0) {
            vo.setUnfinishPurchase(Integer.valueOf(unfinishPurchase));
        }
        if (isNeedPurchase != null && isNeedPurchase.booleanValue()) {
            ++total;
            vo.setIsNeedPurchase(isNeedPurchase);
        }
        if ((diseases = this.sysService.getListToRemind(CoreWorkEnum.threeSimultaneityManagement, CoreWorkEnum.personalProtectionEquipment, cid)) != null) {
            vo.setDiseases(diseases);
            total += diseases.size();
        }
        if ((workChanges = this.sysService.getListToRemind(CoreWorkEnum.harmfactorManagePost, CoreWorkEnum.personalProtectionEquipment, cid)) != null) {
            vo.setWorkChange(workChanges);
            total += workChanges.size();
        }
        vo.setTotal(Integer.valueOf(total));
        return vo;
    }

    public BaseSummaryVO getSummaryData(Long cid, String year) {
        ShieldSendSummaryVo vo = new ShieldSendSummaryVo();
        int finished = this.shieldSendService.getListSize(cid, (byte)1, year);
        vo.setFinishSend(Integer.valueOf(finished));
        int unfinished = this.shieldSendService.getListSize(cid, (byte)0, year);
        vo.setUnfinishSend(Integer.valueOf(unfinished));
        return vo;
    }
}

