/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.shield;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.framework.service.datascope.DataScopeHelper;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.encrypt.spring.utils.SpringEncryptUtils;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.health.dao.work.shield.ShieldSendMapper;
import cn.smarthse.modules.health.entity.work.shield.ShieldSend;
import cn.smarthse.modules.health.entity.work.shield.ShieldSendFile;
import cn.smarthse.modules.health.entity.work.shield.ShieldSendRecord;
import cn.smarthse.modules.health.entity.work.shield.vo.ShieldSendCount;
import cn.smarthse.modules.health.entity.work.shield.vo.ShieldSendInfo;
import cn.smarthse.modules.health.entity.work.shield.vo.ShieldSendTips;
import cn.smarthse.modules.health.enums.sys.coreWork.CoreWorkEnum;
import cn.smarthse.modules.health.service.base.company.ICompanyOrganizationService;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.sys.ISysCoreWorkModuleCorrelationService;
import cn.smarthse.modules.health.service.work.shield.IShieldSendFileService;
import cn.smarthse.modules.health.service.work.shield.IShieldSendRecordService;
import cn.smarthse.modules.health.service.work.shield.IShieldSendService;
import cn.smarthse.modules.health.vo.work.shield.ShieldSendCountParamVo;
import cn.smarthse.modules.health.vo.work.shield.ShieldSendCountVo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class ShieldSendServiceImpl
extends BaseServiceImpl<ShieldSendMapper, ShieldSend>
implements IShieldSendService {
    @Autowired
    IShieldSendFileService filesService;
    @Autowired
    IShieldSendRecordService recordService;
    @Autowired
    ISysCoreWorkModuleCorrelationService sysService;
    @DubboReference
    ISysFileProvideService sysFileService;
    @Autowired
    IStaffInfoService staffInfoService;
    int dayInterval = 180;
    @Autowired
    ICompanyOrganizationService orgService;

    public List<ShieldSend> listDetails(ShieldSend data) {
        DataScopeHelper.startDataScope("shield", "shield_send");
        List<ShieldSend> list = ((ShieldSendMapper)this.dao).listDetails(data);
        if (list == null || list.isEmpty()) {
            return list;
        }
        return list;
    }

    public List<ShieldSend> list(ShieldSend data) {
        return ((ShieldSendMapper)this.dao).listDetails(data);
    }

    @Transactional(readOnly=false)
    public void deleteByIds(String ids, Long staffId, Long cid) {
        List idArray = StringUtils.parseToLongList((String)ids, (String)",");
        if (idArray == null || idArray.size() == 0) {
            return;
        }
        Example example = new Example(ShieldSend.class);
        example.createCriteria().andIn("id", (Iterable)idArray);
        ShieldSend data = new ShieldSend();
        data.setIsValid(Boolean.valueOf(false));
        data.setUpdateDate(new Date());
        data.setUpdateBy(staffId);
        ((ShieldSendMapper)this.dao).updateByExampleSelective(data, example);
        for (Long id : idArray) {
            this.sysService.businessDelete(CoreWorkEnum.personalProtectionEquipment, id, staffId, cid);
        }
    }

    @Transactional(readOnly=false)
    public ShieldSend insertOrUpdate(ShieldSend data, Long cid, Long staffId) {
        if (data == null) {
            return data;
        }
        data.setIsValid(Boolean.valueOf(true));
        if (data.getId() == null) {
            this.add(data, staffId, cid);
        } else {
            this.update(data, staffId);
        }
        this.filesService.updateFilesByParent(data);
        this.updateTip(data, cid, staffId);
        return data;
    }

    private void updateTip(ShieldSend data, Long cid, Long staffId) {
        if (data.getStatus() == null) {
            return;
        }
        if (data.getFromType() == null) {
            return;
        }
        CoreWorkEnum desCoreWork = CoreWorkEnum.personalProtectionEquipment;
        CoreWorkEnum sourceCoreWork = CoreWorkEnum.getCoreWorkEnum((Byte)data.getFromType());
        if (data.getStatus() == 0) {
            this.sysService.businessStart(desCoreWork, sourceCoreWork, data.getId(), staffId, cid, new Long[]{data.getFromId()});
        } else if (data.getStatus() == 1) {
            this.sysService.businessComplete(desCoreWork, sourceCoreWork, data.getId(), staffId, cid, new Long[]{data.getFromId()});
        }
    }

    public ShieldSend getDetailById(Long id) {
        ShieldSend data = ((ShieldSendMapper)this.dao).getDetailById(id);
        data.setSenderName(SpringEncryptUtils.decrypt((String)data.getSenderName()));
        data.setRecords(this.recordService.listByPid(id));
        this.setFiles(data);
        return data;
    }

    private void setFiles(ShieldSend data) {
        if (data == null || data.getId() == null) {
            return;
        }
        List allFiles = this.filesService.getFilesByPid(data.getId());
        if (allFiles == null || allFiles.size() == 0) {
            return;
        }
        for (ShieldSendFile file : allFiles) {
            switch (file.getFileType()) {
                case 1: {
                    data.getFiles1().add(file);
                    break;
                }
            }
        }
    }

    public PageInfo<ShieldSend> getList(JqGridParam gparam, ShieldSend param) {
        if (gparam == null) {
            return new PageInfo();
        }
        PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows());
        return new PageInfo(this.listDetails(param));
    }

    public List<ShieldSendCount> countShieldSend(int distance, Long cid) {
        int maxYear = DateUtils.getThisYear();
        List<ShieldSendInfo> sendInfos = this.listSendInfo(maxYear, distance, cid);
        return this.countSendInfo(sendInfos, maxYear, distance);
    }

    private List<ShieldSendCount> countSendInfo(List<ShieldSendInfo> sendInfos, int maxYear, int distance) {
        HashMap<String, List<ShieldSendInfo>> shieldInfoMap = new HashMap<String, List<ShieldSendInfo>>();
        if (sendInfos == null || sendInfos.size() == 0) {
            return new ArrayList<ShieldSendCount>();
        }
        for (ShieldSendInfo sendInfo : sendInfos) {
            String key = sendInfo.getShieldId() + "_" + sendInfo.getUnit();
            List<ShieldSendInfo> sendInfoList = shieldInfoMap.get(key) == null ? new ArrayList() : (List)shieldInfoMap.get(key);
            sendInfoList.add(sendInfo);
            shieldInfoMap.put(key, sendInfoList);
        }
        List<ShieldSendCount> shieldCounts = this.covertMapToList(shieldInfoMap, maxYear, distance);
        return shieldCounts;
    }

    private List<ShieldSendInfo> listSendInfo(int maxYear, int distance, Long cid) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        int minYear = maxYear - distance;
        params.put("minYear", minYear);
        params.put("maxYear", maxYear);
        params.put("cid", cid);
        return ((ShieldSendMapper)this.dao).countShieldSend(params);
    }

    private List<ShieldSendCount> covertMapToList(Map<String, List<ShieldSendInfo>> map, int maxYear, int distance) {
        ArrayList<ShieldSendCount> results = new ArrayList<ShieldSendCount>();
        for (List<ShieldSendInfo> value : map.values()) {
            if (value == null || value.size() == 0) continue;
            ShieldSendInfo sendInfo = value.get(0);
            ShieldSendCount sendCount = new ShieldSendCount();
            sendCount.setShieldId(sendInfo.getShieldId());
            sendCount.setShieldName(sendInfo.getShieldName());
            sendCount.setUnit(sendInfo.getUnit());
            List<ShieldSendInfo> allInfos = this.getAllInfos(value, maxYear, distance);
            sendCount.setSendInfos(allInfos);
            results.add(sendCount);
        }
        return results;
    }

    private List<ShieldSendInfo> getAllInfos(List<ShieldSendInfo> sendInfos, int maxYear, int distance) {
        ArrayList<ShieldSendInfo> allInfos = new ArrayList<ShieldSendInfo>();
        for (int i = 0; i <= distance; ++i) {
            int year = maxYear - distance + i;
            ShieldSendInfo sendInfo = this.getSendInfoByYear(sendInfos, year);
            allInfos.add(sendInfo);
        }
        return allInfos;
    }

    private ShieldSendInfo getSendInfoByYear(List<ShieldSendInfo> sendInfos, int year) {
        for (ShieldSendInfo sendInfo : sendInfos) {
            if (year != sendInfo.getSendYear()) continue;
            return sendInfo;
        }
        ShieldSendInfo result = new ShieldSendInfo();
        result.setSendYear(year);
        return result;
    }

    public Boolean isNeedSend(Long cid, int interval) {
        ShieldSend data = new ShieldSend();
        data.setCid(cid);
        Date lastSendDate = ((ShieldSendMapper)this.dao).getLastSendDate(data);
        Date distanceDate = DateUtils.getDistanceDate((Date)lastSendDate, (int)2, (int)6);
        Date tipDate = DateUtils.getDistanceDate((Date)distanceDate, (int)5, (int)-1);
        return tipDate != null && tipDate.getTime() <= new Date().getTime();
    }

    public Integer getListSize(Long cid, Byte status) {
        ShieldSend data = new ShieldSend();
        data.setStatus(status);
        data.setCid(cid);
        List<ShieldSend> list = this.list(data);
        return list == null ? 0 : list.size();
    }

    public ShieldSendTips getWorkTips(Long cid, Byte status) {
        ShieldSendTips tips = new ShieldSendTips();
        tips.setUnfinishSum(this.getListSize(cid, status));
        tips.setIsNeedSend(this.isNeedSend(cid, this.dayInterval));
        return tips;
    }

    public List<ShieldSend> doc2Table11(Long cid, Integer year) {
        List list;
        if (cid == null) {
            return null;
        }
        Example example = new Example(ShieldSend.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("cid", (Object)cid);
        criteria.andEqualTo("isValid", (Object)true);
        criteria.andEqualTo("status", (Object)1);
        if (year != null) {
            String beginDateStr = year + "-01-01 00:00:00";
            String endDateStr = year + "-12-31 23:59:59";
            criteria.andBetween("sendTime", (Object)beginDateStr, (Object)endDateStr);
        }
        if ((list = ((ShieldSendMapper)this.dao).selectByExample(example)) == null) {
            return list;
        }
        for (ShieldSend data : list) {
            List records = this.recordService.listByPid(data.getId());
            this.setRecordsHistoryInfos(records, year);
            data.setRecords(records);
            this.setFilesDetail(data);
        }
        return list;
    }

    private void setRecordsHistoryInfos(List<ShieldSendRecord> records, Integer year) {
        if (year == null || records == null || records.isEmpty()) {
            return;
        }
        String dateStr = year + "-12-31 23:59:59";
        Date date = DateUtils.parseDate((Object)dateStr);
        for (ShieldSendRecord r : records) {
            String fecherHistoryName;
            String requirDeptHistoryName;
            String requirerHistoryName = this.staffInfoService.getHistroyRealNameByIdAndYear(r.getRequirerId(), date);
            if (StringUtils.isNotEmpty((String)requirerHistoryName)) {
                r.setRequirerName(requirerHistoryName);
            }
            if (StringUtils.isNotEmpty((String)(requirDeptHistoryName = this.orgService.getHistoryOrgNameByOrgIdAndYear(r.getRequireDeptId(), date)))) {
                r.setRequireDeptName(requirDeptHistoryName);
            }
            if (!StringUtils.isNotEmpty((String)(fecherHistoryName = this.staffInfoService.getHistroyRealNameByIdAndYear(r.getFetcher(), date)))) continue;
            r.setFetcherName(fecherHistoryName);
        }
    }

    private void setFilesDetail(ShieldSend data) {
        if (data == null || data.getId() == null) {
            return;
        }
        List allFiles = this.filesService.getFilesByPid(data.getId());
        if (allFiles == null || allFiles.size() == 0) {
            return;
        }
        for (ShieldSendFile file : allFiles) {
            SysFileModel sysFile = this.sysFileService.getFileById(file.getFileId());
            if (sysFile != null) {
                file.setFileName(sysFile.getFileName());
                file.setFileUrl(sysFile.getOssUrl());
            }
            switch (file.getFileType()) {
                case 1: {
                    data.getFiles1().add(file);
                    break;
                }
            }
        }
    }

    public Integer getListSize(Long cid, byte status, String year) {
        List list;
        if (cid == null) {
            return 0;
        }
        Example example = new Example(ShieldSend.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("cid", (Object)cid);
        criteria.andEqualTo("isValid", (Object)true);
        criteria.andEqualTo("status", (Object)status);
        if (StringUtils.isNotEmpty((String)year)) {
            String beginDateStr = year + "-01-01 00:00:00";
            String endDateStr = year + "-12-31 23:59:59";
            criteria.andBetween("sendTime", (Object)beginDateStr, (Object)endDateStr);
        }
        return (list = ((ShieldSendMapper)this.dao).selectByExample(example)) == null ? 0 : list.size();
    }

    @Transactional(readOnly=false)
    public void cancelByIds(String ids, Long staffId, Long cid) {
        List idArray = StringUtils.parseToLongList((String)ids, (String)",");
        if (idArray == null || idArray.size() == 0) {
            return;
        }
        Example example = new Example(ShieldSend.class);
        example.createCriteria().andIn("id", (Iterable)idArray);
        ShieldSend data = new ShieldSend();
        data.setUpdateDate(new Date());
        data.setUpdateBy(staffId);
        data.setStatus(Byte.valueOf((byte)2));
        ((ShieldSendMapper)this.dao).updateByExampleSelective(data, example);
    }

    public cn.smarthse.modules.health.vo.work.judge.ShieldSendInfo getShieldSendInfo(Long cid) {
        if (cid == null) {
            return null;
        }
        return ((ShieldSendMapper)this.dao).getShieldSendInfo(cid);
    }

    @Transactional(readOnly=false)
    public ShieldSend clone(Long id, Long staffId, Long cid) {
        if (id == null) {
            return null;
        }
        ShieldSend data = this.getDetailById(id);
        if (data == null) {
            return null;
        }
        data.setId(Long.valueOf(this.idworker.nextId()));
        data.setIsValid(Boolean.valueOf(false));
        data.setStatus(Byte.valueOf((byte)0));
        data.setCid(cid);
        data.setCreateBy(staffId);
        data.setCreateDate(new Date());
        data.setUpdateBy(staffId);
        data.setUpdateDate(new Date());
        ((ShieldSendMapper)this.dao).insert(data);
        this.filesService.cloneFilesByParent(data);
        this.recordService.insertOrUpdateBySend(data, staffId, cid);
        return data;
    }

    public List<ShieldSendCountVo> countShieldSend2_9(String name, Long orgId, Date startDate, Date endDate, Long cid) {
        return ((ShieldSendMapper)this.dao).countShieldSend2_9(name, orgId, startDate, endDate, cid);
    }

    public List<ShieldSendCountVo> countShieldSend2_10_2(String name, String orgIds, Date startDate, Date endDate, Long cid) {
        if ("".equals(orgIds)) {
            orgIds = null;
        }
        return ((ShieldSendMapper)this.dao).countShieldSend2_10_2(name, orgIds, startDate, endDate, cid);
    }

    public List<ShieldSendCountVo> countShieldSend2_10_3(ShieldSendCountParamVo param) {
        param.setOrgIdList(StringUtils.parseToNonRepeatLongList((String)param.getOrgIds()));
        List<ShieldSendCountVo> shieldSendCountVos = ((ShieldSendMapper)this.dao).countShieldSend2_10_3(param);
        if (CollectionUtil.isNotEmpty(shieldSendCountVos)) {
            shieldSendCountVos.forEach(s -> {
                s.setFetchName(SpringEncryptUtils.decrypt((String)s.getFetchName()));
                if (ObjectUtil.isNotNull((Object)s.getRequireType()) && s.getRequireType() == 1) {
                    s.setRequiredName(SpringEncryptUtils.decrypt((String)s.getRequiredName()));
                }
            });
        }
        return shieldSendCountVos;
    }
}

