/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.shield;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.encrypt.spring.utils.SpringEncryptUtils;
import cn.smarthse.modules.health.dao.work.shield.ShieldSendRecordMapper;
import cn.smarthse.modules.health.entity.work.shield.ShieldSend;
import cn.smarthse.modules.health.entity.work.shield.ShieldSendRecord;
import cn.smarthse.modules.health.entity.work.shield.vo.PersonalShieldSendInfo;
import cn.smarthse.modules.health.entity.work.shield.vo.ShieldQueryVo;
import cn.smarthse.modules.health.service.work.shield.IShieldSendRecordDetailService;
import cn.smarthse.modules.health.service.work.shield.IShieldSendRecordService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@DubboService
@Transactional(readOnly=true)
public class ShieldSendRecordServiceImpl
extends BaseServiceImpl<ShieldSendRecordMapper, ShieldSendRecord>
implements IShieldSendRecordService {
    @Autowired
    IShieldSendRecordDetailService detailService;

    @Transactional(readOnly=false)
    public void insertOrUpdate(ShieldSendRecord data, Long staffId, Long cid) {
        data.setCid(cid);
        if (data.getId() != null) {
            this.updateByPrimaryKey(data, staffId);
        } else {
            this.add(data, staffId, cid);
        }
        this.detailService.updateDetailsByParent(data);
    }

    @Transactional(readOnly=false)
    public void deleteById(Long id) {
        ((ShieldSendRecordMapper)this.dao).deleteByPrimaryKey(id);
        this.detailService.deleteByPid(id);
    }

    public List<ShieldSendRecord> listByPid(Long pid) {
        List<ShieldSendRecord> shieldSendRecords = ((ShieldSendRecordMapper)this.dao).listByPid(pid);
        if (CollectionUtil.isNotEmpty(shieldSendRecords)) {
            shieldSendRecords.forEach(s -> {
                s.setFetcherName(SpringEncryptUtils.decrypt((String)s.getFetcherName()));
                s.setRequirerName(SpringEncryptUtils.decrypt((String)s.getRequirerName()));
            });
        }
        return shieldSendRecords;
    }

    @Transactional(readOnly=false)
    public void insertOrUpdateBySend(ShieldSend data, Long staffId, Long cid) {
        if (data == null) {
            return;
        }
        List records = data.getRecords();
        if (records == null || records.isEmpty()) {
            return;
        }
        for (ShieldSendRecord r : records) {
            r.setId(null);
            r.setSendId(data.getId());
            this.add(r, staffId, cid);
            this.detailService.updateDetailsByParent(r);
        }
    }

    public PageInfo<PersonalShieldSendInfo> getPersonalShieldSendInfo(JqGridParam gparam, ShieldQueryVo param) {
        if (param == null || param.getStaffId() == null) {
            return new PageInfo();
        }
        PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows());
        List<PersonalShieldSendInfo> list = ((ShieldSendRecordMapper)this.dao).getPersonalShieldSendInfo(param);
        if (CollectionUtil.isNotEmpty(list)) {
            list.forEach(l -> l.setStaffName(SpringEncryptUtils.decrypt((String)l.getStaffName())));
        }
        return new PageInfo(list);
    }

    public PersonalShieldSendInfo getPersonalShieldSendInfoDetail(Long recordId) {
        ShieldQueryVo vo = new ShieldQueryVo();
        vo.setRecordId(recordId);
        List<PersonalShieldSendInfo> list = ((ShieldSendRecordMapper)this.dao).getPersonalShieldSendInfo(vo);
        if (list != null && list.size() > 0) {
            PersonalShieldSendInfo personalShieldSendInfo = list.get(0);
            if (ObjectUtil.isNotNull((Object)personalShieldSendInfo)) {
                personalShieldSendInfo.setStaffName(SpringEncryptUtils.decrypt((String)personalShieldSendInfo.getStaffName()));
            }
            return personalShieldSendInfo;
        }
        return null;
    }

    public ShieldSendRecord getDetailById(Long id) {
        ShieldSendRecord detailById = ((ShieldSendRecordMapper)this.dao).getDetailById(id);
        if (ObjectUtil.isNotNull((Object)detailById)) {
            detailById.setFetcherName(SpringEncryptUtils.decrypt((String)detailById.getFetcherName()));
            detailById.setRequirerName(SpringEncryptUtils.decrypt((String)detailById.getRequirerName()));
        }
        return detailById;
    }
}

