/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.shield;

import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.dao.work.shield.ShieldSendRecordDetailMapper;
import cn.smarthse.modules.health.entity.work.shield.ShieldSendRecord;
import cn.smarthse.modules.health.entity.work.shield.ShieldSendRecordDetail;
import cn.smarthse.modules.health.pojo.ShieldFetchParam;
import cn.smarthse.modules.health.pojo.ShieldFetchVo;
import cn.smarthse.modules.health.service.work.shield.IShieldSendRecordDetailService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class ShieldSendRecordDetailServiceImpl
extends BaseServiceImpl<ShieldSendRecordDetailMapper, ShieldSendRecordDetail>
implements IShieldSendRecordDetailService {
    @Transactional(readOnly=false)
    public void updateDetailsByParent(ShieldSendRecord data) {
        if (data == null) {
            return;
        }
        this.deleteByPid(data.getId());
        List details = data.getDetails();
        if (data.getId() == null || details == null) {
            return;
        }
        for (ShieldSendRecordDetail detail : details) {
            if (detail.getShieldId() == null) continue;
            this.setParentInfos(data, detail);
            detail.setId(Long.valueOf(this.idworker.nextId()));
            ((ShieldSendRecordDetailMapper)this.dao).insert(detail);
        }
    }

    public PageInfo<ShieldFetchVo> queryFetchList(ShieldFetchParam param) {
        PageHelper.startPage((int)param.getPageNum(), (int)param.getPageSize());
        List<ShieldFetchVo> list = ((ShieldSendRecordDetailMapper)this.dao).queryFetchList(param);
        return new PageInfo(list);
    }

    @Transactional(readOnly=false)
    public void fetch(Long id, Integer realFetchNum) {
        ((ShieldSendRecordDetailMapper)this.dao).fetch(id, realFetchNum);
    }

    @Transactional(readOnly=false)
    public void deleteByPid(Long pid) {
        if (pid == null) {
            return;
        }
        Example example = new Example(ShieldSendRecordDetail.class);
        example.createCriteria().andEqualTo("sendRecordId", (Object)pid);
        ((ShieldSendRecordDetailMapper)this.dao).deleteByExample(example);
    }

    private void setParentInfos(ShieldSendRecord data, ShieldSendRecordDetail detail) {
        detail.setSendRecordId(data.getId());
        detail.setCid(data.getCid());
        detail.setCreateBy(data.getCreateBy());
        detail.setCreateDate(data.getCreateDate());
        detail.setUpdateBy(data.getUpdateBy());
        detail.setUpdateDate(data.getUpdateDate());
    }
}

