/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.shield;

import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.dao.work.shield.ShieldSendFileMapper;
import cn.smarthse.modules.health.entity.work.shield.ShieldSend;
import cn.smarthse.modules.health.entity.work.shield.ShieldSendFile;
import cn.smarthse.modules.health.service.work.shield.IShieldSendFileService;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
@Transactional(readOnly=true)
public class ShieldSendFileServiceImpl
extends BaseServiceImpl<ShieldSendFileMapper, ShieldSendFile>
implements IShieldSendFileService {
    @Transactional(readOnly=true)
    public void updateFilesByParent(ShieldSend data) {
        if (data == null) {
            return;
        }
        this.deleteFilesByPid(data.getId());
        this.addFilesByType(data.getFiles1(), data, (byte)1);
    }

    @Transactional(readOnly=true)
    public void cloneFilesByParent(ShieldSend data) {
        if (data == null) {
            return;
        }
        this.deleteFilesByPid(data.getId());
        this.cloneFilesByType(data.getFiles1(), data, (byte)1);
    }

    private void deleteFilesByPid(Long pid) {
        if (pid == null) {
            return;
        }
        Example example = new Example(ShieldSendFile.class);
        example.createCriteria().andEqualTo("sendId", (Object)pid);
        ((ShieldSendFileMapper)this.dao).deleteByExample(example);
    }

    private void cloneFilesByType(List<ShieldSendFile> files, ShieldSend data, Byte fileType) {
        if (files == null || files.size() == 0) {
            return;
        }
        for (ShieldSendFile file : files) {
            if (file.getFileId() == null) continue;
            file.setId(Long.valueOf(this.idworker.nextId()));
            this.setParentInfos(data, file);
            file.setFileType(fileType);
            ((ShieldSendFileMapper)this.dao).insert(file);
        }
    }

    private void addFilesByType(List<ShieldSendFile> files, ShieldSend data, Byte fileType) {
        if (files == null || files.size() == 0) {
            return;
        }
        for (ShieldSendFile file : files) {
            if (file.getFileId() == null) continue;
            this.setParentInfos(data, file);
            file.setFileType(fileType);
            file.setId(Long.valueOf(this.idworker.nextId()));
            ((ShieldSendFileMapper)this.dao).insert(file);
        }
    }

    private void setParentInfos(ShieldSend data, ShieldSendFile file) {
        file.setSendId(data.getId());
        file.setCid(data.getCid());
        file.setCreateBy(data.getUpdateBy());
        file.setCreateDate(data.getUpdateDate());
        file.setUpdateBy(data.getUpdateBy());
        file.setUpdateDate(data.getUpdateDate());
    }

    public List<ShieldSendFile> getFilesByPid(Long buyId) {
        if (buyId == null) {
            return null;
        }
        Example example = new Example(ShieldSendFile.class);
        example.createCriteria().andEqualTo("sendId", (Object)buyId);
        return ((ShieldSendFileMapper)this.dao).selectByExample(example);
    }
}

