/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.shield;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.PageUtil;
import cn.smarthse.modules.health.dao.work.shield.ShieldSendMapper;
import cn.smarthse.modules.health.entity.work.shield.ShieldSend;
import cn.smarthse.modules.health.entity.work.shield.ShieldSendExpireIgnore;
import cn.smarthse.modules.health.entity.work.shield.ShieldSendExpireLog;
import cn.smarthse.modules.health.entity.work.shield.vo.ShieldSendExpireLogParam;
import cn.smarthse.modules.health.service.work.shield.IShieldSendExpireIgnoreService;
import cn.smarthse.modules.health.service.work.shield.IShieldSendExpireLogService;
import cn.smarthse.modules.health.service.work.shield.IShieldSendExpireService;
import cn.smarthse.modules.health.vo.work.shield.ShieldDetailVo;
import cn.smarthse.modules.health.vo.work.shield.ShieldExpireUserVo;
import cn.smarthse.modules.health.vo.work.shield.ShieldExpireVo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@DubboService
public class ShieldSendExpireServiceImpl
extends BaseServiceImpl<ShieldSendMapper, ShieldSend>
implements IShieldSendExpireService {
    @Autowired(required=false)
    private IShieldSendExpireIgnoreService shieldSendExpireIgnoreService;
    @Autowired(required=false)
    private IShieldSendExpireLogService shieldSendExpireLogService;

    public PageInfo<ShieldExpireUserVo> getUserList(JqGridParam gparam, String nameWorkNo, Long orgId, Long workId, Long cid) {
        int pageNum = gparam.getPage();
        int pageSize = gparam.getRows();
        List<ShieldExpireVo> list_1 = ((ShieldSendMapper)this.dao).selectShieldExpireUser(nameWorkNo, orgId, workId, cid);
        List<ShieldExpireUserVo> list = this.parse(list_1);
        return PageUtil.getPageInfo(list, (int)pageNum, (int)pageSize);
    }

    @Transactional(readOnly=false)
    public void ignore(Long staffId, Long ... shieldId) {
        this.shieldSendExpireIgnoreService.ignore(staffId, shieldId);
    }

    @Transactional(readOnly=false)
    public void removeIgnore(Long sendId) {
        List<ShieldSendExpireIgnore> list = ((ShieldSendMapper)this.dao).selectUserShield(sendId);
        list.forEach(item -> this.shieldSendExpireIgnoreService.removeIgnore(item.getRequirerId(), item.getShieldId()));
    }

    public List<ShieldDetailVo> getShieldDetail(Long ... shieldIds) {
        if (shieldIds == null || shieldIds.length == 0) {
            return new ArrayList<ShieldDetailVo>();
        }
        return ((ShieldSendMapper)this.dao).getProtectListByShields(shieldIds);
    }

    public Long getUserNum(Long cid) {
        JqGridParam jqGridParam = new JqGridParam();
        jqGridParam.setPage(1);
        jqGridParam.setRows(1);
        PageInfo<ShieldExpireUserVo> pageInfo = this.getUserList(jqGridParam, null, null, null, cid);
        return pageInfo.getTotal();
    }

    private List<ShieldExpireUserVo> parse(List<ShieldExpireVo> list) {
        ArrayList<ShieldExpireUserVo> resList = new ArrayList<ShieldExpireUserVo>();
        Long currentUserId = 0L;
        ShieldExpireUserVo userVo = null;
        ArrayList<ShieldExpireUserVo.ExpireShield> shieldList = null;
        for (ShieldExpireVo vo : list) {
            ShieldExpireUserVo.ExpireShield shield;
            if (this.shieldSendExpireIgnoreService.isIgnore(vo.getRequirerId(), vo.getShieldId())) continue;
            Long requirerId = vo.getRequirerId();
            if (!requirerId.equals(currentUserId)) {
                currentUserId = requirerId;
                userVo = new ShieldExpireUserVo();
                BeanUtils.copyProperties((Object)vo, (Object)userVo);
                shieldList = new ArrayList<ShieldExpireUserVo.ExpireShield>();
                shield = new ShieldExpireUserVo.ExpireShield();
                BeanUtils.copyProperties((Object)vo, (Object)shield);
                shieldList.add(shield);
                userVo.setShieldList(shieldList);
                resList.add(userVo);
                continue;
            }
            shield = new ShieldExpireUserVo.ExpireShield();
            BeanUtils.copyProperties((Object)vo, (Object)shield);
            shieldList.add(shield);
        }
        return resList;
    }

    public PageInfo<ShieldSendExpireLog> getPage(JqGridParam gparam, ShieldSendExpireLogParam param) {
        return this.shieldSendExpireLogService.getPage(gparam, param);
    }

    public List<ShieldSendExpireLog> getExportList(ShieldSendExpireLogParam param) {
        return this.shieldSendExpireLogService.getExportList(param);
    }

    @Transactional(readOnly=false)
    public void addLogs() {
        this.shieldSendExpireLogService.addExpireLog();
    }
}

