/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.shield;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.dao.work.shield.ShieldSendExpireLogMapper;
import cn.smarthse.modules.health.entity.work.shield.ShieldSendExpireLog;
import cn.smarthse.modules.health.entity.work.shield.vo.ShieldSendExpireLogParam;
import cn.smarthse.modules.health.service.work.shield.IShieldSendExpireLogService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@EnableAsync
public class ShieldSendExpireLogServiceImpl
extends BaseServiceImpl<ShieldSendExpireLogMapper, ShieldSendExpireLog>
implements IShieldSendExpireLogService {
    public void init() {
        this.addExpireLog();
    }

    public PageInfo<ShieldSendExpireLog> getPage(JqGridParam gparam, ShieldSendExpireLogParam param) {
        if (gparam == null || param == null || param.getCid() == null) {
            return new PageInfo();
        }
        PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows());
        List<ShieldSendExpireLog> list = ((ShieldSendExpireLogMapper)this.dao).getPageList(param);
        this.setRealSendTime(list, param.getCid(), false);
        return new PageInfo(list);
    }

    public List<ShieldSendExpireLog> getExportList(ShieldSendExpireLogParam param) {
        if (param == null || param.getCid() == null) {
            return Collections.emptyList();
        }
        List<ShieldSendExpireLog> list = ((ShieldSendExpireLogMapper)this.dao).getExportList(param);
        this.setRealSendTime(list, param.getCid(), true);
        return list;
    }

    private void setRealSendTime(List<ShieldSendExpireLog> list, Long cid, boolean isStaffKey) {
        if (list == null || list.isEmpty()) {
            return;
        }
        Map<String, List<Date>> sendMap = this.getSendMap(cid, isStaffKey);
        if (sendMap.isEmpty()) {
            return;
        }
        list.forEach(l -> {
            String key = l.getShieldId() + "_" + l.getOrgId() + "_" + l.getWorkId();
            if (isStaffKey) {
                key = key + "_" + l.getRequirerId();
            }
            List dates = (List)sendMap.get(key);
            l.setRealSendTime(this.getLastTime(l.getLastSendTime(), dates));
        });
    }

    private Date getLastTime(Date lastSendTime, List<Date> dates) {
        if (dates == null || dates.isEmpty()) {
            return null;
        }
        long d1 = lastSendTime == null ? 0L : lastSendTime.getTime();
        for (Date d : dates) {
            if (d.getTime() <= d1) continue;
            return d;
        }
        return null;
    }

    private Map<String, List<Date>> getSendMap(Long cid, boolean isStaffKey) {
        HashMap<String, List<Date>> map = new HashMap<String, List<Date>>();
        List<ShieldSendExpireLog> allSend = ((ShieldSendExpireLogMapper)this.dao).getAllSend(cid);
        if (allSend == null || allSend.isEmpty()) {
            return map;
        }
        allSend.forEach(send -> {
            ArrayList<Date> dates;
            String key = send.getShieldId() + "_" + send.getOrgId() + "_" + send.getWorkId();
            if (isStaffKey) {
                key = key + "_" + send.getRequirerId();
            }
            if ((dates = (ArrayList<Date>)map.get(key)) == null) {
                dates = new ArrayList<Date>();
            }
            dates.add(send.getLastSendTime());
            map.put(key, dates);
        });
        return map;
    }

    @Async
    @Transactional(readOnly=false)
    public void addExpireLog() {
        ((ShieldSendExpireLogMapper)this.dao).addExpireLog();
    }
}

