/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.shield;

import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.dao.work.shield.ShieldSendExpireIgnoreMapper;
import cn.smarthse.modules.health.entity.work.shield.ShieldSendExpireIgnore;
import cn.smarthse.modules.health.service.work.shield.IShieldSendExpireIgnoreService;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
@EnableAsync
public class ShieldSendExpireIgnoreServiceImp
extends BaseServiceImpl<ShieldSendExpireIgnoreMapper, ShieldSendExpireIgnore>
implements IShieldSendExpireIgnoreService {
    private Set<String> set = new HashSet<String>();

    public void init() {
        List<ShieldSendExpireIgnore> all = this.getListByExample(new Example(ShieldSendExpireIgnore.class));
        all.forEach(item -> this.set.add(item.getRequirerId() + "_" + item.getShieldId()));
    }

    public boolean isIgnore(Long staffId, Long shieldId) {
        return this.set.contains(staffId + "_" + shieldId);
    }

    @Transactional(readOnly=false)
    public void ignore(Long staffId, Long ... shieldIds) {
        for (Long shieldId : shieldIds) {
            ShieldSendExpireIgnore ignore = new ShieldSendExpireIgnore();
            ignore.setRequirerId(staffId);
            ignore.setShieldId(shieldId);
            ((ShieldSendExpireIgnoreMapper)this.dao).insert(ignore);
            this.set.add(staffId + "_" + shieldId);
            this.logger.info("\u5ffd\u7565\uff1a" + staffId + "_" + shieldId);
        }
    }

    @Async
    @Transactional(readOnly=false)
    public void removeIgnore(Long staffId, Long shieldId) {
        Example example = new Example(ShieldSendExpireIgnore.class);
        example.createCriteria().andEqualTo("requirerId", (Object)staffId).andEqualTo("shieldId", (Object)shieldId);
        ((ShieldSendExpireIgnoreMapper)this.dao).deleteByExample(example);
        this.set.remove(staffId + "_" + shieldId);
    }
}

