/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.shield;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.enums.BusinessNoTypeEnum;
import cn.smarthse.common.framework.enums.ResponseStateEnum;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.framework.service.datascope.DataScopeHelper;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.number.NumberUtil;
import cn.smarthse.encrypt.spring.utils.SpringEncryptUtils;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.health.dao.work.shield.ShieldPurchaseMapper;
import cn.smarthse.modules.health.entity.work.planyear.vo.PlanYearSyncSO;
import cn.smarthse.modules.health.entity.work.shield.ShieldEquipRuleDetail;
import cn.smarthse.modules.health.entity.work.shield.ShieldPurchase;
import cn.smarthse.modules.health.entity.work.shield.ShieldPurchaseDetail;
import cn.smarthse.modules.health.entity.work.shield.ShieldPurchaseFile;
import cn.smarthse.modules.health.entity.work.shield.vo.ShieldPurchaseTips;
import cn.smarthse.modules.health.enums.shield.ShieldCountUnitEnum;
import cn.smarthse.modules.health.service.base.IBusinessNoService;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.work.shield.IShieldEquipRuleDetailService;
import cn.smarthse.modules.health.service.work.shield.IShieldPurchaseDetailService;
import cn.smarthse.modules.health.service.work.shield.IShieldPurchaseFileService;
import cn.smarthse.modules.health.service.work.shield.IShieldPurchaseService;
import cn.smarthse.modules.health.vo.base.ImportErrorInfo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class ShieldPurchaseServiceImpl
extends BaseServiceImpl<ShieldPurchaseMapper, ShieldPurchase>
implements IShieldPurchaseService {
    @Autowired
    IShieldPurchaseFileService filesService;
    @Autowired
    IShieldPurchaseDetailService detailService;
    @Autowired
    IBusinessNoService businessNoService;
    @DubboReference
    ISysFileProvideService sysFileService;
    @Autowired
    IStaffInfoService staffInfoService;
    int dayInterval = 180;
    @Autowired
    IShieldEquipRuleDetailService shieldEquipRuleDetailService;
    private Map<String, Long> shieldEquipDetailMap;
    private Map<Long, ShieldPurchaseDetail> shieldPurchaseDetailMap;

    public List<ShieldPurchase> listDetails(ShieldPurchase data) {
        DataScopeHelper.startDataScope("shield", "shield_purchase");
        List<ShieldPurchase> list = this.list(data);
        if (list == null || list.isEmpty()) {
            return Collections.emptyList();
        }
        for (ShieldPurchase d : list) {
            this.setFiles(d);
            if (d.getManager() == null) continue;
            d.setManagerName(this.staffInfoService.getStaffNameIncludeDelStatusByStaffId(d.getManager()));
        }
        return list;
    }

    @Transactional(readOnly=false)
    public void deleteByIds(String ids, Long staffId) {
        List idArray = StringUtils.parseToLongList((String)ids, (String)",");
        if (idArray == null || idArray.size() == 0) {
            return;
        }
        Example example = new Example(ShieldPurchase.class);
        example.createCriteria().andIn("id", (Iterable)idArray);
        ShieldPurchase data = new ShieldPurchase();
        data.setIsValid(Boolean.valueOf(false));
        data.setUpdateDate(new Date());
        data.setUpdateBy(staffId);
        ((ShieldPurchaseMapper)this.dao).updateByExampleSelective(data, example);
    }

    @Transactional(readOnly=false)
    public ShieldPurchase insertOrUpdate(ShieldPurchase data, Long cid, Long staffId) {
        if (data == null) {
            return data;
        }
        data.setCid(cid);
        if (data.getId() == null) {
            data.setIsValid(Boolean.valueOf(true));
            this.add(data, staffId, cid);
        } else {
            data.setUpdateBy(staffId);
            data.setUpdateDate(new Date());
            ((ShieldPurchaseMapper)this.dao).updateById(data);
        }
        this.filesService.updateFilesByParent(data);
        this.detailService.updateDetailsByParent(data);
        return data;
    }

    public ShieldPurchase getDetailById(Long id) {
        ShieldPurchase data = ((ShieldPurchaseMapper)this.dao).getDetailById(id);
        if (ObjectUtil.isNotNull((Object)data)) {
            data.setManagerName(SpringEncryptUtils.decrypt((String)data.getManagerName()));
        }
        this.setFiles(data);
        return data;
    }

    private void setFiles(ShieldPurchase data) {
        if (data == null || data.getId() == null) {
            return;
        }
        List allFiles = this.filesService.getFilesByPid(data.getId());
        if (allFiles == null || allFiles.size() == 0) {
            return;
        }
        for (ShieldPurchaseFile file : allFiles) {
            switch (file.getFileType()) {
                case 1: {
                    data.getFiles1().add(file);
                    break;
                }
                case 2: {
                    data.getFiles2().add(file);
                    break;
                }
                case 3: {
                    data.getFiles3().add(file);
                    break;
                }
            }
        }
    }

    public PageInfo<ShieldPurchase> getList(JqGridParam gparam, ShieldPurchase param) {
        if (gparam == null) {
            return new PageInfo();
        }
        PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows());
        return new PageInfo(this.listDetails(param));
    }

    public Boolean isNeedPurchase(Long cid, int interval) {
        ShieldPurchase data = new ShieldPurchase();
        data.setCid(cid);
        Date lastDate = ((ShieldPurchaseMapper)this.dao).getLastPurchaseDate(data);
        Date distanceDate = DateUtils.getDistanceDate((Date)lastDate, (int)2, (int)6);
        Date tipDate = DateUtils.getDistanceDate((Date)distanceDate, (int)5, (int)-1);
        return tipDate != null && tipDate.getTime() <= new Date().getTime();
    }

    public int getListSize(Long cid, Byte status) {
        ShieldPurchase data = new ShieldPurchase();
        data.setStatus(status);
        data.setCid(cid);
        List<ShieldPurchase> unfinishList = this.list(data);
        return unfinishList == null ? 0 : unfinishList.size();
    }

    private List<ShieldPurchase> list(ShieldPurchase data) {
        List<ShieldPurchase> shieldPurchases = ((ShieldPurchaseMapper)this.dao).listDetails(data);
        if (CollectionUtil.isNotEmpty(shieldPurchases)) {
            shieldPurchases.forEach(s -> s.setManagerName(SpringEncryptUtils.decrypt((String)s.getManagerName())));
        }
        return shieldPurchases;
    }

    public ShieldPurchaseTips getWorkTips(Long cid, Byte status) {
        ShieldPurchaseTips tips = new ShieldPurchaseTips();
        tips.setUnfinishSum(Integer.valueOf(this.getListSize(cid, status)));
        tips.setIsNeedPurchase(this.isNeedPurchase(cid, this.dayInterval));
        return tips;
    }

    @Transactional(readOnly=false)
    public Long syncAddPlanYearByBL(PlanYearSyncSO detail) {
        if (detail == null) {
            return null;
        }
        ShieldPurchase data = new ShieldPurchase();
        data.setBuyName(detail.getBusinessName());
        data.setBuyNo(this.businessNoService.getBusinessNo(detail.getCid(), BusinessNoTypeEnum.SHIELDFETCH.getCode()));
        data.setBuyDate(detail.getBusinessPlantime());
        data.setManager(detail.getManagerId());
        data.setStatus(Byte.valueOf((byte)0));
        data.setIsValid(Boolean.valueOf(true));
        this.add(data, detail.getCreatorBy(), detail.getCid());
        return data.getId();
    }

    public List<ShieldPurchase> doc2Table12(Long cid, Integer year) {
        List list;
        if (cid == null) {
            return null;
        }
        Example example = new Example(ShieldPurchase.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("cid", (Object)cid);
        criteria.andEqualTo("isValid", (Object)true);
        criteria.andEqualTo("status", (Object)1);
        Date date = null;
        if (year != null) {
            String beginDateStr = year + "-01-01 00:00:00";
            String endDateStr = year + "-12-31 23:59:59";
            criteria.andBetween("buyDate", (Object)beginDateStr, (Object)endDateStr);
            date = DateUtils.parseDate((Object)endDateStr);
        }
        if ((list = ((ShieldPurchaseMapper)this.dao).selectByExample(example)) == null) {
            return list;
        }
        for (ShieldPurchase data : list) {
            String managerHistoryName = this.staffInfoService.getHistroyRealNameByIdAndYear(data.getManager(), date);
            if (StringUtils.isNotEmpty((String)managerHistoryName)) {
                data.setManagerName(managerHistoryName);
            } else {
                data.setManagerName(this.staffInfoService.getStaffNameByStaffId(data.getManager()));
            }
            this.setFilesDetail(data);
        }
        return list;
    }

    private void setFilesDetail(ShieldPurchase data) {
        if (data == null || data.getId() == null) {
            return;
        }
        List allFiles = this.filesService.getFilesByPid(data.getId());
        if (allFiles == null || allFiles.size() == 0) {
            return;
        }
        for (ShieldPurchaseFile file : allFiles) {
            SysFileModel sysFile = this.sysFileService.getFileById(file.getFileId());
            if (sysFile != null) {
                file.setFileName(sysFile.getFileName());
                file.setFileUrl(sysFile.getOssUrl());
            }
            switch (file.getFileType()) {
                case 1: {
                    data.getFiles1().add(file);
                    break;
                }
                case 2: {
                    data.getFiles2().add(file);
                    break;
                }
                case 3: {
                    data.getFiles3().add(file);
                    break;
                }
            }
        }
    }

    @Transactional(readOnly=false)
    public void cancelByIds(String ids, Long staffId, Long cid) {
        List idArray = StringUtils.parseToLongList((String)ids, (String)",");
        if (idArray == null || idArray.size() == 0) {
            return;
        }
        Example example = new Example(ShieldPurchase.class);
        example.createCriteria().andIn("id", (Iterable)idArray);
        ShieldPurchase data = new ShieldPurchase();
        data.setUpdateDate(new Date());
        data.setUpdateBy(staffId);
        data.setStatus(Byte.valueOf((byte)2));
        ((ShieldPurchaseMapper)this.dao).updateByExampleSelective(data, example);
    }

    private void init(Long id, Long cid) {
        this.shieldEquipDetailMap = this.getShieldDetailMap(cid);
        this.shieldPurchaseDetailMap = this.getShieldPurchaseDetailMap(id);
    }

    private Map<String, Long> getShieldDetailMap(Long cid) {
        HashMap<String, Long> result = new HashMap<String, Long>();
        ShieldEquipRuleDetail param = new ShieldEquipRuleDetail();
        param.setCid(cid);
        List list = this.shieldEquipRuleDetailService.getDetailTable(param);
        if (list == null || list.isEmpty()) {
            return result;
        }
        list.forEach(l -> {
            String key = l.getDetailName() + "_" + l.getProLevel() + "_" + l.getShieldDesc();
            result.put(key, l.getId());
        });
        return result;
    }

    private Map<Long, ShieldPurchaseDetail> getShieldPurchaseDetailMap(Long id) {
        HashMap<Long, ShieldPurchaseDetail> result = new HashMap<Long, ShieldPurchaseDetail>();
        List details = this.detailService.getByPid(id);
        if (details == null || details.isEmpty()) {
            return result;
        }
        details.forEach(l -> {
            Long key = l.getShieldId();
            result.put(key, (ShieldPurchaseDetail)l);
        });
        return result;
    }

    @Transactional(readOnly=false)
    public ResponseData<Object> importRules(Long purchaseId, List<List<String>> contents, Long staffId, Long cid) {
        ResponseData responseData = new ResponseData();
        responseData.setState(ResponseStateEnum.fail);
        if (contents == null || contents.isEmpty()) {
            responseData.setContent("\u5bfc\u5165\u7684\u6587\u4ef6\u4e2d\u6ca1\u6709\u6570\u636e\uff0c\u8bf7\u6309\u89c4\u5219\u586b\u5199\u4e4b\u540e\u518d\u5bfc\u5165\uff01");
        }
        this.init(purchaseId, cid);
        if (this.shieldEquipDetailMap.isEmpty()) {
            responseData.setContent("\u7cfb\u7edf\u4e2d\u7f3a\u5c11\u62a4\u7528\u54c1\u914d\u5907\u6807\u51c6\u4fe1\u606f\uff0c\u8bf7\u5148\u6dfb\u52a0\uff01");
            return responseData;
        }
        ArrayList<ImportErrorInfo> errors = new ArrayList<ImportErrorInfo>();
        this.checkImportDatas(purchaseId, contents, errors, staffId, cid);
        this.doImport(purchaseId);
        if (!errors.isEmpty()) {
            responseData.setState(ResponseStateEnum.warning);
            responseData.setResult(errors);
            responseData.setContent("\u90e8\u5206\u5bfc\u5165\u5931\u8d25\uff01");
        } else {
            responseData.setState(ResponseStateEnum.success);
            responseData.setContent("\u5bfc\u5165\u6210\u529f\uff01");
        }
        return responseData;
    }

    private void doImport(Long pid) {
        List<ShieldPurchaseDetail> details = this.convertToDetails(this.shieldPurchaseDetailMap);
        this.detailService.updateDetails(pid, details);
    }

    private List<ShieldPurchaseDetail> convertToDetails(Map<Long, ShieldPurchaseDetail> map) {
        ArrayList<ShieldPurchaseDetail> details = new ArrayList<ShieldPurchaseDetail>();
        for (Map.Entry<Long, ShieldPurchaseDetail> m : map.entrySet()) {
            details.add(m.getValue());
        }
        return details;
    }

    private void checkImportDatas(Long purchaseId, List<List<String>> contents, List<ImportErrorInfo> errors, Long staffId, Long cid) {
        Date now = new Date();
        for (int i = 0; i < contents.size(); ++i) {
            ImportErrorInfo importErrorInfo = new ImportErrorInfo();
            importErrorInfo.setRowNum(i);
            List<String> content = contents.get(i);
            ArrayList<String> errorMsg = new ArrayList<String>();
            String detailName = content.get(0);
            String desc = content.get(2);
            Long shieldId = null;
            if (StringUtils.isEmpty((CharSequence)detailName)) {
                errorMsg.add("\u9632\u62a4\u7528\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            } else {
                String protectLevel = content.get(1);
                String key = detailName + "_" + protectLevel + "_" + desc;
                shieldId = this.shieldEquipDetailMap.get(key);
                if (shieldId == null) {
                    errorMsg.add("\u9632\u62a4\u7528\u54c1\u540d\u79f0\u3001\u4fdd\u62a4\u7b49\u7ea7\u548c\u8bf4\u660e\u4e0d\u5bf9\u5e94\uff01");
                }
            }
            String num = content.get(3);
            if (StringUtils.isEmpty((CharSequence)num)) {
                errorMsg.add("\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            } else if (!NumberUtil.isPositiveInteger((String)num)) {
                errorMsg.add("\u8bf7\u6309\u8bf4\u660e\u586b\u5199\u6570\u91cf\uff01");
            }
            String unit = content.get(4);
            if (StringUtils.isEmpty((CharSequence)unit)) {
                errorMsg.add("\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (!errorMsg.isEmpty()) {
                importErrorInfo.setErrorMsg(errorMsg);
                errors.add(importErrorInfo);
                continue;
            }
            ShieldPurchaseDetail detail = this.shieldPurchaseDetailMap.get(shieldId);
            if (detail == null) {
                detail = new ShieldPurchaseDetail();
                detail.setAmount(Integer.valueOf(Integer.parseInt(num)));
                detail.setCreateBy(staffId);
                detail.setId(Long.valueOf(this.idworker.nextId()));
            } else {
                detail.setAmount(Integer.valueOf((detail.getAmount() == null ? 0 : detail.getAmount()) + Integer.parseInt(num)));
            }
            detail.setUpdateBy(staffId);
            detail.setCid(cid);
            detail.setBuyId(purchaseId);
            detail.setDescription(desc);
            detail.setShieldId(shieldId);
            detail.setUnit(ShieldCountUnitEnum.getCode((String)unit));
            this.shieldPurchaseDetailMap.put(shieldId, detail);
        }
    }
}

