/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.shield;

import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.dao.work.shield.ShieldPurchaseFileMapper;
import cn.smarthse.modules.health.entity.work.shield.ShieldPurchase;
import cn.smarthse.modules.health.entity.work.shield.ShieldPurchaseFile;
import cn.smarthse.modules.health.service.work.shield.IShieldPurchaseFileService;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
@Transactional(readOnly=true)
public class ShieldPurchaseFileServiceImpl
extends BaseServiceImpl<ShieldPurchaseFileMapper, ShieldPurchaseFile>
implements IShieldPurchaseFileService {
    @Transactional(readOnly=true)
    public void updateFilesByParent(ShieldPurchase data) {
        if (data == null) {
            return;
        }
        this.deleteFilesByPid(data.getId());
        this.addFilesByType(data.getFiles1(), data, (byte)1);
        this.addFilesByType(data.getFiles2(), data, (byte)2);
        this.addFilesByType(data.getFiles3(), data, (byte)3);
    }

    private void deleteFilesByPid(Long pid) {
        if (pid == null) {
            return;
        }
        Example example = new Example(ShieldPurchaseFile.class);
        example.createCriteria().andEqualTo("buyId", (Object)pid);
        ((ShieldPurchaseFileMapper)this.dao).deleteByExample(example);
    }

    private void addFilesByType(List<ShieldPurchaseFile> files, ShieldPurchase data, Byte fileType) {
        if (files == null || files.size() == 0) {
            return;
        }
        for (ShieldPurchaseFile file : files) {
            if (file.getFileId() == null) continue;
            this.setParentInfos(data, file);
            file.setFileType(fileType);
            file.setId(Long.valueOf(this.idworker.nextId()));
            ((ShieldPurchaseFileMapper)this.dao).insert(file);
        }
    }

    private void setParentInfos(ShieldPurchase data, ShieldPurchaseFile file) {
        file.setBuyId(data.getId());
        file.setCid(data.getCid());
        file.setCreateBy(data.getCreateBy());
        file.setCreateDate(data.getCreateDate());
        file.setUpdateBy(data.getUpdateBy());
        file.setUpdateDate(data.getUpdateDate());
    }

    public List<ShieldPurchaseFile> getFilesByPid(Long buyId) {
        if (buyId == null) {
            return null;
        }
        Example example = new Example(ShieldPurchaseFile.class);
        example.createCriteria().andEqualTo("buyId", (Object)buyId);
        return ((ShieldPurchaseFileMapper)this.dao).selectByExample(example);
    }
}

