/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.shield;

import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.dao.work.shield.ShieldPurchaseDetailMapper;
import cn.smarthse.modules.health.entity.work.shield.ShieldPurchase;
import cn.smarthse.modules.health.entity.work.shield.ShieldPurchaseDetail;
import cn.smarthse.modules.health.service.work.shield.IShieldPurchaseDetailService;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
@Transactional(readOnly=true)
public class ShieldPurchaseDetailServiceImpl
extends BaseServiceImpl<ShieldPurchaseDetailMapper, ShieldPurchaseDetail>
implements IShieldPurchaseDetailService {
    @Transactional(readOnly=false)
    public void updateDetailsByParent(ShieldPurchase data) {
        if (data == null) {
            return;
        }
        this.deleteShieldByPid(data.getId());
        List details = data.getDetails();
        if (data.getId() == null || details == null) {
            return;
        }
        for (ShieldPurchaseDetail detail : details) {
            if (detail.getShieldId() == null) continue;
            this.setParentInfos(data, detail);
            ((ShieldPurchaseDetailMapper)this.dao).insert(detail);
        }
    }

    private void deleteShieldByPid(Long buyId) {
        if (buyId == null) {
            return;
        }
        Example example = new Example(ShieldPurchaseDetail.class);
        example.createCriteria().andEqualTo("buyId", (Object)buyId);
        ((ShieldPurchaseDetailMapper)this.dao).deleteByExample(example);
    }

    private void setParentInfos(ShieldPurchase data, ShieldPurchaseDetail detail) {
        detail.setBuyId(data.getId());
        detail.setCid(data.getCid());
        detail.setCreateBy(data.getUpdateBy());
        detail.setCreateDate(data.getUpdateDate());
        detail.setUpdateBy(data.getUpdateBy());
        detail.setUpdateDate(data.getUpdateDate());
    }

    public List<ShieldPurchaseDetail> getByPid(Long pid) {
        if (pid == null) {
            return null;
        }
        Example example = new Example(ShieldPurchaseDetail.class);
        example.createCriteria().andEqualTo("buyId", (Object)pid);
        return ((ShieldPurchaseDetailMapper)this.dao).selectByExample(example);
    }

    @Transactional(readOnly=false)
    public void updateDetails(Long pid, List<ShieldPurchaseDetail> details) {
        this.deleteShieldByPid(pid);
        if (details == null) {
            return;
        }
        for (ShieldPurchaseDetail detail : details) {
            if (detail.getShieldId() == null) continue;
            ((ShieldPurchaseDetailMapper)this.dao).insert(detail);
        }
    }
}

