/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.shield;

import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.health.dao.work.shield.ShieldEquipRuleMapper;
import cn.smarthse.modules.health.entity.work.harmfactor.Vo.HarmfactorWorkSourceInfoVo;
import cn.smarthse.modules.health.entity.work.shield.ShieldEquipRule;
import cn.smarthse.modules.health.entity.work.shield.vo.HarmfactorWorkInfo;
import cn.smarthse.modules.health.entity.work.shield.vo.ShieldEquipRuleImportInfo;
import cn.smarthse.modules.health.entity.work.shield.vo.ShieldEquipRuleInfo;
import cn.smarthse.modules.health.entity.work.shield.vo.ShieldWorkRelation;
import cn.smarthse.modules.health.enums.sys.coreWork.CoreWorkEnum;
import cn.smarthse.modules.health.service.base.workinfo.IWorkRoleInfoService;
import cn.smarthse.modules.health.service.sys.ISysCoreWorkModuleCorrelationService;
import cn.smarthse.modules.health.service.work.harmfactor.IHarmfactorWorkService;
import cn.smarthse.modules.health.service.work.shield.IShieldEquipRuleDangerService;
import cn.smarthse.modules.health.service.work.shield.IShieldEquipRuleDetailService;
import cn.smarthse.modules.health.service.work.shield.IShieldEquipRuleImportService;
import cn.smarthse.modules.health.service.work.shield.IShieldEquipRuleService;
import cn.smarthse.modules.health.vo.base.historyBasic.BasicEntityContentSearch;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class ShieldEquipRuleServiceImpl
extends BaseServiceImpl<ShieldEquipRuleMapper, ShieldEquipRule>
implements IShieldEquipRuleService {
    @Autowired
    ShieldEquipRuleMapper shieldEquipRuleMapper;
    @Autowired
    IShieldEquipRuleDetailService detailService;
    @Autowired
    IHarmfactorWorkService harmService;
    @Autowired
    ISysCoreWorkModuleCorrelationService sysService;
    @Autowired
    IShieldEquipRuleDangerService dangerService;
    @Autowired
    IWorkRoleInfoService workService;
    @Autowired
    IShieldEquipRuleImportService importService;

    public PageInfo<ShieldEquipRule> listDetails(int pageIndex, ShieldEquipRule data) {
        PageHelper.startPage((int)pageIndex, (int)10);
        List<ShieldEquipRule> list = this.listDetails(data);
        return new PageInfo(list);
    }

    public ShieldEquipRule getDetailById(Long id) {
        ShieldEquipRule data = this.shieldEquipRuleMapper.getDetailById(id);
        if (data == null) {
            return data;
        }
        data.setHarmNames(this.harmService.getHarmNamesByWork(data.getCid(), data.getWorkId(), " "));
        data.setDangers(this.dangerService.getListByRuleId(data.getId()));
        return data;
    }

    @Transactional(readOnly=false)
    public ShieldEquipRule insertOrUpdate(ShieldEquipRule rule, Long cid, Long staffId) {
        if (rule == null) {
            return rule;
        }
        rule.setCid(cid);
        this.deleteInfosByRule(rule);
        if (rule.getId() == null) {
            this.setCreateInfo(rule, cid, staffId);
            this.add(rule);
        } else {
            this.update(rule, staffId);
        }
        this.detailService.updateDetailsByParent(rule);
        this.dangerService.updateByRule(rule);
        this.updateTip(rule, cid, staffId);
        this.updateHistory(rule, cid, staffId);
        return rule;
    }

    private void updateHistory(ShieldEquipRule newEntity, Long cid, Long staffId) {
    }

    private void updateTip(ShieldEquipRule data, Long cid, Long staffId) {
        if (data.getFromType() == null) {
            return;
        }
        CoreWorkEnum desCoreWork = CoreWorkEnum.personalProtectionEquipment;
        CoreWorkEnum sourceCoreWork = CoreWorkEnum.getCoreWorkEnum((Byte)data.getFromType());
        this.sysService.businessComplete(desCoreWork, sourceCoreWork, data.getId(), staffId, cid, new Long[]{data.getWorkId()});
    }

    @Transactional(readOnly=false)
    public void deleteInfosByRule(ShieldEquipRule rule) {
        if (rule == null || rule.getWorkId() == null || rule.getCid() == null) {
            return;
        }
        Example example = new Example(ShieldEquipRule.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("workId", (Object)rule.getWorkId());
        criteria.andEqualTo("cid", (Object)rule.getCid());
        if (rule.getId() != null) {
            criteria.andNotEqualTo("id", (Object)rule.getId());
        }
        ((ShieldEquipRuleMapper)this.dao).deleteByExample(example);
    }

    public PageInfo<ShieldEquipRule> getList(JqGridParam gparam, ShieldEquipRule param) {
        if (gparam == null) {
            return new PageInfo();
        }
        PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows());
        return new PageInfo(this.listDetails(param));
    }

    public List<ShieldEquipRule> listDetails(ShieldEquipRule data) {
        List<ShieldEquipRule> list = ((ShieldEquipRuleMapper)this.dao).listDetails(data);
        if (list == null || list.isEmpty()) {
            return list;
        }
        if (!"true".equals(data.getIsSharingSystem())) {
            return list;
        }
        for (ShieldEquipRule l : list) {
            Long workId = l.getWorkId();
            if (workId == null) continue;
            l.setWorkName(this.workService.getWorkNameIncludeOrgName(workId));
        }
        return ((ShieldEquipRuleMapper)this.dao).listDetails(data);
    }

    @Transactional(readOnly=false)
    public void deleteByIds(String ids, Long updateBy, Long cid) {
        List idArray = StringUtils.parseToLongList((String)ids, (String)",");
        if (idArray == null || idArray.size() == 0) {
            return;
        }
        Example example = new Example(ShieldEquipRule.class);
        example.createCriteria().andIn("id", (Iterable)idArray);
        ShieldEquipRule data = new ShieldEquipRule();
        data.setIsValid(Boolean.valueOf(false));
        data.setUpdateDate(new Date());
        data.setUpdateBy(updateBy);
        ((ShieldEquipRuleMapper)this.dao).updateByExampleSelective(data, example);
        for (Long id : idArray) {
            this.sysService.businessDelete(CoreWorkEnum.personalProtectionEquipment, id, updateBy, cid);
        }
    }

    public List<ShieldWorkRelation> getShieldInfosByWorkId(Long workId, Long cid) {
        if (workId == null || cid == null) {
            return null;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("cid", cid);
        params.put("workId", workId);
        List<ShieldWorkRelation> returnList = ((ShieldEquipRuleMapper)this.dao).getShieldInfosByWorkId(params);
        return returnList;
    }

    public ShieldEquipRule getDetailsByWorkId(ShieldEquipRule param) {
        if (param == null || param.getWorkId() == null || param.getCid() == null) {
            return param;
        }
        List<ShieldEquipRule> list = ((ShieldEquipRuleMapper)this.dao).getDetailsByWorkId(param);
        if (list != null && list.size() > 0) {
            ShieldEquipRule data = list.get(0);
            data.setWorkName(this.workService.getWorkNameIncludeOrgName(data.getWorkId()));
            return data;
        }
        return param;
    }

    public List<HarmfactorWorkInfo> getHarmfactorListByRule(Long ruleId) {
        if (ruleId == null) {
            return null;
        }
        return ((ShieldEquipRuleMapper)this.dao).getHarmfactorListByRule(ruleId);
    }

    public List<ShieldEquipRuleInfo> listDetailInfos(ShieldEquipRule data) {
        List<ShieldEquipRuleInfo> list = ((ShieldEquipRuleMapper)this.dao).listDetailInfos(data);
        if (list == null || list.isEmpty()) {
            return list;
        }
        if (!"true".equals(data.getIsSharingSystem())) {
            return list;
        }
        for (ShieldEquipRuleInfo l : list) {
            Long workId = l.getWorkId();
            if (workId == null) continue;
            l.setWorkName(this.workService.getWorkNameIncludeOrgName(workId));
        }
        return list;
    }

    public PageInfo<ShieldEquipRuleInfo> getPage(JqGridParam gparam, ShieldEquipRule param) {
        if (gparam == null) {
            return new PageInfo();
        }
        PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows());
        return new PageInfo(this.listDetailInfos(param));
    }

    public ShieldEquipRule getDetailByRule(ShieldEquipRule rule) {
        if (rule == null || rule.getId() == null) {
            return rule;
        }
        ShieldEquipRule data = this.shieldEquipRuleMapper.getDetailById(rule.getId());
        if (data == null) {
            return rule;
        }
        data.setWorkName(this.workService.getWorkNameIncludeOrgName(data.getWorkId()));
        data.setDetailType(rule.getDetailType());
        data.setDetails(this.detailService.getListByRule(rule));
        data.setHarmNames((String)this.getHarmInfos(data.getCid(), data.getWorkId()).get("harms"));
        data.setDangers(this.dangerService.getListByRuleId(data.getId()));
        return data;
    }

    private Map<String, Object> getHarmInfos(Long cid, Long workId) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        String harmNames = "";
        Object harmIds = "";
        List harms = this.harmService.getHarmfactorListByWork(cid, workId);
        if (harms == null || harms.size() == 0) {
            return resultMap;
        }
        ArrayList<String> harmArray = new ArrayList<String>();
        for (HarmfactorWorkSourceInfoVo harm : harms) {
            Long harmId = harm.getHarmId();
            String harmCh = harm.getHarmName();
            if (StringUtils.isEmpty((CharSequence)harmCh) || harmArray.contains(harmCh)) continue;
            harmNames = StringUtils.isEmpty((CharSequence)harmNames) ? harmCh : harmNames + " " + harmCh;
            harmIds = (String)harmIds + harmId + ",";
            harmArray.add(harmCh);
        }
        resultMap.put("harms", harmNames);
        resultMap.put("harmIds", harmIds);
        return resultMap;
    }

    @Transactional(readOnly=false)
    public ShieldEquipRule recommendPost(ShieldEquipRule rule, Long cid, Long staffId) {
        if (rule == null) {
            return rule;
        }
        rule.setIsValid(Boolean.valueOf(true));
        rule.setCid(cid);
        this.update(rule, staffId);
        this.detailService.addRecommends(rule);
        this.dangerService.updateByRule(rule);
        this.updateTip(rule, cid, staffId);
        this.updateHistory(rule, cid, staffId);
        return rule;
    }

    public ShieldEquipRule getRuleInfoById(Long ruleId) {
        if (ruleId == null) {
            return null;
        }
        ShieldEquipRule rule = this.shieldEquipRuleMapper.getDetailById(ruleId);
        if (rule == null) {
            return rule;
        }
        rule.setWorkName(this.workService.getWorkNameIncludeOrgName(rule.getWorkId()));
        return rule;
    }

    @Transactional(readOnly=false)
    public void deleteDanger(Long ruleId, Long dangerId) {
        this.dangerService.deleteInfo(ruleId, dangerId);
    }

    public String getExistWorkIds(Long cid, Long excludeWorkId) {
        return ((ShieldEquipRuleMapper)this.dao).getExistWorkIds(cid, excludeWorkId);
    }

    public List<ShieldWorkRelation> getHistoryShieldInfosByWorkId(Long workId, Long cid, Date date) {
        if (workId == null || cid == null) {
            return null;
        }
        ArrayList<BasicEntityContentSearch> search = new ArrayList<BasicEntityContentSearch>();
        BasicEntityContentSearch s = new BasicEntityContentSearch();
        s.setKey("workId");
        s.setValue((Object)workId);
        search.add(s);
        return null;
    }

    public List<Long> getIdsByWorkIds(List<Long> workIds) {
        if (workIds == null || workIds.size() == 0) {
            return new ArrayList<Long>();
        }
        return ((ShieldEquipRuleMapper)this.dao).getIdsByWorkIds(workIds);
    }

    private List<ShieldWorkRelation> convertToRaltion(ShieldEquipRule d, Date date, Long cid) {
        ArrayList results = new ArrayList();
        ArrayList<BasicEntityContentSearch> search = new ArrayList<BasicEntityContentSearch>();
        BasicEntityContentSearch s = new BasicEntityContentSearch();
        s.setKey("ruleId");
        s.setValue((Object)d.getId());
        search.add(s);
        return null;
    }

    @Transactional(readOnly=false)
    public ResponseData<Object> importRules(List<List<String>> contents, Long staffId, Long cid) {
        return this.importService.importRules(contents, staffId, cid);
    }

    public List<ShieldEquipRuleImportInfo> listExistInfos(Long cid) {
        return ((ShieldEquipRuleMapper)this.dao).listExistInfos(cid);
    }

    @Transactional(readOnly=false)
    public void clearOldRule(List<Long> ruleIds) {
        if (ruleIds == null || ruleIds.isEmpty()) {
            return;
        }
        Example example = new Example(ShieldEquipRule.class);
        Example.Criteria c = example.createCriteria();
        c.andIn("id", ruleIds);
        ((ShieldEquipRuleMapper)this.dao).deleteByExample(example);
    }
}

