/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.shield;

import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.enums.ResponseStateEnum;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.number.NumberUtil;
import cn.smarthse.modules.health.dao.work.shield.ShieldEquipRuleImportMapper;
import cn.smarthse.modules.health.entity.base.workinfo.WorkRoleInfo;
import cn.smarthse.modules.health.entity.work.shield.ProtectList;
import cn.smarthse.modules.health.entity.work.shield.ShieldEquipRule;
import cn.smarthse.modules.health.entity.work.shield.ShieldEquipRuleDanger;
import cn.smarthse.modules.health.entity.work.shield.ShieldEquipRuleDetail;
import cn.smarthse.modules.health.entity.work.shield.vo.ProtectQuery;
import cn.smarthse.modules.health.entity.work.shield.vo.ShieldEquipRuleImportInfo;
import cn.smarthse.modules.health.enums.shield.ShieldCountUnitEnum;
import cn.smarthse.modules.health.enums.shield.ShieldCycleUnitEnum;
import cn.smarthse.modules.health.service.base.workinfo.IWorkRoleInfoService;
import cn.smarthse.modules.health.service.work.shield.IL09HarmTypeService;
import cn.smarthse.modules.health.service.work.shield.IProtectListService;
import cn.smarthse.modules.health.service.work.shield.IShieldEquipRuleDangerService;
import cn.smarthse.modules.health.service.work.shield.IShieldEquipRuleDetailService;
import cn.smarthse.modules.health.service.work.shield.IShieldEquipRuleImportService;
import cn.smarthse.modules.health.service.work.shield.IShieldEquipRuleService;
import cn.smarthse.modules.health.vo.base.ImportErrorInfo;
import cn.smarthse.snowflake.IdWorker;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class ShieldEquipRuleImportServiceImpl
implements IShieldEquipRuleImportService {
    @Autowired
    IShieldEquipRuleDetailService detailService;
    @Autowired
    IShieldEquipRuleDangerService dangerService;
    @Autowired
    IWorkRoleInfoService workService;
    @Autowired
    IProtectListService protectListService;
    @Autowired
    IShieldEquipRuleService shieldEquipRuleService;
    @Autowired
    IL09HarmTypeService l09HarmTypeService;
    @Autowired
    ShieldEquipRuleImportMapper mapper;
    @Autowired
    protected IdWorker idworker;
    private String protectNameAndLevelSplitor = "/";
    private Map<String, WorkRoleInfo> workRoleInfoMap;
    private Map<String, ProtectList> protectListMap;
    private Map<Long, Long> existRuleMap;
    private Map<String, Long> existRuleDetailMap;
    private Map<String, Long> existRuleDangerMap;
    private Map<String, Long> dangerMap;
    private List<ShieldEquipRule> needImportRules;
    private List<ShieldEquipRuleDetail> needAddeRuleDetails;
    private List<ShieldEquipRuleDetail> needUpdateRuleDetails;
    private List<ShieldEquipRuleDanger> needAddRuleDangers;
    private List<ShieldEquipRuleDanger> needUpdateRuleDangers;

    private void init(Long cid) {
        this.workRoleInfoMap = this.getWorkInfoMap(cid);
        this.protectListMap = this.getProtectMap();
        this.setExistRules(cid);
        this.dangerMap = this.getDangerMap();
        this.needImportRules = new ArrayList<ShieldEquipRule>();
        this.needAddeRuleDetails = new ArrayList<ShieldEquipRuleDetail>();
        this.needUpdateRuleDetails = new ArrayList<ShieldEquipRuleDetail>();
        this.needAddRuleDangers = new ArrayList<ShieldEquipRuleDanger>();
        this.needUpdateRuleDangers = new ArrayList<ShieldEquipRuleDanger>();
    }

    private Map<String, Long> getDangerMap() {
        HashMap<String, Long> map = new HashMap<String, Long>();
        List list = this.l09HarmTypeService.getList(null);
        if (list == null || list.isEmpty()) {
            return map;
        }
        list.forEach(l -> map.put(l.getHarmType(), l.getId().longValue()));
        return map;
    }

    private void setExistRules(Long cid) {
        this.existRuleMap = new HashMap<Long, Long>();
        this.existRuleDetailMap = new HashMap<String, Long>();
        this.existRuleDangerMap = new HashMap<String, Long>();
        List infos = this.shieldEquipRuleService.listExistInfos(cid);
        if (infos == null || infos.isEmpty()) {
            return;
        }
        for (ShieldEquipRuleImportInfo info : infos) {
            Long workId = info.getWorkId();
            Long ruleId = info.getId();
            String shiledId = info.getShieldId();
            Long dangerId = info.getDangerId();
            this.existRuleMap.put(workId, ruleId);
            this.existRuleDetailMap.put(workId + "_" + shiledId, info.getDetailId());
            this.existRuleDangerMap.put(workId + "_" + dangerId, info.getRuleDangerId());
        }
    }

    @Transactional(readOnly=false)
    public ResponseData<Object> importRules(List<List<String>> contents, Long staffId, Long cid) {
        ResponseData responseData = new ResponseData();
        responseData.setState(ResponseStateEnum.warning);
        if (contents == null || contents.isEmpty()) {
            responseData.setContent("\u5bfc\u5165\u7684\u6587\u4ef6\u4e2d\u6ca1\u6709\u6570\u636e\uff0c\u8bf7\u6309\u89c4\u5219\u586b\u5199\u4e4b\u540e\u518d\u5bfc\u5165\uff01");
            return responseData;
        }
        this.init(cid);
        if (this.workRoleInfoMap == null || this.workRoleInfoMap.isEmpty()) {
            responseData.setContent("\u7cfb\u7edf\u4e2d\u7f3a\u5c11\u5c97\u4f4d\u5de5\u79cd\u4fe1\u606f\uff0c\u8bf7\u5148\u6dfb\u52a0\uff01");
            return responseData;
        }
        ArrayList<ImportErrorInfo> errors = new ArrayList<ImportErrorInfo>();
        this.checkImportDatas(contents, errors, staffId, cid);
        this.doImport();
        if (!errors.isEmpty()) {
            responseData.setResult(errors);
            responseData.setContent("\u90e8\u5206\u5bfc\u5165\u5931\u8d25\uff01");
        } else {
            responseData.setState(ResponseStateEnum.success);
            responseData.setContent("\u5bfc\u5165\u6210\u529f\uff01");
        }
        return responseData;
    }

    private boolean hasImportDatas() {
        return this.needImportRules.isEmpty() && this.needUpdateRuleDetails.isEmpty() && this.needAddRuleDangers.isEmpty() && this.needAddeRuleDetails.isEmpty() && this.needUpdateRuleDangers.isEmpty();
    }

    private void doImport() {
        this.addBatches();
        this.updateBatches();
    }

    private void addBatches() {
        if (!this.needImportRules.isEmpty()) {
            this.mapper.addRuleBatch(this.needImportRules);
        }
        if (!this.needAddRuleDangers.isEmpty()) {
            this.dangerService.addRuleDangerBatch(this.needAddRuleDangers);
        }
        if (!this.needAddeRuleDetails.isEmpty()) {
            this.detailService.addRuleDetailBatch(this.needAddeRuleDetails);
        }
    }

    private void updateBatches() {
        if (!this.needUpdateRuleDangers.isEmpty()) {
            this.dangerService.updateRuleDangerBatch(this.needAddRuleDangers);
        }
        if (!this.needUpdateRuleDetails.isEmpty()) {
            this.detailService.updateRuleDetailBatch(this.needUpdateRuleDetails);
        }
    }

    private void checkImportDatas(List<List<String>> contents, List<ImportErrorInfo> errors, Long staffId, Long cid) {
        Date now = new Date();
        for (int i = 0; i < contents.size(); ++i) {
            ShieldEquipRuleDetail detail = new ShieldEquipRuleDetail();
            detail.setCreateBy(staffId);
            detail.setUpdateBy(staffId);
            detail.setCid(cid);
            ImportErrorInfo importErrorInfo = new ImportErrorInfo();
            importErrorInfo.setRowNum(i);
            ArrayList<Object> errorMsg = new ArrayList<Object>();
            List<String> content = contents.get(i);
            String workName = content.get(0);
            Long workId = null;
            if (StringUtils.isEmpty((CharSequence)workName)) {
                errorMsg.add("\u5c97\u4f4d/\u5de5\u79cd\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            } else {
                WorkRoleInfo workRoleInfo = this.workRoleInfoMap.get(workName);
                if (workRoleInfo == null) {
                    errorMsg.add("\u627e\u4e0d\u5230\u8be5\u5c97\u4f4d/\u5de5\u79cd\u201c" + workName + "\u201d\uff01");
                } else {
                    workId = workRoleInfo.getId();
                }
            }
            String shieldName = content.get(1);
            String protectLevel = content.get(2);
            ProtectList protect = null;
            String shieldId = null;
            if (StringUtils.isEmpty((CharSequence)shieldName)) {
                errorMsg.add("\u9632\u62a4\u7528\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            } else {
                if (this.protectNameAndLevelSplitor.equals(protectLevel)) {
                    protectLevel = "";
                }
                if ((protect = this.protectListMap.get(shieldName + this.protectNameAndLevelSplitor + protectLevel)) == null) {
                    errorMsg.add("\u9632\u62a4\u7528\u54c1\u540d\u79f0\u548c\u4fdd\u62a4\u7b49\u7ea7\u4e0d\u5bf9\u5e94\uff0c\u8bf7\u6309\u7167\u9632\u62a4\u7528\u54c1\u540d\u79f0\u53c2\u7167\u8868\u89c4\u5219\u586b\u5199\uff01");
                } else {
                    shieldId = protect.getPpeId();
                    detail.setShieldId(shieldId);
                    detail.setDetailName(protect.getProName());
                    detail.setFunc(protect.getFunction());
                }
            }
            String danger = "";
            String desc = content.get(3);
            detail.setShieldDesc(desc);
            Long dangerId = this.dangerMap.get(danger);
            ShieldEquipRuleDanger ruleDanger = this.createDanger(dangerId, staffId, cid);
            String isOnDemand = content.get(4);
            String count = content.get(5);
            String countUnit = content.get(6);
            String time = content.get(7);
            String timeUnit = content.get(8);
            detail.setCycleUnit(ShieldCycleUnitEnum.getCode((String)timeUnit));
            detail.setCountUnit(ShieldCountUnitEnum.getCode((String)countUnit));
            detail.setIsOnDemand(Boolean.valueOf("1".equals(isOnDemand)));
            if (StringUtils.isEmpty((CharSequence)(isOnDemand + count + countUnit + time + timeUnit))) {
                errorMsg.add("\u6309\u9700\u53d1\u653e\u548c\u53d1\u653e\u5468\u671f\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\uff01");
            } else if (StringUtils.isNotEmpty((String)isOnDemand) && StringUtils.isNotEmpty((String)(count + countUnit + time + timeUnit))) {
                errorMsg.add("\u6309\u9700\u53d1\u653e\u548c\u53d1\u653e\u5468\u671f\u53ea\u80fd\u586b\u5199\u5176\u4e2d\u4e4b\u4e00\uff01");
            } else if (StringUtils.isNotEmpty((String)isOnDemand) && !"1".equals(isOnDemand)) {
                errorMsg.add("\u8bf7\u6309\u8bf4\u660e\u586b\u5199\u6309\u9700\u53d1\u653e\uff01");
            } else if (StringUtils.isEmpty((CharSequence)isOnDemand)) {
                if (StringUtils.isEmpty((CharSequence)count) || StringUtils.isEmpty((CharSequence)countUnit) || StringUtils.isEmpty((CharSequence)time) || StringUtils.isEmpty((CharSequence)timeUnit)) {
                    errorMsg.add("\u8bf7\u586b\u5199\u5b8c\u6574\u7684\u53d1\u653e\u5468\u671f\uff01");
                } else if (!NumberUtil.isPositiveInteger((String)count) || !NumberUtil.isPositiveInteger((String)time)) {
                    errorMsg.add("\u8bf7\u6309\u8bf4\u660e\u586b\u5199\u6570\u91cf\uff01");
                } else {
                    detail.setCycle(Integer.valueOf(Integer.parseInt(time)));
                    detail.setAmount(Integer.valueOf(Integer.parseInt(count)));
                }
            }
            if (!errorMsg.isEmpty()) {
                importErrorInfo.setErrorMsg(errorMsg);
                errors.add(importErrorInfo);
                continue;
            }
            Long ruleId = this.existRuleMap.get(workId);
            String detailKey = workId + "_" + shieldId;
            String dangerKey = workId + "_" + dangerId;
            if (ruleId == null) {
                ShieldEquipRule rule = this.createRule(workId, staffId, cid);
                this.needImportRules.add(rule);
                Long newRuleId = rule.getId();
                this.existRuleMap.put(workId, newRuleId);
                detail.setRuleId(newRuleId);
                detail.setId(Long.valueOf(this.idworker.nextId()));
                this.existRuleDetailMap.put(detailKey, detail.getId());
                this.needAddeRuleDetails.add(detail);
                ruleDanger.setRuleId(newRuleId);
                this.existRuleDangerMap.put(dangerKey, ruleDanger.getId());
                this.needAddRuleDangers.add(ruleDanger);
                continue;
            }
            Long detailId = this.existRuleDetailMap.get(detailKey);
            if (detailId != null) {
                detail.setId(detailId);
                detail.setUpdateBy(staffId);
                detail.setUpdateDate(now);
                this.needUpdateRuleDetails.add(detail);
            } else {
                detail.setRuleId(ruleId);
                detail.setId(Long.valueOf(this.idworker.nextId()));
                this.existRuleDetailMap.put(detailKey, detail.getId());
                this.needAddeRuleDetails.add(detail);
            }
            Long ruleDangerId = this.existRuleDangerMap.get(dangerKey);
            if (ruleDangerId != null) {
                ruleDanger.setId(ruleDangerId);
                ruleDanger.setRuleId(ruleId);
                ruleDanger.setUpdateBy(staffId);
                ruleDanger.setUpdateDate(now);
                this.needUpdateRuleDangers.add(ruleDanger);
                continue;
            }
            ruleDanger.setRuleId(ruleId);
            ruleDanger.setId(Long.valueOf(this.idworker.nextId()));
            this.existRuleDangerMap.put(dangerKey, ruleDanger.getId());
            this.needAddRuleDangers.add(ruleDanger);
        }
    }

    private ShieldEquipRuleDanger createDanger(Long dangerId, Long staffId, Long cid) {
        ShieldEquipRuleDanger danger = new ShieldEquipRuleDanger();
        danger.setId(Long.valueOf(this.idworker.nextId()));
        danger.setDangerId(dangerId);
        danger.setCid(cid);
        danger.setCreateBy(staffId);
        danger.setUpdateBy(staffId);
        return danger;
    }

    private ShieldEquipRule createRule(Long workId, Long staffId, Long cid) {
        ShieldEquipRule rule = new ShieldEquipRule();
        rule.setId(Long.valueOf(this.idworker.nextId()));
        rule.setWorkId(workId);
        rule.setCid(cid);
        rule.setCreateBy(staffId);
        rule.setUpdateBy(staffId);
        return rule;
    }

    private Map<String, ProtectList> getProtectMap() {
        HashMap<String, ProtectList> protectListMap = new HashMap<String, ProtectList>();
        ProtectQuery query = new ProtectQuery();
        List list = this.protectListService.getList(query);
        if (list == null || list.isEmpty()) {
            return protectListMap;
        }
        list.forEach(protect -> protectListMap.put(protect.getProName() + this.protectNameAndLevelSplitor + protect.getProLevel(), (ProtectList)protect));
        return protectListMap;
    }

    private Map<String, WorkRoleInfo> getWorkInfoMap(Long cid) {
        HashMap<String, WorkRoleInfo> workRoleInfoMap = new HashMap<String, WorkRoleInfo>();
        List list = this.workService.getWorkRoleOrganByCidAndSearch(cid, null);
        if (list == null || list.isEmpty()) {
            return null;
        }
        list.forEach(workRoleInfo -> workRoleInfoMap.put(workRoleInfo.getWorkName(), (WorkRoleInfo)workRoleInfo));
        return workRoleInfoMap;
    }
}

