/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.shield;

import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.dao.work.shield.ShieldEquipRuleDetailMapper;
import cn.smarthse.modules.health.entity.work.shield.ShieldEquipRule;
import cn.smarthse.modules.health.entity.work.shield.ShieldEquipRuleDetail;
import cn.smarthse.modules.health.model.HProEquipmentDetailModel;
import cn.smarthse.modules.health.service.work.shield.IProtectListService;
import cn.smarthse.modules.health.service.work.shield.IShieldEquipRuleDetailService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class ShieldEquipRuleDetailServiceImpl
extends BaseServiceImpl<ShieldEquipRuleDetailMapper, ShieldEquipRuleDetail>
implements IShieldEquipRuleDetailService {
    @Autowired
    ShieldEquipRuleDetailMapper shieldEquipRuleDetailMapper;
    @Autowired
    IProtectListService protectListService;
    private static final Byte PROTECT_QUERY_RECOMMEND = 1;
    private static final Byte HARM_DANGER_RECOMMEND = 2;

    @Transactional(readOnly=false)
    public void updateDetailsByParent(ShieldEquipRule rule) {
        if (rule == null) {
            return;
        }
        List details = rule.getDetails();
        if (rule.getId() == null || details == null) {
            return;
        }
        ArrayList<Long> excludeIds = new ArrayList<Long>();
        for (ShieldEquipRuleDetail detail : details) {
            if (StringUtils.isEmpty((CharSequence)detail.getShieldId())) continue;
            this.setParentInfos(rule, detail);
            if (detail.getId() == null) {
                detail.setId(Long.valueOf(this.idworker.nextId()));
                this.add(detail);
            } else {
                if (detail.getIsOnDemand() == null) {
                    detail.setIsOnDemand(Boolean.valueOf(false));
                }
                this.update(detail);
            }
            excludeIds.add(detail.getId());
        }
        this.deleteByExcludeIds(excludeIds, rule.getId());
    }

    private void deleteByExcludeIds(List<Long> excludeIds, Long ruleId) {
        if (excludeIds == null || excludeIds.isEmpty()) {
            return;
        }
        Example example = new Example(ShieldEquipRuleDetail.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andNotIn("id", excludeIds);
        criteria.andEqualTo("ruleId", (Object)ruleId);
        ((ShieldEquipRuleDetailMapper)this.dao).deleteByExample(example);
    }

    @Transactional(readOnly=false)
    public void deleteShieldByRule(ShieldEquipRule rule) {
        if (rule == null || rule.getId() == null) {
            return;
        }
        Example example = new Example(ShieldEquipRuleDetail.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("ruleId", (Object)rule.getId());
        ((ShieldEquipRuleDetailMapper)this.dao).deleteByExample(example);
    }

    private void setParentInfos(ShieldEquipRule rule, ShieldEquipRuleDetail detail) {
        detail.setRuleId(rule.getId());
        detail.setCid(rule.getCid());
        detail.setCreateBy(rule.getUpdateBy());
        detail.setCreateDate(rule.getUpdateDate());
        detail.setUpdateBy(rule.getUpdateBy());
        detail.setUpdateDate(rule.getUpdateDate());
    }

    public List<ShieldEquipRuleDetail> getDetailList(ShieldEquipRuleDetail param) {
        return ((ShieldEquipRuleDetailMapper)this.dao).getDetailList(param);
    }

    public List<HProEquipmentDetailModel> getByWorkId(Long workId) {
        if (workId == null) {
            return null;
        }
        List<ShieldEquipRuleDetail> list = ((ShieldEquipRuleDetailMapper)this.dao).getByWorkId(workId);
        return this.convertToModels(list);
    }

    private List<HProEquipmentDetailModel> convertToModels(List<ShieldEquipRuleDetail> list) {
        ArrayList<HProEquipmentDetailModel> results = new ArrayList<HProEquipmentDetailModel>();
        if (list == null || list.size() == 0) {
            return null;
        }
        for (ShieldEquipRuleDetail detail : list) {
            if (detail == null) continue;
            HProEquipmentDetailModel model = this.createModel(detail);
            results.add(model);
        }
        return results;
    }

    private HProEquipmentDetailModel createModel(ShieldEquipRuleDetail detail) {
        HProEquipmentDetailModel model = new HProEquipmentDetailModel();
        model.setDescribe(detail.getDescription());
        model.setInstructions(detail.getShieldDesc());
        model.setIssueCycle(detail.getCycleRule());
        model.setProtectiveName(detail.getShieldName());
        model.setFunc(detail.getFunc());
        return model;
    }

    @Transactional(readOnly=false)
    public void updateByProtects(Long ruleId, String[] checkedProtectPPEIds, String[] removedProtectPPEIds, Long staffId, Long cid) {
        if (ruleId == null) {
            return;
        }
        this.addByProtectIds(ruleId, checkedProtectPPEIds, staffId, cid);
    }

    private List<String> getPPEIds(String[] ppeArray) {
        ArrayList<String> ids = new ArrayList<String>();
        for (String id : ppeArray) {
            if (StringUtils.isEmpty((CharSequence)id) || ids.contains(id)) continue;
            ids.add(id);
        }
        return ids;
    }

    private void addByProtectIds(Long ruleId, String[] checkedProtectPPEIds, Long staffId, Long cid) {
        if (checkedProtectPPEIds == null || checkedProtectPPEIds.length == 0) {
            return;
        }
        List<String> ids = this.getPPEIds(checkedProtectPPEIds);
        if (ids == null || ids.size() == 0) {
            return;
        }
        List<ShieldEquipRuleDetail> details = ((ShieldEquipRuleDetailMapper)this.dao).getHaveNotProtects(ids, ruleId);
        this.addDetails(details, ruleId, staffId, cid, PROTECT_QUERY_RECOMMEND);
    }

    private void addDetails(List<ShieldEquipRuleDetail> details, Long ruleId, Long staffId, Long cid, Byte type) {
        if (ruleId == null || details == null || details.size() == 0) {
            return;
        }
        for (ShieldEquipRuleDetail d : details) {
            if (StringUtils.isEmpty((CharSequence)d.getShieldId())) continue;
            ShieldEquipRuleDetail detail = this.getDetail(ruleId, d.getShieldId());
            if (detail != null) {
                detail.setUpdateBy(staffId);
                detail.setUpdateDate(new Date());
                detail.setShieldDesc(d.getShieldDesc());
                detail.setOther(d.getOther());
                this.update(detail);
                continue;
            }
            d.setRuleId(ruleId);
            d.setCid(cid);
            d.setCreateBy(staffId);
            d.setCreateDate(new Date());
            d.setUpdateBy(staffId);
            d.setUpdateDate(d.getCreateDate());
            d.setType(type);
            d.setId(Long.valueOf(this.idworker.nextId()));
            ((ShieldEquipRuleDetailMapper)this.dao).insert(d);
        }
    }

    private ShieldEquipRuleDetail getDetail(Long ruleId, String shieldId) {
        Example example = new Example(ShieldEquipRuleDetail.class);
        example.createCriteria().andEqualTo("ruleId", (Object)ruleId).andEqualTo("shieldId", (Object)shieldId);
        List list = ((ShieldEquipRuleDetailMapper)this.dao).selectByExample(example);
        return list == null || list.size() == 0 ? null : (ShieldEquipRuleDetail)list.get(0);
    }

    @Transactional(readOnly=false)
    public void updateByProtects(ShieldEquipRule rule, String[] removedProtectPPEIds) {
        if (rule == null || rule.getId() == null) {
            return;
        }
        Long ruleId = rule.getId();
        List details = rule.getDetails();
        this.addDetails(details, ruleId, rule.getCreateBy(), rule.getCid(), PROTECT_QUERY_RECOMMEND);
    }

    public List<ShieldEquipRuleDetail> getListByRule(ShieldEquipRule rule) {
        if (rule == null || rule.getId() == null) {
            return null;
        }
        return ((ShieldEquipRuleDetailMapper)this.dao).getListByRule(rule);
    }

    public void addRecommends(ShieldEquipRule rule) {
        List details = rule.getDetails();
        this.addDetails(details, rule.getId(), rule.getCreateBy(), rule.getCid(), HARM_DANGER_RECOMMEND);
    }

    public List<ShieldEquipRuleDetail> getDetailTable(ShieldEquipRuleDetail param) {
        return ((ShieldEquipRuleDetailMapper)this.dao).getDetailTable(param);
    }

    public List<ShieldEquipRuleDetail> getDetailTableV2_9(Long cid, List<Long> ruleIds) {
        if (ruleIds != null && ruleIds.size() == 0) {
            return new ArrayList<ShieldEquipRuleDetail>();
        }
        return ((ShieldEquipRuleDetailMapper)this.dao).getDetailTableV2_9(cid, ruleIds);
    }

    @Transactional(readOnly=false)
    public void clearOldDetail(List<Long> ruleIds) {
        if (ruleIds == null || ruleIds.isEmpty()) {
            return;
        }
        Example example = new Example(ShieldEquipRuleDetail.class);
        Example.Criteria c = example.createCriteria();
        c.andIn("ruleId", ruleIds);
        ((ShieldEquipRuleDetailMapper)this.dao).deleteByExample(example);
    }

    @Transactional(readOnly=false)
    public void addRuleDetailBatch(List<ShieldEquipRuleDetail> details) {
        ((ShieldEquipRuleDetailMapper)this.dao).addRuleDetailBatch(details);
    }

    @Transactional(readOnly=false)
    public void updateRuleDetailBatch(List<ShieldEquipRuleDetail> needUpdateRuleDetails) {
        needUpdateRuleDetails.forEach(detail -> ((ShieldEquipRuleDetailMapper)this.dao).updateByPrimaryKeySelective(detail));
    }
}

