/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.shield;

import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.dao.work.shield.ShieldEquipRuleDangerMapper;
import cn.smarthse.modules.health.entity.work.shield.ShieldEquipRule;
import cn.smarthse.modules.health.entity.work.shield.ShieldEquipRuleDanger;
import cn.smarthse.modules.health.service.work.shield.IShieldEquipRuleDangerService;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
@Transactional(readOnly=true)
public class ShieldEquipRuleDangerServiceImpl
extends BaseServiceImpl<ShieldEquipRuleDangerMapper, ShieldEquipRuleDanger>
implements IShieldEquipRuleDangerService {
    @Transactional(readOnly=false)
    public void updateByRule(ShieldEquipRule rule) {
        if (rule == null) {
            return;
        }
        this.deleteInfo(rule.getId(), null);
        List dangers = rule.getDangers();
        if (rule.getId() == null || dangers == null) {
            return;
        }
        for (ShieldEquipRuleDanger danger : dangers) {
            if (danger.getDangerId() == null) continue;
            this.setParentInfos(rule, danger);
            danger.setId(Long.valueOf(this.idworker.nextId()));
            ((ShieldEquipRuleDangerMapper)this.dao).insert(danger);
        }
    }

    @Transactional(readOnly=false)
    public void deleteInfo(Long ruleId, Long dangerId) {
        if (ruleId == null) {
            return;
        }
        Example example = new Example(ShieldEquipRuleDanger.class);
        Example.Criteria c = example.createCriteria();
        c.andEqualTo("ruleId", (Object)ruleId);
        if (dangerId != null) {
            c.andEqualTo("dangerId", (Object)dangerId);
        }
        ((ShieldEquipRuleDangerMapper)this.dao).deleteByExample(example);
    }

    private void setParentInfos(ShieldEquipRule rule, ShieldEquipRuleDanger detail) {
        detail.setRuleId(rule.getId());
        detail.setCid(rule.getCid());
        detail.setCreateBy(rule.getUpdateBy());
        detail.setCreateDate(rule.getUpdateDate());
        detail.setUpdateBy(rule.getUpdateBy());
        detail.setUpdateDate(rule.getUpdateDate());
    }

    public List<ShieldEquipRuleDanger> getListByRuleId(Long ruleId) {
        if (ruleId == null) {
            return null;
        }
        return ((ShieldEquipRuleDangerMapper)this.dao).getListByRuleId(ruleId);
    }

    @Transactional(readOnly=false)
    public void clearOldDanger(List<Long> ruleIds) {
        if (ruleIds == null || ruleIds.isEmpty()) {
            return;
        }
        Example example = new Example(ShieldEquipRuleDanger.class);
        Example.Criteria c = example.createCriteria();
        c.andIn("ruleId", ruleIds);
        ((ShieldEquipRuleDangerMapper)this.dao).deleteByExample(example);
    }

    @Transactional(readOnly=false)
    public void addRuleDangerBatch(List<ShieldEquipRuleDanger> dangers) {
        ((ShieldEquipRuleDangerMapper)this.dao).addRuleDangerBatch(dangers);
    }

    @Transactional(readOnly=false)
    public void updateRuleDangerBatch(List<ShieldEquipRuleDanger> needAddRuleDangers) {
        needAddRuleDangers.forEach(danger -> ((ShieldEquipRuleDangerMapper)this.dao).updateByPrimaryKeySelective(danger));
    }
}

