/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.shield;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.datacentre.enums.apps.ProtectClassifyEnum;
import cn.smarthse.modules.health.dao.work.shield.ProtectListMapper;
import cn.smarthse.modules.health.entity.work.shield.ProtectList;
import cn.smarthse.modules.health.entity.work.shield.ProtectListClass;
import cn.smarthse.modules.health.entity.work.shield.vo.HarmfactorWorkInfo;
import cn.smarthse.modules.health.entity.work.shield.vo.ProtectQuery;
import cn.smarthse.modules.health.entity.work.shield.vo.ShieldEquipRuleHarm;
import cn.smarthse.modules.health.entity.work.shield.vo.ShieldWorkRelation;
import cn.smarthse.modules.health.service.base.occriskfactor.IOccupationalRiskFactorsService;
import cn.smarthse.modules.health.service.work.shield.IProtectListClassService;
import cn.smarthse.modules.health.service.work.shield.IProtectListService;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class ProtectListServiceImpl
extends BaseServiceImpl<ProtectListMapper, ProtectList>
implements IProtectListService {
    @Autowired
    IProtectListClassService protectListClassService;
    @Autowired
    IOccupationalRiskFactorsService harmService;

    public PageInfo<ProtectList> getPage(JqGridParam gparam, ProtectQuery query) {
        if (gparam == null || query == null) {
            return new PageInfo();
        }
        PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows());
        return new PageInfo(this.getList(query));
    }

    public List<ProtectList> getList(ProtectQuery query) {
        List<ProtectList> list = ((ProtectListMapper)this.dao).selectByQuery(query);
        return list;
    }

    public List<ShieldWorkRelation> getShieldInfosByWorkId(Long workId, Long cid, String harmNum) {
        if (workId == null || cid == null || StringUtils.isEmpty((CharSequence)harmNum) || Double.parseDouble(harmNum) == 0.0) {
            return null;
        }
        return ((ProtectListMapper)this.dao).getShieldInfosByWorkId(workId, cid, harmNum);
    }

    public List<ProtectListClass> getProtectClassList() {
        return this.protectListClassService.getList();
    }

    public ShieldEquipRuleHarm getProtectByBreathHarm(ShieldEquipRuleHarm ruleHarm) {
        if (ruleHarm == null || ruleHarm.getShieldEquipRuleId() == null) {
            return ruleHarm;
        }
        Long ruleId = ruleHarm.getShieldEquipRuleId();
        List harms = ruleHarm.getHarms();
        if (harms == null || harms.size() == 0) {
            return ruleHarm;
        }
        HashMap<Object, HarmfactorWorkInfo> harmTypeValue = new HashMap<Object, HarmfactorWorkInfo>();
        ArrayList<Long> otherTypeIds = new ArrayList<Long>();
        for (HarmfactorWorkInfo harm : harms) {
            Object paramCode;
            Long harmId = harm.getHarmId();
            if (harmId == null || StringUtils.isEmpty((CharSequence)(paramCode = harm.getParamCode()))) continue;
            if (((String)paramCode).startsWith("QT")) {
                otherTypeIds.add(harmId);
                continue;
            }
            HarmfactorWorkInfo harmInfo = this.harmService.getHarmInfoById(harm);
            this.setHarmNum(harmInfo);
            HarmfactorWorkInfo result = (HarmfactorWorkInfo)harmTypeValue.get(paramCode);
            if (result == null || result.getHarmNum() < harmInfo.getHarmNum()) {
                harmInfo.setRuleId(ruleId);
                harmTypeValue.put(paramCode, harmInfo);
            }
            if (harmInfo.getIdlh() == null || !(harmInfo.getHarmNum() >= harmInfo.getIdlh())) continue;
            ruleHarm.setHarmTips("\u6839\u636eGB/T 18664-2002\u4e2d\u7684\u8981\u6c42\uff0c\u73af\u5883\u4e2d\u6c61\u67d3\u7269\u6d53\u5ea6\u8d85\u8fc7IDLH\u6d53\u5ea6\uff0c\u6b64\u73af\u5883\u4e3a\u7acb\u5373\u5a01\u80c1\u751f\u547d\u548c\u5065\u5eb7\uff08IDLH\uff09\u73af\u5883\u3002\u6211\u4eec\u5c06\u4e3a\u60a8\u914d\u7f6e\u6700\u9ad8\u7ea7\u522b\u7684\u547c\u5438\u9632\u62a4\u7528\u54c1\uff0c\u8bf7\u6839\u636e\u60a8\u7684\u5b9e\u9645\u60c5\u51b5\u9009\u62e9\uff0c\u8d2d\u4e70\u65f6\u8bf7\u54a8\u8be2\u5382\u5546\uff01");
        }
        if (harmTypeValue.isEmpty() && otherTypeIds.size() > 0) {
            ruleHarm.setHarmTips("\u6839\u636e\u56fd\u5bb6\u76f8\u5173\u6807\u51c6\uff0c\u4e3a\u60a8\u63a8\u8350\u5982\u4e0bPPE\uff0c\u8bf7\u6839\u636e\u5b9e\u9645\u60c5\u51b5\u9009\u62e9\uff0c\u8d2d\u4e70\u65f6\u8bf7\u54a8\u8be2\u5382\u5546\u9009\u62e9\u5408\u9002\u7684\u547c\u5438\u9632\u62a4\u7528\u54c1\uff1a");
        }
        ArrayList<ProtectList> all = new ArrayList<ProtectList>();
        double maxHarmNum = 0.0;
        for (HarmfactorWorkInfo value : harmTypeValue.values()) {
            List<ProtectList> protects;
            double harmNum = value.getHarmNum();
            if (harmNum <= 0.0) continue;
            if (harmNum > maxHarmNum) {
                maxHarmNum = harmNum;
            }
            if ((protects = ((ProtectListMapper)this.dao).getBreathProtects(value)) == null || protects.size() == 0) continue;
            this.mergeProtects(all, protects);
        }
        if (maxHarmNum == 0.0) {
            ruleHarm.setHarmTips("\u60a8\u7684\u804c\u4e1a\u75c5\u5371\u5bb3\u56e0\u6570\u6d53\u5ea6\u4e3a\u96f6\uff0c\u6839\u636e\u56fd\u5bb6\u6807\u51c6\u53ef\u4e0d\u4f69\u6234\uff0c\u4f46\u662f\u7531\u4e8e\u68c0\u6d4b\u7ed3\u679c\u4e0d\u80fd\u4ee3\u8868\u751f\u4ea7\u5168\u8fc7\u7a0b\uff0c\u82e5\u751f\u4ea7\u8fc7\u7a0b\u4e2d\u5b58\u5728\u6709\u53ef\u80fd\u5bfc\u81f4\u4ea7\u751f\u804c\u4e1a\u75c5\u5371\u5bb3\u6216\u5371\u5bb3\u8d85\u6807\u7684\u610f\u5916\u60c5\u51b5\uff0c\u5efa\u8bae\u60a8\u4e3a\u5458\u5de5\u9009\u914d\u9632\u62a4\u7528\u54c1\u3002\u8bf7\u54a8\u8be2\u5382\u5546\u8d2d\u4e70\u9002\u5408\u7684\u547c\u5438\u9632\u62a4\u7528\u54c1\u3002");
        } else if (maxHarmNum < 1.0) {
            ruleHarm.setHarmTips("\u60a8\u7684\u804c\u4e1a\u75c5\u5371\u5bb3\u56e0\u7d20\u6d53\u5ea6\u6839\u636e\u8ba1\u7b97\u6240\u5f97\u5371\u5bb3\u56e0\u6570\u5c0f\u4e8e1\uff0c\u6839\u636e\u56fd\u5bb6\u6807\u51c6\u4e0d\u5f3a\u5236\u4f69\u6234\uff0c\u4f46\u662f\uff1a</br>1.\u901a\u884c\u7684\u505a\u6cd5\u662f\u5371\u5bb3\u56e0\u6570\u5927\u4e8e0.5\u5c31\u8981\u4f69\u6234\u9632\u62a4\u7528\u54c1\uff1b</br>2.\u7531\u4e8e\u68c0\u6d4b\u7ed3\u679c\u4e0d\u80fd\u4ee3\u8868\u751f\u4ea7\u5168\u8fc7\u7a0b\uff0c\u82e5\u751f\u4ea7\u8fc7\u7a0b\u4e2d\u5b58\u5728\u6709\u53ef\u80fd\u5bfc\u81f4\u8d85\u6807\u7684\u610f\u5916\u60c5\u51b5\uff0c\u5efa\u8bae\u60a8\u4e3a\u5458\u5de5\u9009\u914d\u9632\u62a4\u7528\u54c1\u3002\u8bf7\u54a8\u8be2\u5382\u5546\u8d2d\u4e70\u9002\u5408\u7684\u547c\u5438\u9632\u62a4\u7528\u54c1");
        } else if (maxHarmNum >= 1.0) {
            ruleHarm.setHarmTips("\u60a8\u7684\u804c\u4e1a\u75c5\u5371\u5bb3\u56e0\u7d20\u6d53\u5ea6\u6839\u636e\u8ba1\u7b97\u6240\u5f97\u5371\u5bb3\u56e0\u6570\u6700\u5927\u503c\u4e3a" + maxHarmNum + "\uff0c\u6839\u636eGB/T 18664-2002\u4e2d\u7684\u8981\u6c42\uff0c\u4e3a\u60a8\u63a8\u8350\u5982\u4e0bPPE\uff0c\u8bf7\u6839\u636e\u5b9e\u9645\u60c5\u51b5\u9009\u62e9\uff0c\u8d2d\u4e70\u65f6\u8bf7\u54a8\u8be2\u5382\u5546\u9009\u62e9\u9002\u5408\u7684\u547c\u5438\u9632\u62a4\u7528\u54c1\uff1a");
        }
        ruleHarm.setProtects(all);
        if (otherTypeIds.size() == 0) {
            return ruleHarm;
        }
        List<ProtectList> otherProtects = ((ProtectListMapper)this.dao).getOtherBreathProtects(otherTypeIds);
        if (otherProtects == null || otherProtects.size() == 0) {
            return ruleHarm;
        }
        this.mergeProtects(all, otherProtects);
        ruleHarm.setProtects(all);
        return ruleHarm;
    }

    private void mergeProtects(List<ProtectList> all, List<ProtectList> needMerges) {
        if (needMerges == null || needMerges.size() == 0) {
            return;
        }
        for (ProtectList p : needMerges) {
            String ppeId = p.getPpeId();
            if (StringUtils.isEmpty((CharSequence)ppeId)) continue;
            ProtectList alreadyExist = this.getProtectByPPEId(ppeId, all);
            if (alreadyExist == null) {
                all.add(p);
                continue;
            }
            alreadyExist.setOther(this.setLX(alreadyExist.getOther(), p.getOther()));
        }
    }

    private String setLX(String str1, String str2) {
        Object result = str1;
        if (StringUtils.isEmpty((CharSequence)str2)) {
            return result;
        }
        if (StringUtils.isEmpty((CharSequence)str1)) {
            result = str2;
        } else if (str1.indexOf(str2) < 0) {
            result = (String)result + "+" + str2;
        }
        return result;
    }

    private ProtectList getProtectByPPEId(String ppeId, List<ProtectList> all) {
        for (ProtectList a : all) {
            if (!ppeId.equals(a.getPpeId())) continue;
            return a;
        }
        return null;
    }

    private void setHarmNum(HarmfactorWorkInfo harmInfo) {
        double max = 0.0;
        if (harmInfo == null) {
            return;
        }
        if (harmInfo.getMac() == null && harmInfo.getStel() == null && harmInfo.getTwa() == null && harmInfo.getTwaRespirable() == null && harmInfo.getTwaTotal() == null) {
            max = 1.0;
            harmInfo.setHarmNum(max);
            return;
        }
        if (harmInfo.getMac() != null && harmInfo.getMac() > max) {
            max = harmInfo.getMac();
        }
        if (harmInfo.getStel() != null && harmInfo.getStel() > max) {
            max = harmInfo.getStel();
        }
        if (harmInfo.getTwa() != null && harmInfo.getTwa() > max) {
            max = harmInfo.getTwa();
        }
        if (harmInfo.getTwaRespirable() != null && harmInfo.getTwaRespirable() > max) {
            max = harmInfo.getTwaRespirable();
        }
        if (harmInfo.getTwaTotal() != null && harmInfo.getTwaTotal() > max) {
            max = harmInfo.getTwaTotal();
        }
        harmInfo.setHarmNum(max);
    }

    public List<ProtectList> getRecommendShieldInfos(List<Long> harmIds, List<Long> dangerIds, Long ruleId) {
        if (!(harmIds != null && harmIds.size() != 0 || dangerIds != null && dangerIds.size() != 0)) {
            return null;
        }
        return ((ProtectListMapper)this.dao).getRecommendShieldInfos(harmIds, dangerIds, ruleId);
    }

    @Transactional
    public ProtectList addProtectList(ProtectList protectList) {
        if (protectList.getClassId() == null || StringUtils.isBlank((CharSequence)protectList.getProName())) {
            return null;
        }
        protectList.setPpeId("0" + protectList.getClassId() + "0199");
        protectList.setProClass(ProtectClassifyEnum.getName((Integer)protectList.getClassId()));
        Example example = new Example(ProtectList.class);
        example.createCriteria().andEqualTo("cid", (Object)protectList.getCid()).andEqualTo("proName", (Object)protectList.getProName()).andEqualTo("classId", (Object)protectList.getClassId());
        List already = ((ProtectListMapper)this.dao).selectByExample(example);
        if (CollectionUtils.isNotEmpty((Collection)already)) {
            return (ProtectList)already.get(0);
        }
        int insert = ((ProtectListMapper)this.dao).insert(protectList);
        return protectList;
    }

    public Map<String, String> getAllNameAndIdMap() {
        List<ProtectList> list = ((ProtectListMapper)this.dao).getAll();
        System.out.println(list.stream().map(ProtectList::getProName).collect(Collectors.joining(",")));
        return list.stream().collect(Collectors.toMap(ProtectList::getProName, v -> v.getId().toString(), (o1, o2) -> o1));
    }
}

